/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.gui;

import de.datomino.peppergis.client.alias.AliasPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.datamanager.handler.DataManagerListSelectionHandler;
import de.datomino.peppergis.type.DataManagerType;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.KeyStroke;

public class DataManagerAliasPane
extends AliasPane {
    private static final long serialVersionUID = 4262246004409383905L;
    private ParcelModel referenceModel;
    private boolean doItAnyway;
    private boolean ctrlPressed;

    public DataManagerAliasPane(ModelEnviroment modelEnviroment, DataManagerListSelectionHandler listener) {
        super(modelEnviroment);
        this.parcelList.addListSelectionListener(listener);
        this.parcelList.setEnabled(true);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(17, 128), "controlAction");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("released CONTROL"), "controlAction");
        AbstractAction controlAction = new AbstractAction(){
            private static final long serialVersionUID = -4633696814586095015L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DataManagerAliasPane.this.setCtrlPressed((e.getModifiers() & 2) != 0);
            }
        };
        this.getActionMap().put("controlAction", controlAction);
    }

    public String getPostcode() {
        return this.getPostcodeTextField().getText();
    }

    public void setPostcode(String postcode) {
        this.getPostcodeTextField().setText(postcode);
        if (this.getPostcodesList().getModel().getSize() > 0) {
            this.getPostcodesList().getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public String getCity() {
        return this.getCityTextField().getText();
    }

    public void setCity(String city) {
        this.getCityTextField().setText(city);
        if (this.getCities().getList().getModel().getSize() > 0) {
            this.getCities().getList().getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public String getDistrict() {
        return this.getDistrictTextField().getText();
    }

    public void setDistrict(String district) {
        this.getDistrictTextField().setText(district);
        if (this.getDistricts().getList().getModel().getSize() > 0) {
            this.getDistricts().getList().getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public String getStreet() {
        return this.getStreetTextField().getText();
    }

    public void setStreet(String street) {
        this.getStreetTextField().setText(street);
        if (this.getStreets().getList().getModel().getSize() > 0) {
            this.getStreets().getList().getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @Override
    public JList<ParcelModel> getParcelList() {
        return this.parcelList;
    }

    public void clear() {
        this.getPostcodeTextField().setText("");
        this.getCityTextField().setText("");
        this.getDistrictTextField().setText("");
        this.getStreetTextField().setText("");
        this.getStreets().getList().clearSelection();
        this.getDistricts().getList().clearSelection();
        this.getCities().getList().clearSelection();
        this.getPostcodesList().clearSelection();
    }

    public void setAliasPanePresets(DataManagerType type, List<? extends Model> models) {
        List<ParcelModel> parcelModels;
        if (type == DataManagerType.PARCEL && models.size() > 0 && ((parcelModels = this.getParcelList(models)).size() == 1 || this.isSameStreet(parcelModels) || this.doItAnyway)) {
            EnumMap<AddressPart, String> map = null;
            if (this.referenceModel == null || !models.contains(this.referenceModel)) {
                try {
                    this.referenceModel = (ParcelModel)models.get(0);
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("Only Parcelmodels are accepted! \n" + e.getMessage());
                }
            }
            map = this.getAddress(this.referenceModel);
            DefaultListModel dlm = null;
            if (this.getParcelList().getModel() instanceof DefaultListModel) {
                dlm = (DefaultListModel)this.getParcelList().getModel();
            }
            this.setPostcode(map.get((Object)AddressPart.POSTCODE));
            this.setCity(map.get((Object)AddressPart.CITY));
            this.setDistrict(map.get((Object)AddressPart.DISTRICT));
            this.setStreet(map.get((Object)AddressPart.STREET));
            if (dlm != null) {
                ArrayList<Integer> indices = new ArrayList<Integer>(parcelModels.size());
                int[] indicesA = null;
                for (ParcelModel parcel : parcelModels) {
                    int indexOfParcel = dlm.indexOf(parcel);
                    if (indexOfParcel != -1) {
                        indices.add(indexOfParcel);
                    }
                    indicesA = new int[indices.size()];
                    for (int i = 0; i < indices.size(); ++i) {
                        indicesA[i] = (Integer)indices.get(i);
                    }
                }
                this.getParcelList().setSelectedIndices(indicesA);
            }
        } else {
            this.clear();
        }
    }

    private EnumMap<AddressPart, String> getAddress(ParcelModel pModel) {
        EnumMap<AddressPart, String> map = new EnumMap<AddressPart, String>(AddressPart.class);
        if (pModel.isDeleted()) {
            return map;
        }
        map.put(AddressPart.POSTCODE, pModel.getStreet().getPostcodeDistrictRelation().getPostcode().getName());
        map.put(AddressPart.CITY, pModel.getStreet().getPostcodeDistrictRelation().getDistrict().getCity().getName());
        map.put(AddressPart.DISTRICT, pModel.getStreet().getPostcodeDistrictRelation().getDistrict().getName());
        map.put(AddressPart.STREET, pModel.getStreet().getName());
        return map;
    }

    private List<ParcelModel> getParcelList(List<? extends Model> list) {
        LinkedList<ParcelModel> pList = new LinkedList<ParcelModel>();
        if (list.size() > 0 && list.get(0) instanceof ParcelModel) {
            for (Model model : list) {
                pList.add((ParcelModel)model);
            }
        }
        return pList;
    }

    private boolean isSameStreet(List<ParcelModel> parcels) {
        EnumMap<AddressPart, String> map1 = this.getAddress(parcels.get(0));
        for (ParcelModel parcel : parcels) {
            EnumMap<AddressPart, String> map2 = this.getAddress(parcel);
            if (map1.equals((Object)map2)) continue;
            return false;
        }
        return true;
    }

    public ParcelModel getReferenceModel() {
        return this.referenceModel;
    }

    public void setReferenceModel(Model referenceModel) {
        this.referenceModel = referenceModel instanceof ParcelModel ? (ParcelModel)referenceModel : null;
    }

    public boolean isDoItAnyway() {
        return this.doItAnyway;
    }

    public void setDoItAnyway(boolean doItAnyway) {
        this.doItAnyway = doItAnyway;
    }

    public boolean isCtrlPressed() {
        return this.ctrlPressed;
    }

    public void setCtrlPressed(boolean ctrlPressed) {
        this.ctrlPressed = ctrlPressed;
    }

    static enum AddressPart {
        POSTCODE,
        CITY,
        DISTRICT,
        STREET;

    }
}

