/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.actions;

import de.datomino.peppergis.client.export.AbstractExportFileAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.datamanager.gui.DataManagerGui;
import de.datomino.peppergis.dto.exporter.DefaultExportDto;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.type.DataManagerType;
import de.datomino.peppergis.type.export.ExportParcelType;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ktde.util.datatypes.Tupel;

public class DataServerExportFileAction
extends AbstractExportFileAction<List<Long>> {
    private static final long serialVersionUID = -4645521129619405113L;
    private DataManagerGui gui;
    private boolean markedOnly;

    public DataServerExportFileAction(Window parent, String fileExtension, DataManagerGui gui, boolean markedOnly) {
        super(markedOnly ? ModelEnviroment.getMessageResolver().resolveMessage("messages.area.mark", new Serializable[0]) : ModelEnviroment.getMessageResolver().resolveMessage("messages.data.result", new Serializable[0]), parent, fileExtension);
        this.gui = gui;
        this.markedOnly = markedOnly;
    }

    @Override
    protected List<Long> createContext() {
        List<Model> models = this.markedOnly ? this.gui.getTableSelection() : this.gui.getDataList();
        ArrayList<Long> ids = null;
        if (models != null) {
            ids = new ArrayList<Long>(models.size());
            for (Model model : models) {
                ids.add(model.getId());
            }
        }
        return ids;
    }

    @Override
    protected boolean checkConditions(List<Long> t) {
        return t != null && !t.isEmpty();
    }

    @Override
    protected Tupel<Map<String, byte[]>, ErrorMessages> getContent(List<Long> t) throws ClientExportException {
        DataManagerType currentType = this.gui.getCurrentType();
        String typeName = ModelEnviroment.getMessageResolver().resolveMessageForEnum(currentType);
        DefaultExportDto result = null;
        switch (currentType) {
            case CUSTOMER: 
            case PICKPOINT: 
            case AREALOCATION: 
            case DELIVERERLOCATION: 
            case GROUPLOCATION: 
            case MAINLOCATION: 
            case AREADELIVERERLOCATION: {
                result = this.gui.getModelEnvironment().getAllCaller().getExportCaller().exportPoisByIds(t);
                break;
            }
            case PARCEL: {
                ArrayList<Tupel<Long, String[]>> parcelIds = new ArrayList<Tupel<Long, String[]>>(t.size());
                String[] emptyStringArray = new String[]{};
                for (Long id : t) {
                    parcelIds.add(new Tupel<Long, String[]>(id, emptyStringArray));
                }
                result = this.gui.getModelEnvironment().getAllCaller().getExportCaller().exportParcelsByIds(parcelIds, emptyStringArray, ExportParcelType.DEFAULT);
                break;
            }
            case STOPS: {
                result = this.gui.getModelEnvironment().getAllCaller().getExportCaller().exportStopsByIds(t);
                break;
            }
        }
        return result == null ? null : new Tupel<Map<String, byte[]>, ErrorMessages>(Collections.singletonMap(typeName, result.getContent()), result.getErrorMessages());
    }
}

