/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.renderer;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public abstract class AbstractDefaultRendererSettingsPane
extends JPanel {
    private static final long serialVersionUID = 6213107759485907003L;

    public AbstractDefaultRendererSettingsPane() {
        super(new BorderLayout());
        this.buildLayout();
    }

    public void loadValues(String prefix, Properties tempProps) {
        Enum<?>[] paramEnum;
        for (Enum<?> e : paramEnum = this.getParameters()) {
            String value;
            String key = prefix + e.name();
            String string = value = tempProps == null ? null : tempProps.getProperty(key);
            if (value == null) {
                value = ModelEnviroment.getProperties().getProperty(key);
            }
            if (value == null) continue;
            this.setValue(e, value);
        }
    }

    private void buildLayout() {
        Enum<?>[] paramEnum;
        JPanel panel = new JPanel(new SpringLayout());
        for (Enum<?> e : paramEnum = this.getParameters()) {
            panel.add(new JLabel(this.getLabelForParameter(e)));
            panel.add(this.getComponentForParameter(e));
        }
        SpringUtilities.makeCompactGrid(panel, paramEnum.length, 2, 5, 5, 2, 2);
        this.add((Component)panel, "North");
    }

    public void addProperties(Properties properties, String prefix) {
        Enum<?>[] paramEnum;
        for (Enum<?> e : paramEnum = this.getParameters()) {
            properties.setProperty(prefix + e.name(), this.getValue(e));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        Enum<?>[] paramEnum;
        super.setEnabled(enabled);
        for (Enum<?> e : paramEnum = this.getParameters()) {
            this.getComponentForParameter(e).setEnabled(enabled);
        }
    }

    protected String getLabelForParameter(Enum<?> e) {
        return ModelEnviroment.getMessageResolver().resolveMessageForEnum(e);
    }

    protected abstract Component getComponentForParameter(Enum<?> var1);

    protected abstract Enum<?>[] getParameters();

    protected abstract void setValue(Enum<?> var1, String var2);

    protected abstract String getValue(Enum<?> var1);
}

