/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.print;

import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.DialogDisposeAction;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.common.EnumItem;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.PrintContentModel;
import de.datomino.peppergis.client.model.base.PrintParameterModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.wrapper.area.attribute.AreaAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.client.util.wrapper.parcel.attribute.ParcelAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.client.util.wrapper.subscription.attribute.SubscriptionAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.print.AreaNamePrintType;
import de.datomino.peppergis.print.TourInfoPrintType;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.PrintContentKey;
import de.datomino.peppergis.type.PrintObject;
import de.datomino.peppergis.type.PrintParameterKey;
import de.datomino.util.swing.ImagePosition;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.text.NumberFormatter;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Holder;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintConfigrationDialog
extends CommonDialog {
    private static final long serialVersionUID = 1766047574135171499L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PrintConfigrationDialog.class);
    private ModelEnviroment modelEnviroment;
    private Tupel<Collection<PrintContentModel>, Collection<PrintParameterModel>> models;

    public PrintConfigrationDialog(Window parent, ModelEnviroment modelEnviroment) {
        super((Component)parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.print.configuration", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.models = this.modelEnviroment.getAllCaller().getBaseCaller().fetchAllPrintObjects();
        this.buildLayout();
        this.pack();
        this.center();
    }

    @Override
    protected Component getMainComponent() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.common", new Serializable[0]), this.createCommonPane());
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaObject", new Serializable[0]), this.createAreaPane());
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.pickuproute", new Serializable[0]), this.createTourPane());
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.deliveryroute", new Serializable[0]), this.createAreaTourPane());
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("gui.parcel.parcel", new Serializable[0]), this.createParcelPane());
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscription", new Serializable[0]), this.createSubscriptionPane());
        return tabbedPane;
    }

    private JScrollPane createCommonPane() {
        JPanel commonPane = new JPanel(new SpringLayout());
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.companyAddress", new Serializable[0])));
        PrintParameterModel companyAddress = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.COMPANY_ADDRESS);
        commonPane.add(this.createTextArea(companyAddress.getStringValue(), "StringValue", companyAddress));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.logo.image", new Serializable[0])));
        PrintParameterModel logoImage = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.LOGO_IMAGE);
        commonPane.add(this.createTextField(logoImage.getStringValue(), "StringValue", logoImage));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.logo.width", new Serializable[0])));
        PrintParameterModel logoWidth = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.LOGO_WIDTH);
        commonPane.add(this.createTextField(ClientFormUtil.getNumberString(logoWidth.getFloatValue()), "FloatValue", logoWidth));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.logo.height", new Serializable[0])));
        PrintParameterModel logoHeight = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.LOGO_HEIGHT);
        commonPane.add(this.createTextField(ClientFormUtil.getNumberString(logoHeight.getFloatValue()), "FloatValue", logoHeight));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.logo.position", new Serializable[0])));
        final PrintParameterModel logoPosition = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.LOGO_POSITION);
        EnumComboBox<ImagePosition> logoPositionEnum = new EnumComboBox<ImagePosition>(ImagePosition.class, false);
        logoPositionEnum.setSelectedValue(ImagePosition.valueOf(logoPosition.getStringValue()));
        logoPositionEnum.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EnumItem item = (EnumItem)e.getItem();
                    logoPosition.setStringValue(((ImagePosition)((Object)item.getT())).name());
                }
            }
        });
        commonPane.add(logoPositionEnum);
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.imageInfo.fontSize", new Serializable[0])));
        PrintParameterModel imageInfoFontSize = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.IMAGE_INFO_FONT_SIZE);
        commonPane.add(this.createTextField(ClientFormUtil.getNumberString(imageInfoFontSize.getIntegerValue()), "IntegerValue", imageInfoFontSize));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.imageInfo.width", new Serializable[0])));
        PrintParameterModel imageInfoWidth = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.IMAGE_INFO_WIDTH);
        commonPane.add(this.createTextField(ClientFormUtil.getNumberString(imageInfoWidth.getFloatValue()), "FloatValue", imageInfoWidth));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.imageInfo.height", new Serializable[0])));
        PrintParameterModel imageInfoHeight = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.IMAGE_INFO_HEIGHT);
        commonPane.add(this.createTextField(ClientFormUtil.getNumberString(imageInfoHeight.getFloatValue()), "FloatValue", imageInfoHeight));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.imageInfo.position", new Serializable[0])));
        final PrintParameterModel imageInfoPosition = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.IMAGE_INFO_POSITION);
        EnumComboBox<ImagePosition> imageInfoPositionEnum = new EnumComboBox<ImagePosition>(ImagePosition.class, false);
        imageInfoPositionEnum.setSelectedValue(ImagePosition.valueOf(imageInfoPosition.getStringValue()));
        imageInfoPositionEnum.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EnumItem item = (EnumItem)e.getItem();
                    imageInfoPosition.setStringValue(((ImagePosition)((Object)item.getT())).name());
                }
            }
        });
        commonPane.add(imageInfoPositionEnum);
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.lineSpacing", new Serializable[0])));
        PrintParameterModel lineSpace = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.LINE_SPACING);
        commonPane.add(this.createTextField(ClientFormUtil.getNumberString(lineSpace.getIntegerValue()), "IntegerValue", lineSpace));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.printDate", new Serializable[0])));
        final PrintContentModel printingDate = this.findPrintContent(PrintObject.COMMON, PrintContentKey.PRINTING_DATE);
        JCheckBox printingDateCheckBox = new JCheckBox(new AbstractAction(){
            private static final long serialVersionUID = 2081953495704398405L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox b = (JCheckBox)e.getSource();
                if (b.isSelected()) {
                    printingDate.setCanPrint(true);
                } else {
                    printingDate.setCanPrint(false);
                }
            }
        });
        printingDateCheckBox.setSelected(printingDate.getCanPrint());
        commonPane.add(printingDateCheckBox);
        commonPane.add(new JLabel());
        commonPane.add(new JLabel());
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.server", new Serializable[0])));
        commonPane.add(new JLabel());
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.font", new Serializable[0])));
        final PrintParameterModel serverFontName = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.SERVER_FONT_NAME);
        JComboBox<String> serverFontNamenComboBox = new JComboBox<String>(PeppergisConstants.FONT_NAME_FOP);
        serverFontNamenComboBox.setSelectedItem(serverFontName.getStringValue());
        serverFontNamenComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    serverFontName.setStringValue(String.valueOf(e.getItem()));
                }
            }
        });
        commonPane.add(serverFontNamenComboBox);
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.fontSize", new Serializable[0])));
        PrintParameterModel serverFontSize = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.SERVER_FONT_SIZE);
        commonPane.add(this.createTextField(ClientFormUtil.getNumberString(serverFontSize.getIntegerValue()), "IntegerValue", serverFontSize));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.optimalZoom", new Serializable[0])));
        commonPane.add(this.createPrintParameterCheckBox(PrintObject.COMMON, PrintParameterKey.SERVER_OPTIMAL_ZOOM));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.print.places", new Serializable[0])));
        commonPane.add(this.createPrintParameterCheckBox(PrintObject.COMMON, PrintParameterKey.SERVER_PLACE_NAME));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.print.streets", new Serializable[0])));
        commonPane.add(this.createPrintParameterCheckBox(PrintObject.COMMON, PrintParameterKey.SERVER_STREET_NAME));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.lineWidth", new Serializable[0])));
        PrintParameterModel serverLineWidth = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.SERVER_LINE_WIDTH);
        commonPane.add(this.createTextField(ClientFormUtil.getNumberString(serverLineWidth.getFloatValue()), "FloatValue", serverLineWidth));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.pointSize", new Serializable[0])));
        PrintParameterModel serverPointSize = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.SERVER_POINT_SIZE);
        commonPane.add(this.createTextField(ClientFormUtil.getNumberString(serverPointSize.getFloatValue()), "FloatValue", serverPointSize));
        commonPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessageForEnum(PrinterInformation.LineGroupType.class)));
        final PrintParameterModel serverLineGroupType = this.findPrintParameter(PrintObject.COMMON, PrintParameterKey.SERVER_LINE_GROUP_TYPE);
        EnumComboBox<PrinterInformation.LineGroupType> serverLineGroupTypeEnum = new EnumComboBox<PrinterInformation.LineGroupType>(PrinterInformation.LineGroupType.class, false);
        serverLineGroupTypeEnum.setSelectedValue(PrinterInformation.LineGroupType.valueOf(serverLineGroupType.getStringValue()));
        serverLineGroupTypeEnum.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EnumItem item = (EnumItem)e.getItem();
                    serverLineGroupType.setStringValue(((PrinterInformation.LineGroupType)((Object)item.getT())).name());
                }
            }
        });
        commonPane.add(serverLineGroupTypeEnum);
        SpringUtilities.makeCompactGrid(commonPane, 21, 2, 5, 5, 5, 5);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)commonPane, "North");
        return new JScrollPane(pane);
    }

    private JScrollPane createAreaPane() {
        JPanel areaPane = new JPanel(new SpringLayout());
        areaPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.info.position", new Serializable[0])));
        final PrintParameterModel infoPosition = this.findPrintParameter(PrintObject.AREA, PrintParameterKey.INFO_POSITION);
        EnumComboBox<AreaNamePrintType> infoPositionEnum = new EnumComboBox<AreaNamePrintType>(AreaNamePrintType.class, false);
        infoPositionEnum.setSelectedValue(AreaNamePrintType.valueOf(infoPosition.getStringValue()));
        infoPositionEnum.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EnumItem item = (EnumItem)e.getItem();
                    infoPosition.setStringValue(((AreaNamePrintType)item.getT()).name());
                }
            }
        });
        areaPane.add(infoPositionEnum);
        areaPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.info.pattern", new Serializable[0])));
        PrintParameterModel infoPattern = this.findPrintParameter(PrintObject.AREA, PrintParameterKey.INFO_PATTERN);
        areaPane.add(this.createTextArea(infoPattern.getStringValue(), "StringValue", infoPattern));
        areaPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.special", new Serializable[0])));
        areaPane.add(this.createPrintParameterCheckBox(PrintObject.AREA, PrintParameterKey.SPECIAL_MESSAGE));
        areaPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.headInfo.pattern", new Serializable[0])));
        PrintParameterModel pageHeadPattern = this.findPrintParameter(PrintObject.AREA, PrintParameterKey.PAGE_HEAD_PATTERN);
        areaPane.add(this.createTextArea(pageHeadPattern.getStringValue(), "StringValue", pageHeadPattern));
        areaPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.footInfo.pattern", new Serializable[0])));
        PrintParameterModel pageFootPattern = this.findPrintParameter(PrintObject.AREA, PrintParameterKey.PAGE_FOOT_PATTERN);
        areaPane.add(this.createTextArea(pageFootPattern.getStringValue(), "StringValue", pageFootPattern));
        areaPane.add(new JLabel());
        areaPane.add(new JLabel());
        areaPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.attributes", new Serializable[0])));
        areaPane.add(new JLabel());
        Collection<AreaAttributeValueDescriptorModel> descriptors = this.modelEnviroment.getAllCaller().getAreaCaller().fetchAllAreaAttributeValueDescriptors();
        for (AreaAttributeValueDescriptorModel descriptor : descriptors) {
            areaPane.add(new JLabel(descriptor.getKey() + " (" + descriptor.getName() + ")"));
            areaPane.add(this.createAttributePane(new AreaAttributeValueDescriptorModelAttributeWrapper(descriptor)));
        }
        SpringUtilities.makeCompactGrid(areaPane, 7 + descriptors.size(), 2, 5, 5, 5, 5);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)areaPane, "North");
        return new JScrollPane(pane);
    }

    private JScrollPane createTourPane() {
        JPanel tourPane = new JPanel(new SpringLayout());
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.info.position", new Serializable[0])));
        final PrintParameterModel infoPosition = this.findPrintParameter(PrintObject.TOUR, PrintParameterKey.INFO_POSITION);
        EnumComboBox<TourInfoPrintType> infoPositionEnum = new EnumComboBox<TourInfoPrintType>(TourInfoPrintType.class, false);
        infoPositionEnum.setSelectedValue(TourInfoPrintType.valueOf(infoPosition.getStringValue()));
        infoPositionEnum.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EnumItem item = (EnumItem)e.getItem();
                    infoPosition.setStringValue(((TourInfoPrintType)item.getT()).name());
                }
            }
        });
        tourPane.add(infoPositionEnum);
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.info.pattern", new Serializable[0])));
        PrintParameterModel infoPattern = this.findPrintParameter(PrintObject.TOUR, PrintParameterKey.INFO_PATTERN);
        tourPane.add(this.createTextArea(infoPattern.getStringValue(), "StringValue", infoPattern));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.special", new Serializable[0])));
        tourPane.add(this.createPrintParameterCheckBox(PrintObject.TOUR, PrintParameterKey.SPECIAL_MESSAGE));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.index", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.INDEX, true));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.NAME, true));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.CUSTOMER, true));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.companyName", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.COMPANY, true));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.COUNTRY, true));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.POSTCODE, true));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.CITY, true));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.district", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.DISTRICT, true));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.STREET, true));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.HOUSE_NUMBER, true));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.HOUSE_NUMBER_EX, true));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.estimatedTime", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.ESTIMATED_TIME, true));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.actualTime", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.ACTUAL_TIME, true));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.INFO, false));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.delivererInformation", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.INFO_DELIVERER, false));
        tourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.parkingInformation", new Serializable[0])));
        tourPane.add(this.createContentKeyPane(PrintObject.TOUR, PrintContentKey.INFO_PARKING, false));
        SpringUtilities.makeCompactGrid(tourPane, 19, 2, 5, 5, 5, 5);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)tourPane, "North");
        return new JScrollPane(pane);
    }

    private JScrollPane createAreaTourPane() {
        JPanel areaTourPane = new JPanel(new SpringLayout());
        areaTourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.imageInfo.pattern", new Serializable[0])));
        PrintParameterModel imageInfoPattern = this.findPrintParameter(PrintObject.AREA_TOUR, PrintParameterKey.IMAGE_INFO_PATTERN);
        areaTourPane.add(this.createTextArea(imageInfoPattern.getStringValue(), "StringValue", imageInfoPattern));
        areaTourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.info.position", new Serializable[0])));
        final PrintParameterModel infoPosition = this.findPrintParameter(PrintObject.AREA_TOUR, PrintParameterKey.INFO_POSITION);
        EnumComboBox<TourInfoPrintType> infoPositionEnum = new EnumComboBox<TourInfoPrintType>(TourInfoPrintType.class, false);
        infoPositionEnum.setSelectedValue(TourInfoPrintType.valueOf(infoPosition.getStringValue()));
        infoPositionEnum.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EnumItem item = (EnumItem)e.getItem();
                    infoPosition.setStringValue(((TourInfoPrintType)item.getT()).name());
                }
            }
        });
        areaTourPane.add(infoPositionEnum);
        areaTourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.info.pattern", new Serializable[0])));
        PrintParameterModel infoPattern = this.findPrintParameter(PrintObject.AREA_TOUR, PrintParameterKey.INFO_PATTERN);
        areaTourPane.add(this.createTextArea(infoPattern.getStringValue(), "StringValue", infoPattern));
        areaTourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.message.special", new Serializable[0])));
        areaTourPane.add(this.createPrintParameterCheckBox(PrintObject.AREA_TOUR, PrintParameterKey.SPECIAL_MESSAGE));
        areaTourPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.poiMaxDistance", new Serializable[0])));
        PrintParameterModel serverFontSize = this.findPrintParameter(PrintObject.AREA_TOUR, PrintParameterKey.POI_MAX_DISTANCE);
        areaTourPane.add(this.createTextField(StringUtil.nullToEmpty(serverFontSize.getIntegerValue()), "IntegerValue", serverFontSize));
        areaTourPane.add(new JLabel());
        areaTourPane.add(new JLabel());
        SpringUtilities.makeCompactGrid(areaTourPane, 6, 2, 5, 5, 5, 5);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)areaTourPane, "North");
        return new JScrollPane(pane);
    }

    private JScrollPane createParcelPane() {
        JPanel parcelPane = new JPanel(new SpringLayout());
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.index", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.INDEX, true));
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.COUNTRY, true));
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.POSTCODE, true));
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.CITY, true));
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.district", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.DISTRICT, true));
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.STREET, true));
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.HOUSE_NUMBER, true));
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.HOUSE_NUMBER_EX, true));
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.DISTANCE_FROM_START, true));
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.duration", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.DURATION_FROM_START, true));
        parcelPane.add(new JLabel());
        parcelPane.add(new JLabel());
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.streetGroup", new Serializable[0])));
        parcelPane.add(new JLabel());
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.GROUP_COUNTRY, true));
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.GROUP_POSTCODE, true));
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.GROUP_CITY, true));
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.district", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.GROUP_DISTRICT, true));
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.address", new Serializable[0])));
        parcelPane.add(this.createContentKeyPane(PrintObject.PARCEL, PrintContentKey.ADDRESS_GROUP, true));
        parcelPane.add(new JLabel());
        parcelPane.add(new JLabel());
        parcelPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.attributes", new Serializable[0])));
        parcelPane.add(new JLabel());
        Collection<ParcelAttributeValueDescriptorModel> descriptors = this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchAllParcelAttributeValueDescriptors();
        for (ParcelAttributeValueDescriptorModel descriptor : descriptors) {
            parcelPane.add(new JLabel(descriptor.getKey() + " (" + descriptor.getName() + ")"));
            parcelPane.add(this.createAttributePane(new ParcelAttributeValueDescriptorModelAttributeWrapper(descriptor)));
        }
        SpringUtilities.makeCompactGrid(parcelPane, 19 + descriptors.size(), 2, 5, 5, 5, 5);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)parcelPane, "North");
        return new JScrollPane(pane);
    }

    private JScrollPane createSubscriptionPane() {
        JPanel subscriptionPane = new JPanel(new SpringLayout());
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.index", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.INDEX, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.CUSTOMER, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.COUNTRY, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.POSTCODE, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.CITY, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.district", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.DISTRICT, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.STREET, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.HOUSE_NUMBER, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.HOUSE_NUMBER_EX, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.DISTANCE_FROM_START, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.duration", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.DURATION_FROM_START, true));
        subscriptionPane.add(new JLabel());
        subscriptionPane.add(new JLabel());
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.addressGroup", new Serializable[0])));
        subscriptionPane.add(new JLabel());
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.GROUP_COUNTRY, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.GROUP_POSTCODE, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.GROUP_CITY, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.district", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.GROUP_DISTRICT, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.GROUP_STREET, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.GROUP_HOUSE_NUMBER, true));
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0])));
        subscriptionPane.add(this.createContentKeyPane(PrintObject.SUBSCRIPTION, PrintContentKey.GROUP_HOUSE_NUMBER_EX, true));
        subscriptionPane.add(new JLabel());
        subscriptionPane.add(new JLabel());
        subscriptionPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.attributes", new Serializable[0])));
        subscriptionPane.add(new JLabel());
        Collection<SubscriptionAttributeValueDescriptorModel> descriptors = this.modelEnviroment.getAllCaller().getSubscriptionCaller().getAllSubscriptionAttributeValueDescriptors();
        for (SubscriptionAttributeValueDescriptorModel descriptor : descriptors) {
            subscriptionPane.add(new JLabel(descriptor.getKey() + " (" + descriptor.getName() + ")"));
            subscriptionPane.add(this.createAttributePane(new SubscriptionAttributeValueDescriptorModelAttributeWrapper(descriptor)));
        }
        SpringUtilities.makeCompactGrid(subscriptionPane, 22 + descriptors.size(), 2, 5, 5, 5, 5);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)subscriptionPane, "North");
        return new JScrollPane(pane);
    }

    private PrintContentModel findPrintContent(PrintObject printObject, PrintContentKey key) {
        PrintContentModel found = null;
        for (PrintContentModel content : this.models.getElement1()) {
            if (!content.getPrintObject().equals((Object)printObject) || !content.getKey().equals(key)) continue;
            found = content;
        }
        return found;
    }

    private PrintParameterModel findPrintParameter(PrintObject printObject, PrintParameterKey key) {
        PrintParameterModel found = null;
        for (PrintParameterModel parameter : this.models.getElement2()) {
            if (!parameter.getPrintObject().equals((Object)printObject) || !parameter.getKey().equals(key)) continue;
            found = parameter;
        }
        return found;
    }

    private JTextField createTextField(String text, String fieldName, Model m) {
        return ClientSwingUtil.createParameterTextField(30, text, true, fieldName, new Holder<Model>(m), this);
    }

    private JTextArea createTextArea(String text, String fieldName, Model m) {
        return ClientSwingUtil.createParameterTextArea(5, 30, text, true, fieldName, new Holder<Model>(m), this);
    }

    private Component createPrintParameterCheckBox(PrintObject printObject, PrintParameterKey key) {
        final PrintParameterModel parameter = this.findPrintParameter(printObject, key);
        JCheckBox checkBox = new JCheckBox(new AbstractAction(){
            private static final long serialVersionUID = -8809764428744724832L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox b = (JCheckBox)e.getSource();
                if (b.isSelected()) {
                    parameter.setBooleanValue(true);
                } else {
                    parameter.setBooleanValue(false);
                }
            }
        });
        checkBox.setSelected(parameter.getBooleanValue());
        return checkBox;
    }

    private JPanel createContentKeyPane(PrintObject printObject, PrintContentKey key, boolean active) {
        PrintContentModel content = this.findPrintContent(printObject, key);
        return this.createConntentValuePane(new ContentValueWrapper(content), key != PrintContentKey.INDEX && active, active);
    }

    private JPanel createAttributePane(AttributeValueDescriptorModel<? extends Model, ? extends Model> descriptorWrapper) {
        AttributeValueType attributeValueType = descriptorWrapper.getAttributeValueType();
        return this.createConntentValuePane(new ContentValueWrapper(descriptorWrapper), attributeValueType != AttributeValueType.TEXT, attributeValueType != AttributeValueType.TEXT);
    }

    private JPanel createConntentValuePane(final ContentValueWrapper wrapper, final boolean sortOrderActive, final boolean lengthActive) {
        JPanel pane = new JPanel(new FlowLayout(0));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.attribute.print.sortorder", new Serializable[0])));
        NumberFormatter formatterSortOrder = new NumberFormatter();
        formatterSortOrder.setMinimum(new Integer(1));
        formatterSortOrder.setCommitsOnValidEdit(true);
        final JFormattedTextField printSortOrder = new JFormattedTextField(formatterSortOrder){
            private static final long serialVersionUID = 4425106041696245595L;

            @Override
            protected void processFocusEvent(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                if (e.getID() == 1005) {
                    if (this.getText() == null || this.getText().isEmpty()) {
                        this.setValue(null);
                    }
                    try {
                        wrapper.setPrintSortOrder((Integer)this.getValue());
                    }
                    catch (Exception e1) {
                        LOGGER.error("", e1);
                    }
                }
                super.processFocusEvent(e);
            }
        };
        printSortOrder.setPreferredSize(new Dimension(100, 20));
        pane.add(printSortOrder);
        if (!sortOrderActive) {
            printSortOrder.setEnabled(false);
        }
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.attribute.print.length", new Serializable[0])));
        NumberFormatter formatterLength = new NumberFormatter();
        formatterLength.setMaximum(new Integer(150));
        formatterLength.setMinimum(new Integer(1));
        formatterLength.setCommitsOnValidEdit(true);
        final JFormattedTextField printLength = new JFormattedTextField(formatterLength){
            private static final long serialVersionUID = -9126134096455973541L;

            @Override
            protected void processFocusEvent(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                if (e.getID() == 1005) {
                    if (this.getText() == null || this.getText().isEmpty()) {
                        this.setValue(null);
                    }
                    try {
                        wrapper.setPrintLength((Integer)this.getValue());
                    }
                    catch (Exception e1) {
                        LOGGER.error("", e1);
                    }
                }
                super.processFocusEvent(e);
            }
        };
        printLength.setPreferredSize(new Dimension(100, 20));
        pane.add(printLength);
        if (!lengthActive) {
            printLength.setEnabled(false);
        }
        JCheckBox canPrint = new JCheckBox(new AbstractAction(){
            private static final long serialVersionUID = -728503236409660178L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox b = (JCheckBox)e.getSource();
                try {
                    if (b.isSelected()) {
                        wrapper.setCanPrint(true);
                        if (sortOrderActive) {
                            printSortOrder.setEnabled(true);
                        }
                        if (lengthActive) {
                            printLength.setEnabled(true);
                        }
                    } else {
                        wrapper.setCanPrint(false);
                        printSortOrder.setEnabled(false);
                        printLength.setEnabled(false);
                    }
                }
                catch (Exception e1) {
                    LOGGER.error("", e1);
                }
            }
        });
        pane.add(canPrint);
        try {
            printSortOrder.setValue(wrapper.getPrintSortOrder());
            printLength.setValue(wrapper.getPrintLength());
            boolean b = wrapper.getCanPrint() == null ? false : wrapper.getCanPrint();
            canPrint.setSelected(b);
            if (!b) {
                printSortOrder.setEnabled(false);
                printLength.setEnabled(false);
            }
        }
        catch (Exception e) {
            LOGGER.error("", e);
        }
        return pane;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 2282804022148846503L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelEnviroment.printPropertiesDirty = true;
                UndoManager undoManager = PrintConfigrationDialog.this.modelEnviroment.getUndoManager();
                undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.configuration", new Serializable[0]));
                try {
                    undoManager.storeTransactions();
                    PrintConfigrationDialog.this.dispose();
                }
                catch (ValidateException ex) {
                    undoManager.handleValidateException(ex);
                }
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new DialogDisposeAction(this){
            private static final long serialVersionUID = 370336883779263625L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager undoManager = PrintConfigrationDialog.this.modelEnviroment.getUndoManager();
                if (undoManager.hasCurrentTransactionChanges()) {
                    undoManager.rollbackTransaction();
                }
                PrintConfigrationDialog.this.dispose();
            }
        };
    }

    private class ContentValueWrapper {
        private Object o;

        private ContentValueWrapper(Object o) {
            this.o = o;
        }

        private Boolean getCanPrint() throws Exception {
            Method getMethod = this.o.getClass().getMethod("getCanPrint", new Class[0]);
            return (Boolean)getMethod.invoke(this.o, new Object[0]);
        }

        private void setCanPrint(Boolean canPrint) throws Exception {
            Method getMethod = this.o.getClass().getMethod("getCanPrint", new Class[0]);
            Method setMethod = this.o.getClass().getMethod("setCanPrint", getMethod.getReturnType());
            setMethod.invoke(this.o, canPrint);
        }

        private Integer getPrintSortOrder() throws Exception {
            Method getMethod = this.o.getClass().getMethod("getPrintSortOrder", new Class[0]);
            return (Integer)getMethod.invoke(this.o, new Object[0]);
        }

        private void setPrintSortOrder(Integer sortOrder) throws Exception {
            Method getMethod = this.o.getClass().getMethod("getPrintSortOrder", new Class[0]);
            Method setMethod = this.o.getClass().getMethod("setPrintSortOrder", getMethod.getReturnType());
            setMethod.invoke(this.o, sortOrder);
        }

        private Integer getPrintLength() throws Exception {
            Method getMethod = this.o.getClass().getMethod("getPrintLength", new Class[0]);
            return (Integer)getMethod.invoke(this.o, new Object[0]);
        }

        private void setPrintLength(Integer printLength) throws Exception {
            Method getMethod = this.o.getClass().getMethod("getPrintLength", new Class[0]);
            Method setMethod = this.o.getClass().getMethod("setPrintLength", getMethod.getReturnType());
            setMethod.invoke(this.o, printLength);
        }
    }
}

