/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.job.schedule.parameter;

import de.datomino.logistic.type.RouteBackType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.BlockDescriptor;
import de.datomino.peppergis.client.model.admin.JobScheduleModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.configuration.gui.job.schedule.parameter.SimpleUserJobParameterPane;
import de.datomino.peppergis.configuration.gui.job.schedule.parameter.special.CloneLayerJobSettingsPane;
import de.datomino.peppergis.configuration.gui.job.schedule.parameter.special.DeprecatedLetterCleanerJobSettingsPane;
import de.datomino.peppergis.configuration.gui.job.schedule.parameter.special.DeprecatedSubscriptionCleanerJobSettingsPane;
import de.datomino.peppergis.configuration.gui.job.schedule.parameter.special.ExportParcelOfChangedAreasSettingsPane;
import de.datomino.peppergis.configuration.gui.job.schedule.parameter.special.ReviewAreaTourJobSettingsPane;
import de.datomino.peppergis.dto.exporter.TourExportFormat;
import de.datomino.peppergis.job.user.CloneLayerJobParameters;
import de.datomino.peppergis.job.user.DeprecatedLetterCleanerJobParameters;
import de.datomino.peppergis.job.user.DeprecatedSubscriptionCleanerJobParameters;
import de.datomino.peppergis.job.user.OldGeoTrackAnonymizerJobParameters;
import de.datomino.peppergis.job.user.OldTourCleanerJobParameters;
import de.datomino.peppergis.job.user.ParcelsOfChangedAreasExportUserBeanJobParameter;
import de.datomino.peppergis.job.user.ReviewAreaTourJobParameters;
import de.datomino.peppergis.tour.CalculationWay;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.LetterDeliveryType;
import de.datomino.peppergis.type.SubscriptionDeliveryType;
import de.datomino.peppergis.type.SubscriptionStatus;
import de.datomino.peppergis.type.areatourtype.AreaCalculationType;
import de.datomino.peppergis.util.NightSurchargeTimeWindow;
import de.datomino.peppergis.util.RewardEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.ktde.util.datatypes.Tripel;

public class JobScheduleParameterUtil {
    private static final String USER_PARCELS_OF_CHANGED_AREAS_EXPORT_JOB = "userParcelsOfChangedAreasUserBeanExportJob";
    private static final String USER_DEPRECATED_SUBSCRIPTION_CLEANER_JOB = "userDeprecatedSubscriptionCleanerJob";
    private static final String USER_OLD_GEOTRACK_ANONYMIZER_JOB = "userOldGeoTrackAnonymizerJob";
    private static final String USER_OLD_TOUR_CLEANER_JOB = "userOldTourCleanerJob";
    private static final String USER_CLONE_LAYER_JOB = "userCloneLayerJob";
    private static final String USER_REVIEW_AREA_TOUR_JOB = "userReviewAreaJob";
    private static final String USER_DEPRECATED_LETTER_CLEANER_JOB = "userDeprecatedLetterCleanerJob";
    private Map<String, JComponent> componentMap = new HashMap<String, JComponent>();
    private ModelEnviroment modelEnviroment;

    public JobScheduleParameterUtil(ModelEnviroment modelEnviroment) {
        this.modelEnviroment = modelEnviroment;
    }

    public byte[] getDefaultParameters(String jobBeanName) {
        switch (jobBeanName) {
            case "userParcelsOfChangedAreasUserBeanExportJob": {
                Collection<AreaLayerModel> areaLayersForType = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
                return ParcelsOfChangedAreasExportUserBeanJobParameter.toJson(areaLayersForType.isEmpty() ? "" : areaLayersForType.iterator().next().getDisplayname(), null, null, null);
            }
            case "userDeprecatedSubscriptionCleanerJob": {
                return DeprecatedSubscriptionCleanerJobParameters.toJson(30, null);
            }
            case "userDeprecatedLetterCleanerJob": {
                return DeprecatedLetterCleanerJobParameters.toJson(30, null);
            }
            case "userOldGeoTrackAnonymizerJob": {
                return OldGeoTrackAnonymizerJobParameters.toJson(30);
            }
            case "userOldTourCleanerJob": {
                return OldTourCleanerJobParameters.toJson(30);
            }
            case "userCloneLayerJob": {
                return CloneLayerJobParameters.toJson(0L, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.newLayer", new Serializable[0]), true, true, true, true, true, true, CloneLayerJobParameters.Mode.OVERWRITE);
            }
            case "userReviewAreaJob": {
                List<String> emptyList1 = Collections.emptyList();
                List<ReviewAreaTourJobParameters.BlockDescriptor> emptyList2 = Collections.emptyList();
                return ReviewAreaTourJobParameters.toJson(new ReviewAreaTourJobParameters("", emptyList1, false, "", CalculationWay.OPTIMIZE, AreaCalculationType.DEFAULT, new Date(), null, 0, TourExportFormat.CSV, false, new RouteVehicleType[]{RouteVehicleType.FOOT}, false, RouteVehicleType.FOOT, false, RouteVehicleType.FOOT, false, false, false, RouteBackType.NONE, false, false, Collections.singletonList(SubscriptionStatus.ACTIVE), Collections.singletonList(SubscriptionDeliveryType.ALL), Collections.singletonList(LetterDeliveryType.ALL), false, emptyList2, 0.0, 0.0, 0.0, 0.0, 0.0, 0, 0, 0, 0.0));
            }
        }
        return new byte[0];
    }

    public JComponent getParameterPanel(String jobBeanName) {
        JComponent comp = this.componentMap.get(jobBeanName);
        if (comp == null) {
            switch (jobBeanName) {
                case "userParcelsOfChangedAreasUserBeanExportJob": {
                    comp = new ExportParcelOfChangedAreasSettingsPane(this.modelEnviroment);
                    this.componentMap.put(USER_PARCELS_OF_CHANGED_AREAS_EXPORT_JOB, comp);
                    break;
                }
                case "userDeprecatedSubscriptionCleanerJob": {
                    comp = new DeprecatedSubscriptionCleanerJobSettingsPane(this.modelEnviroment);
                    this.componentMap.put(USER_DEPRECATED_SUBSCRIPTION_CLEANER_JOB, comp);
                    break;
                }
                case "userDeprecatedLetterCleanerJob": {
                    comp = new DeprecatedLetterCleanerJobSettingsPane(this.modelEnviroment);
                    this.componentMap.put(USER_DEPRECATED_LETTER_CLEANER_JOB, comp);
                    break;
                }
                case "userOldGeoTrackAnonymizerJob": {
                    comp = new SimpleUserJobParameterPane(Arrays.asList(new Tripel<String, String, Class<Integer>>("days", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.days", new Serializable[0]), Integer.class)));
                    this.componentMap.put(USER_OLD_GEOTRACK_ANONYMIZER_JOB, comp);
                    break;
                }
                case "userOldTourCleanerJob": {
                    comp = new SimpleUserJobParameterPane(Arrays.asList(new Tripel<String, String, Class<Integer>>("days", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.days", new Serializable[0]), Integer.class)));
                    this.componentMap.put(USER_OLD_TOUR_CLEANER_JOB, comp);
                    break;
                }
                case "userCloneLayerJob": {
                    comp = new CloneLayerJobSettingsPane(this.modelEnviroment);
                    this.componentMap.put(USER_CLONE_LAYER_JOB, comp);
                    break;
                }
                case "userReviewAreaJob": {
                    comp = new ReviewAreaTourJobSettingsPane(this.modelEnviroment);
                    this.componentMap.put(USER_REVIEW_AREA_TOUR_JOB, comp);
                }
            }
        }
        return comp;
    }

    public byte[] getParameters(String jobBeanName) {
        JComponent comp = this.getParameterPanel(jobBeanName);
        switch (jobBeanName) {
            case "userParcelsOfChangedAreasUserBeanExportJob": {
                ExportParcelOfChangedAreasSettingsPane exportParcelOfChangedAreasSettingsPane = (ExportParcelOfChangedAreasSettingsPane)comp;
                Date date = exportParcelOfChangedAreasSettingsPane.getDate();
                Collection<Long> areaObjectIds = null;
                if (!exportParcelOfChangedAreasSettingsPane.isShowAllSelected()) {
                    areaObjectIds = exportParcelOfChangedAreasSettingsPane.getAreas();
                }
                AreaLayerModel layer = exportParcelOfChangedAreasSettingsPane.getLayer();
                AreaLayerModel targetLayer = exportParcelOfChangedAreasSettingsPane.getTargetLayer();
                return ParcelsOfChangedAreasExportUserBeanJobParameter.toJson(layer.getDisplayname(), areaObjectIds, date, targetLayer == null ? null : targetLayer.getId());
            }
            case "userDeprecatedSubscriptionCleanerJob": {
                DeprecatedSubscriptionCleanerJobSettingsPane deprecatedSubscriptionCleanerJobSettingsPane = (DeprecatedSubscriptionCleanerJobSettingsPane)comp;
                int days = deprecatedSubscriptionCleanerJobSettingsPane.getDays();
                Collection<AreaLayerModel> layers = deprecatedSubscriptionCleanerJobSettingsPane.getAreaLayers();
                ArrayList<Long> areaLayerIds = null;
                if (layers != null) {
                    areaLayerIds = new ArrayList<Long>(layers.size());
                    for (AreaLayerModel areaLayer : layers) {
                        areaLayerIds.add(areaLayer.getId());
                    }
                }
                return DeprecatedSubscriptionCleanerJobParameters.toJson(days, areaLayerIds);
            }
            case "userDeprecatedLetterCleanerJob": {
                DeprecatedLetterCleanerJobSettingsPane deprecatedLetterCleanerJobSettingsPane = (DeprecatedLetterCleanerJobSettingsPane)comp;
                int days = deprecatedLetterCleanerJobSettingsPane.getDays();
                Collection<AreaLayerModel> layers = deprecatedLetterCleanerJobSettingsPane.getAreaLayers();
                ArrayList<Long> areaLayerIds = null;
                if (layers != null) {
                    areaLayerIds = new ArrayList<Long>(layers.size());
                    for (AreaLayerModel areaLayer : layers) {
                        areaLayerIds.add(areaLayer.getId());
                    }
                }
                return DeprecatedLetterCleanerJobParameters.toJson(days, areaLayerIds);
            }
            case "userOldGeoTrackAnonymizerJob": {
                SimpleUserJobParameterPane simpleUserJobParameterPane = (SimpleUserJobParameterPane)comp;
                Integer daysI = (Integer)simpleUserJobParameterPane.getValue("days");
                return OldGeoTrackAnonymizerJobParameters.toJson(daysI);
            }
            case "userOldTourCleanerJob": {
                SimpleUserJobParameterPane simpleUserJobParameterPane = (SimpleUserJobParameterPane)comp;
                Integer daysI = (Integer)simpleUserJobParameterPane.getValue("days");
                return OldTourCleanerJobParameters.toJson(daysI);
            }
            case "userCloneLayerJob": {
                CloneLayerJobSettingsPane cloneLayerJobSettingsPane = (CloneLayerJobSettingsPane)comp;
                return CloneLayerJobParameters.toJson(cloneLayerJobSettingsPane.getAreaLayerId(), cloneLayerJobSettingsPane.getNewAreaLayerName(), cloneLayerJobSettingsPane.isAreaParcelRelations(), cloneLayerJobSettingsPane.isAreas(), cloneLayerJobSettingsPane.isSubscriptions(), cloneLayerJobSettingsPane.isLetters(), cloneLayerJobSettingsPane.isStops(), cloneLayerJobSettingsPane.isDelivererAreaRelations(), cloneLayerJobSettingsPane.getMode());
            }
            case "userReviewAreaJob": {
                ReviewAreaTourJobSettingsPane reviewAreaTourJobSettingsPane = (ReviewAreaTourJobSettingsPane)comp;
                return this.getUserReviewAreaTourJobParameters(reviewAreaTourJobSettingsPane);
            }
        }
        return new byte[0];
    }

    private byte[] getUserReviewAreaTourJobParameters(ReviewAreaTourJobSettingsPane reviewAreaTourJobSettingsPane) {
        String areaLayer = reviewAreaTourJobSettingsPane.getSelectedAreaLayer().getDisplayname();
        Collection<String> areaShortcuts = reviewAreaTourJobSettingsPane.getSelectedAreaShortcuts();
        boolean useDeliveryRoundFromLog2 = reviewAreaTourJobSettingsPane.isSelfParameter();
        String deliveryRound = reviewAreaTourJobSettingsPane.getDeliveryRound().getName();
        CalculationWay calculationWay = reviewAreaTourJobSettingsPane.getSelectedCalculationWay();
        AreaCalculationType areaCalculationType = reviewAreaTourJobSettingsPane.getAreaCalculationType();
        Date fixedDate = reviewAreaTourJobSettingsPane.getDate();
        Integer dayGap = reviewAreaTourJobSettingsPane.getDayGap();
        Tripel<Integer, Integer, Integer> time = reviewAreaTourJobSettingsPane.getTime();
        Integer minutes = null;
        if (time != null) {
            minutes = time.getElement1() * 60 + time.getElement2();
        }
        TourExportFormat tourExportFormat = reviewAreaTourJobSettingsPane.getTourExportType();
        boolean pdf = reviewAreaTourJobSettingsPane.isPdf();
        RouteVehicleType[] routeVehicleTypes = reviewAreaTourJobSettingsPane.getSelectedRouteVehicleTypes();
        boolean defaultPoiRouteVehicleType = reviewAreaTourJobSettingsPane.isDefaultPoiRouteVehicleTypeSelected();
        RouteVehicleType poiRouteVehicleType = reviewAreaTourJobSettingsPane.getPoiRouteVehicleType();
        boolean defaultPickPointRouteVehicleType = reviewAreaTourJobSettingsPane.isDefaultPickPointRouteVehicleTypeSelected();
        RouteVehicleType pickPointRouteVehicleType = reviewAreaTourJobSettingsPane.getPickPointRouteVehicleType();
        boolean withPoi = reviewAreaTourJobSettingsPane.isPoi();
        boolean withPickPointStart = reviewAreaTourJobSettingsPane.isStartPickPoint();
        boolean withPickPointEnd = reviewAreaTourJobSettingsPane.isEndPickPoint();
        RouteBackType routeBackType = reviewAreaTourJobSettingsPane.getRouteBackType();
        boolean withDifficultyLevel = reviewAreaTourJobSettingsPane.isWithDifficultyLevel();
        boolean withParcelLocation = reviewAreaTourJobSettingsPane.isWithParcelLocation();
        Collection<SubscriptionStatus> subscriptionStatus = reviewAreaTourJobSettingsPane.getSubscriptionStatus();
        Collection<SubscriptionDeliveryType> subscriptionDeliveryType = reviewAreaTourJobSettingsPane.getSubscriptionDeliveryTypes();
        Collection<LetterDeliveryType> letterDeliveryType = reviewAreaTourJobSettingsPane.getLetterDeliveryTypes();
        boolean preferExclusions = reviewAreaTourJobSettingsPane.isPreferExclusions();
        Collection<BlockDescriptor> rBlockDescriptors = reviewAreaTourJobSettingsPane.getBlockDescriptors();
        ArrayList<ReviewAreaTourJobParameters.BlockDescriptor> blockDescriptors = new ArrayList<ReviewAreaTourJobParameters.BlockDescriptor>(rBlockDescriptors.size());
        for (BlockDescriptor blockDescriptor : rBlockDescriptors) {
            blockDescriptors.add(new ReviewAreaTourJobParameters.BlockDescriptor(blockDescriptor.getParcelAttributeValueDescriptorModel().getKey(), blockDescriptor.getValue(), blockDescriptor.getParcelBlockType()));
        }
        RewardEntity rewardEntity = reviewAreaTourJobSettingsPane.getRewardEntity();
        Double costPerHour = null;
        Double costCarPerKilometer = null;
        Double costBikePerKilometer = null;
        Double costFootPerKilometer = null;
        Double nightSurcharge = null;
        Integer nightSurchargeFromMinute = null;
        Double extraCharge = null;
        if (rewardEntity != null) {
            costPerHour = rewardEntity.getHourReward();
            costCarPerKilometer = rewardEntity.getKmRewardMotor();
            costBikePerKilometer = rewardEntity.getKmRewardBike();
            costFootPerKilometer = rewardEntity.getKmRewardFoot();
            nightSurcharge = rewardEntity.getNightSurcharge();
            nightSurchargeFromMinute = rewardEntity.getNightSurchargeMinMinutes();
            extraCharge = rewardEntity.getExtraCharge();
        }
        NightSurchargeTimeWindow nightSurchargeTimeWindow = reviewAreaTourJobSettingsPane.getNight();
        Integer nightSurchargeValidFrom = null;
        Integer nightSurchargeValidTill = null;
        if (nightSurchargeTimeWindow != null) {
            nightSurchargeValidFrom = nightSurchargeTimeWindow.getStartHour() * 60 + nightSurchargeTimeWindow.getStartMinute();
            nightSurchargeValidTill = nightSurchargeTimeWindow.getEndHour() * 60 + nightSurchargeTimeWindow.getEndMinute();
        }
        ReviewAreaTourJobParameters reviewAreaTourJobParameters = new ReviewAreaTourJobParameters(areaLayer, areaShortcuts, useDeliveryRoundFromLog2, deliveryRound, calculationWay, areaCalculationType, fixedDate, dayGap, minutes, tourExportFormat, pdf, routeVehicleTypes, defaultPoiRouteVehicleType, poiRouteVehicleType, defaultPickPointRouteVehicleType, pickPointRouteVehicleType, withPoi, withPickPointStart, withPickPointEnd, routeBackType, withDifficultyLevel, withParcelLocation, subscriptionStatus, subscriptionDeliveryType, letterDeliveryType, preferExclusions, blockDescriptors, costPerHour, costCarPerKilometer, costBikePerKilometer, costFootPerKilometer, nightSurcharge, nightSurchargeFromMinute, nightSurchargeValidFrom, nightSurchargeValidTill, extraCharge);
        return ReviewAreaTourJobParameters.toJson(reviewAreaTourJobParameters);
    }

    public void setParameters(JobScheduleModel jobScheduleModel) {
        String jobBeanName = jobScheduleModel.getJobBeanName();
        JComponent comp = this.getParameterPanel(jobBeanName);
        switch (jobBeanName) {
            case "userParcelsOfChangedAreasUserBeanExportJob": {
                ExportParcelOfChangedAreasSettingsPane exportParcelOfChangedAreasSettingsPane = (ExportParcelOfChangedAreasSettingsPane)comp;
                ParcelsOfChangedAreasExportUserBeanJobParameter fromJson = ParcelsOfChangedAreasExportUserBeanJobParameter.fromJson(jobScheduleModel.getParameters());
                exportParcelOfChangedAreasSettingsPane.setDate(fromJson.getDate());
                exportParcelOfChangedAreasSettingsPane.setAreas(fromJson.getAreaObjectIds());
                String layer = fromJson.getAreaLayerName();
                Collection<AreaLayerModel> areaLayers = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayer(layer);
                exportParcelOfChangedAreasSettingsPane.setLayer(areaLayers.isEmpty() ? null : areaLayers.iterator().next());
                AreaLayerModel targetAreaLayer = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayer(fromJson.getTargetLayerId());
                exportParcelOfChangedAreasSettingsPane.setTargetLayer(targetAreaLayer);
                break;
            }
            case "userDeprecatedSubscriptionCleanerJob": {
                DeprecatedSubscriptionCleanerJobSettingsPane deprecatedSubscriptionCleanerJobSettingsPane = (DeprecatedSubscriptionCleanerJobSettingsPane)comp;
                DeprecatedSubscriptionCleanerJobParameters deprecatedSubscriptionCleanerJobParameters = DeprecatedSubscriptionCleanerJobParameters.fromJson(jobScheduleModel.getParameters());
                deprecatedSubscriptionCleanerJobSettingsPane.setDays(deprecatedSubscriptionCleanerJobParameters.getDays());
                deprecatedSubscriptionCleanerJobSettingsPane.setAreaLayerIds(deprecatedSubscriptionCleanerJobParameters.getAreaLayers());
                break;
            }
            case "userDeprecatedLetterCleanerJob": {
                DeprecatedLetterCleanerJobSettingsPane deprecatedLetterCleanerJobSettingsPane = (DeprecatedLetterCleanerJobSettingsPane)comp;
                DeprecatedLetterCleanerJobParameters deprecatedLetterCleanerJobParameters = DeprecatedLetterCleanerJobParameters.fromJson(jobScheduleModel.getParameters());
                deprecatedLetterCleanerJobSettingsPane.setDays(deprecatedLetterCleanerJobParameters.getDays());
                deprecatedLetterCleanerJobSettingsPane.setAreaLayerIds(deprecatedLetterCleanerJobParameters.getAreaLayers());
                break;
            }
            case "userOldGeoTrackAnonymizerJob": {
                SimpleUserJobParameterPane simpleUserJobParameterPane = (SimpleUserJobParameterPane)comp;
                OldGeoTrackAnonymizerJobParameters oldGeoTrackAnonymizerJobParameters = OldGeoTrackAnonymizerJobParameters.fromJson(jobScheduleModel.getParameters());
                simpleUserJobParameterPane.setValue("days", oldGeoTrackAnonymizerJobParameters.getDays());
                break;
            }
            case "userOldTourCleanerJob": {
                SimpleUserJobParameterPane simpleUserJobParameterPane = (SimpleUserJobParameterPane)comp;
                OldTourCleanerJobParameters oldTourCleanerJobParameters = OldTourCleanerJobParameters.fromJson(jobScheduleModel.getParameters());
                simpleUserJobParameterPane.setValue("days", oldTourCleanerJobParameters.getDays());
                break;
            }
            case "userCloneLayerJob": {
                CloneLayerJobSettingsPane cloneLayerJobSettingsPane = (CloneLayerJobSettingsPane)comp;
                CloneLayerJobParameters cloneLayerJobParameters = CloneLayerJobParameters.fromJson(jobScheduleModel.getParameters());
                cloneLayerJobSettingsPane.setAreaLayerId(cloneLayerJobParameters.getAreaLayerId());
                cloneLayerJobSettingsPane.setNewAreaLayerName(cloneLayerJobParameters.getNewLayerName());
                cloneLayerJobSettingsPane.setAreaParcelRelations(cloneLayerJobParameters.isAreaParcelRelations());
                cloneLayerJobSettingsPane.setAreas(cloneLayerJobParameters.isAreas());
                cloneLayerJobSettingsPane.setSubscriptions(cloneLayerJobParameters.isSubscriptions());
                cloneLayerJobSettingsPane.setStops(cloneLayerJobParameters.isStops());
                cloneLayerJobSettingsPane.setDelivererAreaRelations(cloneLayerJobParameters.isDelivererAreaRelations());
                cloneLayerJobSettingsPane.setMode(cloneLayerJobParameters.getMode());
                break;
            }
            case "userReviewAreaJob": {
                ReviewAreaTourJobSettingsPane reviewAreaTourJobSettingsPane = (ReviewAreaTourJobSettingsPane)comp;
                ReviewAreaTourJobParameters reviewAreaTourJobParameters = ReviewAreaTourJobParameters.fromJson(jobScheduleModel.getParameters());
                this.setUserReviewAreaTourJobParameters(reviewAreaTourJobSettingsPane, reviewAreaTourJobParameters);
            }
        }
    }

    private void setUserReviewAreaTourJobParameters(ReviewAreaTourJobSettingsPane reviewAreaTourJobSettingsPane, ReviewAreaTourJobParameters parameters) {
        String areaLayer = parameters.getAreaLayer();
        reviewAreaTourJobSettingsPane.setSelectedAreaLayer(areaLayer);
        Collection<String> areaShortcuts = parameters.getAreaShortcuts();
        if (areaShortcuts == null) {
            areaShortcuts = Collections.emptyList();
        }
        reviewAreaTourJobSettingsPane.setSelectedAreaShorts(areaShortcuts);
        boolean useDeliveryRoundFromLog2 = parameters.isUseDeliveryRoundFromLog2();
        reviewAreaTourJobSettingsPane.setSelfParameter(useDeliveryRoundFromLog2);
        String deliveryRound = parameters.getDeliveryRound();
        reviewAreaTourJobSettingsPane.setSelectedDeliveryRound(deliveryRound);
        CalculationWay calculationWay = parameters.getCalculationWay();
        reviewAreaTourJobSettingsPane.setSelectedCalculationWay(calculationWay);
        AreaCalculationType areaCalculationType = parameters.getAreaCalculationType();
        reviewAreaTourJobSettingsPane.setSelectedAreaCalculationType(areaCalculationType);
        Date fixedDate = parameters.getFixedDate();
        Integer dayGap = parameters.getDayGap();
        reviewAreaTourJobSettingsPane.setDateSettings(fixedDate, dayGap);
        Integer minutes = parameters.getMinutes();
        Tripel<Integer, Integer, Integer> time = minutes == null ? null : new Tripel<Integer, Integer, Integer>(minutes / 60, minutes % 60, 0);
        reviewAreaTourJobSettingsPane.setTime(time);
        TourExportFormat tourExportFormat = parameters.getTourExportFormat();
        reviewAreaTourJobSettingsPane.setTourExportType(tourExportFormat);
        boolean pdf = parameters.isPdf();
        reviewAreaTourJobSettingsPane.setPdf(pdf);
        RouteVehicleType[] routeVehicleTypes = parameters.getRouteVehicleTypes();
        reviewAreaTourJobSettingsPane.setSelectedRouteVehicleTypes(routeVehicleTypes);
        boolean defaultPoiRouteVehicleType = parameters.isDefaultPoiRouteVehicleType();
        RouteVehicleType poiRouteVehicleType = parameters.getPoiRouteVehicleType();
        reviewAreaTourJobSettingsPane.setPoiRouteVehicleType(defaultPoiRouteVehicleType, poiRouteVehicleType);
        boolean defaultPickPointRouteVehicleType = parameters.isDefaultPickPointRouteVehicleType();
        RouteVehicleType pickPointRouteVehicleType = parameters.getPickPointRouteVehicleType();
        reviewAreaTourJobSettingsPane.setPickPointRouteVehicleType(defaultPickPointRouteVehicleType, pickPointRouteVehicleType);
        boolean withPoi = parameters.isWithPoi();
        reviewAreaTourJobSettingsPane.setPoi(withPoi);
        boolean withPickPointStart = parameters.isWithPickPointStart();
        reviewAreaTourJobSettingsPane.setStartPickPoint(withPickPointStart);
        boolean withPickPointEnd = parameters.isWithPickPointEnd();
        reviewAreaTourJobSettingsPane.setEndPickPoint(withPickPointEnd);
        RouteBackType routeBackType = parameters.getRouteBackType();
        reviewAreaTourJobSettingsPane.setRouteBackType(routeBackType);
        boolean withDifficultyLevel = parameters.isWithDifficultyLevel();
        reviewAreaTourJobSettingsPane.setWithDifficultyLevel(withDifficultyLevel);
        boolean withParcelLocation = parameters.isWithParcelLocation();
        reviewAreaTourJobSettingsPane.setWithParcelLocation(withParcelLocation);
        Collection<SubscriptionStatus> subscriptionStatus = parameters.getSubscriptionStatus();
        reviewAreaTourJobSettingsPane.setSubscriptionStatus(subscriptionStatus);
        Collection<SubscriptionDeliveryType> subscriptionDeliveryType = parameters.getSubscriptionDeliveryType();
        reviewAreaTourJobSettingsPane.setSubscriptionDeliveryType(subscriptionDeliveryType);
        Collection<LetterDeliveryType> letterDeliveryType = parameters.getLetterDeliveryType();
        reviewAreaTourJobSettingsPane.setLetterDeliveryType(letterDeliveryType);
        boolean preferExclusions = parameters.isPreferExclusions();
        reviewAreaTourJobSettingsPane.setPreferExclusions(preferExclusions);
        Collection<ReviewAreaTourJobParameters.BlockDescriptor> rBlockDescriptors = parameters.getBlockDescriptors();
        ArrayList<BlockDescriptor> blockDescriptors = new ArrayList<BlockDescriptor>(rBlockDescriptors.size());
        Collection<ParcelAttributeValueDescriptorModel> parcelAttributeValueDescriptors = this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchAllParcelAttributeValueDescriptors();
        HashMap<String, ParcelAttributeValueDescriptorModel> parcelMap = new HashMap<String, ParcelAttributeValueDescriptorModel>();
        for (ParcelAttributeValueDescriptorModel model : parcelAttributeValueDescriptors) {
            parcelMap.put(model.getKey(), model);
        }
        for (ReviewAreaTourJobParameters.BlockDescriptor blockDescriptor : rBlockDescriptors) {
            String key = blockDescriptor.getKey();
            ParcelAttributeValueDescriptorModel model = (ParcelAttributeValueDescriptorModel)parcelMap.get(key);
            if (model == null) continue;
            blockDescriptors.add(new BlockDescriptor(model, blockDescriptor.getValue(), blockDescriptor.getParcelBlockType()));
        }
        reviewAreaTourJobSettingsPane.setBlockDescriptors(blockDescriptors);
        Double costPerHour = parameters.getCostPerHour();
        Double costCarPerKilometer = parameters.getCostCarPerKilometer();
        Double costBikePerKilometer = parameters.getCostBikePerKilometer();
        Double costFootPerKilometer = parameters.getCostCarPerKilometer();
        Double nightSurcharge = parameters.getNightSurcharge();
        Integer nightSurchargeFromMinute = parameters.getNightSurchargeFromMinute();
        Double extraCharge = parameters.getExtraCharge();
        RewardEntity rewardEntity = new RewardEntity(costCarPerKilometer, costBikePerKilometer, costFootPerKilometer, costPerHour, nightSurcharge, nightSurchargeFromMinute == null ? null : Integer.valueOf(nightSurchargeFromMinute * 60), extraCharge);
        reviewAreaTourJobSettingsPane.setRewardEntity(rewardEntity);
        Integer nightSurchargeValidFrom = parameters.getNightSurchargeValidFrom();
        Integer nightSurchargeValidTill = parameters.getNightSurchargeValidTill();
        reviewAreaTourJobSettingsPane.getNight();
        int startHour = 0;
        int startMinute = 0;
        if (nightSurchargeValidFrom != null) {
            startHour = nightSurchargeValidFrom / 60;
            startMinute = nightSurchargeValidFrom % 60;
        }
        int endHour = 0;
        int endMinute = 0;
        if (nightSurchargeValidTill != null) {
            endHour = nightSurchargeValidTill / 60;
            endMinute = nightSurchargeValidTill % 60;
        }
        NightSurchargeTimeWindow nightSurchargeTimeWindow = new NightSurchargeTimeWindow(startHour, startMinute, endHour, endMinute);
        reviewAreaTourJobSettingsPane.setNight(nightSurchargeTimeWindow);
    }
}

