/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.job.schedule;

import de.datomino.peppergis.client.communication.ClientManagementCaller;
import de.datomino.peppergis.client.gui.common.AbstractCommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.dto.task.ServerTaskManagerStatus;
import de.datomino.peppergis.dto.task.TaskReport;
import de.datomino.peppergis.dto.task.TaskStatus;
import de.datomino.peppergis.dto.task.TaskType;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.message.MessageResolver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.ktde.util.StringUtil;

public class ServerTaskDialog
extends AbstractCommonDialog {
    private static final long serialVersionUID = 3207576824282651502L;
    private static final int COLUMN_COUNT = 6;
    private static final int COLUMN_ID = 1;

    public ServerTaskDialog(Component parent) {
        super(new ModelEnviroment(null), parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.task.serverTasks", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment.getUndoManager().setParent(this);
    }

    @Override
    protected Action getCancelAction() {
        return null;
    }

    @Override
    protected Component getMainComponent() {
        ClientManagementCaller clientManagementCaller = this.modelEnviroment.getAllCaller().getClientManagementCaller();
        ServerTaskManagerStatus status = clientManagementCaller.getServerTaskManagerStatus();
        DefaultTableModel dm = new DefaultTableModel(this.createData(status.getUserTaskMap()), this.createHeader());
        JTable table = new JTable(dm);
        this.setTableStyle(table);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)table.getTableHeader(), "North");
        pane.add((Component)table, "Center");
        return pane;
    }

    private Object[][] createData(Map<Long, List<TaskReport>> userTaskMap) {
        int rowCount = 0;
        for (List<TaskReport> list : userTaskMap.values()) {
            rowCount += list.isEmpty() ? 1 : list.size();
        }
        Object[][] data = new Object[rowCount][6];
        rowCount = 0;
        List<UserModel> users = this.modelEnviroment.getAllCaller().getUserCaller().fetchUsersByIds(userTaskMap.keySet());
        for (UserModel user : users) {
            String name = user.getLogin() + " - " + user.getName();
            List<TaskReport> list = userTaskMap.get(user.getId());
            if (list.isEmpty()) {
                String[] row = new String[6];
                row[0] = name;
                data[rowCount++] = row;
                continue;
            }
            for (TaskReport report : list) {
                String[] row = new String[]{name, report.getId() == null ? "" : String.valueOf(report.getId()), report.getType() == null ? "" : ModelEnviroment.getMessageResolver().resolveMessageForEnum(report.getType()), report.getType() == null ? "" : ModelEnviroment.getMessageResolver().resolveMessageForEnum(report.getStatus()), ClientFormUtil.dateToString(report.getCreationTime()), ClientFormUtil.dateToString(report.getStartTime())};
                data[rowCount++] = row;
            }
        }
        return data;
    }

    private String[] createHeader() {
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        String[] columnHeader = new String[]{" \n" + messageResolver.resolveMessage("messages.default.user", new Serializable[0]) + "\n \n", " \n" + messageResolver.resolveMessage("gui.task.id", new Serializable[0]), " \n" + messageResolver.resolveMessageForEnum(TaskType.class), " \n" + messageResolver.resolveMessageForEnum(TaskStatus.class), " \n" + messageResolver.resolveMessage("messages.default.creationTime", new Serializable[0]), " \n" + messageResolver.resolveMessage("messages.trackwatch.start.time", new Serializable[0])};
        return columnHeader;
    }

    private void setTableStyle(final JTable table) {
        table.setCellSelectionEnabled(false);
        table.setRowHeight(40);
        table.setRowMargin(5);
        table.setPreferredSize(new Dimension(950, 500));
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(200);
        columnModel.getColumn(1).setPreferredWidth(100);
        columnModel.getColumn(2).setPreferredWidth(250);
        columnModel.getColumn(3).setPreferredWidth(100);
        columnModel.getColumn(4).setPreferredWidth(150);
        columnModel.getColumn(5).setPreferredWidth(150);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = columnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
        }
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selectedRow = table.rowAtPoint(e.getPoint());
                if (selectedRow < 0) {
                    return;
                }
                DefaultTableModel tm = (DefaultTableModel)table.getModel();
                String value = (String)tm.getValueAt(selectedRow, 1);
                if (e.getButton() == 3 && !StringUtil.isBlank(value)) {
                    Long taskId = Long.parseLong(value);
                    ServerTaskDialog.this.showPopupMenu(taskId, table, e);
                    table.clearSelection();
                }
            }
        });
    }

    private void showPopupMenu(final Long taskId, final JTable table, MouseEvent e) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0])){
            private static final long serialVersionUID = 4536962730704640672L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int d = JOptionPane.showConfirmDialog(table, ModelEnviroment.getMessageResolver().resolveMessage("gui.task.deleteQuestion", taskId), "", 0);
                switch (d) {
                    case 0: {
                        ServerTaskDialog.this.removeServerTask(taskId, table);
                        break;
                    }
                }
            }
        });
        popupMenu.show(table, e.getX(), e.getY());
    }

    private void removeServerTask(Long taskId, JTable table) {
        ClientManagementCaller clientManagementCaller = this.modelEnviroment.getAllCaller().getClientManagementCaller();
        ServerTaskManagerStatus newStatus = clientManagementCaller.removeServerTasks(CollectionUtil.buildHashSet(taskId));
        TaskReport removed = null;
        for (List<TaskReport> reports : newStatus.getUserTaskMap().values()) {
            for (TaskReport report : reports) {
                if (!report.getId().equals(taskId)) continue;
                removed = report;
            }
        }
        if (removed != null) {
            String message = ModelEnviroment.getMessageResolver().resolveMessage("gui.task.deleteFailed", new Serializable[]{removed.getId(), ModelEnviroment.getMessageResolver().resolveMessageForEnum(removed.getStatus())});
            JOptionPane.showMessageDialog(table, message, "", 2);
        }
        DefaultTableModel tm = (DefaultTableModel)table.getModel();
        tm.setDataVector(this.createData(newStatus.getUserTaskMap()), this.createHeader());
        this.setTableStyle(table);
        tm.fireTableDataChanged();
    }
}

