/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.job.schedule;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.admin.JobScheduleModel;
import de.datomino.peppergis.configuration.gui.job.schedule.UserJobBeanComboBox;
import de.datomino.peppergis.configuration.gui.job.schedule.parameter.JobScheduleParameterUtil;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.quartz.CronExpression;

public class JobSchedulePane
extends JPanel {
    private static final long serialVersionUID = -4003056037742124141L;
    private JobScheduleModel jobScheduleModel;
    private UserJobBeanComboBox userJobBeanComboBox;
    private JTextField cronExpression;
    private JTextField name;
    private JPanel parameterPanel;
    private CardLayout cardLayout;
    private JobScheduleParameterUtil jobScheduleParamterUtil;
    private CronEditAction cronEditAction;
    private ModelEnviroment modelEnviroment;

    public JobSchedulePane(Map<String, String> jobBeans, JobScheduleParameterUtil jobScheduleParamterUtil, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.jobScheduleParamterUtil = jobScheduleParamterUtil;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout(jobBeans);
        this.setEnabled(false);
    }

    private void buildLayout(Map<String, String> jobBeans) {
        JPanel head = new JPanel(new SpringLayout());
        head.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0])));
        this.name = new JTextField();
        head.add(this.name);
        head.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.job", new Serializable[0])));
        this.userJobBeanComboBox = new UserJobBeanComboBox(jobBeans);
        head.add(this.userJobBeanComboBox);
        head.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.job.cron", new Serializable[0])));
        JPanel cronPanel = new JPanel(new BorderLayout());
        this.cronExpression = new JTextField();
        this.cronExpression.setEditable(false);
        cronPanel.add((Component)this.cronExpression, "Center");
        this.cronEditAction = new CronEditAction();
        cronPanel.add((Component)new JButton(this.cronEditAction), "East");
        head.add(cronPanel);
        SpringUtilities.makeCompactGrid(head, 3, 2, 5, 5, 2, 2);
        this.add((Component)head, "North");
        this.cardLayout = new CardLayout();
        this.parameterPanel = new JPanel(this.cardLayout);
        this.parameterPanel.add((Component)new JPanel(), "EMPTY");
        for (Map.Entry<String, String> jobBean : jobBeans.entrySet()) {
            String jobBeanName = jobBean.getKey();
            JComponent parameterPanel2 = this.jobScheduleParamterUtil.getParameterPanel(jobBeanName);
            this.parameterPanel.add((Component)parameterPanel2, jobBeanName);
        }
        this.userJobBeanComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tupel<String, String> selected = JobSchedulePane.this.userJobBeanComboBox.getSelectedValue();
                String jobBeanName = selected.getElement1();
                JobSchedulePane.this.cardLayout.show(JobSchedulePane.this.parameterPanel, jobBeanName);
            }
        });
        this.add((Component)this.parameterPanel, "Center");
    }

    public void setJobSchedule(JobScheduleModel jobScheduleModel) {
        this.adaptValues();
        this.jobScheduleModel = jobScheduleModel;
        if (jobScheduleModel == null) {
            this.cardLayout.show(this.parameterPanel, "EMPTY");
            this.setEnabled(false);
            this.cronExpression.setText("");
            this.name.setText("");
            this.userJobBeanComboBox.setSelectedIndex(0);
        } else {
            this.cardLayout.show(this.parameterPanel, jobScheduleModel.getJobBeanName());
            this.cronExpression.setText(jobScheduleModel.getCronExpression());
            this.name.setText(jobScheduleModel.getName());
            this.userJobBeanComboBox.setSelectedJobBean(jobScheduleModel.getJobBeanName());
            this.jobScheduleParamterUtil.setParameters(jobScheduleModel);
            this.setEnabled(true);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.cronEditAction.setEnabled(enabled);
        this.name.setEditable(enabled);
        this.userJobBeanComboBox.setEnabled(enabled);
        if (enabled) {
            if (this.jobScheduleModel != null) {
                this.cardLayout.show(this.parameterPanel, this.jobScheduleModel.getJobBeanName());
            }
        } else {
            this.cardLayout.show(this.parameterPanel, "EMPTY");
        }
    }

    public void adaptValues() {
        if (this.jobScheduleModel != null) {
            UndoManager undoManager = this.modelEnviroment.getUndoManager();
            undoManager.startTransaction();
            this.jobScheduleModel.setCronExpression(this.cronExpression.getText());
            this.jobScheduleModel.setJobBeanName(this.userJobBeanComboBox.getSelectedValue().getElement1());
            this.jobScheduleModel.setName(this.name.getText());
            this.jobScheduleModel.setParameters(this.jobScheduleParamterUtil.getParameters(this.userJobBeanComboBox.getSelectedValue().getElement1()));
            undoManager.finishTransaction("");
        }
    }

    private class CronEditAction
    extends AbstractAction {
        private static final long serialVersionUID = -6259394722107084351L;

        public CronEditAction() {
            super("...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel panel = new JPanel(new SpringLayout());
            MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
            StringBuilder sb = new StringBuilder("\"").append(messageResolver.resolveMessage("messages.default.second", new Serializable[0])).append("\" \"").append(messageResolver.resolveMessage("messages.default.minute", new Serializable[0])).append("\" \"").append(messageResolver.resolveMessage("messages.default.hour", new Serializable[0])).append("\" \"").append(messageResolver.resolveMessage("messages.default.dayOfMonth", new Serializable[0])).append("\" \"").append(messageResolver.resolveMessage("messages.default.month", new Serializable[0])).append("\" \"").append(messageResolver.resolveMessage("messages.default.dayOfWeek", new Serializable[0])).append("\" \"").append(messageResolver.resolveMessage("messages.default.year", new Serializable[0])).append(" (").append(messageResolver.resolveMessage("messages.default.optional", new Serializable[0])).append(")\"");
            panel.add(new JLabel(sb.toString()));
            JTextField tf = new JTextField(JobSchedulePane.this.cronExpression.getText());
            panel.add(tf);
            SpringUtilities.makeCompactGrid(panel, 2, 1, 5, 5, 5, 5);
            int d = 0;
            Window parent = SwingUtils.findWindowParent(JobSchedulePane.this);
            block4: while (true) {
                d = JOptionPane.showConfirmDialog(parent, panel, messageResolver.resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
                switch (d) {
                    case 1: {
                        break block4;
                    }
                    case 0: {
                        String value = tf.getText();
                        if (!StringUtil.isBlank(value) && !CronExpression.isValidExpression(value)) {
                            JOptionPane.showMessageDialog(parent, messageResolver.resolveMessage("messages.job.cron.noValidExpression", new Serializable[0]), messageResolver.resolveMessage("messages.default.error", new Serializable[0]), 0);
                        } else {
                            JobSchedulePane.this.cronExpression.setText(value);
                            break block4;
                        }
                    }
                    default: {
                        continue block4;
                    }
                }
                break;
            }
        }
    }
}

