/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.job.schedule;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.admin.JobScheduleModel;
import de.datomino.peppergis.client.model.admin.JobScheduleModelImpl;
import de.datomino.peppergis.configuration.gui.job.schedule.JobSchedulePane;
import de.datomino.peppergis.configuration.gui.job.schedule.JobScheduleTableModel;
import de.datomino.peppergis.configuration.gui.job.schedule.parameter.JobScheduleParameterUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.util.datatypes.Tupel;

public class JobScheduleOverviewPane
extends JPanel {
    private static final long serialVersionUID = -3092219950502835477L;
    private ModelEnviroment modelEnviroment;
    private JTable scheduleTable;
    private Action removeAction;
    private Action addAction;
    private JobSchedulePane jobSchedulePane;
    private Map<String, String> avaiableJobs;
    private JobScheduleParameterUtil jobScheduleParamterUtil;

    public JobScheduleOverviewPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.jobScheduleParamterUtil = new JobScheduleParameterUtil(modelEnviroment);
        List<Tupel<String, String>> userJobs = this.modelEnviroment.getAllCaller().getJobCaller().getUserJobs();
        this.avaiableJobs = new LinkedHashMap<String, String>();
        for (Tupel<String, String> tupel : userJobs) {
            this.avaiableJobs.put(tupel.getElement1(), tupel.getElement2());
        }
        this.buildLayout();
        JobScheduleTableModel jobScheduleTableModel = (JobScheduleTableModel)this.scheduleTable.getModel();
        jobScheduleTableModel.setJobSchedules(this.modelEnviroment.getAllCaller().getJobCaller().getScheduledUserJobs());
    }

    private void buildLayout() {
        JSplitPane split = new JSplitPane(1);
        JPanel leftPanel = new JPanel(new BorderLayout());
        this.scheduleTable = new JTable(new JobScheduleTableModel(this.avaiableJobs));
        this.scheduleTable.getSelectionModel().setSelectionMode(0);
        this.scheduleTable.getSelectionModel().addListSelectionListener(new JobScheduleTableSelectionListener());
        this.scheduleTable.getTableHeader().setReorderingAllowed(false);
        leftPanel.add((Component)new JScrollPane(this.scheduleTable), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.removeAction = new RemoveAction();
        this.removeAction.setEnabled(false);
        buttonPanel.add((Component)new JButton(this.removeAction), "West");
        this.addAction = new AddAction();
        buttonPanel.add((Component)new JButton(this.addAction), "East");
        leftPanel.add((Component)buttonPanel, "South");
        split.setLeftComponent(leftPanel);
        this.jobSchedulePane = new JobSchedulePane(this.avaiableJobs, this.jobScheduleParamterUtil, this.modelEnviroment);
        split.setRightComponent(this.jobSchedulePane);
        this.add((Component)split, "Center");
    }

    public void adaptValues() {
        this.jobSchedulePane.adaptValues();
    }

    private class JobScheduleTableSelectionListener
    implements ListSelectionListener {
        private JobScheduleTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            JobScheduleModel jobSchedule = null;
            int row = JobScheduleOverviewPane.this.scheduleTable.getSelectedRow();
            if (row >= 0) {
                JobScheduleTableModel jobScheduleTableModel = (JobScheduleTableModel)JobScheduleOverviewPane.this.scheduleTable.getModel();
                jobSchedule = jobScheduleTableModel.getJobScheduleAt(row);
                JobScheduleOverviewPane.this.removeAction.setEnabled(true);
            } else {
                JobScheduleOverviewPane.this.removeAction.setEnabled(false);
            }
            JobScheduleOverviewPane.this.jobSchedulePane.setJobSchedule(jobSchedule);
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = -7496976610765303920L;

        public RemoveAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = JobScheduleOverviewPane.this.scheduleTable.getSelectedRow();
            JobScheduleTableModel jobScheduleTableModel = (JobScheduleTableModel)JobScheduleOverviewPane.this.scheduleTable.getModel();
            JobScheduleModel jobSchedule = jobScheduleTableModel.removeJobScheduleAt(row);
            JobScheduleOverviewPane.this.modelEnviroment.getUndoManager().startTransaction();
            jobSchedule.delete();
            JobScheduleOverviewPane.this.modelEnviroment.getUndoManager().finishTransaction("");
        }
    }

    private class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = -6006502317010272784L;

        public AddAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JobScheduleOverviewPane.this.modelEnviroment.getUndoManager().startTransaction();
            JobScheduleModelImpl jobScheduleModel = new JobScheduleModelImpl();
            jobScheduleModel.setCronExpression("");
            jobScheduleModel.setJobBeanName(null);
            String jobBeanName = (String)JobScheduleOverviewPane.this.avaiableJobs.keySet().iterator().next();
            jobScheduleModel.setJobBeanName(jobBeanName);
            jobScheduleModel.setName("");
            jobScheduleModel.setParameters(JobScheduleOverviewPane.this.jobScheduleParamterUtil.getDefaultParameters(jobBeanName));
            JobScheduleTableModel model = (JobScheduleTableModel)JobScheduleOverviewPane.this.scheduleTable.getModel();
            model.addJobSchedule(jobScheduleModel);
            JobScheduleOverviewPane.this.modelEnviroment.getUndoManager().finishTransaction("");
        }
    }
}

