/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.job.schedule;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.configuration.gui.job.schedule.JobScheduleOverviewPane;
import de.datomino.peppergis.dto.Dto;
import de.datomino.peppergis.dto.i18n.MessageDto;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JobScheduleDialog
extends CommonDialog {
    private static final long serialVersionUID = 6541953439777191218L;
    private ModelEnviroment modelEnviroment = new ModelEnviroment(this);
    private JobScheduleOverviewPane jobScheduleOverviewPane;

    public JobScheduleDialog(Component parent) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.job.userjobs", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.buildLayout();
        this.pack();
        SwingUtils.center((Window)this, parent);
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 5410588400922900463L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JobScheduleDialog.this.jobScheduleOverviewPane.adaptValues();
                try {
                    JobScheduleDialog.this.modelEnviroment.getUndoManager().storeTransactions();
                    JobScheduleDialog.this.modelEnviroment.close();
                    JobScheduleDialog.this.dispose();
                }
                catch (ValidateException ex) {
                    Map<Dto, List<MessageDto>> errormessages = ex.getErrormessages();
                    JTextArea text = new JTextArea(5, 30);
                    for (List<MessageDto> list : errormessages.values()) {
                        for (MessageDto message : list) {
                            text.append(ModelEnviroment.getMessageResolver().resolveMessage(message.getMessageKey(), message.getArgs()));
                            text.append("\n");
                        }
                    }
                    text.setEditable(false);
                    text.setCaretPosition(0);
                    JOptionPane.showMessageDialog(JobScheduleDialog.this, new JScrollPane(text), ModelEnviroment.getMessageResolver().resolveMessage("messages.error", new Serializable[0]), 0);
                }
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 8140570704705777360L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JobScheduleDialog.this.modelEnviroment.getUndoManager().rollbackTransaction();
                JobScheduleDialog.this.modelEnviroment.close();
                JobScheduleDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        this.jobScheduleOverviewPane = new JobScheduleOverviewPane(this.modelEnviroment);
        return this.jobScheduleOverviewPane;
    }
}

