/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.area;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.DetaillessLevelModel;
import de.datomino.peppergis.client.model.area.DetaillessLevelModelImpl;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.util.datatypes.Tupel;

public class AreaLayerDetaillessConfigurationPane
extends JPanel {
    private static final long serialVersionUID = -6255191645738001800L;
    private static final Comparator<DetaillessLevelModel> DETAIL_COMPARATOR = new Comparator<DetaillessLevelModel>(){

        @Override
        public int compare(DetaillessLevelModel o1, DetaillessLevelModel o2) {
            return Double.compare(o1.getFromScale(), o2.getFromScale());
        }
    };
    private ModelEnviroment modelEnviroment;
    private JList detaillessLevelList;
    private JSpinner toleranceSpinner;
    private JSpinner zoomlevelSpinner;
    private DetaillessLevelModel lastSelected;
    private RemoveAction removeAction;
    private AddAction addAction;
    private RecalculateAction recalculateAction;
    private AreaLayerModel areaLayerModel;

    public AreaLayerDetaillessConfigurationPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        JPanel panel = new JPanel(new SpringLayout());
        JPanel listPanel = new JPanel(new BorderLayout());
        this.detaillessLevelList = new JList(new DefaultListModel());
        this.detaillessLevelList.setSelectionMode(0);
        this.detaillessLevelList.addListSelectionListener(new DetaillessListSelectionListener());
        this.detaillessLevelList.setCellRenderer(new DetaillessListCellRenderer(this.detaillessLevelList.getCellRenderer()));
        listPanel.add((Component)new JScrollPane(this.detaillessLevelList), "Center");
        JPanel buttonListPanel = new JPanel(new BorderLayout());
        this.removeAction = new RemoveAction();
        buttonListPanel.add((Component)new JButton(this.removeAction), "West");
        this.addAction = new AddAction();
        buttonListPanel.add((Component)new JButton(this.addAction), "East");
        listPanel.add((Component)buttonListPanel, "South");
        panel.add(listPanel);
        JPanel valuePanel = new JPanel(new BorderLayout());
        JPanel subValuePanel = new JPanel(new SpringLayout());
        subValuePanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.zoomlevel", new Serializable[0])));
        this.zoomlevelSpinner = new JSpinner(new SpinnerNumberModel((Number)5.0, Double.valueOf(1.0), null, (Number)1.0));
        this.zoomlevelSpinner.setEnabled(false);
        subValuePanel.add(this.zoomlevelSpinner);
        subValuePanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.tolerance", new Serializable[0])));
        this.toleranceSpinner = new JSpinner(new SpinnerNumberModel((Number)10000.0, Double.valueOf(0.0), null, (Number)10000.0));
        this.toleranceSpinner.setEnabled(false);
        subValuePanel.add(this.toleranceSpinner);
        SpringUtilities.makeCompactGrid(subValuePanel, 2, 2, 5, 5, 2, 2);
        valuePanel.add((Component)subValuePanel, "North");
        subValuePanel = new JPanel(new BorderLayout());
        this.recalculateAction = new RecalculateAction();
        JButton button = new JButton(this.recalculateAction);
        subValuePanel.add((Component)button, "East");
        valuePanel.add((Component)subValuePanel, "South");
        panel.add(valuePanel);
        SpringUtilities.makeCompactGrid(panel, 1, 2, 5, 5, 2, 2);
        this.add((Component)panel, "Center");
    }

    public void setAreaLayer(AreaLayerModel areaLayerModel) {
        if (this.lastSelected != null) {
            this.lastSelected.setFromScale(Math.pow(2.0, (Double)this.zoomlevelSpinner.getValue() - 1.0));
            this.lastSelected.setTolerance((Double)this.toleranceSpinner.getValue());
        }
        this.lastSelected = null;
        DefaultListModel dlm = (DefaultListModel)this.detaillessLevelList.getModel();
        dlm.clear();
        if (areaLayerModel == null) {
            this.addAction.setEnabled(false);
            this.recalculateAction.setEnabled(false);
        } else {
            ArrayList<DetaillessLevelModel> sorted = new ArrayList<DetaillessLevelModel>(areaLayerModel.countDetaillessLevels());
            for (DetaillessLevelModel detaillessLevelModel : areaLayerModel.iterableDetaillessLevels()) {
                sorted.add(detaillessLevelModel);
            }
            Collections.sort(sorted, DETAIL_COMPARATOR);
            for (DetaillessLevelModel detaillessLevelModel : sorted) {
                dlm.addElement(detaillessLevelModel);
            }
            this.addAction.setEnabled(true);
            this.recalculateAction.setEnabled(areaLayerModel.getId() != null);
        }
        this.zoomlevelSpinner.setEnabled(false);
        this.toleranceSpinner.setEnabled(false);
        this.removeAction.setEnabled(false);
        this.areaLayerModel = areaLayerModel;
    }

    public void setCurrentValues() {
        if (this.lastSelected != null) {
            JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.zoomlevelSpinner.getEditor();
            try {
                editor.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            editor = (JSpinner.NumberEditor)this.toleranceSpinner.getEditor();
            try {
                editor.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            double fromScale = Math.pow(2.0, (Double)this.zoomlevelSpinner.getValue() - 1.0);
            this.lastSelected.setFromScale(fromScale);
            this.lastSelected.setTolerance((Double)this.toleranceSpinner.getValue());
        }
    }

    private class DetaillessListCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer parent;

        public DetaillessListCellRenderer(ListCellRenderer parent) {
            this.parent = parent;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object nValue = value;
            if (value instanceof DetaillessLevelModel) {
                DetaillessLevelModel detaillessLevelModel = (DetaillessLevelModel)value;
                Double upp = detaillessLevelModel.getFromScale();
                double zoomlevel = Math.log10(upp) / Math.log10(2.0) + 1.0;
                String formated = this.formatZoomlevel(zoomlevel);
                nValue = formated + " - " + detaillessLevelModel.getTolerance();
            }
            return this.parent.getListCellRendererComponent(list, nValue, index, isSelected, cellHasFocus);
        }

        private String formatZoomlevel(double zoomlevel) {
            String s = Long.toString(Math.round(zoomlevel * 10.0));
            int length = s.length();
            String f = s.substring(0, length - 1);
            char last = s.charAt(length - 1);
            f = last == '0' ? f + "  " : f + "," + last;
            if (length <= 2) {
                f = f + " ";
            }
            return f;
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1573612190464226437L;

        public RemoveAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DetaillessLevelModel detaillessLevelModel = (DetaillessLevelModel)AreaLayerDetaillessConfigurationPane.this.detaillessLevelList.getSelectedValue();
            detaillessLevelModel.setAreaLayer(null);
            DefaultListModel dlm = (DefaultListModel)AreaLayerDetaillessConfigurationPane.this.detaillessLevelList.getModel();
            dlm.removeElement(detaillessLevelModel);
            detaillessLevelModel.delete();
        }
    }

    private class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = -979108611066163286L;

        public AddAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DetaillessLevelModelImpl detaillessLevelModel = new DetaillessLevelModelImpl();
            detaillessLevelModel.setAreaLayer(AreaLayerDetaillessConfigurationPane.this.areaLayerModel);
            detaillessLevelModel.setFromScale(1.0);
            detaillessLevelModel.setTolerance(0.0);
            DefaultListModel dlm = (DefaultListModel)AreaLayerDetaillessConfigurationPane.this.detaillessLevelList.getModel();
            dlm.addElement(detaillessLevelModel);
        }
    }

    private class RecalculateAction
    extends AbstractAction {
        private static final long serialVersionUID = 3963773626807065885L;

        public RecalculateAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.rereduceGeoms", new Serializable[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AreaLayerDetaillessConfigurationPane.this.setCurrentValues();
            HashSet<Tupel<Double, Double>> set = new HashSet<Tupel<Double, Double>>();
            DefaultListModel dlm = (DefaultListModel)AreaLayerDetaillessConfigurationPane.this.detaillessLevelList.getModel();
            for (int i = 0; i < dlm.getSize(); ++i) {
                DetaillessLevelModel detaillessLevelModel = (DetaillessLevelModel)dlm.getElementAt(i);
                set.add(new Tupel<Double, Double>(detaillessLevelModel.getFromScale(), detaillessLevelModel.getTolerance()));
            }
            AreaLayerDetaillessConfigurationPane.this.modelEnviroment.getAllCaller().getAreaCaller().createReducedAreasForLayerByConfig(AreaLayerDetaillessConfigurationPane.this.areaLayerModel, set);
        }
    }

    private class DetaillessListSelectionListener
    implements ListSelectionListener {
        private DetaillessListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            AreaLayerDetaillessConfigurationPane.this.setCurrentValues();
            AreaLayerDetaillessConfigurationPane.this.lastSelected = (DetaillessLevelModel)AreaLayerDetaillessConfigurationPane.this.detaillessLevelList.getSelectedValue();
            if (AreaLayerDetaillessConfigurationPane.this.lastSelected == null) {
                AreaLayerDetaillessConfigurationPane.this.zoomlevelSpinner.setEnabled(false);
                AreaLayerDetaillessConfigurationPane.this.toleranceSpinner.setEnabled(false);
                AreaLayerDetaillessConfigurationPane.this.removeAction.setEnabled(false);
            } else {
                Double fromScale = AreaLayerDetaillessConfigurationPane.this.lastSelected.getFromScale();
                double zoomlevel = Math.log10(fromScale) / Math.log10(2.0) + 1.0;
                AreaLayerDetaillessConfigurationPane.this.zoomlevelSpinner.setValue(zoomlevel);
                AreaLayerDetaillessConfigurationPane.this.toleranceSpinner.setValue(AreaLayerDetaillessConfigurationPane.this.lastSelected.getTolerance());
                AreaLayerDetaillessConfigurationPane.this.zoomlevelSpinner.setEnabled(true);
                AreaLayerDetaillessConfigurationPane.this.toleranceSpinner.setEnabled(true);
                AreaLayerDetaillessConfigurationPane.this.removeAction.setEnabled(true);
            }
        }
    }
}

