/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.admin.user;

import de.datomino.peppergis.type.UserRole;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

class UserRoleSelectionDialog
extends JDialog {
    private static final long serialVersionUID = -2415587030830783269L;
    private JComboBox userRoleComboBox;
    private MessageResolver messageResolver;
    private boolean ok = false;
    private OkCallBack okCallBack;

    public UserRoleSelectionDialog(Window parent, MessageResolver messageResolver, OkCallBack okCallBack) {
        super(parent, messageResolver.resolveMessage("gui.userdialog.chooseUserRole", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.okCallBack = okCallBack;
        this.messageResolver = messageResolver;
        this.buildLayout();
        this.pack();
        this.setSize(Math.max(this.getWidth(), 200), this.getHeight());
        SwingUtils.centerDialog(this, parent);
    }

    private void buildLayout() {
        try {
            this.setIconImage(ImageIO.read(UserRoleSelectionDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 5, 0));
        Object[] items = new UserRoleItem[UserRole.values().length];
        int counter = 0;
        for (UserRole userRole : UserRole.values()) {
            items[counter] = new UserRoleItem(userRole);
            ++counter;
        }
        Arrays.sort(items);
        this.userRoleComboBox = new JComboBox<Object>(items);
        panel.add((Component)this.userRoleComboBox, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        JButton ok = new JButton(new AbstractAction(this.messageResolver.resolveMessage("gui.common.ok", new Serializable[0])){
            private static final long serialVersionUID = -8463156910122073166L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UserRoleSelectionDialog.this.ok = true;
                UserRoleSelectionDialog.this.okCallBack.doOkCallBack(UserRoleSelectionDialog.this.getSelectedUserRole());
                UserRoleSelectionDialog.this.dispose();
            }
        });
        buttonPanel.add(ok);
        JButton cancel = new JButton(new AbstractAction(this.messageResolver.resolveMessage("gui.common.cancel", new Serializable[0])){
            private static final long serialVersionUID = -8463156910122073166L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UserRoleSelectionDialog.this.ok = false;
                UserRoleSelectionDialog.this.dispose();
            }
        });
        buttonPanel.add(cancel);
        panel.add((Component)buttonPanel, "South");
        this.getContentPane().add(panel);
    }

    public UserRole getSelectedUserRole() {
        return ((UserRoleItem)this.userRoleComboBox.getSelectedItem()).getUserRole();
    }

    public boolean isOk() {
        return this.ok;
    }

    static interface OkCallBack {
        public void doOkCallBack(UserRole var1);
    }

    private class UserRoleItem
    implements Comparable<UserRoleItem> {
        private UserRole userRole;
        private String representation;

        public UserRoleItem(UserRole userRole) {
            this.userRole = userRole;
        }

        public String toString() {
            if (this.representation == null) {
                this.representation = UserRoleSelectionDialog.this.messageResolver.resolveMessage("gui.userdialog.userrole." + this.userRole.name(), new Serializable[0]);
            }
            return this.representation;
        }

        public UserRole getUserRole() {
            return this.userRole;
        }

        @Override
        public int compareTo(UserRoleItem o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

