/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.admin.user;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.admin.UserRoleObjectModel;
import de.datomino.peppergis.client.model.admin.UserRoleObjectModelImpl;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.configuration.gui.admin.user.AreaLayerSelectionDialog;
import de.datomino.peppergis.configuration.gui.admin.user.BranchSelectionDialog;
import de.datomino.peppergis.configuration.gui.admin.user.DelivererSelectionDialog;
import de.datomino.peppergis.configuration.gui.admin.user.UserRoleSelectionDialog;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.RandomUtil;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.StringUtil;

abstract class SingleUserPanel
extends JPanel {
    private static final long serialVersionUID = -8223857366324800358L;
    private UserModel userModel;
    private ModelEnviroment modelEnviroment;
    private JTextField login;
    private JPasswordField password;
    private JPasswordField password2;
    private JTextField name;
    private JList userRoleObjectList;
    private Action addUserRoleAction;
    private Action removeUserRoleAction;
    private boolean enabled;
    private Window parent;

    SingleUserPanel(Window parent, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.parent = parent;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.setEnabled(false);
    }

    private void buildLayout() {
        JPanel textPanels = new JPanel(new SpringLayout());
        textPanels.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.login", new Serializable[0])));
        this.login = new JTextField(20);
        textPanels.add(this.login);
        textPanels.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.password", new Serializable[0])));
        this.password = new JPasswordField(20);
        textPanels.add(this.password);
        textPanels.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.passwordrepetition", new Serializable[0])));
        this.password2 = new JPasswordField(20);
        textPanels.add(this.password2);
        textPanels.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.name", new Serializable[0])));
        this.name = new JTextField(20);
        textPanels.add(this.name);
        SpringUtilities.makeCompactGrid(textPanels, 4, 2, 5, 5, 2, 2);
        this.add((Component)textPanels, "North");
        JPanel userRoleObjectPanel = new JPanel(new BorderLayout());
        this.userRoleObjectList = new JList(new DefaultListModel());
        this.userRoleObjectList.setSelectionMode(0);
        this.userRoleObjectList.addListSelectionListener(new UserRoleObjectListSelectionListener());
        userRoleObjectPanel.add((Component)new JScrollPane(this.userRoleObjectList), "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addUserRoleAction = new AddUserRoleAction();
        JButton addUserRole = new JButton(this.addUserRoleAction);
        buttonPanel.add(addUserRole);
        this.removeUserRoleAction = new RemoveUserRoleAction();
        JButton removeUserRole = new JButton(this.removeUserRoleAction);
        buttonPanel.add(removeUserRole);
        userRoleObjectPanel.add((Component)buttonPanel, "South");
        userRoleObjectPanel.setBorder(new TitledBorder(ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.roles", new Serializable[0])));
        this.add((Component)userRoleObjectPanel, "Center");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enabled = enabled;
        this.login.setEnabled(enabled);
        this.name.setEnabled(enabled);
        this.password.setEnabled(enabled);
        this.password2.setEnabled(enabled);
        this.addUserRoleAction.setEnabled(enabled);
        this.removeUserRoleAction.setEnabled(enabled);
        this.userRoleObjectList.setEnabled(enabled);
    }

    public void clear() {
        this.userModel = null;
        this.login.setText("");
        this.name.setText("");
        this.password.setText("");
        this.password2.setText("");
        DefaultListModel dlm = (DefaultListModel)this.userRoleObjectList.getModel();
        dlm.removeAllElements();
    }

    public void setUser(UserModel userDialogUserModel) {
        this.userModel = userDialogUserModel;
        this.login.setText(userDialogUserModel.getLogin());
        this.name.setText(userDialogUserModel.getName());
        this.password.setText("");
        this.password2.setText("");
        DefaultListModel dlm = (DefaultListModel)this.userRoleObjectList.getModel();
        dlm.removeAllElements();
        for (UserRoleObjectModel userRoleObjectModel : userDialogUserModel.iterableUserRoleObjects()) {
            dlm.addElement(new UserRoleObjectListElement(userRoleObjectModel));
        }
        this.userRoleObjectList.clearSelection();
        this.removeUserRoleAction.setEnabled(false);
    }

    public UserModel getUserModel() {
        return this.userModel;
    }

    public void setValuesToModel() {
        this.userModel.setLogin(this.login.getText());
        this.userModel.setName(this.name.getText());
        char[] password = this.password.getPassword();
        if (password.length > 0) {
            String passwordString = new String(password);
            String salt = RandomUtil.nextAsciiString(32);
            this.userModel.setMd5Password(StringUtil.getMd5String(salt + passwordString));
            this.userModel.setSalt(salt);
        }
    }

    public ErrorMessages validateInput() {
        ErrorMessages errorMessages = new ErrorMessages();
        String setLogin = this.login.getText();
        if (StringUtil.isBlank(setLogin)) {
            errorMessages.addErrorMessage("gui.userdialog.loginEmpty", new Serializable[0]);
        } else {
            Collection<UserModel> users = this.getAllUsersInCache();
            for (UserModel userModel : users) {
                if (userModel.equals(this.userModel) || !new EqualsBuilder().append(setLogin, userModel.getLogin()).isEquals()) continue;
                errorMessages.addErrorMessage("gui.userdialog.multipleLogin", new Serializable[]{setLogin});
                break;
            }
        }
        char[] password = this.password.getPassword();
        char[] password2 = this.password2.getPassword();
        if (password.length > 0 || password2.length > 0) {
            if (!Arrays.equals(password, password2)) {
                errorMessages.addErrorMessage("gui.userdialog.passwordnotequal", new Serializable[0]);
            }
        } else if (this.userModel.getMd5Password() == null) {
            errorMessages.addErrorMessage("gui.userdialog.passwordempty", new Serializable[0]);
        }
        return errorMessages;
    }

    protected abstract Collection<UserModel> getAllUsersInCache();

    private class UserRoleObjectListElement {
        private UserRoleObjectModel userRoleObjectModel;
        private String representation;

        public UserRoleObjectListElement(UserRoleObjectModel userRoleObjectModel) {
            this.userRoleObjectModel = userRoleObjectModel;
        }

        public UserRoleObjectModel getUserRoleObjectModel() {
            return this.userRoleObjectModel;
        }

        public String toString() {
            if (this.representation == null) {
                this.representation = this.createStringRepresentation();
            }
            return this.representation;
        }

        private String createStringRepresentation() {
            Long attachedId = this.userRoleObjectModel.getAttachedId();
            switch (this.userRoleObjectModel.getUserRole()) {
                case ADMIN: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.userrole.admin", new Serializable[0]);
                }
                case AREA_EDITOR: {
                    String subRep = this.getAreaLayerRepresentation(attachedId);
                    return ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.userrole.areaeditor", new Serializable[]{subRep});
                }
                case AREA_VIEWER: {
                    String subRep = this.getAreaLayerRepresentation(attachedId);
                    return ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.userrole.areaviewer", new Serializable[]{subRep});
                }
                case PERSONAL_PLANNER: {
                    String subRep = this.getAreaLayerRepresentation(attachedId);
                    return ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.userrole.personalplanner", new Serializable[]{subRep});
                }
                case DELIVERER_ACTIVE: {
                    String subRep = this.getDelivererRepresentation(attachedId);
                    return ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.userrole.delivereractive", new Serializable[]{subRep});
                }
                case DELIVERER_PASSIVE: {
                    String subRep = this.getDelivererRepresentation(attachedId);
                    return ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.userrole.delivererpassiv", new Serializable[]{subRep});
                }
                case DISPONENT_LOCAL_ACTIVE: {
                    String subRep = this.getBranchRepresentation(attachedId);
                    return ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.userrole.disponentlocalactive", new Serializable[]{subRep});
                }
                case DISPONENT_LOCAL_PASSIVE: {
                    String subRep = this.getBranchRepresentation(attachedId);
                    return ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.userrole.disponentlocalpassive", new Serializable[]{subRep});
                }
                case DISPONENT_SUPER: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.userrole.disponentsuper", new Serializable[0]);
                }
                case AREA_ADMIN: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.userrole.areaadmin", new Serializable[0]);
                }
                case POST_WORK: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.userrole.postwork", new Serializable[0]);
                }
                case WAGE_ACTIVE: {
                    return ModelEnviroment.getMessageResolver().resolveMessageForEnum(UserRole.WAGE_ACTIVE);
                }
                case WAGE_PASSIVE: {
                    return ModelEnviroment.getMessageResolver().resolveMessageForEnum(UserRole.WAGE_PASSIVE);
                }
                case WAGE_DIFFERENCE: {
                    return ModelEnviroment.getMessageResolver().resolveMessageForEnum(UserRole.WAGE_DIFFERENCE);
                }
            }
            return "???";
        }

        private String getBranchRepresentation(Long attachedId) {
            String rep;
            BranchModel branchModel;
            if (attachedId != null && (branchModel = SingleUserPanel.this.modelEnviroment.getAllCaller().getTourCaller().getBranchById(attachedId)) != null && (rep = branchModel.getName()) != null) {
                return rep;
            }
            return "?";
        }

        private String getDelivererRepresentation(Long attachedId) {
            String rep;
            DelivererModel delivererModel;
            if (attachedId != null && (delivererModel = SingleUserPanel.this.modelEnviroment.getAllCaller().getTourCaller().getDelivererById(attachedId)) != null && (rep = delivererModel.getDelivererNumber()) != null) {
                return rep;
            }
            return "?";
        }

        private String getAreaLayerRepresentation(Long attachedId) {
            String r;
            AreaLayerModel areaLayerModel;
            if (attachedId != null && (areaLayerModel = SingleUserPanel.this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayer(attachedId)) != null && (r = areaLayerModel.getDisplayname()) != null) {
                return r;
            }
            return "?";
        }
    }

    private class RemoveUserRoleAction
    extends AbstractAction {
        private static final long serialVersionUID = 3899406233680959070L;

        public RemoveUserRoleAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = SingleUserPanel.this.userRoleObjectList.getSelectedIndex();
            if (index >= 0) {
                UserRoleObjectListElement element = (UserRoleObjectListElement)SingleUserPanel.this.userRoleObjectList.getSelectedValue();
                DefaultListModel dlm = (DefaultListModel)SingleUserPanel.this.userRoleObjectList.getModel();
                boolean allowed = true;
                if (element.getUserRoleObjectModel().getUserRole() == UserRole.ADMIN && ModelEnviroment.getUserInformation().getLogin().equals(SingleUserPanel.this.userModel.getLogin())) {
                    boolean otherAdminFound = false;
                    for (int i = 0; i < dlm.getSize(); ++i) {
                        UserRoleObjectListElement next = (UserRoleObjectListElement)dlm.getElementAt(i);
                        if (next == element || next.getUserRoleObjectModel().getUserRole() != UserRole.ADMIN) continue;
                        otherAdminFound = true;
                        break;
                    }
                    if (!otherAdminFound) {
                        JOptionPane.showMessageDialog(SingleUserPanel.this.parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.error.selfadminremove", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.common.errormessage.window.title", new Serializable[0]), 0);
                        allowed = false;
                    }
                }
                if (allowed) {
                    dlm.removeElementAt(index);
                    UserRoleObjectModel userRoleObjectModel = element.getUserRoleObjectModel();
                    SingleUserPanel.this.userModel.removeUserRoleObject(userRoleObjectModel);
                    userRoleObjectModel.delete();
                }
            }
        }
    }

    private class AddUserRoleAction
    extends AbstractAction {
        private static final long serialVersionUID = -2414642713027146321L;

        public AddUserRoleAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserRoleSelectionDialog.OkCallBack okCallBack = new UserRoleSelectionDialog.OkCallBack(){

                @Override
                public void doOkCallBack(UserRole userRole) {
                    switch (userRole) {
                        case AREA_EDITOR: 
                        case AREA_VIEWER: 
                        case PERSONAL_PLANNER: {
                            AddUserRoleAction.this.getAreaLayerId(userRole);
                            break;
                        }
                        case DELIVERER_ACTIVE: 
                        case DELIVERER_PASSIVE: {
                            AddUserRoleAction.this.getDelivererId(userRole);
                            break;
                        }
                        case DISPONENT_LOCAL_PASSIVE: 
                        case DISPONENT_LOCAL_ACTIVE: {
                            AddUserRoleAction.this.getBranchId(userRole);
                            break;
                        }
                        default: {
                            AddUserRoleAction.this.createUserObject(userRole, null);
                        }
                    }
                }
            };
            UserRoleSelectionDialog userRoleSelectionDialog = new UserRoleSelectionDialog(SingleUserPanel.this.parent, ModelEnviroment.getMessageResolver(), okCallBack);
            userRoleSelectionDialog.setVisible(true);
        }

        protected Long getBranchId(final UserRole userRole) {
            BranchSelectionDialog.OkCallBack okCallback = new BranchSelectionDialog.OkCallBack(){

                @Override
                public void doOkCallback(Long branchId) {
                    AddUserRoleAction.this.createUserObject(userRole, branchId);
                }
            };
            BranchSelectionDialog branchSelectionDialog = new BranchSelectionDialog(SingleUserPanel.this.parent, SingleUserPanel.this.modelEnviroment, ModelEnviroment.getMessageResolver(), okCallback);
            branchSelectionDialog.setVisible(true);
            return branchSelectionDialog.getBranchId();
        }

        private Long getDelivererId(final UserRole userRole) {
            DelivererSelectionDialog.OkCallBack okCallback = new DelivererSelectionDialog.OkCallBack(){

                @Override
                public void doOkCallback(Long delivererId) {
                    AddUserRoleAction.this.createUserObject(userRole, delivererId);
                }
            };
            DelivererSelectionDialog delivererSelectionDialog = new DelivererSelectionDialog(SingleUserPanel.this.parent, SingleUserPanel.this.modelEnviroment, ModelEnviroment.getMessageResolver(), okCallback);
            delivererSelectionDialog.setVisible(true);
            return delivererSelectionDialog.getDelivererId();
        }

        private Long getAreaLayerId(final UserRole userRole) {
            AreaLayerSelectionDialog.OkCallBack okCallBack = new AreaLayerSelectionDialog.OkCallBack(){

                @Override
                public void doOkCallback(Long areaLayerId) {
                    AddUserRoleAction.this.createUserObject(userRole, areaLayerId);
                }
            };
            AreaLayerSelectionDialog areaLayerSelectionDialog = new AreaLayerSelectionDialog(SingleUserPanel.this.parent, SingleUserPanel.this.modelEnviroment, ModelEnviroment.getMessageResolver(), okCallBack);
            areaLayerSelectionDialog.setVisible(true);
            return areaLayerSelectionDialog.getAreaLayerId();
        }

        private void createUserObject(UserRole userRole, Long attachedId) {
            UserRoleObjectModelImpl userRoleObjectModel = new UserRoleObjectModelImpl();
            userRoleObjectModel.setUser(SingleUserPanel.this.userModel);
            userRoleObjectModel.setAttachedId(attachedId);
            userRoleObjectModel.setUserRole(userRole);
            DefaultListModel dlm = (DefaultListModel)SingleUserPanel.this.userRoleObjectList.getModel();
            dlm.addElement(new UserRoleObjectListElement(userRoleObjectModel));
        }
    }

    private class UserRoleObjectListSelectionListener
    implements ListSelectionListener {
        private UserRoleObjectListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean selectionEmpty = SingleUserPanel.this.userRoleObjectList.isSelectionEmpty();
            SingleUserPanel.this.removeUserRoleAction.setEnabled(SingleUserPanel.this.enabled && !selectionEmpty);
        }
    }
}

