/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.admin.user;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class DelivererSelectionDialog
extends JDialog {
    private static final long serialVersionUID = -2415587030830783269L;
    private static final Comparator<DelivererModel> DELIVERER_COMPARATOR = new Comparator<DelivererModel>(){

        @Override
        public int compare(DelivererModel o1, DelivererModel o2) {
            String delivererNumber1 = StringUtil.nullToEmpty(o1.getDelivererNumber());
            String delivererNumber2 = StringUtil.nullToEmpty(o2.getDelivererNumber());
            return delivererNumber1.compareTo(delivererNumber2);
        }
    };
    private static final Comparator<BranchModel> BRANCH_COMPARATOR = new Comparator<BranchModel>(){

        @Override
        public int compare(BranchModel o1, BranchModel o2) {
            return StringUtil.nullToEmpty(o1.getName()).compareTo(StringUtil.nullToEmpty(o2.getName()));
        }
    };
    private JTree delivererTree;
    private MessageResolver messageResolver;
    private ModelEnviroment modelEnviroment;
    private Long delivererId;
    private Action okAction;
    private OkCallBack okCallback;

    public DelivererSelectionDialog(Window parent, ModelEnviroment modelEnviroment, MessageResolver messageResolver, OkCallBack okCallback) {
        super(parent, messageResolver.resolveMessage("gui.userdialog.chooseDeliverer", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.messageResolver = messageResolver;
        this.okCallback = okCallback;
        this.buildLayout();
        this.pack();
        this.setSize(Math.max(this.getWidth(), 300), Math.max(this.getHeight(), 300));
        SwingUtils.centerDialog(this, parent);
    }

    private void buildLayout() {
        try {
            this.setIconImage(ImageIO.read(DelivererSelectionDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.getContentPane().setLayout(new BorderLayout());
        Date today = new Date();
        List<DelivererModel> deliverers = this.modelEnviroment.getAllCaller().getTourCaller().fetchAllDeliverers();
        Tupel<Map<BranchModel, List<DelivererModel>>, List<DelivererModel>> delivererSorting = this.createDelivererMap(deliverers);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.messageResolver.resolveMessage("gui.userdialog.deliverer", new Serializable[0]));
        Map<BranchModel, List<DelivererModel>> map = delivererSorting.getElement1();
        ArrayList<BranchModel> branches = new ArrayList<BranchModel>(map.keySet());
        Collections.sort(branches, BRANCH_COMPARATOR);
        for (BranchModel branchModel : branches) {
            DefaultMutableTreeNode branchNode = new DefaultMutableTreeNode(branchModel.getName());
            root.add(branchNode);
            List<DelivererModel> delivererModels = map.get(branchModel);
            for (DelivererModel delivererModel : delivererModels) {
                DefaultMutableTreeNode delivererNode = new DefaultMutableTreeNode(new DelivererUserObject(delivererModel));
                branchNode.add(delivererNode);
            }
        }
        List<DelivererModel> unbranchedDeliverers = delivererSorting.getElement2();
        for (DelivererModel deliverer : unbranchedDeliverers) {
            DefaultMutableTreeNode delivererNode = new DefaultMutableTreeNode(new DelivererUserObject(deliverer));
            root.add(delivererNode);
        }
        this.delivererTree = new JTree(root);
        this.delivererTree.addTreeSelectionListener(new DelivererTreeSelectionListener());
        this.getContentPane().add((Component)new JScrollPane(this.delivererTree), "Center");
        JPanel jPanel = new JPanel();
        this.okAction = new AbstractAction(this.messageResolver.resolveMessage("gui.common.ok", new Serializable[0])){
            private static final long serialVersionUID = -8463156910122073166L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DelivererSelectionDialog.this.delivererId = ((DelivererUserObject)((DefaultMutableTreeNode)DelivererSelectionDialog.this.delivererTree.getSelectionPath().getLastPathComponent()).getUserObject()).getDelivererModel().getId();
                DelivererSelectionDialog.this.okCallback.doOkCallback(DelivererSelectionDialog.this.delivererId);
                DelivererSelectionDialog.this.dispose();
            }
        };
        JButton ok = new JButton(this.okAction);
        this.okAction.setEnabled(false);
        jPanel.add(ok);
        JButton cancel = new JButton(new AbstractAction(this.messageResolver.resolveMessage("gui.common.cancel", new Serializable[0])){
            private static final long serialVersionUID = -8463156910122073166L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DelivererSelectionDialog.this.delivererId = null;
                DelivererSelectionDialog.this.dispose();
            }
        });
        jPanel.add(cancel);
        this.getContentPane().add((Component)jPanel, "South");
    }

    private Tupel<Map<BranchModel, List<DelivererModel>>, List<DelivererModel>> createDelivererMap(List<DelivererModel> deliverers) {
        HashMap<BranchModel, LinkedList<DelivererModel>> map = new HashMap<BranchModel, LinkedList<DelivererModel>>();
        LinkedList<DelivererModel> list = new LinkedList<DelivererModel>();
        for (DelivererModel delivererModel : deliverers) {
            BranchModel branch = delivererModel.getBranch();
            if (branch == null) {
                list.add(delivererModel);
                continue;
            }
            LinkedList<DelivererModel> subList = (LinkedList<DelivererModel>)map.get(branch);
            if (subList == null) {
                subList = new LinkedList<DelivererModel>();
                map.put(branch, subList);
            }
            subList.add(delivererModel);
        }
        for (List subList : map.values()) {
            Collections.sort(subList, DELIVERER_COMPARATOR);
        }
        Collections.sort(list, DELIVERER_COMPARATOR);
        return new Tupel<Map<BranchModel, List<DelivererModel>>, List<DelivererModel>>(map, list);
    }

    public Long getDelivererId() {
        return this.delivererId;
    }

    static interface OkCallBack {
        public void doOkCallback(Long var1);
    }

    private class DelivererTreeSelectionListener
    implements TreeSelectionListener {
        private DelivererTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath treePath = DelivererSelectionDialog.this.delivererTree.getSelectionPath();
            if (treePath == null) {
                DelivererSelectionDialog.this.okAction.setEnabled(false);
            } else {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                DelivererSelectionDialog.this.okAction.setEnabled(dmtn.getUserObject() instanceof DelivererUserObject);
            }
        }
    }

    private class DelivererUserObject {
        private DelivererModel delivererModel;

        public DelivererUserObject(DelivererModel delivererModel) {
            this.delivererModel = delivererModel;
        }

        public String toString() {
            return this.delivererModel.getDelivererNumber();
        }

        public DelivererModel getDelivererModel() {
            return this.delivererModel;
        }
    }
}

