/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.actions;

import de.datomino.peppergis.client.auth.UserInformation;
import de.datomino.peppergis.client.export.AbstractExportFileAction;
import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.admin.UserRoleObjectModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.exporter.DefaultExportDto;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JOptionPane;
import org.ktde.util.datatypes.Tupel;

public class ExportSubscriptionsAction
extends AbstractExportFileAction<Object> {
    private static final long serialVersionUID = -7386768988791061524L;

    public ExportSubscriptionsAction(Window parent) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]), parent, "csv");
    }

    @Override
    protected Tupel<Map<String, byte[]>, ErrorMessages> getContent(Object o) throws ClientExportException {
        AreaLayerComboBox areaLayerComboBox = null;
        ModelEnviroment modelEnviroment = new ModelEnviroment(this.getParent());
        UserInformation userInfo = ModelEnviroment.getUserInformation();
        if (userInfo.isAdmin() || userInfo.hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER)) {
            areaLayerComboBox = new AreaLayerComboBox(modelEnviroment, true, AreaObjectGenInfoDiscriminator.values());
        } else {
            ArrayList<Long> ids = new ArrayList<Long>();
            UserModel userModel = userInfo.getUserModel();
            for (UserRoleObjectModel userObject : userModel.iterableUserRoleObjects()) {
                if (userObject.getAttachedId() == null) continue;
                ids.add(userObject.getAttachedId());
            }
            Collection<AreaLayerModel> areaLayers = modelEnviroment.getAllCaller().getAreaCaller().getAreaLayerForIds(ids);
            areaLayerComboBox = new AreaLayerComboBox(areaLayers, true);
        }
        int d = JOptionPane.showConfirmDialog(this.getParent(), areaLayerComboBox, "Bitte Layer ausw\u00e4hlen: ", 2);
        switch (d) {
            case 0: {
                final AreaLayerModel layer = (AreaLayerModel)areaLayerComboBox.getSelectedItem();
                AbstractAsynchronousDialog<DefaultExportDto> asynchronousDialog = new AbstractAsynchronousDialog<DefaultExportDto>(this.getParent(), ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]), 1, modelEnviroment){
                    private static final long serialVersionUID = -7470505194793690760L;

                    @Override
                    protected AsynchronousDto<DefaultExportDto> getAsynchronousDto(String token) {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().getExportSubscriptionsByLayerResult(token);
                    }

                    @Override
                    protected String startAsynchronous() {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().exportSubscriptionsByLayer(layer);
                    }
                };
                LinkedList exportDtos = new LinkedList();
                try {
                    Tupel subscriptionExportDto = asynchronousDialog.run();
                    exportDtos.add(subscriptionExportDto.getElement1());
                }
                catch (Exception ex) {
                    if (ex instanceof ClientExportException) {
                        throw (ClientExportException)ex;
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
                modelEnviroment.close();
                return new Tupel<Map<String, byte[]>, ErrorMessages>(Collections.singletonMap("Subscriptions", ((DefaultExportDto)exportDtos.get(0)).getContent()), ((DefaultExportDto)exportDtos.get(0)).getErrorMessages());
            }
        }
        return null;
    }

    @Override
    protected boolean checkConditions(Object o) {
        boolean cond = super.checkConditions(o);
        if (cond) {
            int d = JOptionPane.showConfirmDialog(this.getParent(), ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.export.question", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0);
            cond = d == 0;
        }
        return cond;
    }
}

