/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.actions;

import de.datomino.peppergis.client.export.AbstractExportFileAction;
import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.exporter.DefaultExportDto;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.export.ExportParcelType;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Tupel;

public class ExportParcelAction
extends AbstractExportFileAction<ParcelExportContext> {
    private ModelEnviroment modelEnviroment = new ModelEnviroment(this.getParent());
    private static final long serialVersionUID = -7386768988791061524L;

    public ExportParcelAction(Window parent) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]), parent, "csv");
    }

    @Override
    protected Tupel<Map<String, byte[]>, ErrorMessages> getContent(final ParcelExportContext parcelExportContext) throws ClientExportException {
        AbstractAsynchronousDialog<DefaultExportDto> asynchronousDialog = new AbstractAsynchronousDialog<DefaultExportDto>(this.getParent(), ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]), 1, this.modelEnviroment){
            private static final long serialVersionUID = -9010756475037313167L;

            @Override
            protected AsynchronousDto<DefaultExportDto> getAsynchronousDto(String token) {
                return ExportParcelAction.this.modelEnviroment.getAllCaller().getAsynchronousCaller().getExportParcelResult(token);
            }

            @Override
            protected String startAsynchronous() {
                return ExportParcelAction.this.modelEnviroment.getAllCaller().getAsynchronousCaller().exportParcel(parcelExportContext.getExportParcelType(), parcelExportContext.getAreaLayer());
            }
        };
        LinkedList exportDtos = new LinkedList();
        try {
            Tupel parcelExportDto = asynchronousDialog.run();
            exportDtos.add(parcelExportDto.getElement1());
        }
        catch (Exception ex) {
            if (ex instanceof ClientExportException) {
                throw (ClientExportException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        return new Tupel<Map<String, byte[]>, ErrorMessages>(Collections.singletonMap("Parcels", ((DefaultExportDto)exportDtos.get(0)).getContent()), ((DefaultExportDto)exportDtos.get(0)).getErrorMessages());
    }

    @Override
    protected ParcelExportContext createContext() {
        return new ParcelExportContext();
    }

    @Override
    protected boolean checkConditions(ParcelExportContext exportParcelContext) {
        boolean cond = super.checkConditions(exportParcelContext);
        if (cond) {
            EnumComboBox<ExportParcelType> exportParcelType = new EnumComboBox<ExportParcelType>(ExportParcelType.class, false);
            exportParcelType.setSelectedValue(ExportParcelType.DEFAULT);
            JPanel panel = new JPanel(new SpringLayout());
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(ExportParcelType.class.getName(), new Serializable[0])), "West");
            panel2.add(exportParcelType, "East");
            panel.add(panel2);
            panel2 = new JPanel(new BorderLayout());
            panel2.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0])));
            AreaLayerComboBox areaLayerComboBox = new AreaLayerComboBox(this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values()), true);
            panel2.add((Component)areaLayerComboBox, "East");
            panel.add(panel2);
            panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.export.question", new Serializable[0])));
            SpringUtilities.makeCompactGrid(panel, 3, 1, 5, 5, 5, 5);
            int d = JOptionPane.showConfirmDialog(this.getParent(), panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0);
            exportParcelContext.setExportParcelType(exportParcelType.getSelectedValue());
            exportParcelContext.setAreaLayer((AreaLayerModel)areaLayerComboBox.getSelectedItem());
            cond = d == 0;
        }
        return cond;
    }

    protected static class ParcelExportContext {
        private ExportParcelType exportParcelType;
        private AreaLayerModel areaLayer;

        protected ParcelExportContext() {
        }

        public ExportParcelType getExportParcelType() {
            return this.exportParcelType;
        }

        public void setExportParcelType(ExportParcelType exportParcelType) {
            this.exportParcelType = exportParcelType;
        }

        public AreaLayerModel getAreaLayer() {
            return this.areaLayer;
        }

        public void setAreaLayer(AreaLayerModel areaLayer) {
            this.areaLayer = areaLayer;
        }
    }
}

