/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.common.attribute.descriptor;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.StaticChoiceValueModel;
import de.datomino.peppergis.configuration.common.attribute.descriptor.SubDescriptorPane;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.attribute.StaticChoiceValue;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class StaticChoiceDescriptorPane<T extends Model, U extends Model>
extends JPanel
implements SubDescriptorPane<T, U> {
    private static final long serialVersionUID = -2377540349831629158L;
    private JList staticChoiceValues;
    private JTextField name;
    private JTextArea description;
    private JTextField value;
    private Action removeAction;
    private AttributeValueDescriptorModel<U, T> attributeValueDescriptorModel;
    private StaticChoiceValue<T, U> selectedStaticChoiceValue;
    private Integer selectedStaticChoiceValueIndex;

    public StaticChoiceDescriptorPane() {
        super(new BorderLayout());
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel listPanel = new JPanel(new BorderLayout());
        this.staticChoiceValues = new JList(new DefaultListModel());
        this.staticChoiceValues.setSelectionMode(0);
        this.staticChoiceValues.addListSelectionListener(new StaticChoiceValueListSelectionListener());
        JScrollPane scroll = new JScrollPane(this.staticChoiceValues);
        scroll.setHorizontalScrollBarPolicy(32);
        listPanel.add((Component)scroll, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.removeAction = new RemoveAction();
        JButton remove = new JButton(this.removeAction);
        this.removeAction.setEnabled(false);
        buttonPanel.add((Component)remove, "West");
        JButton add = new JButton(new AddAction());
        buttonPanel.add((Component)add, "East");
        listPanel.add((Component)buttonPanel, "South");
        this.add((Component)listPanel, "West");
        JPanel fieldPanel1 = new JPanel(new BorderLayout());
        JPanel fieldPanel2 = new JPanel(new SpringLayout());
        fieldPanel2.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.attributevaluedescriptor.staticchoice.name", new Serializable[0])));
        this.name = new JTextField(30);
        this.name.setEditable(false);
        fieldPanel2.add(this.name);
        fieldPanel2.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.attributevaluedescriptor.staticchoice.value", new Serializable[0])));
        this.value = new JTextField(30);
        this.value.setEditable(false);
        fieldPanel2.add(this.value);
        fieldPanel2.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.attributevaluedescriptor.staticchoice.description", new Serializable[0])));
        this.description = new JTextArea(5, 30);
        this.description.setEditable(false);
        fieldPanel2.add(new JScrollPane(this.description));
        SpringUtilities.makeCompactGrid(fieldPanel2, 3, 2, 2, 2, 2, 2);
        fieldPanel1.add((Component)fieldPanel2, "North");
        this.add((Component)fieldPanel1, "Center");
    }

    private void setValuesToModel(StaticChoiceValue<T, U> staticChoiceValue, Integer sortOrder) {
        staticChoiceValue.setName(this.name.getText());
        staticChoiceValue.setValue(this.value.getText());
        staticChoiceValue.setDescription(this.description.getText());
        staticChoiceValue.setSortOrder(sortOrder);
    }

    @Override
    public void setValuesToModel() {
        if (this.selectedStaticChoiceValue != null) {
            this.setValuesToModel(this.selectedStaticChoiceValue, this.selectedStaticChoiceValueIndex);
        }
        DefaultListModel dlm = (DefaultListModel)this.staticChoiceValues.getModel();
        ArrayList list = new ArrayList(dlm.getSize());
        for (int i = 0; i < dlm.getSize(); ++i) {
            list.add(((StaticChoiceValueListItem)dlm.elementAt(i)).getStaticChoiceValue());
        }
        this.attributeValueDescriptorModel.setStaticChoiceValues(list);
    }

    private void clearValues() {
        this.name.setText("");
        this.value.setText("");
        this.description.setText("");
    }

    @Override
    public void setAttributeValueDescriptorModel(AttributeValueDescriptorModel<U, T> attributeValueDescriptorModel) {
        this.attributeValueDescriptorModel = attributeValueDescriptorModel;
        DefaultListModel dlm = (DefaultListModel)this.staticChoiceValues.getModel();
        dlm.clear();
        if (this.attributeValueDescriptorModel != null) {
            for (StaticChoiceValue staticChoiceValue : this.attributeValueDescriptorModel.getStaticChoiceValues()) {
                dlm.addElement(new StaticChoiceValueListItem(staticChoiceValue));
            }
        }
    }

    private void setValues(StaticChoiceValue<T, U> staticChoiceValue) {
        this.name.setText(staticChoiceValue.getName());
        this.value.setText(staticChoiceValue.getValue());
        this.description.setText(staticChoiceValue.getDescription());
    }

    protected abstract StaticChoiceValueModel<T, U> createEmptyStaticChoiceValueModel();

    @Override
    public Collection<AttributeValueType> getAttributeValueTypes() {
        return Collections.singleton(AttributeValueType.STATIC_CHOICE);
    }

    private class StaticChoiceValueListItem {
        private StaticChoiceValue<T, U> staticChoiceValue;

        public StaticChoiceValueListItem(StaticChoiceValue<T, U> staticChoiceValue) {
            this.staticChoiceValue = staticChoiceValue;
        }

        public StaticChoiceValue<T, U> getStaticChoiceValue() {
            return this.staticChoiceValue;
        }

        public String toString() {
            return this.getStaticChoiceValue().getName();
        }
    }

    private class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = -6201311558007630005L;

        private AddAction() {
            super("Hinzuf\u00fcgen");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StaticChoiceValueModel staticChoiceValueModel = StaticChoiceDescriptorPane.this.createEmptyStaticChoiceValueModel();
            staticChoiceValueModel.setName("Name");
            staticChoiceValueModel.setValue("");
            staticChoiceValueModel.setDescription("");
            DefaultListModel dlm = (DefaultListModel)StaticChoiceDescriptorPane.this.staticChoiceValues.getModel();
            staticChoiceValueModel.setSortOrder(dlm.getSize());
            dlm.addElement(new StaticChoiceValueListItem(staticChoiceValueModel));
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = 6801502172975378109L;

        private RemoveAction() {
            super("Entfernen");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StaticChoiceValueListItem staticChoiceValueListItem = (StaticChoiceValueListItem)StaticChoiceDescriptorPane.this.staticChoiceValues.getSelectedValue();
            ((Model)staticChoiceValueListItem.getStaticChoiceValue().getAttachedObject()).delete();
            DefaultListModel dlm = (DefaultListModel)StaticChoiceDescriptorPane.this.staticChoiceValues.getModel();
            dlm.removeElementAt(StaticChoiceDescriptorPane.this.staticChoiceValues.getSelectedIndex());
        }
    }

    private class StaticChoiceValueListSelectionListener
    implements ListSelectionListener {
        private StaticChoiceValueListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            StaticChoiceValueListItem staticChoiceValueListItem;
            if (StaticChoiceDescriptorPane.this.selectedStaticChoiceValue != null) {
                StaticChoiceDescriptorPane.this.setValuesToModel(StaticChoiceDescriptorPane.this.selectedStaticChoiceValue, StaticChoiceDescriptorPane.this.selectedStaticChoiceValueIndex);
            }
            if ((staticChoiceValueListItem = (StaticChoiceValueListItem)StaticChoiceDescriptorPane.this.staticChoiceValues.getSelectedValue()) == null) {
                StaticChoiceDescriptorPane.this.clearValues();
                StaticChoiceDescriptorPane.this.selectedStaticChoiceValue = null;
                StaticChoiceDescriptorPane.this.selectedStaticChoiceValueIndex = null;
                StaticChoiceDescriptorPane.this.removeAction.setEnabled(false);
                StaticChoiceDescriptorPane.this.name.setEditable(false);
                StaticChoiceDescriptorPane.this.value.setEditable(false);
                StaticChoiceDescriptorPane.this.description.setEditable(false);
            } else {
                StaticChoiceValue staticChoiceValue = staticChoiceValueListItem.getStaticChoiceValue();
                StaticChoiceDescriptorPane.this.setValues(staticChoiceValue);
                StaticChoiceDescriptorPane.this.selectedStaticChoiceValue = staticChoiceValue;
                StaticChoiceDescriptorPane.this.selectedStaticChoiceValueIndex = StaticChoiceDescriptorPane.this.staticChoiceValues.getSelectedIndex();
                StaticChoiceDescriptorPane.this.removeAction.setEnabled(true);
                StaticChoiceDescriptorPane.this.name.setEditable(true);
                StaticChoiceDescriptorPane.this.value.setEditable(true);
                StaticChoiceDescriptorPane.this.description.setEditable(true);
            }
        }
    }
}

