/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.common.attribute.descriptor;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.LetterAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.PoiAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.configuration.common.attribute.descriptor.SubDescriptorPane;
import de.datomino.peppergis.type.AttributeValueType;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AttributeValueLimitPane
extends JPanel
implements SubDescriptorPane<Model, Model> {
    private static final long serialVersionUID = 415315199399622254L;
    private static final Set<AttributeValueType> LIMIT_TYPES;
    private AttributeValueDescriptorModel<Model, Model> attributeValueDescriptorModel;
    private JSpinner llSpinner;
    private JSpinner ulSpinner;
    private JCheckBox llCheckBox;
    private JCheckBox ulCheckBox;
    private boolean changeForced = false;

    AttributeValueLimitPane() {
        super(new BorderLayout());
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel mainPanel = new JPanel(new GridLayout(2, 2));
        JPanel limitPanel = new JPanel(new GridLayout(2, 3, 1, 10));
        this.ulCheckBox = new JCheckBox();
        this.ulCheckBox.setSelected(true);
        limitPanel.add(this.ulCheckBox);
        this.ulCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = AttributeValueLimitPane.this.ulCheckBox.isSelected();
                AttributeValueLimitPane.this.ulSpinner.setEnabled(selected);
                if (selected && AttributeValueLimitPane.this.llCheckBox.isSelected()) {
                    double upperLimit = (Double)AttributeValueLimitPane.this.ulSpinner.getValue();
                    double lowLimit = (Double)AttributeValueLimitPane.this.llSpinner.getValue();
                    if (lowLimit > upperLimit) {
                        AttributeValueLimitPane.this.ulSpinner.setValue(lowLimit);
                    }
                }
            }
        });
        JLabel upperLimitLable = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.attributevaluedescriptor.upper.limit", new Serializable[0]));
        limitPanel.add(upperLimitLable);
        this.ulSpinner = new JSpinner(new SpinnerNumberModel((Number)0.0, null, null, (Number)1.0));
        this.ulSpinner.setSize(7, 5);
        limitPanel.add(this.ulSpinner);
        this.llCheckBox = new JCheckBox();
        this.llCheckBox.setSelected(true);
        limitPanel.add(this.llCheckBox);
        this.llCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = AttributeValueLimitPane.this.llCheckBox.isSelected();
                AttributeValueLimitPane.this.llSpinner.setEnabled(selected);
                if (selected && AttributeValueLimitPane.this.ulCheckBox.isSelected()) {
                    double upperLimit = (Double)AttributeValueLimitPane.this.ulSpinner.getValue();
                    double lowLimit = (Double)AttributeValueLimitPane.this.llSpinner.getValue();
                    if (lowLimit > upperLimit) {
                        AttributeValueLimitPane.this.llSpinner.setValue(upperLimit);
                    }
                }
            }
        });
        JLabel lowerLimitLable = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.attributevaluedescriptor.lower.limit", new Serializable[0]));
        limitPanel.add(lowerLimitLable);
        this.llSpinner = new JSpinner(new SpinnerNumberModel((Number)0.0, null, null, (Number)1.0));
        this.llSpinner.setSize(7, 5);
        limitPanel.add(this.llSpinner);
        this.ulSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AttributeValueLimitPane.this.llCheckBox.isSelected()) {
                    double currentUpVal = (Double)((JSpinner)e.getSource()).getValue();
                    double lowLimit = (Double)AttributeValueLimitPane.this.llSpinner.getValue();
                    if (!AttributeValueLimitPane.this.changeForced && currentUpVal < lowLimit) {
                        ((JSpinner)e.getSource()).setValue(lowLimit);
                    }
                }
            }
        });
        this.llSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AttributeValueLimitPane.this.ulCheckBox.isSelected()) {
                    double currentDownVal = (Double)((JSpinner)e.getSource()).getValue();
                    double upLimit = (Double)AttributeValueLimitPane.this.ulSpinner.getValue();
                    if (!AttributeValueLimitPane.this.changeForced && currentDownVal > upLimit) {
                        ((JSpinner)e.getSource()).setValue(upLimit);
                    }
                }
            }
        });
        mainPanel.add(limitPanel);
        JPanel tempPanel1 = new JPanel(new BorderLayout());
        mainPanel.add(tempPanel1);
        JPanel tempPanel2 = new JPanel(new BorderLayout());
        mainPanel.add(tempPanel2);
        this.add(mainPanel);
    }

    @Override
    public void setValuesToModel() {
        if (this.attributeValueDescriptorModel != null && this.attributeValueDescriptorModel.getAttachedObject() != null) {
            if (this.llSpinner.isEnabled()) {
                Double lVal = (Double)this.llSpinner.getValue();
                if (this.attributeValueDescriptorModel.getAttributeValueType() == AttributeValueType.INTEGER) {
                    this.attributeValueDescriptorModel.setLowerLimit(Double.valueOf(Math.round(lVal)));
                } else {
                    this.attributeValueDescriptorModel.setLowerLimit(lVal);
                }
            } else {
                this.attributeValueDescriptorModel.setLowerLimit(null);
            }
            if (this.ulSpinner.isEnabled()) {
                Double uVal = (Double)this.ulSpinner.getValue();
                if (this.attributeValueDescriptorModel.getAttributeValueType() == AttributeValueType.INTEGER) {
                    this.attributeValueDescriptorModel.setUpperLimit(Double.valueOf(Math.round(uVal)));
                } else {
                    this.attributeValueDescriptorModel.setUpperLimit(uVal);
                }
            } else {
                this.attributeValueDescriptorModel.setUpperLimit(null);
            }
        }
    }

    @Override
    public void setAttributeValueDescriptorModel(AttributeValueDescriptorModel<Model, Model> attributeValueDescriptorModel) {
        this.attributeValueDescriptorModel = attributeValueDescriptorModel;
        this.setLimitValues();
        if (this.attributeValueDescriptorModel != null) {
            if (this.attributeValueDescriptorModel.getModifiable() != null) {
                this.setFieldsEnabled(this.attributeValueDescriptorModel.getModifiable());
            } else {
                this.setFieldsEnabled(true);
            }
        }
    }

    @Override
    public Collection<AttributeValueType> getAttributeValueTypes() {
        return LIMIT_TYPES;
    }

    private void setFieldsEnabled(boolean modifiable) {
        this.llCheckBox.setEnabled(modifiable);
        this.llSpinner.setEnabled(modifiable && this.llCheckBox.isSelected());
        this.ulCheckBox.setEnabled(modifiable);
        this.ulSpinner.setEnabled(modifiable && this.ulCheckBox.isSelected());
    }

    private void setLimitValues() {
        Model attachedObject;
        Double lowerLimit = null;
        Double upperLimit = null;
        if (this.attributeValueDescriptorModel != null && (attachedObject = (Model)this.attributeValueDescriptorModel.getAttachedObject()) != null) {
            if (attachedObject instanceof AreaAttributeValueDescriptorModel) {
                AreaAttributeValueDescriptorModel areaDescriptor = (AreaAttributeValueDescriptorModel)attachedObject;
                if (areaDescriptor.getLowerLimit() != null) {
                    lowerLimit = areaDescriptor.getLowerLimit();
                }
                if (areaDescriptor.getUpperLimit() != null) {
                    upperLimit = areaDescriptor.getUpperLimit();
                }
            } else if (attachedObject instanceof SubscriptionAttributeValueDescriptorModel) {
                SubscriptionAttributeValueDescriptorModel subDescriptor = (SubscriptionAttributeValueDescriptorModel)attachedObject;
                if (subDescriptor.getLowerLimit() != null) {
                    lowerLimit = subDescriptor.getLowerLimit();
                }
                if (subDescriptor.getUpperLimit() != null) {
                    upperLimit = subDescriptor.getUpperLimit();
                }
            } else if (attachedObject instanceof PoiAttributeValueDescriptorModel) {
                PoiAttributeValueDescriptorModel poiDescriptor = (PoiAttributeValueDescriptorModel)attachedObject;
                if (poiDescriptor.getLowerLimit() != null) {
                    lowerLimit = poiDescriptor.getLowerLimit();
                }
                if (poiDescriptor.getUpperLimit() != null) {
                    upperLimit = poiDescriptor.getUpperLimit();
                }
            } else if (attachedObject instanceof ParcelAttributeValueDescriptorModel) {
                ParcelAttributeValueDescriptorModel parcelDescriptor = (ParcelAttributeValueDescriptorModel)attachedObject;
                if (parcelDescriptor.getLowerLimit() != null) {
                    lowerLimit = parcelDescriptor.getLowerLimit();
                }
                if (parcelDescriptor.getUpperLimit() != null) {
                    upperLimit = parcelDescriptor.getUpperLimit();
                }
            } else if (attachedObject instanceof LetterAttributeValueDescriptorModel) {
                LetterAttributeValueDescriptorModel letterDescriptor = (LetterAttributeValueDescriptorModel)attachedObject;
                if (letterDescriptor.getLowerLimit() != null) {
                    lowerLimit = letterDescriptor.getLowerLimit();
                }
                if (letterDescriptor.getUpperLimit() != null) {
                    upperLimit = letterDescriptor.getUpperLimit();
                }
            }
        }
        this.changeForced = true;
        if (lowerLimit != null) {
            this.llCheckBox.setSelected(true);
            this.llSpinner.setValue(lowerLimit);
            this.llSpinner.setEnabled(true);
        } else {
            this.llCheckBox.setSelected(false);
            this.llSpinner.setValue(0.0);
            this.llSpinner.setEnabled(false);
        }
        if (upperLimit != null) {
            this.ulCheckBox.setSelected(true);
            this.ulSpinner.setValue(upperLimit);
            this.ulSpinner.setEnabled(true);
        } else {
            this.ulCheckBox.setSelected(false);
            this.ulSpinner.setValue(0.0);
            this.ulSpinner.setEnabled(false);
        }
        this.changeForced = false;
    }

    static {
        HashSet<AttributeValueType> set = new HashSet<AttributeValueType>();
        set.add(AttributeValueType.INTEGER);
        set.add(AttributeValueType.FLOAT);
        LIMIT_TYPES = Collections.unmodifiableSet(set);
    }
}

