/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.stopeditor;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.stop.StopLayerRenderer;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.clienttools.stopeditor.StopEditorGui;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.SpringUtilities;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.ktde.swing.AbstractToggleAction;

public class StopEditorActions {
    private StopEditorGui stopEditorGui;
    private JTextField startPostcodeTexField;
    private JTextField endPostcodeTexField;

    public StopEditorActions(StopEditorGui stopEditorGui) {
        this.stopEditorGui = stopEditorGui;
    }

    public JToggleButton getShowStreetButton() {
        AbstractToggleAction showStreetAction = new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("gui.route.motorcar", "gui.route.foot", "gui.route.bike"), new String[0]).replace(" ", "/")){
            private static final long serialVersionUID = 5296326736752642676L;

            @Override
            public void turnOn() {
                StopEditorActions.this.stopEditorGui.getLayerRenderer().setForMotorSegment(true);
                StopEditorActions.this.stopEditorGui.getLayerRenderer().setForFootSegment(true);
                StopEditorActions.this.stopEditorGui.getLayerRenderer().setForBikeSegment(true);
                StopEditorActions.this.stopEditorGui.repaint(10L);
            }

            @Override
            public void turnOff() {
                StopEditorActions.this.stopEditorGui.getLayerRenderer().setForMotorSegment(false);
                StopEditorActions.this.stopEditorGui.getLayerRenderer().setForFootSegment(false);
                StopEditorActions.this.stopEditorGui.getLayerRenderer().setForBikeSegment(false);
                StopEditorActions.this.stopEditorGui.repaint(10L);
            }
        };
        return new JToggleButton(showStreetAction);
    }

    public synchronized void filterAndSetInList() {
        StopLayerRenderer layerRenderer = this.stopEditorGui.getLayerRenderer();
        DefaultListModel dlm = (DefaultListModel)this.stopEditorGui.getLegendList().getModel();
        ArrayList<StopModel> stops = new ArrayList<StopModel>(dlm.size());
        for (int i = 0; i < dlm.size(); ++i) {
            stops.add((StopModel)dlm.getElementAt(i));
        }
        ArrayList<StopModel> list = new ArrayList<StopModel>(stops.size());
        for (StopModel stop : stops) {
            if (stop == null || !this.isInFilter(stop.getLocation())) continue;
            list.add(stop);
        }
        dlm.clear();
        for (StopModel stop : list) {
            dlm.addElement(stop);
        }
        layerRenderer.setStops(list);
        ArrayList<PoiModel> filteredPois = new ArrayList<PoiModel>();
        DefaultListModel poiListModel = this.stopEditorGui.getPoiListModel();
        Enumeration elements = poiListModel.elements();
        while (elements.hasMoreElements()) {
            PoiModel poi = (PoiModel)elements.nextElement();
            if (poi == null || !this.isInFilter(poi.getLocation())) continue;
            filteredPois.add(poi);
        }
        poiListModel.clear();
        for (PoiModel poi : filteredPois) {
            poiListModel.addElement(poi);
        }
        layerRenderer.setPois(filteredPois);
        this.stopEditorGui.repaint(10L);
    }

    private boolean isInFilter(LocationModel location) {
        boolean b = true;
        if (b) {
            String startPostcode = this.startPostcodeTexField.getText();
            String endPostcode = this.endPostcodeTexField.getText();
            if (startPostcode != null && !startPostcode.trim().equals("") || endPostcode != null && !endPostcode.trim().equals("")) {
                String postcodeString = null;
                try {
                    LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
                    postcodeString = wrapper.getPostcode();
                }
                catch (NullPointerException e) {
                    b = false;
                }
                if (postcodeString != null && (startPostcode != null && startPostcode.compareTo(postcodeString.substring(0, Math.min(postcodeString.length(), startPostcode.length()))) > 0 || endPostcode != null && endPostcode.compareTo(postcodeString.substring(0, Math.min(postcodeString.length(), endPostcode.length()))) < 0)) {
                    b = false;
                }
            }
        }
        return b;
    }

    public Component getKindFilter() {
        JPanel kindFilterPanel = new JPanel(new SpringLayout());
        JCheckBox kindCheckBox = new JCheckBox("Alle Abladestellen auf der Karte");
        kindCheckBox.addItemListener(new KindFilterItemListener());
        kindFilterPanel.add(kindCheckBox);
        SpringUtilities.makeCompactGrid(kindFilterPanel, 1, 1, 2, 2, 2, 2);
        return kindFilterPanel;
    }

    public JPanel getPlzFilter() {
        JPanel plzFilterPanel = new JPanel(new SpringLayout());
        TextFilterChangedListener textFilterChangedListener = new TextFilterChangedListener();
        plzFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("address.postcode", "messages.default.from"), new String[0])));
        this.startPostcodeTexField = new JTextField(5);
        this.startPostcodeTexField.getDocument().addDocumentListener(textFilterChangedListener);
        plzFilterPanel.add(this.startPostcodeTexField);
        plzFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0])));
        this.endPostcodeTexField = new JTextField(5);
        this.endPostcodeTexField.getDocument().addDocumentListener(textFilterChangedListener);
        plzFilterPanel.add(this.endPostcodeTexField);
        SpringUtilities.makeCompactGrid(plzFilterPanel, 1, 4, 2, 2, 2, 2);
        return plzFilterPanel;
    }

    private class TextFilterChangedListener
    implements DocumentListener {
        private TextFilterChangedListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            StopEditorActions.this.stopEditorGui.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            StopEditorActions.this.stopEditorGui.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            StopEditorActions.this.stopEditorGui.update();
        }
    }

    private class KindFilterItemListener
    implements ItemListener {
        private KindFilterItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                StopEditorActions.this.stopEditorGui.setWithAllModels(true);
            } else {
                StopEditorActions.this.stopEditorGui.setWithAllModels(false);
            }
            StopEditorActions.this.stopEditorGui.update();
        }
    }
}

