/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.search;

import de.datomino.peppergis.client.gui.address.AddressTable;
import de.datomino.peppergis.client.gui.address.ListedAddressPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class AddressSearchDialog
extends JDialog {
    private static final long serialVersionUID = 1811672020246558708L;
    private ListedAddressPane listedAddressPane;
    private AddressTable addressTable;
    private ModelEnviroment modelEnviroment = new ModelEnviroment(this);
    private Action searchAction;

    public AddressSearchDialog(Window parent) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.internal.search", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.buildLayout();
        this.pack();
        SwingUtils.center(this);
    }

    private void buildLayout() {
        try {
            this.setIconImage(ImageIO.read(AddressSearchDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.getContentPane().setLayout(new BorderLayout());
        List<Tupel<Country, Integer>> countries = this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchPostcodesWithAtLeastOneParcel();
        Country[] countryArray = new Country[countries.size()];
        Country defaultCountry = this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry();
        boolean found = false;
        int i = 0;
        for (Tupel<Country, Integer> tupel : countries) {
            Country country;
            countryArray[i] = country = tupel.getElement1();
            if (country != defaultCountry) continue;
            found = true;
        }
        if (!found && !countries.isEmpty()) {
            defaultCountry = countryArray[0];
        }
        this.listedAddressPane = new ListedAddressPane(countryArray, defaultCountry);
        this.getContentPane().add((Component)this.listedAddressPane, "North");
        this.addressTable = new AddressTable(true, true, this.modelEnviroment);
        this.getContentPane().add((Component)new JScrollPane(this.addressTable), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.searchAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0])){
            private static final long serialVersionUID = 6909248606531788694L;

            @Override
            public void actionPerformed(ActionEvent e) {
                List<Tupel<ParcelModel, Double>> result = AddressSearchDialog.this.modelEnviroment.getAllCaller().getStreetSearchCaller().searchParcelsInternal(AddressSearchDialog.this.listedAddressPane.getCountry(), AddressSearchDialog.this.listedAddressPane.getPostcode(), AddressSearchDialog.this.listedAddressPane.getCity(), AddressSearchDialog.this.listedAddressPane.getDistrict(), AddressSearchDialog.this.listedAddressPane.getStreet(), AddressSearchDialog.this.listedAddressPane.getHousenumber(), AddressSearchDialog.this.listedAddressPane.getHousenumberExtension());
                AddressSearchDialog.this.addressTable.removeAllRows();
                if (result.isEmpty()) {
                    JOptionPane.showMessageDialog(AddressSearchDialog.this.addressTable, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search.noresult", new Serializable[0]));
                } else {
                    for (Tupel<ParcelModel, Double> tupel : result) {
                        AddressSearchDialog.this.addressTable.addParcel(tupel.getElement1(), tupel.getElement2());
                    }
                }
            }
        };
        JButton search = new JButton(this.searchAction);
        buttonPanel.add((Component)search, "East");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.listedAddressPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean b = !StringUtil.isBlank(AddressSearchDialog.this.listedAddressPane.getPostcode()) || AddressSearchDialog.this.checkSearchAbleNormalize(AddressSearchDialog.this.listedAddressPane.getCity()) || AddressSearchDialog.this.checkSearchAbleNormalize(AddressSearchDialog.this.listedAddressPane.getDistrict()) || AddressSearchDialog.this.checkSearchAbleNormalize(AddressSearchDialog.this.listedAddressPane.getStreet());
                AddressSearchDialog.this.searchAction.setEnabled(b);
            }
        });
        this.searchAction.setEnabled(false);
    }

    private boolean checkSearchAbleNormalize(String s) {
        String n = StringUtil.normalize(s);
        return !StringUtil.isBlank(n);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.modelEnviroment.close();
        }
    }
}

