/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.parceleditor;

import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.communication.StreetNetCaller;
import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.location.AbstractLocationEditorPane;
import de.datomino.peppergis.client.gui.location.SearchLocationAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelDialog;
import de.datomino.peppergis.client.gui.parcel.ParcelLayerRenderer;
import de.datomino.peppergis.client.gui.parcel.ParcelListCellRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.StreetNameComparator;
import de.datomino.peppergis.clienttools.parceleditor.ParcelEditorActions;
import de.datomino.peppergis.clienttools.parceleditor.ParcelLegendMouseListener;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeoObjectBucketsChangeListener;
import de.datomino.util.geo.model.GeoObjectBucketsChangedEvent;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class ParcelEditorGui
extends AbstractLocationEditorPane {
    private static final long serialVersionUID = -967880666587890520L;
    private ParcelEditorActions parcelEditorActions;
    private ParcelLayerRenderer parcelLayerRenderer;
    private AreaLayerModel currentAreaLayer;
    private DefaultGeoObjectBucketsModel<ParcelModel, ImmutablePoint> parcelBucketsModel;
    private Map<AreaLayerModel, AreaLayerRenderer> areaLayerRendererMap = new HashMap<AreaLayerModel, AreaLayerRenderer>();
    private Set<ParcelModel> parcelSet;
    private static boolean NULL_GEOM;
    private static boolean BAD_SEGMENT;

    public ParcelEditorGui(ModelEnviroment modelEnviroment, Properties properties) {
        super(modelEnviroment, properties);
    }

    private static GeomExtractor<AreaObjectModel, ImmutablePolygonKind> createAreaGeomExtractor() {
        return new GeomExtractor<AreaObjectModel, ImmutablePolygonKind>(){

            @Override
            public ImmutablePolygonKind getGeom(AreaObjectModel object) {
                return object.getGeom();
            }
        };
    }

    private static GeomExtractor<ParcelModel, ImmutablePoint> createParcelGeomExtractor() {
        return new GeomExtractor<ParcelModel, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(ParcelModel object) {
                return object.getGeom();
            }
        };
    }

    @Override
    protected JPanel createTopPanel(JPanel undoManagerPane) {
        this.parcelEditorActions = new ParcelEditorActions(this);
        JPanel filterPanel = new JPanel(new FlowLayout());
        filterPanel.add(this.parcelEditorActions.getKindFilter());
        filterPanel.add(this.parcelEditorActions.getPlzFilter());
        filterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaLayer", new Serializable[0])));
        AreaLayerComboBox areaLayerComboBox = new AreaLayerComboBox(this.getModelEnviroment(), true, AreaObjectGenInfoDiscriminator.values());
        areaLayerComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() == 1 && item != null) {
                    ParcelEditorGui.this.currentAreaLayer = item instanceof AreaLayerModel ? (AreaLayerModel)item : null;
                    boolean fand = false;
                    for (AreaLayerModel areaLayer : ParcelEditorGui.this.areaLayerRendererMap.keySet()) {
                        if (areaLayer.equals(ParcelEditorGui.this.currentAreaLayer)) {
                            ((AreaLayerRenderer)ParcelEditorGui.this.areaLayerRendererMap.get(areaLayer)).setActive(true);
                            fand = true;
                            continue;
                        }
                        ((AreaLayerRenderer)ParcelEditorGui.this.areaLayerRendererMap.get(areaLayer)).setActive(false);
                    }
                    if (!fand && ParcelEditorGui.this.currentAreaLayer != null) {
                        ParcelEditorGui.this.creatAreaLayerRenderer(ParcelEditorGui.this.currentAreaLayer);
                    }
                }
            }
        });
        filterPanel.add(areaLayerComboBox);
        final Tupel<SearchLocationAction, Action> tupel = SearchLocationAction.createButtonTupel(this, super.getNavigatorPanel(), super.getModelEnviroment(), true, true);
        filterPanel.add(new JButton(tupel.getElement1()));
        filterPanel.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.remove.pin", new Serializable[0])){
            private static final long serialVersionUID = -6854094302238412751L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ((SearchLocationAction)tupel.getElement1()).clearCoordinate();
                ParcelEditorGui.this.parcelLayerRenderer.center(null);
            }
        }));
        filterPanel.add(this.parcelEditorActions.getShowStreetButton());
        JPanel managePane = new JPanel(new FlowLayout());
        managePane.setAlignmentX(0.0f);
        JButton parcelRefreshButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.sync", new Serializable[0])){
            private static final long serialVersionUID = -3117859723669632262L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ParcelEditorGui.this.refreshParcels();
            }
        });
        managePane.add(parcelRefreshButton);
        managePane.add(undoManagerPane);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)filterPanel, "West");
        topPanel.add(p1);
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add((Component)managePane, "East");
        topPanel.add(p2);
        return topPanel;
    }

    private void refreshParcels() {
        this.getModelEnviroment().getModelCache().refresh(ParcelModel.class);
    }

    @Override
    protected JScrollPane createLeftPanel() {
        DefaultListModel parcelListModel = new DefaultListModel();
        JList legendList = new JList(parcelListModel);
        this.setLegendList(legendList);
        ParcelListCellRenderer parcelModelListCellRenderer = new ParcelListCellRenderer();
        parcelModelListCellRenderer.setWithIndex(true);
        legendList.setCellRenderer(parcelModelListCellRenderer);
        legendList.addMouseListener(new ParcelLegendMouseListener(legendList, this.getModelEnviroment(), this));
        JScrollPane jScrollPane = new JScrollPane(legendList);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(ModelEnviroment.getMessageResolver().resolveMessage("messages.filter.parcel.legend", new Serializable[0])));
        jScrollPane.setPreferredSize(FormUtil.SIZEOFLISTANDTREE);
        return jScrollPane;
    }

    @Override
    protected ParcelLayerRenderer getLayerRenderer() {
        if (this.parcelLayerRenderer == null) {
            this.parcelLayerRenderer = new ParcelLayerRenderer(null, this.getModelEnviroment(), true, true);
        }
        return this.parcelLayerRenderer;
    }

    protected void creatAreaLayerRenderer(final AreaLayerModel areaLayer) {
        DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> bucketsModel = new DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>(this.getNavigatorPanel().getCoordinateFactory(), ParcelEditorGui.createAreaGeomExtractor());
        bucketsModel.setFetchCallback(new BucketsFetchCallback<AreaObjectModel, ImmutablePolygonKind>(){

            @Override
            public Collection<AreaObjectModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                AreaCaller areaCaller = ParcelEditorGui.this.getModelEnviroment().getAllCaller().getAreaCaller();
                return areaCaller.fetchAreaObjects(areaLayer, topLeft, bottomRight);
            }
        });
        AreaLayerRenderer areaLayerRenderer = AreaLayerRenderer.createDefaultAreaLayerRenderer(areaLayer.getDisplayname(), bucketsModel, ParcelEditorGui.createAreaGeomExtractor(), areaLayer.getId().toString(), this.getModelEnviroment(), true, this.getNavigatorPanel());
        areaLayerRenderer.setActive(true);
        super.addRenderer(areaLayerRenderer);
        this.areaLayerRendererMap.put(areaLayer, areaLayerRenderer);
    }

    @Override
    public void update() {
        final StreetNetCaller streetNetCaller = this.getModelEnviroment().getAllCaller().getStreetNetCaller();
        if (this.parcelSet == null) {
            this.parcelSet = new HashSet<ParcelModel>();
            if (NULL_GEOM) {
                this.parcelSet.addAll(streetNetCaller.fetchParcelsWithNullGeom());
            }
            if (BAD_SEGMENT) {
                this.parcelSet.addAll(streetNetCaller.fetchParcelsWithBadSegment());
            }
        }
        DefaultListModel parcelListModel = (DefaultListModel)this.getLegendList().getModel();
        parcelListModel.clear();
        NavigatorPanel navigatorPanel = this.getNavigatorPanel();
        CoordinateFactory coordinateFactory = navigatorPanel.getCoordinateFactory();
        if (this.parcelBucketsModel == null) {
            this.parcelBucketsModel = new DefaultGeoObjectBucketsModel<ParcelModel, ImmutablePoint>(5000.0 * coordinateFactory.getRefScale(), coordinateFactory, ParcelEditorGui.createParcelGeomExtractor());
            this.parcelBucketsModel.setFetchCallback(new BucketsFetchCallback<ParcelModel, ImmutablePoint>(){

                @Override
                public Collection<ParcelModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                    return streetNetCaller.fetchParcels(topLeft, bottomRight, false);
                }
            });
            this.parcelBucketsModel.addGeoObjectBucketsChangeListener(new GeoObjectBucketsChangeListener(){

                @Override
                public void geoBucketsChanged(GeoObjectBucketsChangedEvent e) {
                    ParcelEditorGui.this.getNavigatorPanel().repaint(10L);
                }
            });
        }
        ArrayList<ParcelModel> tList = new ArrayList<ParcelModel>(this.parcelSet);
        if (this.isWithAllModels()) {
            CoordinateFactory factory = coordinateFactory;
            Point2D.Double bottomLeft = navigatorPanel.getRealBoundaryBottomLeft();
            Point2D.Double topRight = navigatorPanel.getRealBoundaryTopRight();
            ArrayList parcels = new ArrayList(this.parcelBucketsModel.findObjects(factory.createCoordinate(bottomLeft.getX(), bottomLeft.getY()), factory.createCoordinate(topRight.getX(), topRight.getY())));
            for (ParcelModel parcel : parcels) {
                if (tList.contains(parcel)) continue;
                tList.add(parcel);
            }
        }
        Collections.sort(tList, new StreetNameComparator());
        for (ParcelModel tupel : tList) {
            parcelListModel.addElement(tupel);
        }
        this.parcelEditorActions.filterAndSetInList();
        this.repaint(10L);
    }

    @Override
    protected void showLegendDialog(Object o) {
        if (o instanceof ParcelModel) {
            Window parent = SwingUtils.findWindowParent(this);
            ParcelDialog parcelDialog = new ParcelDialog(parent, (ParcelModel)o, Dialog.ModalityType.MODELESS, this.getModelEnviroment(), false);
            parcelDialog.setVisible(true);
        }
    }

    public AreaLayerModel getCurrentAreaLayer() {
        return this.currentAreaLayer;
    }

    static {
        String nullGeomString = ModelEnviroment.getProperties().getProperty("parcelEditor.nullGeom.active");
        nullGeomString = StringUtil.isBlank(nullGeomString) ? "false" : nullGeomString;
        NULL_GEOM = StringUtil.isTrue(nullGeomString);
        String badSegmentString = ModelEnviroment.getProperties().getProperty("parcelEditor.badSegment.active");
        badSegmentString = StringUtil.isBlank(badSegmentString) ? "false" : badSegmentString;
        BAD_SEGMENT = StringUtil.isTrue(badSegmentString);
    }
}

