/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.action.geosearch;

import de.datomino.peppergis.client.communication.AsynchronousCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.clienttools.action.geosearch.AbstractCsvGeoSearchingAction;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.ParcelImportDto;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.message.MessageResolver;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ktde.math.projection.CoordinateFactory;

public class CoordinateSearchingAction
extends AbstractCsvGeoSearchingAction {
    private static final long serialVersionUID = -2234441481574467651L;

    public CoordinateSearchingAction(Window parent) {
        super(parent, "Abgleich Koordinaten");
    }

    @Override
    protected List<CsvColumnChoiceField> getColumnMapFields() {
        return Arrays.asList(this.idField, this.xField, this.yField);
    }

    @Override
    protected boolean showSearchType() {
        return false;
    }

    @Override
    protected boolean showDuplicated() {
        return true;
    }

    @Override
    protected boolean showCoordinateFactory() {
        return true;
    }

    @Override
    protected String startAsynchronousSearch(ModelEnviroment modelEnviroment, byte[] content) {
        ArrayList<String> headerExtension = new ArrayList<String>();
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(ParcelImportDto.Columns.ID));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.COUNTRY));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.POSTCODE));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.CITY));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.DISTRICT));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.STREET));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.HOUSENUMBER));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.HOUSENUMBER_EXTENSION));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.X));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.Y));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(ParcelImportDto.Columns.MATCHING));
        AsynchronousCaller asynchronousCaller = modelEnviroment.getAllCaller().getAsynchronousCaller();
        GenericCsvDto dto = new GenericCsvDto();
        dto.setColumnMapping(this.getCsvGeocodingMapping());
        dto.setContent(content);
        String value = (String)this.delimiterField.getValue();
        dto.setDelim(value.isEmpty() ? (char)',' : value.charAt(0));
        dto.setEncoding((String)this.encodingField.getValue());
        value = (String)this.textQuoteField.getValue();
        dto.setTextQuote(value.isEmpty() ? (char)'\"' : value.charAt(0));
        Integer decimalPlaces = (Integer)this.decimalPlacesField.getValue();
        CoordinateFactory.Projections coord = (CoordinateFactory.Projections)((Object)this.coordinateFactoryField.getValue());
        return asynchronousCaller.searchCoordinates(dto, 1, headerExtension, this.isDuplicated(), decimalPlaces == null ? 5 : decimalPlaces, coord);
    }

    @Override
    protected boolean showImportedLocations() {
        return false;
    }
}

