/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.action;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.area.AreaObjectComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.CountryPostcodePane;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.dto.exporter.DefaultExportDto;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;

public class RemoveParcelRoutingSegmentPane
extends JPanel {
    private static final long serialVersionUID = -8993573923584496688L;
    private ModelEnviroment modelEnviroment = new ModelEnviroment(this);

    public RemoveParcelRoutingSegmentPane() {
        super(new BorderLayout());
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel settingPane = new JPanel(new SpringLayout());
        settingPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.line", new Serializable[0])));
        final JRadioButton distance25 = new JRadioButton("> 25");
        final JRadioButton distance50 = new JRadioButton("> 50");
        final JRadioButton distance100 = new JRadioButton("> 100");
        JRadioButton distanceSelf = new JRadioButton("> ");
        NumberFormat nf = NumberFormat.getInstance(Locale.GERMAN);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern("###,###,###");
        final JFormattedTextField selfTextField = new JFormattedTextField(df);
        selfTextField.setColumns(10);
        ButtonGroup distanceGroup = new ButtonGroup();
        distanceGroup.add(distance25);
        distanceGroup.add(distance50);
        distanceGroup.add(distance100);
        distanceGroup.add(distanceSelf);
        distance25.setSelected(true);
        JPanel distancePane = new JPanel(new FlowLayout());
        distancePane.add(distance25);
        distancePane.add(distance50);
        distancePane.add(distance100);
        distancePane.add(distanceSelf);
        distancePane.add(selfTextField);
        settingPane.add(distancePane);
        final JRadioButton complete = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.allParcels", new Serializable[0]));
        final JRadioButton areaSelection = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaObject", new Serializable[0]));
        final JRadioButton poSelection = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.postcode", new Serializable[0]));
        ButtonGroup selectionGroup = new ButtonGroup();
        selectionGroup.add(complete);
        selectionGroup.add(areaSelection);
        selectionGroup.add(poSelection);
        complete.setSelected(true);
        settingPane.add(complete);
        settingPane.add(areaSelection);
        final AreaLayerComboBox areaLayerComboBox = new AreaLayerComboBox(this.modelEnviroment, true, new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND, AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT});
        final AreaObjectComboBox areaObjectComboBox = new AreaObjectComboBox(true);
        areaLayerComboBox.addActionListener(areaObjectComboBox.createLayerChangeListener(areaLayerComboBox));
        settingPane.add(areaLayerComboBox);
        settingPane.add(areaObjectComboBox);
        settingPane.add(poSelection);
        final CountryPostcodePane countryPostcodePane = new CountryPostcodePane(this.modelEnviroment);
        settingPane.add(countryPostcodePane);
        JPanel panel = new JPanel(new FlowLayout());
        final JCheckBox foot = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.FOOT));
        panel.add(foot);
        final JCheckBox motor = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.MOTORCAR));
        panel.add(motor);
        final JCheckBox bike = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.BIKE));
        panel.add(bike);
        JPanel mPanel = new JPanel(new BorderLayout());
        mPanel.add((Component)panel, "West");
        settingPane.add(mPanel);
        final JCheckBox removeRelation = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.remove.parcelConnection.remove", new Serializable[0]));
        settingPane.add(removeRelation);
        ActionListener radioActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (complete.isSelected()) {
                    areaLayerComboBox.setEnabled(false);
                    areaObjectComboBox.setEnabled(false);
                    countryPostcodePane.setEnabled(false);
                } else if (areaSelection.isSelected()) {
                    areaLayerComboBox.setEnabled(true);
                    areaObjectComboBox.setEnabled(true);
                    countryPostcodePane.setEnabled(false);
                } else {
                    areaLayerComboBox.setEnabled(false);
                    areaObjectComboBox.setEnabled(false);
                    countryPostcodePane.setEnabled(true);
                }
            }
        };
        complete.addActionListener(radioActionListener);
        areaSelection.addActionListener(radioActionListener);
        poSelection.addActionListener(radioActionListener);
        radioActionListener.actionPerformed(null);
        SpringUtilities.makeCompactGrid(settingPane, 10, 1, 5, 5, 5, 5);
        JPanel buttonPane = new JPanel(new FlowLayout());
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.run", new Serializable[0])){
            private static final long serialVersionUID = -2406650230129684408L;

            @Override
            public void actionPerformed(ActionEvent e) {
                double maxDistance = Double.MAX_VALUE;
                if (distance25.isSelected()) {
                    maxDistance = 25.0;
                } else if (distance50.isSelected()) {
                    maxDistance = 50.0;
                } else if (distance100.isSelected()) {
                    maxDistance = 100.0;
                } else {
                    try {
                        maxDistance = Double.parseDouble(selfTextField.getValue().toString());
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(RemoveParcelRoutingSegmentPane.this, ModelEnviroment.getMessageResolver().resolveMessage("gui.input.integer", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.common.errormessage.window.title", new Serializable[0]), 0);
                        return;
                    }
                }
                AreaObjectModel area = null;
                PostcodeModel postcode = null;
                if (areaSelection.isSelected()) {
                    area = (AreaObjectModel)areaObjectComboBox.getSelectedItem();
                    if (area == null) {
                        JOptionPane.showMessageDialog(RemoveParcelRoutingSegmentPane.this, ModelEnviroment.getMessageResolver().resolveMessage("gui.input.select.area", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.common.errormessage.window.title", new Serializable[0]), 0);
                        return;
                    }
                } else if (poSelection.isSelected() && (postcode = countryPostcodePane.getSelectedPostcode()) == null) {
                    JOptionPane.showMessageDialog(RemoveParcelRoutingSegmentPane.this, ModelEnviroment.getMessageResolver().resolveMessage("gui.input.select.postcode", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.common.errormessage.window.title", new Serializable[0]), 0);
                    return;
                }
                RemoveParcelRoutingSegmentPane.this.removeParcelSegments(removeRelation.isSelected(), maxDistance, area, postcode, foot.isSelected(), motor.isSelected(), bike.isSelected());
            }
        }));
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -3150696364971949601L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtils.findWindowParent(RemoveParcelRoutingSegmentPane.this).dispose();
            }
        }));
        this.add((Component)settingPane, "Center");
        this.add((Component)buttonPane, "South");
    }

    private void removeParcelSegments(boolean remove, double maxDistance, AreaObjectModel area, PostcodeModel postcode, boolean foot, boolean motor, boolean bike) {
        try {
            DefaultExportDto defaultExportDto = this.modelEnviroment.getAllCaller().getStreetNetCaller().deleteParcelSegmentRelations(maxDistance, area, postcode, remove, foot, motor, bike);
            this.save(defaultExportDto);
        }
        catch (ClientExportException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void save(DefaultExportDto content) throws IOException {
        String dotFileExtension = ".csv";
        JFileChooser fileChooser = new JFileChooser();
        FileFilter filter = new FileFilter(){

            @Override
            public String getDescription() {
                return ".csv";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".csv");
            }
        };
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        int d2 = 0;
        do {
            int d = fileChooser.showSaveDialog(SwingUtils.findWindowParent(this));
            switch (d) {
                case 0: {
                    File file = fileChooser.getSelectedFile();
                    String oName = file.getName();
                    if (fileChooser.getFileFilter() == filter && !oName.endsWith(".csv")) {
                        file = new File(file.getParent(), oName + ".csv");
                    }
                    d2 = 0;
                    if (file.exists()) {
                        d2 = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question.overwriteFile", new Serializable[]{oName}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 1);
                    }
                    if (d2 != 0) break;
                    FileUtils.writeByteArrayToFile(file, content.getContent());
                    break;
                }
            }
        } while (d2 == 2);
    }
}

