/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.action;

import de.datomino.peppergis.client.action.AbstractCsvAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.dto.importer.DefaultCsvDto;
import de.datomino.peppergis.dto.importer.DefaultCsvResultDto;
import de.datomino.util.swing.blocking.BlockingDialog;
import de.datomino.util.swing.csv.CsvHeaderChooserPane;
import java.awt.Component;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.io.CsvReader;
import org.ktde.util.io.CsvWriter;

public class CsvCoordsInAreaAction
extends AbstractCsvAction<DefaultCsvDto, DefaultCsvResultDto> {
    private static final long serialVersionUID = -7335226649944183433L;
    private static final List<CsvHeaderChooserPane.CsvField> CSV_FIELDS;

    public CsvCoordsInAreaAction(Window parent) {
        super(parent, "Koordinate in PLZ");
    }

    @Override
    protected DefaultCsvDto createDto(Map<Serializable, String> map) {
        return new DefaultCsvDto();
    }

    @Override
    protected Collection<CsvHeaderChooserPane.CsvField> getCsvFields() {
        return CSV_FIELDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DefaultCsvResultDto doWork(DefaultCsvDto t, byte[] content, BlockingDialog blockingDialog) {
        try (ModelEnviroment modelEnviroment = new ModelEnviroment(this.getParent());){
            CsvReader csvReader = new CsvReader(new ByteArrayInputStream(content));
            List<String> header = csvReader.readLine();
            Map<String, Integer> headerMapping = CsvReader.getHeaderMapping(header);
            String xColumn = t.getHeaderMapping().get("X");
            String yColumn = t.getHeaderMapping().get("Y");
            Integer xCol = headerMapping.get(xColumn);
            Integer yCol = headerMapping.get(yColumn);
            File file = File.createTempFile("coordArea", ".csv");
            CsvWriter csvWriter = new CsvWriter(file);
            header.add("Area");
            csvWriter.writeLine(header);
            List<String> line = csvReader.readLine();
            while (line != null) {
                if (!CsvReader.isLineEmpty(line)) {
                    Collection<AreaObjectModel> areaObjectModels = modelEnviroment.getAllCaller().getAreaCaller().findAreasWithCoordWithin(Wgs84Factory.INSTANCE.createCoordinate(Double.parseDouble(line.get(xCol)), Double.parseDouble(line.get(yCol))), 4L);
                    switch (areaObjectModels.size()) {
                        case 0: {
                            line.add("");
                            break;
                        }
                        case 1: {
                            line.add(areaObjectModels.iterator().next().getShortcut());
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    csvWriter.writeLine(line);
                }
                line = csvReader.readLine();
            }
            csvReader.close();
            csvWriter.flush();
            csvWriter.close();
        }
        return new DefaultCsvResultDto();
    }

    @Override
    protected Component getSpecialComponent() {
        return null;
    }

    @Override
    protected void afterWork(DefaultCsvResultDto u) {
    }

    static {
        ArrayList<CsvHeaderChooserPane.CsvField> csvFields = new ArrayList<CsvHeaderChooserPane.CsvField>(2);
        csvFields.add(new CsvHeaderChooserPane.CsvField((Serializable)((Object)"X"), "X", true));
        csvFields.add(new CsvHeaderChooserPane.CsvField((Serializable)((Object)"Y"), "Y", true));
        CSV_FIELDS = Collections.unmodifiableList(csvFields);
    }
}

