/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.wage.track;

import com.google.common.collect.Multimap;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.model.wage.HistoryAreaStopModel;
import de.datomino.peppergis.client.model.wage.TrackWatchDataModel;
import de.datomino.peppergis.client.wage.track.EstimatedTourTrackingsRenderer;
import de.datomino.peppergis.client.wage.track.TrackWatchTrackingsRenderer;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.swing.navigator.DefaultMouseManipulator;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;

public class TrackWatchTracksMapPane
extends JPanel {
    private static final long serialVersionUID = -6436115453343104267L;
    private ModelEnviroment modelEnvironment;
    private NavigatorPanel navigatorPanel;
    private Multimap<Integer, TrackWatchDataModel> trackingPoints;
    private List<HistoryAreaStopModel> stops;
    private ImmutableLineString lineString;
    private TrackWatchTrackingsRenderer trackWatchTrackingsRenderer;
    private EstimatedTourTrackingsRenderer estimatedTourTrackingsRenderer;

    public TrackWatchTracksMapPane(ModelEnviroment modelEnviroment, Multimap<Integer, TrackWatchDataModel> trackingImmutablePoints, List<HistoryAreaStopModel> stops, ImmutableLineString lineString) {
        this.modelEnvironment = modelEnviroment;
        this.trackingPoints = trackingImmutablePoints;
        this.stops = stops;
        this.lineString = lineString;
        this.createMapPanel();
    }

    private void createMapPanel() {
        this.setLayout(new BorderLayout());
        this.navigatorPanel = new NavigatorPanel(0.0, 0.0, OpenStreetmapViewFactory.INSTANCE, (Container)this);
        this.navigatorPanel.setCursor(Cursor.getDefaultCursor());
        this.navigatorPanel.setSize(1000, 250);
        this.navigatorPanel.setPreferredSize(new Dimension(1000, 1000));
        this.navigatorPanel.forceCalcTransform();
        this.navigatorPanel.setPanning(true);
        this.navigatorPanel.getPanningAction().setSelected(true);
        this.addRenderers(this.modelEnvironment);
        DefaultMouseManipulator mouseManipulator = new DefaultMouseManipulator(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (NavigatorPanningAction.performWheelZoom(e, TrackWatchTracksMapPane.this.getNavigatorPanel())) {
                    super.mouseWheelMoved(e);
                    TrackWatchTracksMapPane.this.getNavigatorPanel().forceCalcTransform();
                }
            }
        };
        this.navigatorPanel.setMouseManipulator(mouseManipulator);
        this.navigatorPanel.addMouseListener(mouseManipulator);
        this.navigatorPanel.center(this.getCoordinatesForPoints(), 10);
        this.add((Component)this.navigatorPanel, "Center");
    }

    private List<Coordinate> getCoordinatesForPoints() {
        ImmutablePoint point;
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        if (!this.trackingPoints.isEmpty()) {
            for (TrackWatchDataModel trackData : this.trackingPoints.values()) {
                point = trackData.getGeoTrack();
                coordinates.add(point.getCoordinate());
            }
        }
        for (HistoryAreaStopModel stopData : this.stops) {
            point = stopData.getLocation();
            coordinates.add(point.getCoordinate());
        }
        if (this.lineString != null) {
            for (ImmutablePoint pointLineString : this.lineString.getCoordinates()) {
                coordinates.add(pointLineString.getCoordinate());
            }
        }
        return coordinates;
    }

    private void addRenderers(ModelEnviroment modelEnviroment) {
        ThreadingOsmNavigatorRenderer osmNavigatorRenderer = new ThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
        osmNavigatorRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(osmNavigatorRenderer);
        this.trackWatchTrackingsRenderer = new TrackWatchTrackingsRenderer(this.navigatorPanel, this.trackingPoints);
        this.trackWatchTrackingsRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.getToggleActions().addAction(this.trackWatchTrackingsRenderer);
        this.navigatorPanel.addMouseMotionListener(this.trackWatchTrackingsRenderer);
        this.navigatorPanel.addMouseListener(this.trackWatchTrackingsRenderer);
        this.navigatorPanel.addMouseWheelListener(this.trackWatchTrackingsRenderer);
        this.navigatorPanel.addRenderer(this.trackWatchTrackingsRenderer);
        this.estimatedTourTrackingsRenderer = new EstimatedTourTrackingsRenderer(this.navigatorPanel, this.stops, this.lineString);
        this.estimatedTourTrackingsRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.getToggleActions().addAction(this.estimatedTourTrackingsRenderer);
        this.navigatorPanel.addMouseMotionListener(this.estimatedTourTrackingsRenderer);
        this.navigatorPanel.addMouseListener(this.estimatedTourTrackingsRenderer);
        this.navigatorPanel.addMouseWheelListener(this.estimatedTourTrackingsRenderer);
        this.navigatorPanel.addRenderer(this.estimatedTourTrackingsRenderer);
    }

    public ModelEnviroment getModelEnvironment() {
        return this.modelEnvironment;
    }

    public void setModelEnvironment(ModelEnviroment modelEnvironment) {
        this.modelEnvironment = modelEnvironment;
    }

    public NavigatorPanel getNavigatorPanel() {
        return this.navigatorPanel;
    }

    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.navigatorPanel = navigatorPanel;
    }

    public Multimap<Integer, TrackWatchDataModel> getTrackingPoints() {
        return this.trackingPoints;
    }

    public void setTrackingPoints(Multimap<Integer, TrackWatchDataModel> trackingPoints) {
        this.trackingPoints = trackingPoints;
    }

    public TrackWatchTrackingsRenderer getTrackWatchTrackingsRenderer() {
        return this.trackWatchTrackingsRenderer;
    }

    public void setTrackWatchTrackingsRenderer(TrackWatchTrackingsRenderer trackWatchTrackingsRenderer) {
        this.trackWatchTrackingsRenderer = trackWatchTrackingsRenderer;
    }

    public EstimatedTourTrackingsRenderer getEstimatedTourTrackingsRenderer() {
        return this.estimatedTourTrackingsRenderer;
    }

    public void setEstimatedTourTrackingsRenderer(EstimatedTourTrackingsRenderer estimatedTourTrackingsRenderer) {
        this.estimatedTourTrackingsRenderer = estimatedTourTrackingsRenderer;
    }

    public List<HistoryAreaStopModel> getStops() {
        return this.stops;
    }

    public void setStops(List<HistoryAreaStopModel> stops) {
        this.stops = stops;
    }

    public ImmutableLineString getLineString() {
        return this.lineString;
    }

    public void setLineString(ImmutableLineString lineString) {
        this.lineString = lineString;
    }
}

