/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.wage.track;

import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.model.wage.HistoryAreaStopModel;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.swing.AbstractEnhancedMouseManipulatorAction;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.listener.NavigatorRendererActivateEvent;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;

public class EstimatedTourTrackingsRenderer
extends AbstractEnhancedMouseManipulatorAction
implements NavigatorRenderer {
    private static final long serialVersionUID = 7219028705863898278L;
    private List<HistoryAreaStopModel> allPoints;
    private ImmutableLineString lineString;
    private NavigatorPanel navigatorPanel;
    private List<NavigatorRendererActiveListener> navigatorRendererActiveListeners;
    private boolean active = true;
    private static final int RED = 1;
    private static final int GREEN = 2;
    private static final int BLACK = 3;
    private static final double R_FOR_START_STOP = 10.0;
    private static final double R_FOR_TRACK_POINT = 5.0;
    private static final double LINE_WIDTH_FACTOR = 3.0;
    private static final int DEFAULT_POINT_SIZE = 15;
    public static final int DEFAULT_FONT_SIZE = 7;
    public static final int DEFAULT_FONT_STYLE = 0;
    public static final String DEFAULT_FONT_NAME = "Courier";
    public static final int DEFAULT_FONT_PADDING = 0;
    private static final int ARROW_SIZE = 4;
    private HistoryAreaStopModel hover = null;
    private boolean refreshRequired;
    private int sortOrder = Integer.MAX_VALUE;

    public EstimatedTourTrackingsRenderer(NavigatorPanel navigatorPanel, List<HistoryAreaStopModel> allPoints, ImmutableLineString lineString) {
        super(navigatorPanel, (Double)Double.MAX_VALUE, "Track Map");
        this.navigatorPanel = navigatorPanel;
        this.allPoints = allPoints;
        this.lineString = lineString;
    }

    @Override
    public Collection<OnTopRendering> paintOnto(final Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, final double upp) {
        if (this.isActive()) {
            if (!this.allPoints.isEmpty()) {
                for (HistoryAreaStopModel stopPoint : this.allPoints) {
                    ImmutablePoint immutablePoint1 = stopPoint.getLocation();
                    this.drawSquare(g2d, 3, immutablePoint1.getCoordinate(), 5.0);
                }
            }
            if (this.lineString != null) {
                boolean initial = true;
                this.drawLineString(g2d, this.lineString, upp, Color.BLUE);
                ListIterator<ImmutablePoint> listPoints = this.lineString.getCoordinates() != null ? this.lineString.getCoordinates().listIterator() : null;
                ImmutablePoint point1 = null;
                ImmutablePoint point2 = null;
                while (listPoints != null && listPoints.hasNext()) {
                    if (initial) {
                        point1 = listPoints.next();
                        initial = false;
                    } else {
                        point1 = point2;
                    }
                    if (!listPoints.hasNext()) continue;
                    point2 = listPoints.next();
                    this.drawArrow(g2d, point1.getX(), point1.getY(), point2.getX(), point2.getY());
                }
                this.drawSquare(g2d, 1, this.lineString.getStartPoint().getCoordinate(), 10.0);
                this.drawSquare(g2d, 2, this.lineString.getEndPoint().getCoordinate(), 10.0);
            }
        }
        if (this.isActive() && this.hover != null) {
            OnTopRendering onTopRendering = new OnTopRendering(){

                @Override
                public void paint() {
                    Rectangle2D.Double rectangleOfBox = new Rectangle2D.Double();
                    double left = EstimatedTourTrackingsRenderer.this.hover.getLocation().getX();
                    double top = EstimatedTourTrackingsRenderer.this.hover.getLocation().getY();
                    rectangleOfBox.height = upp * 17.0;
                    rectangleOfBox.width = upp * 65.0;
                    rectangleOfBox.x = left;
                    rectangleOfBox.y = top - rectangleOfBox.height;
                    g2d.setColor(Color.WHITE);
                    g2d.fill(rectangleOfBox);
                    g2d.setColor(Color.BLACK);
                    BasicStroke stroke = new BasicStroke((float)upp);
                    g2d.setStroke(stroke);
                    g2d.draw(rectangleOfBox);
                    EstimatedTourTrackingsRenderer.this.drawInfoText(g2d, upp, left, top);
                }
            };
            ArrayList<OnTopRendering> aOnTops = new ArrayList<OnTopRendering>(1);
            aOnTops.add(onTopRendering);
            return aOnTops;
        }
        return Collections.emptyList();
    }

    private void drawArrow(Graphics2D g, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.sqrt(dx * dx + dy * dy) / 2;
        AffineTransform affineTransform = g.getTransform();
        AffineTransform at = AffineTransform.getTranslateInstance(x1, y1);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        g.transform(at);
        g.drawLine(0, 0, len, 0);
        g.fillPolygon(new int[]{len, len - 4, len - 4, len}, new int[]{0, -4, 4, 0}, 4);
        g.setTransform(affineTransform);
    }

    private void drawInfoText(Graphics2D g2d, double upp, double left, double top) {
        Integer secondsFromStart = this.hover.getSecondsFromStart();
        secondsFromStart = PrimitiveUtil.nullToZero(secondsFromStart);
        int hr = secondsFromStart / 3600;
        int rem = secondsFromStart % 3600;
        int mn = rem / 60;
        int sec = rem % 60;
        String hrStr = (hr < 10 ? "0" : "") + hr + ":";
        String mnStr = (mn < 10 ? "0" : "") + mn + ":";
        String secStr = (sec < 10 ? "0" : "") + sec;
        String info = hrStr + mnStr + secStr;
        double marginTop = 15.0;
        Point2D.Double topLeftPixel = this.navigatorPanel.getPixel(new Point2D.Double(left, top));
        Point2D.Double real = this.navigatorPanel.getReal(topLeftPixel.getX() + 5.0, topLeftPixel.getY() + marginTop);
        Coordinate c = this.navigatorPanel.getCoordinateFactory().createCoordinate(real.getX(), real.getY());
        AffineTransform affineTransform = g2d.getTransform();
        double scaleX = affineTransform.getScaleX() / 1.5;
        double scaleY = affineTransform.getScaleY() / 1.5;
        AffineTransform tranformForText = AffineTransform.getScaleInstance(1.0 / scaleX, 1.0 / scaleY);
        g2d.transform(tranformForText);
        double textX = c.getX() + upp;
        double textY = c.getY();
        Point2D.Double point = new Point2D.Double(textX, textY);
        Point2D.Double dst = new Point2D.Double();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform.getScaleInstance(scaleX, scaleY).transform(point, dst);
        Font font = new Font(DEFAULT_FONT_NAME, 0, 7);
        TextLayout textLayout = new TextLayout(info, font, g2d.getFontRenderContext());
        g2d.setColor(Color.BLACK);
        textLayout.draw(g2d, (float)(dst.getX() + 0.0 - 1.0), (float)(dst.getY() + 0.0 - 1.0));
        g2d.setTransform(affineTransform);
    }

    protected void drawLineString(Graphics2D g2d, ImmutableLineString geom, double upp, Color color) {
        double margin = 3.0 * Math.pow(upp, 0.3);
        boolean first = true;
        g2d.setColor(color);
        BasicStroke stroke = new BasicStroke((float)margin, 1, 1);
        g2d.setStroke(stroke);
        List<ImmutablePoint> coordinates = geom.getCoordinates();
        GeneralPath line = new GeneralPath(0, coordinates.size());
        for (ImmutablePoint immutablePoint : coordinates) {
            Coordinate c = immutablePoint.getCoordinate();
            if (first) {
                line.moveTo(c.getX(), c.getY());
                first = false;
                continue;
            }
            line.lineTo(c.getX(), c.getY());
        }
        g2d.draw(line);
    }

    private void drawSquare(Graphics2D g2d, int color, Coordinate c, double r) {
        if (color == 1) {
            g2d.setColor(Color.RED);
        } else if (color == 2) {
            g2d.setColor(Color.GREEN);
        } else if (color == 3) {
            g2d.setColor(Color.BLACK);
        }
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        rectangle.x = c.getX() - r / 2.0;
        rectangle.y = c.getY() - r / 2.0;
        rectangle.width = r;
        rectangle.height = r;
        g2d.fill(rectangle);
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void turnedOn() {
        this.setActive(true);
        this.fireNavigatorRendererActivateEvent(new NavigatorRendererActivateEvent(this, true));
        this.getNavigatorPanel().repaint(1L);
    }

    @Override
    public void turnedOff() {
        this.setActive(false);
        this.fireNavigatorRendererActivateEvent(new NavigatorRendererActivateEvent(this, false));
        this.getNavigatorPanel().repaint(1L);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        if (this.navigatorRendererActiveListeners == null) {
            this.navigatorRendererActiveListeners = new LinkedList<NavigatorRendererActiveListener>();
        }
        this.navigatorRendererActiveListeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        if (this.navigatorRendererActiveListeners == null) {
            this.navigatorRendererActiveListeners = new LinkedList<NavigatorRendererActiveListener>();
        }
        this.navigatorRendererActiveListeners.remove(navigatorPanelActiveListener);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void close() {
    }

    public List<HistoryAreaStopModel> getAllPoints() {
        return this.allPoints;
    }

    public void setAllPoints(List<HistoryAreaStopModel> allPoints) {
        this.allPoints = allPoints;
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.navigatorPanel = navigatorPanel;
    }

    @Override
    public NavigatorPanel getNavigatorPanel() {
        return this.navigatorPanel;
    }

    public HistoryAreaStopModel getHover() {
        return this.hover;
    }

    public void setHover(HistoryAreaStopModel hover) {
        this.hover = hover;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    protected void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
    }

    @Override
    protected void mouseDragged(int x, int y) {
    }

    @Override
    protected void mouseDragFinished(int x, int y, int modifiers) {
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
    }

    @Override
    protected Integer getTimerInterval() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mouseMoved(int x, int y) {
        if (this.isActive()) {
            Point2D.Double real = this.navigatorPanel.getReal(x, y);
            double upp = this.navigatorPanel.getUpp();
            double margin = 15.0 * Math.pow(upp, -0.2) * upp;
            CoordinateFactory factory = this.navigatorPanel.getCoordinateFactory();
            EstimatedTourTrackingsRenderer estimatedTourTrackingsRenderer = this;
            synchronized (estimatedTourTrackingsRenderer) {
                this.hover = null;
                for (HistoryAreaStopModel stopData : this.allPoints) {
                    Coordinate c = factory.createCoordinate(stopData.getLocation().getCoordinate());
                    Ellipse2D.Double circle = DefaultPointRenderer.getCircle(c, margin);
                    if (!circle.contains(real)) continue;
                    this.hover = stopData;
                    this.refreshRequired = true;
                    this.navigatorPanel.repaint(1L);
                    break;
                }
                if (this.refreshRequired && this.hover == null) {
                    this.navigatorPanel.repaint(1L);
                    this.refreshRequired = false;
                }
            }
        }
    }

    private void fireNavigatorRendererActivateEvent(NavigatorRendererActivateEvent navigatorPanelActivateEvent) {
        if (this.navigatorRendererActiveListeners != null) {
            for (NavigatorRendererActiveListener navigatorRendererActiveListener : this.navigatorRendererActiveListeners) {
                navigatorRendererActiveListener.valueChanged(navigatorPanelActivateEvent);
            }
        }
    }

    public List<NavigatorRendererActiveListener> getNavigatorRendererActiveListeners() {
        return this.navigatorRendererActiveListeners;
    }

    public void setNavigatorRendererActiveListeners(List<NavigatorRendererActiveListener> navigatorRendererActiveListeners) {
        this.navigatorRendererActiveListeners = navigatorRendererActiveListeners;
    }

    public boolean isRefreshRequired() {
        return this.refreshRequired;
    }

    public void setRefreshRequired(boolean refreshRequired) {
        this.refreshRequired = refreshRequired;
    }

    public ImmutableLineString getLineString() {
        return this.lineString;
    }

    public void setLineString(ImmutableLineString lineString) {
        this.lineString = lineString;
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }
}

