/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.wage.parameter;

import de.datomino.logistic.type.CalculateType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.gui.area.AreaTourTypePane;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.util.WeekdayName;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.wage.ThrowLeafletScalingModel;
import de.datomino.peppergis.client.model.wage.ThrowLeafletScalingModelImpl;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.wage.WageDeltaModelUtil;
import de.datomino.peppergis.client.wage.SortVolumeScalingPane;
import de.datomino.peppergis.client.wage.ThrowLeafletScalingPane;
import de.datomino.peppergis.client.wage.parameter.inclusionexclusion.WageParameterInclusionExclusionPane;
import de.datomino.peppergis.type.LetterDeliveryType;
import de.datomino.peppergis.type.SubscriptionDeliveryType;
import de.datomino.peppergis.type.ThrowLeafletType;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.type.WageParameterStatus;
import de.datomino.peppergis.type.areatourtype.AreaCalculationType;
import de.datomino.peppergis.type.areatourtype.AreaObjectType;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.SpringUtilities;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ktde.util.datatypes.Holder;

public class WageParameterPane
extends JTabbedPane {
    private static final long serialVersionUID = -1352019905151746717L;
    private Holder<WageParameterModel> wageParameterObject;
    private boolean editable;
    private JTextField parameterName;
    private SortVolumeScalingPane sortVolumeScalings;
    private Holder<ThrowLeafletScalingModel> firstThrowDirectDelivery;
    private Holder<ThrowLeafletScalingModel> throwDirectDelivery;
    private ThrowLeafletScalingPane throwLeafletScalingPane;
    private EnumComboBox<SubscriptionDeliveryType> subscriptionDeliveryType;
    private EnumComboBox<LetterDeliveryType> letterDeliveryType;
    private AreaTourTypePane areaTourType;
    private EnumComboBox<RouteVehicleType> vehicelTypeInArea;
    private EnumComboBox<CalculateType> routingType;
    private EnumComboBox<RouteVehicleType> vehicelTypeFromPoi;
    private EnumComboBox<RouteVehicleType> vehicelTypeFromPickPoint;
    private JRadioButton backTrue;
    private JRadioButton backFalse;
    private JRadioButton parcelLocationYes;
    private JRadioButton parcelLocationNo;
    private JRadioButton difficultyLevelYes;
    private JRadioButton difficultyLevelNo;
    private EnumComboBox<WageParameterStatus> status;
    private ModelEnviroment modelEnviroment;
    private WageParameterInclusionExclusionPane wageParameterInclusionExclusionPane;

    public WageParameterPane(WageParameterModel wageParameter, boolean editable, ModelEnviroment modelEnviroment) {
        this.wageParameterObject = new Holder<WageParameterModel>(wageParameter);
        this.editable = editable && ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER, UserRole.WAGE_ACTIVE);
        this.modelEnviroment = modelEnviroment;
        this.initialize();
        this.fillData();
    }

    private void initialize() {
        this.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.parameter", new Serializable[0]), this.createDefaultPane());
        this.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.receptionTime", new Serializable[0]), this.createReceptionPane());
        this.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.throw", new Serializable[0]), this.createThrowPane());
        this.wageParameterInclusionExclusionPane = new WageParameterInclusionExclusionPane(this.modelEnviroment);
        this.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.block", new Serializable[0]), this.wageParameterInclusionExclusionPane);
        this.wageParameterInclusionExclusionPane.setEditable(this.editable);
    }

    private Component createReceptionPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.flatTime", "-", "messages.subscription.subscription"), new String[0])));
        JTextField receptionSubscriptionFlatTime = this.createTextField(10, "ReceptionSubscriptionFlatTime");
        pane.add(receptionSubscriptionFlatTime);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.flatTime", "-", "messages.wage.weeklyPaper"), new String[0])));
        JTextField receptionWeeklyPaperFlatTime = this.createTextField(10, "ReceptionWeeklyPaperFlatTime");
        pane.add(receptionWeeklyPaperFlatTime);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.flatTime", "-", "messages.wage.leaflet"), new String[0])));
        JTextField receptionLeafletFlatTime = this.createTextField(10, "ReceptionLeafletFlatTime");
        pane.add(receptionLeafletFlatTime);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.flatTime", "-", "messages.wage.letter"), new String[0])));
        JTextField receptionLetterFlatTime = this.createTextField(10, "ReceptionLetterFlatTime");
        pane.add(receptionLetterFlatTime);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.pieceTime", "-", "messages.subscription.subscription"), new String[0])));
        JTextField receptionSubscriptionPieceTime = this.createTextField(10, "ReceptionSubscriptionPieceTime");
        pane.add(receptionSubscriptionPieceTime);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.pieceTime", "-", "messages.wage.weeklyPaper"), new String[0])));
        JTextField receptionWeeklyPaperPieceTime = this.createTextField(10, "ReceptionWeeklyPaperPieceTime");
        pane.add(receptionWeeklyPaperPieceTime);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.pieceTime", "-", "messages.wage.leaflet"), new String[0])));
        JTextField receptionLeafletPieceTime = this.createTextField(10, "ReceptionLeafletPieceTime");
        pane.add(receptionLeafletPieceTime);
        pane.add(new JLabel("---------------------"));
        pane.add(new JLabel(""));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.sortLetter"), new String[0])));
        this.sortVolumeScalings = new SortVolumeScalingPane(this, this.editable);
        pane.add(this.sortVolumeScalings);
        pane.add(new JLabel("---------------------"));
        pane.add(new JLabel(""));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.pieceTime", "-", "messages.wage.depositor"), new String[0])));
        JTextField manualLeafletPieceTime = this.createTextField(10, "ManualLeafletPieceTime");
        pane.add(manualLeafletPieceTime);
        SpringUtilities.makeCompactGrid(pane, 11, 2, 5, 5, 5, 5);
        return ClientSwingUtil.createScrollPane(pane);
    }

    private Component createThrowPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.firstThrowTime", "-", "messages.subscription.subscription"), new String[0])));
        JTextField firstThrowSubscriptionPieceTime = this.createTextField(10, "FirstThrowSubscriptionPieceTime");
        pane.add(firstThrowSubscriptionPieceTime);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.firstThrowTime", "-", "messages.wage.weeklyPaper"), new String[0])));
        JTextField firstThrowWeeklyPaperPieceTime = this.createTextField(10, "FirstThrowWeeklyPaperPieceTime");
        pane.add(firstThrowWeeklyPaperPieceTime);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.firstThrowTime", "-", "messages.wage.leaflet"), new String[0])));
        this.firstThrowDirectDelivery = new Holder<ThrowLeafletScalingModel>(WageDeltaModelUtil.getThrowLeafletScalingModel(this.wageParameterObject.getElement(), 1, ThrowLeafletType.DIRECT_FIRST));
        JTextField firstThrowDirectDeliveryPieceTime = ClientSwingUtil.createParameterTextField(10, null, this.editable, "PieceTime", this.firstThrowDirectDelivery, this);
        pane.add(firstThrowDirectDeliveryPieceTime);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.firstThrowTime", "-", "messages.wage.letter"), new String[0])));
        JTextField firstThrowLetterPieceTime = this.createTextField(10, "FirstThrowLetterPieceTime");
        pane.add(firstThrowLetterPieceTime);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.throwTime", "-", "messages.subscription.subscription"), new String[0])));
        JTextField throwSubscriptionPieceTime = this.createTextField(10, "ThrowSubscriptionPieceTime");
        pane.add(throwSubscriptionPieceTime);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.throwTime", "-", "messages.wage.weeklyPaper"), new String[0])));
        JTextField throwWeeklyPaperPieceTime = this.createTextField(10, "ThrowWeeklyPaperPieceTime");
        pane.add(throwWeeklyPaperPieceTime);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.throwTime", "-", "messages.wage.leaflet"), new String[0]) + "-DV"));
        this.throwDirectDelivery = new Holder<ThrowLeafletScalingModel>(WageDeltaModelUtil.getThrowLeafletScalingModel(this.wageParameterObject.getElement(), 1, ThrowLeafletType.DIRECT));
        JTextField throwDirectDeliveryPieceTime = ClientSwingUtil.createParameterTextField(10, null, this.editable, "PieceTime", this.throwDirectDelivery, this);
        pane.add(throwDirectDeliveryPieceTime);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.throw", "-", "messages.wage.leaflet"), new String[0]) + "-MB"));
        this.throwLeafletScalingPane = new ThrowLeafletScalingPane(this, this.editable, ThrowLeafletType.MANUAL_FIRST, ThrowLeafletType.MANUAL);
        pane.add(this.throwLeafletScalingPane);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.wage.throwTime", "-", "messages.wage.letter"), new String[0])));
        JTextField throwLetterPieceTime = this.createTextField(10, "ThrowLetterPieceTime");
        pane.add(throwLetterPieceTime);
        SpringUtilities.makeCompactGrid(pane, 9, 2, 5, 5, 5, 5);
        return ClientSwingUtil.createScrollPane(pane);
    }

    private Component createDefaultPane() {
        AreaAttributeValueDescriptorModel motorLevel;
        AreaAttributeValueDescriptorModel footLevel;
        AreaAttributeValueDescriptorModel motorParcelLocation;
        AreaAttributeValueDescriptorModel footParcelLocation;
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0])));
        this.parameterName = this.createTextField(10, "Name");
        pane.add(this.parameterName);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.status", new Serializable[0])));
        this.status = new EnumComboBox(WageParameterStatus.class, false, (Enum[])new WageParameterStatus[]{WageParameterStatus.ACTIVE, WageParameterStatus.DEFAULT});
        this.status.setEnabled(this.editable);
        this.status.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && WageParameterPane.this.getWageParameter() != null) {
                    WageParameterPane.this.getWageParameter().setStatus((WageParameterStatus)((Object)WageParameterPane.this.status.getSelectedValue()));
                }
            }
        });
        pane.add(this.status);
        pane.add(new JLabel("---------------------"));
        pane.add(new JLabel(""));
        this.subscriptionDeliveryType = new EnumComboBox<SubscriptionDeliveryType>(SubscriptionDeliveryType.class, true);
        this.subscriptionDeliveryType.setEnabled(this.editable);
        this.subscriptionDeliveryType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && WageParameterPane.this.getWageParameter() != null) {
                    WageParameterPane.this.getWageParameter().setSubscriptionDeliveryType((SubscriptionDeliveryType)((Object)WageParameterPane.this.subscriptionDeliveryType.getSelectedValue()));
                }
            }
        });
        this.letterDeliveryType = new EnumComboBox<LetterDeliveryType>(LetterDeliveryType.class, true);
        this.letterDeliveryType.setEnabled(this.editable);
        this.letterDeliveryType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && WageParameterPane.this.getWageParameter() != null) {
                    WageParameterPane.this.getWageParameter().setLetterDeliveryType((LetterDeliveryType)((Object)WageParameterPane.this.letterDeliveryType.getSelectedValue()));
                }
            }
        });
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.type", new Serializable[0])));
        this.areaTourType = new AreaTourTypePane(new AreaObjectType[0], new AreaCalculationType[]{AreaCalculationType.DEFAULT, AreaCalculationType.SIDE, AreaCalculationType.PARCEL_SORT_ORDER});
        this.areaTourType.setEnabled(this.editable);
        this.areaTourType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WageParameterModel wageParameter = WageParameterPane.this.getWageParameter();
                if (wageParameter != null) {
                    AreaTourType selectedValue = WageParameterPane.this.areaTourType.getAreaTourType();
                    if (selectedValue == null) {
                        return;
                    }
                    wageParameter.setAreaTourType(selectedValue);
                    WageParameterPane.this.subscriptionDeliveryType.setEnabled(true);
                    WageParameterPane.this.letterDeliveryType.setEnabled(true);
                    WageParameterPane.this.repaint(10L);
                }
            }
        });
        pane.add(this.areaTourType);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessageForEnum(SubscriptionDeliveryType.class)));
        pane.add(this.subscriptionDeliveryType);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessageForEnum(LetterDeliveryType.class)));
        pane.add(this.letterDeliveryType);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.vehicle.area", new Serializable[0])));
        this.vehicelTypeInArea = new EnumComboBox(RouteVehicleType.class, true, (Enum[])RouteVehicleType.values());
        this.vehicelTypeInArea.setEnabled(this.editable);
        this.vehicelTypeInArea.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && WageParameterPane.this.getWageParameter() != null) {
                    WageParameterPane.this.getWageParameter().setVehicelTypeInArea((RouteVehicleType)((Object)WageParameterPane.this.vehicelTypeInArea.getSelectedValue()));
                }
            }
        });
        pane.add(this.vehicelTypeInArea);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.vehicle.poi", new Serializable[0])));
        this.vehicelTypeFromPoi = new EnumComboBox(RouteVehicleType.class, true, (Enum[])RouteVehicleType.values());
        this.vehicelTypeFromPoi.setEnabled(this.editable);
        this.vehicelTypeFromPoi.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && WageParameterPane.this.getWageParameter() != null) {
                    WageParameterPane.this.getWageParameter().setVehicelTypeFromPoi((RouteVehicleType)((Object)WageParameterPane.this.vehicelTypeFromPoi.getSelectedValue()));
                }
            }
        });
        pane.add(this.vehicelTypeFromPoi);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.vehicle.pickPoint", new Serializable[0])));
        this.vehicelTypeFromPickPoint = new EnumComboBox(RouteVehicleType.class, true, (Enum[])RouteVehicleType.values());
        this.vehicelTypeFromPickPoint.setEnabled(this.editable);
        this.vehicelTypeFromPickPoint.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && WageParameterPane.this.getWageParameter() != null) {
                    WageParameterPane.this.getWageParameter().setVehicelTypeFromPickPoint((RouteVehicleType)((Object)WageParameterPane.this.vehicelTypeFromPickPoint.getSelectedValue()));
                }
            }
        });
        pane.add(this.vehicelTypeFromPickPoint);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi", new Serializable[0])));
        this.routingType = new EnumComboBox(CalculateType.class, true, (Enum[])new CalculateType[]{CalculateType.NONFIX, CalculateType.STARTWITHPOI});
        this.routingType.setEnabled(this.editable);
        this.routingType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && WageParameterPane.this.getWageParameter() != null) {
                    WageParameterPane.this.getWageParameter().setRoutingType((CalculateType)WageParameterPane.this.routingType.getSelectedValue());
                }
            }
        });
        pane.add(this.routingType);
        JPanel backPane = new JPanel(new FlowLayout(0));
        this.backTrue = new JRadioButton();
        this.backTrue.setEnabled(this.editable);
        this.backTrue.setAction(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.yes", new Serializable[0])){
            private static final long serialVersionUID = 7519201131102437796L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WageParameterPane.this.editable && WageParameterPane.this.backTrue.isSelected() && WageParameterPane.this.getWageParameter() != null) {
                    WageParameterPane.this.getWageParameter().setBack(true);
                }
            }
        });
        backPane.add(this.backTrue);
        this.backFalse = new JRadioButton();
        this.backFalse.setEnabled(this.editable);
        this.backFalse.setAction(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.no", new Serializable[0])){
            private static final long serialVersionUID = -4890034641944119397L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WageParameterPane.this.editable && WageParameterPane.this.backFalse.isSelected() && WageParameterPane.this.getWageParameter() != null) {
                    WageParameterPane.this.getWageParameter().setBack(false);
                }
            }
        });
        backPane.add(this.backFalse);
        ButtonGroup backGroup = new ButtonGroup();
        backGroup.add(this.backTrue);
        backGroup.add(this.backFalse);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("buttons.backward", new Serializable[0])));
        pane.add(backPane);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.parcellocation", new Serializable[0])));
        ArrayList<String> parcelLocationItems = CollectionUtil.buildArrayList("");
        AreaAttributeValueDescriptorModel bikeParcelLocation = (AreaAttributeValueDescriptorModel)this.modelEnviroment.getModelFromMap("AREA-PARCELLOCATION-BIKE");
        if (bikeParcelLocation != null) {
            parcelLocationItems.add(bikeParcelLocation.getKey());
        }
        if ((footParcelLocation = (AreaAttributeValueDescriptorModel)this.modelEnviroment.getModelFromMap("AREA-PARCELLOCATION-FOOT")) != null) {
            parcelLocationItems.add(footParcelLocation.getKey());
        }
        if ((motorParcelLocation = (AreaAttributeValueDescriptorModel)this.modelEnviroment.getModelFromMap("AREA-PARCELLOCATION-MOTOR")) != null) {
            parcelLocationItems.add(motorParcelLocation.getKey());
        }
        this.parcelLocationYes = new JRadioButton();
        this.parcelLocationYes.setEnabled(this.editable);
        this.parcelLocationYes.setAction(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.yes", new Serializable[0])){
            private static final long serialVersionUID = 8463223927962560576L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WageParameterPane.this.editable && WageParameterPane.this.parcelLocationYes.isSelected() && WageParameterPane.this.getWageParameter() != null) {
                    WageParameterPane.this.getWageParameter().setParcelLocation(true);
                }
            }
        });
        this.parcelLocationNo = new JRadioButton();
        this.parcelLocationNo.setEnabled(this.editable);
        this.parcelLocationNo.setAction(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.no", new Serializable[0])){
            private static final long serialVersionUID = -8527740485831757353L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WageParameterPane.this.editable && WageParameterPane.this.parcelLocationNo.isSelected() && WageParameterPane.this.getWageParameter() != null) {
                    WageParameterPane.this.getWageParameter().setParcelLocation(false);
                }
            }
        });
        ButtonGroup parcelLocationGroup = new ButtonGroup();
        parcelLocationGroup.add(this.parcelLocationYes);
        parcelLocationGroup.add(this.parcelLocationNo);
        JPanel parcelLocPanel = new JPanel(new FlowLayout(0));
        parcelLocPanel.add(this.parcelLocationYes);
        parcelLocPanel.add(this.parcelLocationNo);
        pane.add(parcelLocPanel);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.difficultyLevel", new Serializable[0])));
        ArrayList<String> difficultyLevelItems = CollectionUtil.buildArrayList("");
        AreaAttributeValueDescriptorModel bikeLevel = (AreaAttributeValueDescriptorModel)this.modelEnviroment.getModelFromMap("AREA-DIFFICULTYLEVEL-BIKE");
        if (bikeLevel != null) {
            difficultyLevelItems.add(bikeLevel.getKey());
        }
        if ((footLevel = (AreaAttributeValueDescriptorModel)this.modelEnviroment.getModelFromMap("AREA-DIFFICULTYLEVEL-FOOT")) != null) {
            difficultyLevelItems.add(footLevel.getKey());
        }
        if ((motorLevel = (AreaAttributeValueDescriptorModel)this.modelEnviroment.getModelFromMap("AREA-DIFFICULTYLEVEL-MOTOR")) != null) {
            difficultyLevelItems.add(motorLevel.getKey());
        }
        this.difficultyLevelYes = new JRadioButton();
        this.difficultyLevelYes.setEnabled(this.editable);
        this.difficultyLevelYes.setAction(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.yes", new Serializable[0])){
            private static final long serialVersionUID = -6465996340899122937L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WageParameterPane.this.editable && WageParameterPane.this.difficultyLevelYes.isSelected() && WageParameterPane.this.getWageParameter() != null) {
                    WageParameterPane.this.getWageParameter().setDifficultyLevel(true);
                }
            }
        });
        this.difficultyLevelNo = new JRadioButton();
        this.difficultyLevelNo.setEnabled(this.editable);
        this.difficultyLevelNo.setAction(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.no", new Serializable[0])){
            private static final long serialVersionUID = -7634944057585678696L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WageParameterPane.this.editable && WageParameterPane.this.difficultyLevelNo.isSelected() && WageParameterPane.this.getWageParameter() != null) {
                    WageParameterPane.this.getWageParameter().setDifficultyLevel(false);
                }
            }
        });
        ButtonGroup difficultyLevelGroup = new ButtonGroup();
        difficultyLevelGroup.add(this.difficultyLevelYes);
        difficultyLevelGroup.add(this.difficultyLevelNo);
        JPanel diffLevelPanel = new JPanel(new FlowLayout(0));
        diffLevelPanel.add(this.difficultyLevelYes);
        diffLevelPanel.add(this.difficultyLevelNo);
        pane.add(diffLevelPanel);
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.maxFootDistanceFromPoi", new Serializable[0])));
        pane.add(this.createTextField(10, "MaxFootDistanceFromPoi"));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.maxBikeDistanceFromPoi", new Serializable[0])));
        pane.add(this.createTextField(10, "MaxBikeDistanceFromPoi"));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.maxFootDistanceInArea", new Serializable[0])));
        pane.add(this.createTextField(10, "MaxFootDistanceInArea"));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.maxBikeDistanceInArea", new Serializable[0])));
        pane.add(this.createTextField(10, "MaxBikeDistanceInArea"));
        pane.add(new JLabel("---------------------"));
        pane.add(new JLabel(""));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.pausetime.trackPointCount", new Serializable[0])));
        pane.add(this.createTextField(10, "TrackPointCount"));
        pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.pausetime.distanceBetweenPoints", new Serializable[0])));
        pane.add(this.createTextField(10, "TrackPauseDistanceInMeter"));
        SpringUtilities.makeCompactGrid(pane, 20, 2, 5, 5, 5, 5);
        return ClientSwingUtil.createScrollPane(pane);
    }

    private Vector<Object> createParcelBlockTableHeader() {
        Vector<Object> columnNames = new Vector<Object>();
        columnNames.addElement(" \n#\n \n");
        columnNames.addElement(" \n" + WeekdayName.D1.getShortName());
        columnNames.addElement(" \n" + WeekdayName.D2.getShortName());
        columnNames.addElement(" \n" + WeekdayName.D3.getShortName());
        columnNames.addElement(" \n" + WeekdayName.D4.getShortName());
        columnNames.addElement(" \n" + WeekdayName.D5.getShortName());
        columnNames.addElement(" \n" + WeekdayName.D6.getShortName());
        columnNames.addElement(" \n" + WeekdayName.D7.getShortName());
        return columnNames;
    }

    private ThrowLeafletScalingModel getThrowLeafletScaling(ThrowLeafletType type) {
        if (this.getWageParameter() == null) {
            return null;
        }
        ThrowLeafletScalingModel scaling = WageDeltaModelUtil.getThrowLeafletScalingModel(this.getWageParameter(), 1, type);
        if (scaling == null) {
            scaling = new ThrowLeafletScalingModelImpl();
            scaling.setPieceTime(0.0);
            scaling.setType(type);
            this.getWageParameter().addThrowLeafletScaling(scaling);
        }
        return scaling;
    }

    private void fillData() {
        WageParameterModel wageParameter = this.wageParameterObject.getElement();
        if (wageParameter == null) {
            this.parameterName.setEnabled(false);
        } else {
            AreaObjectType areaObjectType;
            this.parameterName.setEnabled(this.editable);
            this.status.setSelectedValue(wageParameter.getStatus() == null ? WageParameterStatus.ACTIVE : wageParameter.getStatus());
            this.sortVolumeScalings.setModel(wageParameter);
            this.firstThrowDirectDelivery.setElement(this.getThrowLeafletScaling(ThrowLeafletType.DIRECT_FIRST));
            this.throwDirectDelivery.setElement(this.getThrowLeafletScaling(ThrowLeafletType.DIRECT));
            this.throwLeafletScalingPane.setModel(wageParameter);
            this.subscriptionDeliveryType.setSelectedValue(wageParameter.getSubscriptionDeliveryType());
            this.letterDeliveryType.setSelectedValue(wageParameter.getLetterDeliveryType());
            AreaTourType areaTourType = wageParameter.getAreaTourType();
            this.areaTourType.setAreaTourType(areaTourType);
            if (areaTourType != null && (areaObjectType = areaTourType.getAreaObjectType()) != null) {
                boolean subscriptionDeliveryTypeEnabled = true;
                boolean letterDeliveryTypeEnabled = true;
                switch (areaObjectType) {
                    case LETTER: 
                    case PARCEL_WITH_LETTER: {
                        subscriptionDeliveryTypeEnabled = false;
                        break;
                    }
                    case PARCEL: {
                        subscriptionDeliveryTypeEnabled = false;
                        letterDeliveryTypeEnabled = false;
                        break;
                    }
                    case PARCEL_WITHOUT_SUBSCRIPTION: 
                    case SUBSCRIPTION: {
                        letterDeliveryTypeEnabled = false;
                        break;
                    }
                    case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: 
                    case SUBSCRIPTION_WITH_LETTER: {
                        break;
                    }
                    case PARCEL_SUBSCRIPTION: {
                        letterDeliveryTypeEnabled = false;
                        break;
                    }
                }
                this.subscriptionDeliveryType.setEnabled(subscriptionDeliveryTypeEnabled);
                this.letterDeliveryType.setEnabled(letterDeliveryTypeEnabled);
            }
            this.vehicelTypeInArea.setSelectedValue(wageParameter.getVehicelTypeInArea());
            this.vehicelTypeFromPoi.setSelectedValue(wageParameter.getVehicelTypeFromPoi());
            this.vehicelTypeFromPickPoint.setSelectedValue(wageParameter.getVehicelTypeFromPickPoint());
            this.routingType.setSelectedValue(wageParameter.getRoutingType());
            if (wageParameter.getBack() != null && wageParameter.getBack().booleanValue()) {
                this.backTrue.setSelected(true);
            } else {
                this.backFalse.setSelected(true);
            }
            if (wageParameter.getParcelLocation() != null && wageParameter.getParcelLocation().booleanValue()) {
                this.parcelLocationYes.setSelected(true);
            } else {
                this.parcelLocationNo.setSelected(true);
            }
            if (wageParameter.getDifficultyLevel() != null && wageParameter.getDifficultyLevel().booleanValue()) {
                this.difficultyLevelYes.setSelected(true);
            } else {
                this.difficultyLevelNo.setSelected(true);
            }
            this.wageParameterInclusionExclusionPane.setWageParameter(wageParameter);
        }
        for (Component c : this.getComponents()) {
            c.repaint(10L);
        }
        this.repaint(10L);
    }

    private JTextField createTextField(int size, String fieldName) {
        return ClientSwingUtil.createParameterTextField(size, null, this.editable, fieldName, this.wageParameterObject, this);
    }

    public WageParameterModel getWageParameter() {
        WageParameterModel wageParameter = this.wageParameterObject.getElement();
        return wageParameter;
    }

    public void setWageParameter(WageParameterModel wageParameter) {
        this.wageParameterObject.setElement(wageParameter);
        this.fillData();
    }
}

