/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.wage;

import de.datomino.peppergis.client.model.wage.SortVolumeScalingModel;
import de.datomino.peppergis.client.model.wage.SortVolumeScalingModelImpl;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.util.AbstractDocumentListener;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class SortVolumeScalingPane
extends JPanel {
    private static final long serialVersionUID = 495462878254023654L;
    private WageParameterModel wageParameter;
    private List<Tupel<SortVolumeScalingModel, SubPane>> tupelList;
    private Box scallingBox;
    private Component parent;
    private boolean editable;

    public SortVolumeScalingPane(Component parent, boolean editable) {
        super(new BorderLayout());
        super.setPreferredSize(new Dimension(300, 200));
        this.parent = parent;
        this.editable = editable;
        this.tupelList = new ArrayList<Tupel<SortVolumeScalingModel, SubPane>>(){
            private static final long serialVersionUID = 6293707780561449148L;

            @Override
            public boolean add(Tupel<SortVolumeScalingModel, SubPane> e) {
                boolean b = super.add(e);
                if (b) {
                    Collections.sort(this, new Comparator<Tupel<SortVolumeScalingModel, SubPane>>(){

                        @Override
                        public int compare(Tupel<SortVolumeScalingModel, SubPane> o1, Tupel<SortVolumeScalingModel, SubPane> o2) {
                            Integer minVolume1 = o1.getElement1().getMinVolume() == null ? 0 : o1.getElement1().getMinVolume();
                            Integer minVolume2 = o2.getElement1().getMinVolume() == null ? 0 : o2.getElement1().getMinVolume();
                            return minVolume1.compareTo(minVolume2);
                        }
                    });
                }
                return b;
            }
        };
        this.initialize();
    }

    private void initialize() {
        this.scallingBox = Box.createVerticalBox();
        this.fillData();
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this.scallingBox, "North");
        JScrollPane scrollPane = new JScrollPane(pane);
        super.add((Component)scrollPane, "Center");
        JPanel buttonPane = new JPanel(new GridLayout(1, 2));
        JButton addButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = -1120541285990896045L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SortVolumeScalingPane.this.wageParameter != null) {
                    SortVolumeScalingModelImpl newModel = new SortVolumeScalingModelImpl();
                    newModel.setMinVolume(1000);
                    newModel.setMaxVolume(1000);
                    newModel.setPieceTime(0.0);
                    SortVolumeScalingPane.this.wageParameter.addSortVolumeScaling(newModel);
                    SortVolumeScalingPane.this.tupelList.add(new Tupel<SortVolumeScalingModelImpl, SubPane>(newModel, new SubPane(newModel)));
                    SortVolumeScalingPane.this.fillData();
                }
            }
        });
        addButton.setText("+");
        addButton.setBorder(BorderFactory.createEmptyBorder());
        addButton.setEnabled(this.editable);
        buttonPane.add(addButton);
        JButton removeButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 5618093758838171047L;

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = SortVolumeScalingPane.this.tupelList;
                if (!list.isEmpty()) {
                    Tupel last = (Tupel)list.remove(list.size() - 1);
                    SortVolumeScalingPane.this.wageParameter.removeSortVolumeScaling((SortVolumeScalingModel)last.getElement1());
                    ((SortVolumeScalingModel)last.getElement1()).delete();
                    SortVolumeScalingPane.this.fillData();
                }
            }
        });
        removeButton.setText("-");
        removeButton.setBorder(BorderFactory.createEmptyBorder());
        removeButton.setEnabled(this.editable);
        buttonPane.add(removeButton);
        super.add((Component)buttonPane, "South");
    }

    public void setModel(WageParameterModel wageParameter) {
        this.wageParameter = wageParameter;
        this.tupelList.clear();
        for (SortVolumeScalingModel scaling : wageParameter.iterableSortVolumeScalings()) {
            this.tupelList.add(new Tupel<SortVolumeScalingModel, SubPane>(scaling, new SubPane(scaling)));
        }
        this.fillData();
    }

    private void fillData() {
        Window window;
        this.scallingBox.removeAll();
        for (Tupel<SortVolumeScalingModel, SubPane> tupel : this.tupelList) {
            this.scallingBox.add(tupel.getElement2());
        }
        if (this.tupelList.size() < 5) {
            for (int i = 0; i < 5 - this.tupelList.size(); ++i) {
                this.scallingBox.add(new JLabel(" "));
            }
        }
        if ((window = SwingUtils.findWindowParent(this.parent)) != null) {
            window.pack();
        }
    }

    private class SubPane
    extends JPanel {
        private static final long serialVersionUID = 8410277774060088374L;

        public SubPane(SortVolumeScalingModel scaling) {
            this.initializeSubPane(scaling);
        }

        private void initializeSubPane(final SortVolumeScalingModel scaling) {
            final JTextField min = new JTextField(5);
            min.setText(scaling.getMinVolume() == null ? "" : scaling.getMinVolume().toString());
            super.add(min);
            super.add(new JLabel(" - "));
            final JTextField max = new JTextField(5);
            max.setText(scaling.getMaxVolume() == null ? "" : scaling.getMaxVolume().toString());
            super.add(max);
            super.add(new JLabel(" ==> "));
            final JTextField time = new JTextField(5);
            time.setText(scaling.getPieceTime() == null ? "" : ClientFormUtil.getNumberString(scaling.getPieceTime()));
            super.add(time);
            if (SortVolumeScalingPane.this.editable) {
                min.getDocument().addDocumentListener(new AbstractDocumentListener(){

                    @Override
                    protected void handleChange() {
                        try {
                            scaling.setMinVolume(StringUtil.isBlank(min.getText()) ? null : Integer.valueOf(Integer.parseInt(min.getText())));
                        }
                        catch (Exception e) {
                            this.errorMessage = "Bitte eine Zahl geben.";
                        }
                    }

                    @Override
                    protected void rollback() {
                        JOptionPane.showConfirmDialog(SortVolumeScalingPane.this, this.errorMessage, "", 0, 2);
                        Integer minVolume = scaling.getMinVolume();
                        min.setText(minVolume == null ? "" : minVolume.toString());
                    }
                });
                max.getDocument().addDocumentListener(new AbstractDocumentListener(){

                    @Override
                    protected void handleChange() {
                        try {
                            scaling.setMaxVolume(StringUtil.isBlank(max.getText()) ? null : Integer.valueOf(Integer.parseInt(max.getText())));
                        }
                        catch (Exception e) {
                            this.errorMessage = "Bitte eine Zahl geben.";
                        }
                    }

                    @Override
                    protected void rollback() {
                        JOptionPane.showConfirmDialog(SortVolumeScalingPane.this, this.errorMessage, "", 0, 2);
                        Integer maxVolume = scaling.getMaxVolume();
                        max.setText(maxVolume == null ? "" : maxVolume.toString());
                    }
                });
                time.getDocument().addDocumentListener(new AbstractDocumentListener(){

                    @Override
                    protected void handleChange() {
                        try {
                            String text = time.getText().replaceAll(",", ".");
                            scaling.setPieceTime(StringUtil.isBlank(time.getText()) ? null : Double.valueOf(Double.parseDouble(text)));
                        }
                        catch (Exception e) {
                            this.errorMessage = "Bitte eine Zahl geben.";
                        }
                    }

                    @Override
                    protected void rollback() {
                        JOptionPane.showConfirmDialog(SortVolumeScalingPane.this, this.errorMessage, "", 0, 2);
                        Double pieceTime = scaling.getPieceTime();
                        time.setText(pieceTime == null ? "" : pieceTime.toString());
                    }
                });
            } else {
                min.setEditable(false);
                max.setEditable(false);
                time.setEditable(false);
            }
        }
    }
}

