/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.wage;

import de.datomino.peppergis.client.model.wage.HistoryAreaStopModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.model.wage.SortVolumeScalingModel;
import de.datomino.peppergis.client.model.wage.SortVolumeScalingModelImpl;
import de.datomino.peppergis.client.model.wage.ThrowLeafletScalingModel;
import de.datomino.peppergis.client.model.wage.ThrowLeafletScalingModelImpl;
import de.datomino.peppergis.client.model.wage.TrackWatchDataModel;
import de.datomino.peppergis.client.model.wage.WageDifferenceModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.model.wage.WageParcelInclusionExclusionModel;
import de.datomino.peppergis.client.model.wage.WageParcelInclusionExclusionModelImpl;
import de.datomino.peppergis.client.model.wage.WageParcelInclusionExclusionSetModel;
import de.datomino.peppergis.client.model.wage.WageParcelInclusionExclusionSetModelImpl;
import de.datomino.peppergis.type.ThrowLeafletType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.ktde.util.StringUtil;

public class WageDeltaModelUtil {
    public static void wageParameterClone(WageParameterModel parameter, WageParameterModel clone) {
        if (parameter != null && clone != null) {
            Object newScaling;
            clone.setName(parameter.getName());
            clone.setStatus(parameter.getStatus());
            clone.setAreaTourType(parameter.getAreaTourType());
            clone.setSubscriptionDeliveryType(parameter.getSubscriptionDeliveryType());
            clone.setParcelLocation(parameter.getParcelLocation());
            clone.setDifficultyLevel(parameter.getDifficultyLevel());
            clone.setBack(parameter.getBack());
            clone.setVehicelTypeFromPoi(parameter.getVehicelTypeFromPoi());
            clone.setVehicelTypeFromPickPoint(parameter.getVehicelTypeFromPickPoint());
            clone.setVehicelTypeInArea(parameter.getVehicelTypeInArea());
            clone.setFirstThrowLetterPieceTime(parameter.getFirstThrowLetterPieceTime());
            clone.setFirstThrowSubscriptionPieceTime(parameter.getFirstThrowSubscriptionPieceTime());
            clone.setFirstThrowWeeklyPaperPieceTime(parameter.getFirstThrowWeeklyPaperPieceTime());
            clone.setManualLeafletPieceTime(parameter.getManualLeafletPieceTime());
            clone.setParcelLocation(parameter.getParcelLocation());
            clone.setReceptionLeafletFlatTime(parameter.getReceptionLeafletFlatTime());
            clone.setReceptionLeafletPieceTime(parameter.getReceptionLeafletPieceTime());
            clone.setReceptionLetterFlatTime(parameter.getReceptionLetterFlatTime());
            clone.setReceptionSubscriptionFlatTime(parameter.getReceptionSubscriptionFlatTime());
            clone.setReceptionSubscriptionPieceTime(parameter.getReceptionSubscriptionPieceTime());
            clone.setReceptionWeeklyPaperFlatTime(parameter.getReceptionWeeklyPaperFlatTime());
            clone.setReceptionWeeklyPaperPieceTime(parameter.getReceptionWeeklyPaperPieceTime());
            clone.setRoutingType(parameter.getRoutingType());
            clone.setThrowLetterPieceTime(parameter.getThrowLetterPieceTime());
            clone.setThrowSubscriptionPieceTime(parameter.getThrowSubscriptionPieceTime());
            clone.setThrowWeeklyPaperPieceTime(parameter.getThrowWeeklyPaperPieceTime());
            clone.clearSortVolumeScalings();
            for (SortVolumeScalingModel sortVolumeScalingModel : parameter.iterableSortVolumeScalings()) {
                newScaling = new SortVolumeScalingModelImpl();
                newScaling.setMaxVolume(sortVolumeScalingModel.getMaxVolume());
                newScaling.setMinVolume(sortVolumeScalingModel.getMinVolume());
                newScaling.setPieceTime(sortVolumeScalingModel.getPieceTime());
                clone.addSortVolumeScaling((SortVolumeScalingModel)newScaling);
            }
            clone.clearThrowLeafletScalings();
            for (ThrowLeafletScalingModel throwLeafletScalingModel : parameter.iterableThrowLeafletScalings()) {
                newScaling = new ThrowLeafletScalingModelImpl();
                newScaling.setMaxVolume(throwLeafletScalingModel.getMaxVolume());
                newScaling.setMinVolume(throwLeafletScalingModel.getMinVolume());
                newScaling.setPieceTime(throwLeafletScalingModel.getPieceTime());
                newScaling.setType(throwLeafletScalingModel.getType());
                clone.addThrowLeafletScaling((ThrowLeafletScalingModel)newScaling);
            }
            for (WageParcelInclusionExclusionSetModel wageParcelInclusionExclusionSetModel : clone.iterableWageParcelInclusionExclusionSet()) {
                for (WageParcelInclusionExclusionModel wageParcelInclusionExclusion : wageParcelInclusionExclusionSetModel.iterableWageParcelInclusionExclusions()) {
                    wageParcelInclusionExclusion.delete();
                }
                wageParcelInclusionExclusionSetModel.clearWageParcelInclusionExclusions();
                wageParcelInclusionExclusionSetModel.delete();
            }
            clone.clearWageParcelInclusionExclusionSet();
            for (WageParcelInclusionExclusionSetModel wageParcelInclusionExclusionSetModel : parameter.iterableWageParcelInclusionExclusionSet()) {
                WageParcelInclusionExclusionSetModelImpl newWageParcelInclusionExclusionSet = new WageParcelInclusionExclusionSetModelImpl();
                newWageParcelInclusionExclusionSet.setPreferExclusion(wageParcelInclusionExclusionSetModel.getPreferExclusion());
                newWageParcelInclusionExclusionSet.setWageParameter(clone);
                newWageParcelInclusionExclusionSet.setWeekDay(wageParcelInclusionExclusionSetModel.getWeekDay());
                for (WageParcelInclusionExclusionModel wageParcelInclusionExclusion : wageParcelInclusionExclusionSetModel.iterableWageParcelInclusionExclusions()) {
                    WageParcelInclusionExclusionModelImpl newWageParcelInclusionExclusion = new WageParcelInclusionExclusionModelImpl();
                    newWageParcelInclusionExclusion.setDescriptorKey(wageParcelInclusionExclusion.getDescriptorKey());
                    newWageParcelInclusionExclusion.setValue(wageParcelInclusionExclusion.getValue());
                    newWageParcelInclusionExclusion.setType(wageParcelInclusionExclusion.getType());
                    newWageParcelInclusionExclusion.setWageParcelInclusionExclusionSet(newWageParcelInclusionExclusionSet);
                }
            }
        }
    }

    public static ThrowLeafletScalingModel getThrowLeafletScalingModel(WageParameterModel parameter, int packageSize, ThrowLeafletType type) {
        if (parameter == null) {
            return null;
        }
        for (ThrowLeafletScalingModel scaling : parameter.iterableThrowLeafletScalings()) {
            int max;
            if (scaling.getType() == null || scaling.getType() != type) continue;
            int min = scaling.getMinVolume() == null ? Integer.MIN_VALUE : scaling.getMinVolume();
            int n = max = scaling.getMaxVolume() == null ? Integer.MAX_VALUE : scaling.getMaxVolume();
            if (packageSize < min || packageSize >= max) continue;
            return scaling;
        }
        return null;
    }

    public static List<TrackWatchDataModel> getTrackWatchDataForTour(HistoryAreaTourModel historyAreaTour) {
        ArrayList<TrackWatchDataModel> result = new ArrayList<TrackWatchDataModel>();
        if (historyAreaTour == null) {
            return result;
        }
        for (TrackWatchDataModel trackData : historyAreaTour.iterableTrackWatchData()) {
            result.add(trackData);
        }
        return result;
    }

    public static List<HistoryAreaStopModel> getEstimatedStopsDataForTour(HistoryAreaTourModel historyAreaTour) {
        ArrayList<HistoryAreaStopModel> result = new ArrayList<HistoryAreaStopModel>();
        if (historyAreaTour == null) {
            return result;
        }
        for (HistoryAreaStopModel data : historyAreaTour.iterableHistoryAreaTourStop()) {
            result.add(data);
        }
        return result;
    }

    public static Double getThrowLeafletPieceTime(WageParameterModel parameter, int packageSize, ThrowLeafletType type) {
        ThrowLeafletScalingModel scaling = WageDeltaModelUtil.getThrowLeafletScalingModel(parameter, packageSize, type);
        return scaling == null ? null : scaling.getPieceTime();
    }

    public static Integer getDifferenceTime(HistoryAreaTourModel historyAreaTourModel) {
        WageDifferenceModel wageDifference = historyAreaTourModel.getWageDifference();
        Integer duration = historyAreaTourModel.getDuration();
        if (duration != null && wageDifference != null) {
            Integer actualBreak1;
            Date actualEndTime1;
            Date actualStartTime1;
            Integer difference = null;
            Integer timeDeviation1 = wageDifference.getTimeDeviation1();
            Integer sDifference = WageDeltaModelUtil.getDifferenceFromBlock(timeDeviation1, actualStartTime1 = wageDifference.getActualStartTime1(), actualEndTime1 = wageDifference.getActualEndTime1(), actualBreak1 = wageDifference.getActualBreak1());
            if (sDifference != null) {
                Integer actualBreak2;
                Date actualEndTime2;
                Date actualStartTime2;
                difference = duration - sDifference;
                Integer timeDeviation2 = wageDifference.getTimeDeviation2();
                sDifference = WageDeltaModelUtil.getDifferenceFromBlock(timeDeviation2, actualStartTime2 = wageDifference.getActualStartTime2(), actualEndTime2 = wageDifference.getActualEndTime2(), actualBreak2 = wageDifference.getActualBreak2());
                if (sDifference != null) {
                    Integer actualBreak3;
                    Date actualEndTime3;
                    Date actualStartTime3;
                    difference = duration - sDifference;
                    Integer timeDeviation3 = wageDifference.getTimeDeviation3();
                    sDifference = WageDeltaModelUtil.getDifferenceFromBlock(timeDeviation3, actualStartTime3 = wageDifference.getActualStartTime3(), actualEndTime3 = wageDifference.getActualEndTime3(), actualBreak3 = wageDifference.getActualBreak3());
                    if (sDifference != null) {
                        difference = duration - sDifference;
                    }
                }
            }
            return difference;
        }
        return null;
    }

    private static Integer getDifferenceFromBlock(Integer timeDeviation1, Date actualStartTime1, Date actualEndTime1, Integer actualBreak1) {
        Integer difference = null;
        if (actualStartTime1 != null && actualEndTime1 != null) {
            long time = actualEndTime1.getTime() - actualStartTime1.getTime();
            difference = (int)Math.round((double)time / 1000.0);
            if (actualBreak1 != null) {
                difference = difference - actualBreak1;
            }
        }
        return difference;
    }

    public static Long getTimeForDifference(String startTime, String endTime, String pauseString, String dateFormat) throws ParseException {
        if (!StringUtil.isBlank(startTime) && !StringUtil.isBlank(endTime)) {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            Date startDate = sdf.parse(startTime);
            Date endDate = sdf.parse(endTime);
            long diff = (endDate.getTime() - startDate.getTime()) / 1000L;
            if (!StringUtil.isBlank(pauseString)) {
                long pause = Long.parseLong(pauseString);
                diff -= pause;
            }
            long time = diff * 1000L;
            return time;
        }
        return null;
    }

    public static Integer getTimeForDifference(Date startDate, Date endDate, Integer pause) {
        if (startDate != null && endDate != null) {
            long diff = (endDate.getTime() - startDate.getTime()) / 1000L;
            if (pause != null) {
                diff -= (long)pause.intValue();
            }
            return (int)diff;
        }
        return null;
    }
}

