/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.wage;

import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.model.wage.TrackWatchDataModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public final class TrackWatchUtil {
    private TrackWatchUtil() {
    }

    public static Tupel<Multimap<Integer, TrackWatchDataModel>, Tripel<Date, Date, Long>> getTrackwatchSummary(HistoryAreaTourModel historyAreaTourModel) {
        int size;
        ArrayList listLast;
        Comparator<TrackWatchDataModel> comparator = new Comparator<TrackWatchDataModel>(){

            @Override
            public int compare(TrackWatchDataModel o1, TrackWatchDataModel o2) {
                return o1.getTrackTime().compareTo(o2.getTrackTime());
            }
        };
        TreeMultimap tracksForPeriodMap = TreeMultimap.create(Ordering.natural(), comparator);
        for (TrackWatchDataModel trackData : historyAreaTourModel.iterableTrackWatchData()) {
            Date trackTime = trackData.getTrackTime();
            if (trackTime == null) continue;
            tracksForPeriodMap.put(trackData.getEventPeriod(), trackData);
        }
        Date startTime = new Date(0L);
        Date stopTime = new Date(0L);
        ArrayList list0 = new ArrayList(tracksForPeriodMap.get(0));
        if (!list0.isEmpty()) {
            Date date = startTime = list0.get(0) != null ? ((TrackWatchDataModel)list0.get(0)).getTrackTime() : startTime;
        }
        if (!(listLast = new ArrayList(tracksForPeriodMap.get((size = tracksForPeriodMap.keySet().size()) - 1))).isEmpty()) {
            stopTime = listLast.get(listLast.size() - 1) != null ? ((TrackWatchDataModel)listLast.get(listLast.size() - 1)).getTrackTime() : stopTime;
        }
        long trackedPauseTime = 0L;
        Iterator iterator = tracksForPeriodMap.keySet().iterator();
        while (iterator.hasNext()) {
            int period = (Integer)iterator.next();
            if (period == 0) continue;
            ArrayList temp1 = new ArrayList(tracksForPeriodMap.get(period - 1));
            ArrayList temp2 = new ArrayList(tracksForPeriodMap.get(period));
            long nextPeriodStartTime = 0L;
            long previousPeriodEndTime = 0L;
            try {
                nextPeriodStartTime = ((TrackWatchDataModel)temp2.get(0)).getTrackTime().getTime();
                previousPeriodEndTime = ((TrackWatchDataModel)temp1.get(temp1.size() - 1)).getTrackTime().getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
            trackedPauseTime += nextPeriodStartTime - previousPeriodEndTime;
        }
        Tripel<Date, Date, Long> tripel = new Tripel<Date, Date, Long>(startTime != null ? startTime : new Date(0L), stopTime != null ? stopTime : new Date(0L), trackedPauseTime);
        return new Tupel<Multimap<Integer, TrackWatchDataModel>, Tripel<Date, Date, Long>>(tracksForPeriodMap, tripel);
    }
}

