/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.wage;

import com.google.common.collect.Lists;
import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.logistic.dto.LogisticTourPartDto;
import de.datomino.logistic.type.CalculateType;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.model.wage.HistoryAreaStopModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.model.wage.SortVolumeScalingModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.util.wage.WageDeltaModelUtil;
import de.datomino.peppergis.helper.PointEntity;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.type.Product;
import de.datomino.peppergis.type.ThrowLeafletType;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.peppergis.wage.ProductWeightParameter;
import de.datomino.util.NumericUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.geo.util.GeoUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.Coordinate;

public class HistoryAreaTourModelWageResult {
    private HistoryAreaTourModel historyAreaTourModel;
    private double receptionSubscriptionTime;
    private double receptionWeeklyPaperTime;
    private double receptionLeafletTime;
    private double receptionManualLeafletTime;
    private double receptionLetterTime;
    private double sortLetterTime;
    private double throwSubscriptionTime;
    private double throwWeeklyPaperTime;
    private double throwLeafletTime;
    private double throwLetterTime;
    private int reload = -1;
    private double averageDistanceToPoi = -1.0;
    private ProductWeightParameter productWeightParameter;
    private TourCaller tourCaller;

    public HistoryAreaTourModelWageResult(HistoryAreaTourModel history, ProductWeightParameter productWeightParameter, TourCaller tourCaller) {
        this.historyAreaTourModel = history;
        this.productWeightParameter = productWeightParameter;
        this.tourCaller = tourCaller;
        this.refresh();
    }

    public HistoryAreaTourModel getModel() {
        return this.historyAreaTourModel;
    }

    public double getReceptionSubscriptionTime() {
        return this.receptionSubscriptionTime;
    }

    public double getReceptionWeeklyPaperTime() {
        return this.receptionWeeklyPaperTime;
    }

    public double getReceptionLeafletTime() {
        return this.receptionLeafletTime;
    }

    public double getReceptionManualLeafletTime() {
        return this.receptionManualLeafletTime;
    }

    public double getReceptionLetterTime() {
        return this.receptionLetterTime;
    }

    public double getSortLetterTime() {
        return this.sortLetterTime;
    }

    public double getThrowSubscriptionTime() {
        return this.throwSubscriptionTime;
    }

    public double getThrowWeeklyPaperTime() {
        return this.throwWeeklyPaperTime;
    }

    public double getThrowLeafletTime() {
        return this.throwLeafletTime;
    }

    public double getThrowLetterTime() {
        return this.throwLetterTime;
    }

    public double getReceptionTimeSum() {
        return this.receptionSubscriptionTime + this.receptionWeeklyPaperTime + this.receptionLeafletTime + this.receptionManualLeafletTime + this.receptionLetterTime + this.sortLetterTime;
    }

    public double getThrowTimeSum() {
        return this.throwSubscriptionTime + this.throwWeeklyPaperTime + this.throwLeafletTime + this.throwLetterTime + this.getReloadTime();
    }

    public double getTimeSum() {
        Integer duration = this.historyAreaTourModel == null ? null : this.historyAreaTourModel.getDuration();
        duration = duration == null ? 0 : duration;
        return (double)duration.intValue() + this.getThrowTimeSum() + this.getReceptionTimeSum() + this.getDifference();
    }

    public double getDifference() {
        Integer difference = WageDeltaModelUtil.getDifferenceTime(this.getModel());
        return difference == null ? 0.0 : (double)difference.intValue();
    }

    public List<PointEntity> getPointEntities() {
        ArrayList<PointEntity> pointEntities = new ArrayList<PointEntity>(this.historyAreaTourModel.countHistoryAreaTourStop());
        for (HistoryAreaStopModel stop : this.historyAreaTourModel.iterableHistoryAreaTourStop()) {
            pointEntities.add(this.getPointEntity(stop));
        }
        return pointEntities;
    }

    private PointEntity getPointEntity(HistoryAreaStopModel stop) {
        PointEntity pointEntity = new PointEntity(new PointEntityId(stop.getId(), null), stop.getLocation(), stop.getAccessLocation());
        return pointEntity;
    }

    public Collection<Coordinate> getAreaRectangle(boolean withPoi) {
        int startPoiCount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getLengthFromPoi()) == 0 ? 0 : 1;
        startPoiCount += NumericUtil.getIntegerValue(this.historyAreaTourModel.getLengthFromPickPoint()) == 0 ? 0 : 1;
        int endPoiCount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getLengthToPoi()) == 0 ? 0 : 1;
        endPoiCount += NumericUtil.getIntegerValue(this.historyAreaTourModel.getLengthToPickPoint()) == 0 ? 0 : 1;
        HashSet<ImmutablePoint> points = new HashSet<ImmutablePoint>();
        for (int i = startPoiCount; i < this.historyAreaTourModel.countHistoryAreaTourStop() - endPoiCount; ++i) {
            HistoryAreaStopModel stop = this.historyAreaTourModel.getAHistoryAreaTourStopAt(i);
            if (!GeoUtil.isNullPoint(stop.getLocation())) {
                points.add(stop.getLocation());
            }
            if (GeoUtil.isNullPoint(stop.getAccessLocation())) continue;
            points.add(stop.getAccessLocation());
        }
        return GeoUtils.getAreaRectangle(points);
    }

    public double getReloadTime() {
        if (this.reload == -1) {
            this.calculateReload(this.productWeightParameter.getProductMaxWeight());
        }
        return this.productWeightParameter.getReloadFlatTime() * (double)this.reload;
    }

    private void calculateReload(Map<Product, Integer> productMaxWeight) {
        this.reload = 0;
        for (Product product : productMaxWeight.keySet()) {
            Integer weight = productMaxWeight.get((Object)product);
            if (weight == null) continue;
            int amount = 0;
            switch (product) {
                case LEAFLET: {
                    if (!(this.throwLeafletTime > 0.0)) break;
                    amount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getDirectDeliveryLeafletAmount()) + NumericUtil.getIntegerValue(this.historyAreaTourModel.getManualLeafletAmount());
                    break;
                }
                case LETTER: {
                    if (!(this.throwLetterTime > 0.0)) break;
                    amount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getLetterAmount());
                    break;
                }
                case SUBSCRIPTION: {
                    if (!(this.throwSubscriptionTime > 0.0)) break;
                    amount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getSubscriptionAmount());
                    break;
                }
                case WEEKLY_PAPER: {
                    if (!(this.throwWeeklyPaperTime > 0.0)) break;
                    amount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getWeeklyPaperAmount());
                }
            }
            this.reload += amount / weight;
        }
    }

    public double getReloadDistance() {
        if (this.reload == -1) {
            this.calculateReload(this.productWeightParameter.getProductMaxWeight());
        }
        if (this.averageDistanceToPoi == -1.0) {
            this.calculateAverageDistanceToPoi();
        }
        return this.averageDistanceToPoi * (double)this.reload;
    }

    private void calculateAverageDistanceToPoi() {
        this.averageDistanceToPoi = 0.0;
        if (this.historyAreaTourModel.getPoiNumber() == null || this.historyAreaTourModel.isHistoryAreaTourStopEmpty()) {
            return;
        }
        LogisticTourDto<PointEntityId> tour = new LogisticTourDto<PointEntityId>(1L);
        List tourParts = tour.getTourParts();
        LogisticTourPartDto part = new LogisticTourPartDto(1L);
        part.setRouteVehicleType(this.historyAreaTourModel.getVehicelTypeFromPoi());
        part.setRouteType(this.historyAreaTourModel.getVehicelTypeFromPoi() == null ? null : this.historyAreaTourModel.getVehicelTypeFromPoi().getRouteType());
        part.setDifficultLevel(this.historyAreaTourModel.getDifficultyLevel());
        part.setParcelLocation(this.historyAreaTourModel.getParcelLocation());
        tourParts.add(part);
        ArrayList<HistoryAreaStopModel> historyStops = Lists.newArrayList(this.historyAreaTourModel.iterateHistoryAreaTourStop());
        HistoryAreaStopModel poi = (HistoryAreaStopModel)historyStops.get(0);
        List logisticStops = part.getStopDtos();
        logisticStops.add(this.createLogisticStop(poi, 0L));
        int startIndex = this.historyAreaTourModel.getFirstPickPoint() == null ? 1 : 2;
        Boolean back = this.historyAreaTourModel.getParameter().getBack();
        int endIndex = back != null && back != false ? historyStops.size() - 1 : historyStops.size();
        if (startIndex >= (endIndex -= this.historyAreaTourModel.getLastPickPoint() == null ? 0 : 1)) {
            return;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            HistoryAreaStopModel historyStop = (HistoryAreaStopModel)historyStops.get(i);
            logisticStops.add(this.createLogisticStop(historyStop, 1L));
            try {
                LogisticTourDto<PointEntityId> result = this.tourCaller.calculateLogisticTour(tour, false);
                this.averageDistanceToPoi += (double)NumericUtil.getIntegerValue(result.getDistanceSum());
            }
            catch (LogisticException logisticException) {
                // empty catch block
            }
            logisticStops.remove(1);
        }
        this.averageDistanceToPoi /= (double)(endIndex - startIndex);
    }

    private LogisticStopDto<PointEntityId> createLogisticStop(HistoryAreaStopModel historyStop, Long l) {
        ImmutablePointDto geomDto = ImmutablePointDto.create((ImmutablePoint)historyStop.getLocation().getGeom());
        ImmutablePointDto accessGeomDto = ImmutablePointDto.create((ImmutablePoint)historyStop.getAccessLocation().getGeom());
        LogisticLocationDto<PointEntityId> logisticLocation = new LogisticLocationDto<PointEntityId>(new PointEntityId(l, PointEntityId.PointEnityType.STOP), geomDto, accessGeomDto, null, null, null, null, null, (Integer)null, null);
        return new LogisticStopDto<PointEntityId>(new PointEntityId(l, PointEntityId.PointEnityType.STOP), logisticLocation);
    }

    public LogisticTourDto<PointEntityId> createLogisticTour() {
        LogisticTourDto<PointEntityId> tour = new LogisticTourDto<PointEntityId>(1L);
        List tourParts = tour.getTourParts();
        LogisticTourPartDto part = new LogisticTourPartDto(1L);
        part.setRouteVehicleType(this.historyAreaTourModel.getVehicelTypeFromPoi());
        part.setRouteType(this.historyAreaTourModel.getVehicelTypeFromPoi() == null ? null : this.historyAreaTourModel.getVehicelTypeFromPoi().getRouteType());
        part.setDifficultLevel(this.historyAreaTourModel.getDifficultyLevel());
        part.setParcelLocation(this.historyAreaTourModel.getParcelLocation());
        tourParts.add(part);
        List logisticStops = part.getStopDtos();
        for (HistoryAreaStopModel stop : this.historyAreaTourModel.iterableHistoryAreaTourStop()) {
            logisticStops.add(this.createLogisticStop(stop, stop.getSortOrder() == null ? 0L : stop.getSortOrder().longValue()));
        }
        return tour;
    }

    public void refresh() {
        WageParameterModel parameter;
        WageParameterModel wageParameterModel = parameter = this.historyAreaTourModel == null ? null : this.historyAreaTourModel.getParameter();
        if (parameter == null) {
            return;
        }
        int stopCount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getStopCount());
        CalculateType routingType = parameter.getRoutingType() == null ? CalculateType.NONFIX : parameter.getRoutingType();
        switch (routingType) {
            case BOTHWITHPOI: {
                stopCount -= 2;
                break;
            }
            case STARTWITHPOI: 
            case ENDWITHPOI: {
                --stopCount;
                break;
            }
        }
        stopCount = stopCount < 0 ? 0 : stopCount;
        this.receptionSubscriptionTime = NumericUtil.getDoubleValue(parameter.getReceptionSubscriptionFlatTime());
        int subscriptionAmount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getSubscriptionAmount());
        if (subscriptionAmount < 1) {
            this.receptionSubscriptionTime = 0.0;
        } else {
            int subscriptionPackage = (int)Math.ceil(subscriptionAmount / (NumericUtil.getIntegerValue(this.historyAreaTourModel.getSubscriptionPackageCount()) == 0 ? 1 : this.historyAreaTourModel.getSubscriptionPackageCount()));
            this.receptionSubscriptionTime += (double)subscriptionPackage * NumericUtil.getDoubleValue(parameter.getReceptionSubscriptionPieceTime());
        }
        this.receptionWeeklyPaperTime = NumericUtil.getDoubleValue(parameter.getReceptionWeeklyPaperFlatTime());
        int weeklyPaperAmount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getWeeklyPaperAmount());
        if (weeklyPaperAmount < 1) {
            this.receptionWeeklyPaperTime = 0.0;
        } else {
            int weeklyPaperPackage = (int)Math.ceil(weeklyPaperAmount / (NumericUtil.getIntegerValue(this.historyAreaTourModel.getWeeklyPaperPackageCount()) == 0 ? 1 : this.historyAreaTourModel.getWeeklyPaperPackageCount()));
            this.receptionWeeklyPaperTime += (double)weeklyPaperPackage * NumericUtil.getDoubleValue(parameter.getReceptionWeeklyPaperPieceTime());
        }
        this.receptionLeafletTime = NumericUtil.getDoubleValue(parameter.getReceptionLeafletFlatTime());
        int directDeliveryLeafletAmount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getDirectDeliveryLeafletAmount());
        this.receptionLeafletTime = directDeliveryLeafletAmount < 1 ? 0.0 : (this.receptionLeafletTime += (double)directDeliveryLeafletAmount * NumericUtil.getDoubleValue(parameter.getReceptionLeafletPieceTime()));
        int manualLeafletAmount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getManualLeafletAmount());
        this.receptionManualLeafletTime = (double)manualLeafletAmount * NumericUtil.getDoubleValue(parameter.getManualLeafletPieceTime());
        this.receptionLetterTime = NumericUtil.getDoubleValue(parameter.getReceptionLetterFlatTime());
        double sortPieceTime = 0.0;
        int letterAmount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getLetterAmount());
        if (letterAmount < 1) {
            this.receptionLetterTime = 0.0;
            this.sortLetterTime = 0.0;
        } else {
            for (SortVolumeScalingModel scaling : parameter.iterableSortVolumeScalings()) {
                Integer minVolume = scaling.getMinVolume() == null ? Integer.MIN_VALUE : scaling.getMinVolume();
                Integer maxVolume = scaling.getMaxVolume() == null ? Integer.MAX_VALUE : scaling.getMaxVolume();
                if (minVolume > letterAmount || maxVolume < letterAmount) continue;
                sortPieceTime = NumericUtil.getDoubleValue(scaling.getPieceTime());
                break;
            }
            this.sortLetterTime = (double)letterAmount * sortPieceTime;
        }
        int subscriptionStopCount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getSubscriptionStopCount());
        int n = subscriptionStopCount = subscriptionStopCount < 1 ? stopCount : subscriptionStopCount;
        if (subscriptionStopCount >= subscriptionAmount) {
            this.throwSubscriptionTime = (double)subscriptionAmount * NumericUtil.getDoubleValue(parameter.getFirstThrowSubscriptionPieceTime());
        } else {
            this.throwSubscriptionTime = (double)subscriptionStopCount * NumericUtil.getDoubleValue(parameter.getFirstThrowSubscriptionPieceTime());
            this.throwSubscriptionTime += (double)(subscriptionAmount - subscriptionStopCount) * NumericUtil.getDoubleValue(parameter.getThrowSubscriptionPieceTime());
        }
        int weeklyPaperStopCount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getWeeklyPaperStopCount());
        int n2 = weeklyPaperStopCount = weeklyPaperStopCount < 1 ? stopCount : weeklyPaperStopCount;
        if (weeklyPaperStopCount >= weeklyPaperAmount) {
            this.throwWeeklyPaperTime = (double)weeklyPaperAmount * NumericUtil.getDoubleValue(parameter.getFirstThrowWeeklyPaperPieceTime());
        } else {
            this.throwWeeklyPaperTime = (double)weeklyPaperStopCount * NumericUtil.getDoubleValue(parameter.getFirstThrowWeeklyPaperPieceTime());
            this.throwWeeklyPaperTime += (double)(weeklyPaperAmount - weeklyPaperStopCount) * NumericUtil.getDoubleValue(parameter.getThrowWeeklyPaperPieceTime());
        }
        int directDeliveryStopCount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getDirectDeliveryStopCount());
        int n3 = directDeliveryStopCount = directDeliveryStopCount < 1 ? stopCount : directDeliveryStopCount;
        if (directDeliveryStopCount >= directDeliveryLeafletAmount) {
            this.throwLeafletTime = (double)directDeliveryLeafletAmount * NumericUtil.getDoubleValue(WageDeltaModelUtil.getThrowLeafletPieceTime(parameter, 1, ThrowLeafletType.DIRECT_FIRST));
        } else {
            this.throwLeafletTime = (double)directDeliveryStopCount * NumericUtil.getDoubleValue(WageDeltaModelUtil.getThrowLeafletPieceTime(parameter, 1, ThrowLeafletType.DIRECT_FIRST));
            this.throwLeafletTime += (double)(directDeliveryLeafletAmount - directDeliveryStopCount) * NumericUtil.getDoubleValue(WageDeltaModelUtil.getThrowLeafletPieceTime(parameter, 1, ThrowLeafletType.DIRECT));
        }
        int manualStopCount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getManualLeafletStopCount());
        int manualPackageSize = this.historyAreaTourModel.getLeafletPackageCount() == null || this.historyAreaTourModel.getLeafletPackageCount() == 0 ? 1 : this.historyAreaTourModel.getLeafletPackageCount();
        int manualPackageCount = (int)Math.ceil(manualLeafletAmount / manualPackageSize);
        int n4 = manualStopCount = manualStopCount < 1 ? stopCount : manualStopCount;
        if (manualStopCount >= manualPackageCount) {
            this.throwLeafletTime += (double)manualPackageCount * NumericUtil.getDoubleValue(WageDeltaModelUtil.getThrowLeafletPieceTime(parameter, manualPackageSize, ThrowLeafletType.MANUAL_FIRST));
        } else {
            this.throwLeafletTime += (double)manualStopCount * NumericUtil.getDoubleValue(WageDeltaModelUtil.getThrowLeafletPieceTime(parameter, manualPackageSize, ThrowLeafletType.MANUAL_FIRST));
            this.throwLeafletTime += (double)(manualPackageCount - manualStopCount) * NumericUtil.getDoubleValue(WageDeltaModelUtil.getThrowLeafletPieceTime(parameter, manualPackageSize, ThrowLeafletType.DIRECT));
        }
        int letterStopCount = NumericUtil.getIntegerValue(this.historyAreaTourModel.getLetterStopCount());
        int n5 = letterStopCount = letterStopCount < 1 ? stopCount : letterStopCount;
        if (letterStopCount >= letterAmount) {
            this.throwLetterTime += (double)letterAmount * NumericUtil.getDoubleValue(parameter.getFirstThrowLetterPieceTime());
        } else {
            this.throwLetterTime = (double)letterStopCount * NumericUtil.getDoubleValue(parameter.getFirstThrowLetterPieceTime());
            this.throwLetterTime += (double)(letterAmount - letterStopCount) * NumericUtil.getDoubleValue(parameter.getThrowLetterPieceTime());
        }
    }
}

