/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.filter.subscription;

import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.base.SubscriptionStaticChoiceAttributeValueModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.model.filter.SubscriptionFilterAreaRelationModel;
import de.datomino.peppergis.client.model.filter.SubscriptionFilterModel;
import de.datomino.peppergis.client.util.filter.AbstractFilterChecker;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueModel;
import de.datomino.peppergis.client.util.wrapper.subscription.attribute.SubscriptionAttributeValueModelAttributeWrapper;
import de.datomino.peppergis.type.SubscriptionDeliveryType;
import de.datomino.peppergis.type.SubscriptionStatus;
import de.datomino.peppergis.type.filter.ObjectFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.ktde.util.StringUtil;

public class SubscriptionFilterChecker
extends AbstractFilterChecker<SubscriptionFilterModel, SubscriptionModel, SubscriptionAttributeValueModel, SubscriptionStaticChoiceAttributeValueModel, SubscriptionAttributeValueDescriptorModel> {
    public SubscriptionFilterChecker(ObjectFilter<SubscriptionFilterModel, AttributeValueFilterModel> modelObjectFilter) {
        super(modelObjectFilter);
    }

    @Override
    protected Collection<AttributeValueModel<SubscriptionAttributeValueModel, SubscriptionStaticChoiceAttributeValueModel, SubscriptionAttributeValueDescriptorModel>> getAttributeValueModels(SubscriptionModel model) {
        ArrayList<AttributeValueModel<SubscriptionAttributeValueModel, SubscriptionStaticChoiceAttributeValueModel, SubscriptionAttributeValueDescriptorModel>> list = new ArrayList<AttributeValueModel<SubscriptionAttributeValueModel, SubscriptionStaticChoiceAttributeValueModel, SubscriptionAttributeValueDescriptorModel>>(model.countSubscriptionAttributeValues());
        for (SubscriptionAttributeValueModel subscriptionAttributeValueModel : model.iterableSubscriptionAttributeValues()) {
            list.add(new SubscriptionAttributeValueModelAttributeWrapper(subscriptionAttributeValueModel));
        }
        return list;
    }

    @Override
    protected boolean satisfiesSpecial(SubscriptionModel model, ObjectFilter<SubscriptionFilterModel, AttributeValueFilterModel> modelObjectFilter2) {
        SubscriptionDeliveryType deliveryType;
        String subscriptionNumber;
        SubscriptionFilterModel subscriptionFilterModel = (SubscriptionFilterModel)modelObjectFilter2.getAttachedObject();
        String subscriptionNumberPattern = subscriptionFilterModel.getSubscriptionNumber();
        if (!StringUtil.isBlank(subscriptionNumberPattern) && !(subscriptionNumber = StringUtil.nullToEmpty(model.getSubscriptionNumber())).matches(subscriptionNumberPattern.replace("*", ".*"))) {
            return false;
        }
        SubscriptionStatus subscriptionStatus = subscriptionFilterModel.getSubscriptionStatus();
        if (subscriptionStatus != null && subscriptionStatus != model.getStatus()) {
            return false;
        }
        boolean found = true;
        Boolean subscriptionFilterAreaEnabled = subscriptionFilterModel.getSubscriptionFilterAreaEnabled();
        if (subscriptionFilterAreaEnabled != null && subscriptionFilterAreaEnabled.booleanValue()) {
            found = false;
            for (SubscriptionFilterAreaRelationModel subscriptionFilterAreaRelationModel : subscriptionFilterModel.iterableSubscriptionFilterAreaRelation()) {
                if (!subscriptionFilterAreaRelationModel.getAreaObject().equals(model.getAreaObject())) continue;
                found = true;
                break;
            }
            return found;
        }
        if (!found) {
            return false;
        }
        Boolean monday = subscriptionFilterModel.getMonday();
        Boolean tuesday = subscriptionFilterModel.getTuesday();
        Boolean wednesday = subscriptionFilterModel.getWednesday();
        Boolean thursday = subscriptionFilterModel.getThursday();
        Boolean friday = subscriptionFilterModel.getFriday();
        Boolean saturday = subscriptionFilterModel.getSaturday();
        Boolean sunday = subscriptionFilterModel.getSunday();
        if (monday != null || tuesday != null || wednesday != null || thursday != null || friday != null || saturday != null || sunday != null) {
            Boolean sMonday = model.getMonday();
            Boolean sTuesday = model.getTuesday();
            Boolean sWednesday = model.getWednesday();
            Boolean sThursday = model.getThursday();
            Boolean sFriday = model.getFriday();
            Boolean sSaturday = model.getSaturday();
            Boolean sSunday = model.getSunday();
            boolean oneHit = false;
            oneHit |= sMonday != false && monday != false;
            oneHit |= sTuesday != false && tuesday != false;
            oneHit |= sWednesday != false && wednesday != false;
            oneHit |= sThursday != false && thursday != false;
            oneHit |= sFriday != false && friday != false;
            oneHit |= sSaturday != false && saturday != false;
            if (!(oneHit |= sSunday != false && sunday != false)) {
                return false;
            }
        }
        if ((deliveryType = subscriptionFilterModel.getDeliveryType()) != null && deliveryType != model.getDeliveryType()) {
            return false;
        }
        Date startDate = subscriptionFilterModel.getStartDate();
        Date endDate = subscriptionFilterModel.getEndDate();
        if (startDate != null && endDate != null) {
            Date sStartDate = model.getStartDate();
            Date sEndDate = model.getEndDate();
            boolean inPeriod = sStartDate == null || sStartDate.after(startDate) && sStartDate.before(endDate);
            if (!(inPeriod |= sEndDate == null || sEndDate.after(startDate) && sEndDate.before(endDate))) {
                return false;
            }
        }
        return true;
    }
}

