/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.filter.letter;

import de.datomino.peppergis.client.model.base.LetterAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.LetterAttributeValueModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LetterStaticChoiceAttributeValueModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.model.filter.LetterFilterAreaRelationModel;
import de.datomino.peppergis.client.model.filter.LetterFilterModel;
import de.datomino.peppergis.client.util.filter.AbstractFilterChecker;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueModel;
import de.datomino.peppergis.client.util.wrapper.letter.attribute.LetterAttributeValueModelAttributeWrapper;
import de.datomino.peppergis.type.LetterDeliveryType;
import de.datomino.peppergis.type.filter.ObjectFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.ktde.util.StringUtil;

public class LetterFilterChecker
extends AbstractFilterChecker<LetterFilterModel, LetterModel, LetterAttributeValueModel, LetterStaticChoiceAttributeValueModel, LetterAttributeValueDescriptorModel> {
    public LetterFilterChecker(ObjectFilter<LetterFilterModel, AttributeValueFilterModel> modelObjectFilter) {
        super(modelObjectFilter);
    }

    @Override
    protected Collection<AttributeValueModel<LetterAttributeValueModel, LetterStaticChoiceAttributeValueModel, LetterAttributeValueDescriptorModel>> getAttributeValueModels(LetterModel model) {
        ArrayList<AttributeValueModel<LetterAttributeValueModel, LetterStaticChoiceAttributeValueModel, LetterAttributeValueDescriptorModel>> list = new ArrayList<AttributeValueModel<LetterAttributeValueModel, LetterStaticChoiceAttributeValueModel, LetterAttributeValueDescriptorModel>>(model.countLetterAttributeValues());
        for (LetterAttributeValueModel letterAttributeValueModel : model.iterableLetterAttributeValues()) {
            list.add(new LetterAttributeValueModelAttributeWrapper(letterAttributeValueModel));
        }
        return list;
    }

    @Override
    protected boolean satisfiesSpecial(LetterModel model, ObjectFilter<LetterFilterModel, AttributeValueFilterModel> modelObjectFilter2) {
        String letterNumber;
        LetterFilterModel letterFilterModel = (LetterFilterModel)modelObjectFilter2.getAttachedObject();
        String letterNumberPattern = letterFilterModel.getLetterNumber();
        if (!StringUtil.isBlank(letterNumberPattern) && !(letterNumber = StringUtil.nullToEmpty(model.getLetterNumber())).matches(letterNumberPattern.replace("*", ".*"))) {
            return false;
        }
        boolean found = true;
        Boolean letterFilterAreaEnabled = letterFilterModel.getLetterFilterAreaEnabled();
        if (letterFilterAreaEnabled != null && letterFilterAreaEnabled.booleanValue()) {
            found = false;
            for (LetterFilterAreaRelationModel letterFilterAreaRelationModel : letterFilterModel.iterableLetterFilterAreaRelation()) {
                if (!letterFilterAreaRelationModel.getAreaObject().equals(model.getAreaObject())) continue;
                found = true;
                break;
            }
            return found;
        }
        if (!found) {
            return false;
        }
        LetterDeliveryType deliveryType = letterFilterModel.getDeliveryType();
        if (deliveryType != null && deliveryType != model.getDeliveryType()) {
            return false;
        }
        Date startDate = letterFilterModel.getStartDate();
        Date endDate = letterFilterModel.getEndDate();
        if (startDate != null && endDate != null) {
            boolean inPeriod;
            Date date = model.getDate();
            boolean bl = inPeriod = date.after(startDate) && date.before(endDate);
            if (!inPeriod) {
                return false;
            }
        }
        return true;
    }
}

