/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.filter;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.ImageModel;
import de.datomino.peppergis.type.RendererType;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import de.datomino.util.geo.swing.renderer.CirclePointRenderer;
import de.datomino.util.geo.swing.renderer.DashLineRenderer;
import de.datomino.util.geo.swing.renderer.EmptyAreaRenderer;
import de.datomino.util.geo.swing.renderer.HatchLineAreaRenderer;
import de.datomino.util.geo.swing.renderer.HatchQuadAreaRenderer;
import de.datomino.util.geo.swing.renderer.IconPointRenderer;
import de.datomino.util.geo.swing.renderer.IsoscelesTrianglePointRenderer;
import de.datomino.util.geo.swing.renderer.PlainAreaRenderer;
import de.datomino.util.geo.swing.renderer.RandomAreaRenderer;
import de.datomino.util.geo.swing.renderer.RectanglePointRenderer;
import de.datomino.util.geo.swing.renderer.Renderer;
import de.datomino.util.geo.swing.renderer.RendererProperties;
import de.datomino.util.geo.swing.renderer.SolidLineRenderer;
import java.awt.Color;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RendererFactory.class);
    private static final RendererFactory INSTANCE = new RendererFactory();
    private Image poiImage;
    private Image fallbackImage;

    private RendererFactory() {
    }

    public static RendererFactory getInstance() {
        return INSTANCE;
    }

    public <T extends RendererProperties, S extends ImmutableGeoObject, U> Renderer<T, S, U> createRenderer(RendererType rendererType, List<Tupel<String, String>> parameters, ModelEnviroment modelEnviroment, Map<Long, Image> imageCache) {
        return this.createRenderer(rendererType, parameters, modelEnviroment, imageCache, false, null);
    }

    public <T extends RendererProperties, S extends ImmutableGeoObject, U> Renderer<T, S, U> createRenderer(RendererType rendererType, List<Tupel<String, String>> parameters, ModelEnviroment modelEnviroment, Map<Long, Image> imageCache, boolean withFallBackValues, Integer maxAlpha) {
        return this.createRenderer(rendererType, parameters, modelEnviroment, imageCache, withFallBackValues, maxAlpha, null);
    }

    public <T extends RendererProperties, S extends ImmutableGeoObject, U> Renderer<T, S, U> createRenderer(RendererType rendererType, List<Tupel<String, String>> parameters, ModelEnviroment modelEnviroment, Map<Long, Image> imageCache, boolean withFallBackValues, Integer maxAlpha, AreaRenderer<? extends RendererProperties, U> empAreaRenderer) {
        switch (rendererType) {
            case INVISIBLE: {
                return null;
            }
            case CIRCLE: {
                return this.createCircleRenderer(parameters, withFallBackValues);
            }
            case RECTANGLE: {
                return this.createRectangleRenderer(parameters, withFallBackValues);
            }
            case ISOSCELES_TRIANGLE: {
                return this.createIsoscelesTriangleRenderer(parameters, withFallBackValues);
            }
            case HATCH_QUAD: {
                return this.createHatchQuadRenderer(parameters, withFallBackValues, maxAlpha, empAreaRenderer);
            }
            case PLAIN: {
                return this.createAreaPlainRenderer(parameters, withFallBackValues, maxAlpha, empAreaRenderer);
            }
            case ICON_POINT: {
                return this.createIconPointRenderer(parameters, modelEnviroment, imageCache, withFallBackValues);
            }
            case SOLID_LINE: {
                return this.createSolidLineRenderer(parameters, withFallBackValues);
            }
            case DASH_LINE: {
                return this.createDashLineRenderer(parameters, withFallBackValues);
            }
            case RANDOM_AREA: {
                return this.createRandomAreaRenderer(parameters, modelEnviroment, withFallBackValues, maxAlpha, empAreaRenderer);
            }
            case HATCH_LINE: {
                return this.createHatchLineAreaRenderer(parameters, withFallBackValues, maxAlpha, empAreaRenderer);
            }
        }
        throw new RuntimeException();
    }

    private <T extends RendererProperties, S extends ImmutableGeoObject, U> Renderer<T, S, U> createHatchLineAreaRenderer(List<Tupel<String, String>> parameters, boolean withFallBackValues, Integer maxAlpha, AreaRenderer<? extends RendererProperties, U> emphasizeRenderer) {
        Color color1 = null;
        Color color2 = null;
        Integer alpha1 = null;
        Integer alpha2 = null;
        Double width = null;
        HatchLineAreaRenderer.DirectionType directionType = null;
        for (Tupel<String, String> tupel : parameters) {
            String key = tupel.getElement1();
            String value = tupel.getElement2();
            if (color1 == null && key.equals(HatchLineAreaRenderer.Parameters.COLOR_1.name())) {
                color1 = PaintUtil.extractColor(0, value);
                continue;
            }
            if (color2 == null && key.equals(HatchLineAreaRenderer.Parameters.COLOR_2.name())) {
                color2 = PaintUtil.extractColor(0, value);
                continue;
            }
            if (alpha1 == null && key.equals(HatchLineAreaRenderer.Parameters.ALPHA_1.name())) {
                alpha1 = Integer.valueOf(value);
                continue;
            }
            if (alpha2 == null && key.equals(HatchLineAreaRenderer.Parameters.ALPHA_2.name())) {
                alpha2 = Integer.valueOf(value);
                continue;
            }
            if (width == null && key.equals(HatchLineAreaRenderer.Parameters.WIDTH.name())) {
                width = Double.valueOf(value);
                continue;
            }
            if (directionType != null || !key.equals(HatchLineAreaRenderer.Parameters.DIRECTION_TYPE.name())) continue;
            directionType = HatchLineAreaRenderer.DirectionType.valueOf(value);
        }
        if (withFallBackValues) {
            if (color1 == null && color2 == null) {
                color1 = Color.BLUE;
                color2 = Color.ORANGE;
            } else if (color1 == null) {
                color1 = new Color(255 - color2.getRed(), 255 - color2.getGreen(), 255 - color2.getBlue());
            } else if (color2 == null) {
                color2 = new Color(255 - color1.getRed(), 255 - color1.getGreen(), 255 - color1.getBlue());
            }
            if (alpha1 == null && alpha2 == null) {
                alpha1 = 80;
                alpha2 = 80;
            } else if (alpha1 == null) {
                alpha1 = alpha2;
            } else if (alpha2 == null) {
                alpha2 = alpha1;
            }
            if (width == null) {
                width = 10.0;
            }
            if (directionType == null) {
                directionType = HatchLineAreaRenderer.DirectionType.HORIZONTAL;
            }
        }
        if (maxAlpha != null) {
            if (alpha1 != null) {
                alpha1 = Math.min(alpha1, maxAlpha);
            }
            if (alpha2 != null) {
                alpha2 = Math.min(alpha2, maxAlpha);
            }
        }
        if (color1 != null && color2 != null && alpha1 != null && alpha2 != null && width != null && width > 0.0 && (alpha1 > 0 || alpha2 > 0) && directionType != null) {
            HatchLineAreaRenderer<U> areaRenderer = new HatchLineAreaRenderer<U>(color1, alpha1, color2, alpha2, width, directionType, emphasizeRenderer);
            return areaRenderer;
        }
        EmptyAreaRenderer<U> emptyAreaRenderer = new EmptyAreaRenderer<U>(emphasizeRenderer);
        return emptyAreaRenderer;
    }

    private <T extends RendererProperties, S extends ImmutableGeoObject, U> Renderer<T, S, U> createDashLineRenderer(List<Tupel<String, String>> parameters, boolean withFallBackValues) {
        Color color = null;
        Double width = null;
        for (Tupel<String, String> tupel : parameters) {
            String key = tupel.getElement1();
            String value = tupel.getElement2();
            if (color == null && key.equals(DashLineRenderer.Parameters.COLOR.name())) {
                color = PaintUtil.extractColor(0, value);
                continue;
            }
            if (width != null || !key.equals(DashLineRenderer.Parameters.WIDTH.name())) continue;
            width = Double.valueOf(value);
        }
        if (withFallBackValues) {
            if (color == null) {
                color = Color.BLACK;
            }
            if (width == null) {
                width = 5.0;
            }
        }
        if (color != null) {
            DashLineRenderer lineRenderer = new DashLineRenderer(color, width);
            return lineRenderer;
        }
        return null;
    }

    private <T extends RendererProperties, S extends ImmutableGeoObject, U> Renderer<T, S, U> createSolidLineRenderer(List<Tupel<String, String>> parameters, boolean withFallBackValues) {
        Color color = null;
        Double width = null;
        for (Tupel<String, String> tupel : parameters) {
            String key = tupel.getElement1();
            String value = tupel.getElement2();
            if (color == null && key.equals(SolidLineRenderer.Parameters.COLOR.name())) {
                color = PaintUtil.extractColor(0, value);
                continue;
            }
            if (width != null || !key.equals(SolidLineRenderer.Parameters.WIDTH.name())) continue;
            width = Double.valueOf(value);
        }
        if (withFallBackValues) {
            if (color == null) {
                color = Color.BLACK;
            }
            if (width == null) {
                width = 5.0;
            }
        }
        if (color != null && width != null) {
            SolidLineRenderer lineRenderer = new SolidLineRenderer(color, width);
            return lineRenderer;
        }
        return null;
    }

    public <U> IconPointRenderer<U> createIconPointRenderer(URL imageResource) {
        Image image = null;
        if (imageResource != null) {
            try {
                image = ImageIO.read(imageResource);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (image == null) {
            image = this.getFallbackImage();
        }
        if (image == null) {
            return null;
        }
        return new IconPointRenderer(image);
    }

    private <T extends RendererProperties, S extends ImmutableGeoObject, U> Renderer<T, S, U> createIconPointRenderer(List<Tupel<String, String>> parameters, ModelEnviroment modelEnviroment, Map<Long, Image> imageCache, boolean withFallBackValues) {
        Image image = null;
        for (Tupel<String, String> tupel : parameters) {
            String key = tupel.getElement1();
            String value = tupel.getElement2();
            if (image != null || !key.equals(IconPointRenderer.Parameters.IMAGE_ID.name()) || StringUtil.isBlank(value)) continue;
            Long id = Long.parseLong(value);
            if (imageCache != null) {
                image = imageCache.get(id);
            }
            if (image != null) continue;
            image = this.fetchImage(modelEnviroment, id);
            if (imageCache == null) continue;
            imageCache.put(id, image);
        }
        if (withFallBackValues && image == null) {
            image = this.getDefaultIconPointImage(modelEnviroment);
        }
        return image == null ? null : new IconPointRenderer(image);
    }

    private Image fetchImage(ModelEnviroment modelEnviroment, Long id) {
        Image image = null;
        ImageModel imageModel = modelEnviroment.getAllCaller().getBaseCaller().getImageById(id);
        if (imageModel != null) {
            try {
                image = ImageIO.read(new ByteArrayInputStream(imageModel.getData()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (image == null) {
            image = this.getDefaultIconPointImage(modelEnviroment);
        }
        return image;
    }

    private Image getDefaultIconPointImage(ModelEnviroment modelEnviroment) {
        byte[] b;
        Image image = null;
        String imageFile = ModelEnviroment.getProperties().getProperty("icon.image.default");
        if (!StringUtil.isBlank(imageFile)) {
            try {
                image = ImageIO.read(new File(imageFile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (image == null && (b = modelEnviroment.getAllCaller().getBaseCaller().getDefaultImage()) != null) {
            try {
                image = ImageIO.read(new ByteArrayInputStream(b));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (image == null) {
            image = this.getFallbackImage();
        }
        return image;
    }

    public Image getDefaultPoiImage(ModelEnviroment modelEnviroment) {
        if (this.poiImage == null) {
            String poiImageProp = ModelEnviroment.getProperties().getProperty("poi.image");
            if (!StringUtil.isBlank(poiImageProp)) {
                char d = Character.toLowerCase(poiImageProp.charAt(0));
                String value = poiImageProp.substring(1);
                switch (d) {
                    case 'u': {
                        try {
                            this.poiImage = ImageIO.read(new URL(value));
                        }
                        catch (MalformedURLException e) {
                            LOGGER.warn("Could not load poi image from url: " + value, e);
                        }
                        catch (IOException e) {
                            LOGGER.warn("Could not load poi image from url: " + value, e);
                        }
                        break;
                    }
                    case 'r': {
                        ImageModel imageModel = modelEnviroment.getAllCaller().getBaseCaller().getImageByName(value);
                        if (imageModel != null) {
                            try {
                                byte[] data = imageModel.getData();
                                this.poiImage = ImageIO.read(new ByteArrayInputStream(data));
                            }
                            catch (IOException e) {
                                LOGGER.warn("Could not load poi image with name: " + value, e);
                            }
                            break;
                        }
                        LOGGER.warn("Could not load poi image with name: " + value);
                    }
                }
            }
            if (this.poiImage == null) {
                this.poiImage = this.getFallbackImage();
            }
        }
        return this.poiImage;
    }

    public Image getFallbackImage() {
        if (this.fallbackImage == null) {
            try {
                this.fallbackImage = ImageIO.read(this.getClass().getResourceAsStream("/images/fallback.gif"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.fallbackImage;
    }

    private <T extends RendererProperties, S extends ImmutableGeoObject, U> Renderer<T, S, U> createIsoscelesTriangleRenderer(List<Tupel<String, String>> parameters, boolean withFallBackValues) {
        Color color = null;
        Integer baseLineLength = null;
        Integer height = null;
        Integer alpha = null;
        for (Tupel<String, String> tupel : parameters) {
            String key = tupel.getElement1();
            String value = tupel.getElement2();
            if (color == null && key.equals(IsoscelesTrianglePointRenderer.Parameters.COLOR.name())) {
                color = PaintUtil.extractColor(0, value);
                continue;
            }
            if (baseLineLength == null && key.equals(IsoscelesTrianglePointRenderer.Parameters.BASE_LINE_LENGTH.name())) {
                baseLineLength = Integer.valueOf(value);
                continue;
            }
            if (height == null && key.equals(IsoscelesTrianglePointRenderer.Parameters.HEIGHT.name())) {
                height = Integer.valueOf(value);
                continue;
            }
            if (alpha != null || !key.equals(IsoscelesTrianglePointRenderer.Parameters.ALPHA.name())) continue;
            alpha = Integer.valueOf(value);
        }
        if (withFallBackValues) {
            if (color == null) {
                color = Color.WHITE;
            }
            if (baseLineLength == null) {
                baseLineLength = 10;
            }
            if (height == null) {
                height = 10;
            }
            if (alpha == null) {
                alpha = 100;
            }
        }
        if (color != null && baseLineLength != null && height != null && alpha != null) {
            return new IsoscelesTrianglePointRenderer(color, alpha, baseLineLength, height);
        }
        return null;
    }

    private <T extends RendererProperties, S extends ImmutableGeoObject, U> Renderer<T, S, U> createRectangleRenderer(List<Tupel<String, String>> parameters, boolean withFallBackValues) {
        Color color = null;
        Integer height = null;
        Integer width = null;
        Integer alpha = null;
        for (Tupel<String, String> tupel : parameters) {
            String key = tupel.getElement1();
            String value = tupel.getElement2();
            if (color == null && key.equals(RectanglePointRenderer.Parameters.COLOR.name())) {
                color = PaintUtil.extractColor(0, value);
                continue;
            }
            if (height == null && key.equals(RectanglePointRenderer.Parameters.HEIGHT.name())) {
                height = Integer.valueOf(value);
                continue;
            }
            if (width == null && key.equals(RectanglePointRenderer.Parameters.WIDTH.name())) {
                width = Integer.valueOf(value);
                continue;
            }
            if (alpha != null || !key.equals(RectanglePointRenderer.Parameters.ALPHA.name())) continue;
            alpha = Integer.valueOf(value);
        }
        if (withFallBackValues) {
            if (color == null) {
                color = Color.WHITE;
            }
            if (width == null) {
                width = 10;
            }
            if (height == null) {
                height = 10;
            }
            if (alpha == null) {
                alpha = 100;
            }
        }
        if (color != null && height != null && width != null) {
            return new RectanglePointRenderer(color, alpha, height, width);
        }
        return null;
    }

    private <T extends RendererProperties, S extends ImmutableGeoObject, U> Renderer<T, S, U> createCircleRenderer(List<Tupel<String, String>> parameters, boolean withFallBackValues) {
        Color color = null;
        Integer radius = null;
        Integer alpha = null;
        for (Tupel<String, String> tupel : parameters) {
            String key = tupel.getElement1();
            String value = tupel.getElement2();
            if (color == null && key.equals(CirclePointRenderer.Parameters.COLOR.name())) {
                color = PaintUtil.extractColor(0, value);
                continue;
            }
            if (radius == null && key.equals(CirclePointRenderer.Parameters.RADIUS.name())) {
                radius = Integer.valueOf(value);
                continue;
            }
            if (alpha != null || !key.equals(CirclePointRenderer.Parameters.ALPHA.name())) continue;
            alpha = Integer.valueOf(value);
        }
        if (withFallBackValues) {
            if (color == null) {
                color = Color.WHITE;
            }
            if (radius == null) {
                radius = 10;
            }
            if (alpha == null) {
                alpha = 100;
            }
        }
        if (color != null && radius != null && alpha != null) {
            return new CirclePointRenderer(color, alpha, radius);
        }
        return null;
    }

    private <T extends RendererProperties, S extends ImmutableGeoObject, U> Renderer<T, S, U> createHatchQuadRenderer(List<Tupel<String, String>> parameters, boolean withFallBackValues, Integer maxAlpha, AreaRenderer<? extends RendererProperties, U> emphasizeRenderer) {
        Color color1 = null;
        Color color2 = null;
        Integer alpha1 = null;
        Integer alpha2 = null;
        Double size = null;
        for (Tupel<String, String> tupel : parameters) {
            String key = tupel.getElement1();
            String value = tupel.getElement2();
            if (color1 == null && key.equals(HatchQuadAreaRenderer.Parameters.COLOR_1.name())) {
                color1 = PaintUtil.extractColor(0, value);
                continue;
            }
            if (color2 == null && key.equals(HatchQuadAreaRenderer.Parameters.COLOR_2.name())) {
                color2 = PaintUtil.extractColor(0, value);
                continue;
            }
            if (alpha1 == null && key.equals(HatchQuadAreaRenderer.Parameters.ALPHA_1.name())) {
                alpha1 = Integer.valueOf(value);
                continue;
            }
            if (alpha2 == null && key.equals(HatchQuadAreaRenderer.Parameters.ALPHA_2.name())) {
                alpha2 = Integer.valueOf(value);
                continue;
            }
            if (size != null || !key.equals(HatchQuadAreaRenderer.Parameters.QUAD_SIZE.name())) continue;
            size = Double.valueOf(value);
        }
        if (withFallBackValues) {
            if (color1 == null && color2 == null) {
                color1 = Color.BLUE;
                color2 = Color.ORANGE;
            } else if (color1 == null) {
                color1 = new Color(255 - color2.getRed(), 255 - color2.getGreen(), 255 - color2.getBlue());
            } else if (color2 == null) {
                color2 = new Color(255 - color1.getRed(), 255 - color1.getGreen(), 255 - color1.getBlue());
            }
            if (alpha1 == null && alpha2 == null) {
                alpha1 = 80;
                alpha2 = 80;
            } else if (alpha1 == null) {
                alpha1 = alpha2;
            } else if (alpha2 == null) {
                alpha2 = alpha1;
            }
            if (size == null) {
                size = 10.0;
            }
        }
        if (maxAlpha != null) {
            if (alpha1 != null) {
                alpha1 = Math.min(alpha1, maxAlpha);
            }
            if (alpha2 != null) {
                alpha2 = Math.min(alpha2, maxAlpha);
            }
        }
        if (color1 != null && color2 != null && alpha1 != null && alpha2 != null && size != null && size > 0.0 && (alpha1 > 0 || alpha2 > 0)) {
            HatchQuadAreaRenderer<U> areaRenderer = new HatchQuadAreaRenderer<U>(color1, alpha1, color2, alpha2, size, emphasizeRenderer);
            return areaRenderer;
        }
        EmptyAreaRenderer<U> emptyAreaRenderer = new EmptyAreaRenderer<U>(emphasizeRenderer);
        return emptyAreaRenderer;
    }

    private <T extends RendererProperties, S extends ImmutableGeoObject, U> Renderer<T, S, U> createAreaPlainRenderer(List<Tupel<String, String>> parameters, boolean withFallBackValues, Integer maxAlpha, AreaRenderer<? extends RendererProperties, U> emphasizeRenderer) {
        Color color = null;
        Integer alpha = null;
        for (Tupel<String, String> tupel : parameters) {
            String key = tupel.getElement1();
            String value = tupel.getElement2();
            if (color == null && key.equals(PlainAreaRenderer.Parameters.COLOR.name())) {
                color = PaintUtil.extractColor(0, value);
                continue;
            }
            if (alpha != null || !key.equals(PlainAreaRenderer.Parameters.ALPHA.name())) continue;
            alpha = Integer.valueOf(value);
        }
        if (withFallBackValues) {
            if (color == null) {
                color = Color.BLUE;
            }
            if (alpha == null) {
                alpha = 80;
            }
        }
        if (maxAlpha != null && alpha != null) {
            alpha = Math.min(alpha, maxAlpha);
        }
        if (color != null && alpha != null && alpha > 0) {
            PlainAreaRenderer<U> areaRenderer = new PlainAreaRenderer<U>(color, alpha, emphasizeRenderer);
            return areaRenderer;
        }
        EmptyAreaRenderer<U> emptyAreaRenderer = new EmptyAreaRenderer<U>(emphasizeRenderer);
        return emptyAreaRenderer;
    }

    private <T extends RendererProperties, S extends ImmutableGeoObject, U> Renderer<T, S, U> createRandomAreaRenderer(List<Tupel<String, String>> parameters, ModelEnviroment modelEnviroment, boolean withFallBackValues, Integer maxAlpha, AreaRenderer<? extends RendererProperties, U> emphasizeRenderer) {
        LinkedList renderers = new LinkedList();
        Integer alphaV = null;
        for (Tupel<String, String> tupel : parameters) {
            String key = tupel.getElement1();
            String value = tupel.getElement2();
            if (alphaV != null || !key.equals(RandomAreaRenderer.Parameters.ALPHA.name())) continue;
            alphaV = Integer.valueOf(value);
        }
        for (Color color : PaintUtil.RANDOM_COLORS) {
            PlainAreaRenderer areaRenderer = new PlainAreaRenderer(color, alphaV, null);
            renderers.add(areaRenderer);
        }
        if (withFallBackValues && renderers.isEmpty()) {
            String alphaString = ModelEnviroment.getProperties().getProperty("renderer.randomArea.default.alpha");
            alphaV = 80;
            try {
                alphaV = Integer.parseInt(alphaString);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Color color : PaintUtil.RANDOM_COLORS) {
                PlainAreaRenderer areaRenderer = new PlainAreaRenderer(color, alphaV, null);
                renderers.add(areaRenderer);
            }
        }
        if (renderers.isEmpty()) {
            return null;
        }
        return new RandomAreaRenderer(renderers, emphasizeRenderer);
    }
}

