/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.filter;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.util.filter.AbstractFilterChecker;
import de.datomino.peppergis.client.util.filter.RendererFactory;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelFilterPatternSetup;
import de.datomino.peppergis.type.RendererType;
import de.datomino.peppergis.type.filter.FilterPatternParameter;
import de.datomino.peppergis.type.filter.FilterPatternRelation;
import de.datomino.peppergis.type.filter.ObjectFilter;
import de.datomino.util.geo.swing.renderer.Renderer;
import de.datomino.util.geo.swing.renderer.RendererChecker;
import java.awt.Image;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractFilterPatternSetupRendererSelektor<T extends Model, W extends Model, A extends Model, B extends Model, C extends Model, U extends Model, V extends Model, S extends Model, Z extends Model>
implements RendererChecker<W> {
    private ModelFilterPatternSetup<S, U, V, T, Z> modelFilterPatternSetup;
    private Map<Long, AbstractFilterChecker<T, W, A, B, C>> filterCheckerMap = new HashMap<Long, AbstractFilterChecker<T, W, A, B, C>>();
    private ModelEnviroment modelEnviroment;
    private Boolean showFilterDefault;
    private Set<ObjectFilter<T, AttributeValueFilterModel>> invisibleFilters;
    private Map<Long, Image> imageCache = new HashMap<Long, Image>();

    public AbstractFilterPatternSetupRendererSelektor(ModelFilterPatternSetup<S, U, V, T, Z> modelFilterPatternSetup, ModelEnviroment modelEnviroment) {
        this.modelFilterPatternSetup = modelFilterPatternSetup;
        this.modelEnviroment = modelEnviroment;
    }

    public <X> List<Renderer<?, ?, X>> getRenderers(W model) {
        LinkedList list = new LinkedList();
        for (FilterPatternRelation filterPatternRelation : this.modelFilterPatternSetup.getRelations()) {
            boolean add;
            RendererType rendererType = filterPatternRelation.getRendererType();
            String lastParameterKey = null;
            LinkedList<Tupel<String, String>> parameters = new LinkedList<Tupel<String, String>>();
            HashSet sFilters = new HashSet();
            for (FilterPatternParameter filterPatternParameter : filterPatternRelation.getFilterPatternParameter()) {
                String string = filterPatternParameter.getParameterKey();
                if (lastParameterKey != null && lastParameterKey.equals(string)) continue;
                ObjectFilter objectFilter = filterPatternParameter.getObjectFilter();
                if (objectFilter == null) {
                    parameters.add(new Tupel<String, String>(string, filterPatternParameter.getParameterValue()));
                    lastParameterKey = string;
                    continue;
                }
                AbstractFilterChecker filterChecker = this.getFilterChecker(objectFilter);
                boolean satisfiesFilter = filterChecker.satisfiesFilter(model);
                if (!satisfiesFilter) continue;
                parameters.add(new Tupel<String, String>(string, filterPatternParameter.getParameterValue()));
                lastParameterKey = string;
                sFilters.add(objectFilter);
            }
            if (sFilters.isEmpty()) {
                add = this.showFilterDefault == null || this.showFilterDefault != false;
            } else {
                add = true;
                if (this.invisibleFilters != null) {
                    for (ObjectFilter objectFilter : sFilters) {
                        if (!this.invisibleFilters.contains(objectFilter)) continue;
                        add = false;
                        break;
                    }
                }
            }
            if (!add) continue;
            list.add(this.createRenderer(rendererType, parameters));
        }
        return list;
    }

    @Override
    public boolean isToBeRendered(W model) {
        List renderers = this.getRenderers(model);
        return !renderers.isEmpty();
    }

    public AbstractFilterChecker<T, W, A, B, C> getFilterChecker(ObjectFilter<T, AttributeValueFilterModel> objectFilter) {
        AbstractFilterChecker<T, W, A, B, C> filterChecker = this.filterCheckerMap.get(((Model)objectFilter.getAttachedObject()).getId());
        if (filterChecker == null) {
            filterChecker = this.createFilterChecker(objectFilter);
            this.filterCheckerMap.put(((Model)objectFilter.getAttachedObject()).getId(), filterChecker);
        }
        return filterChecker;
    }

    protected <X, Y> Renderer<?, ?, X> createRenderer(RendererType rendererType, List<Tupel<String, String>> parameters) {
        return RendererFactory.getInstance().createRenderer(rendererType, parameters, this.modelEnviroment, this.imageCache);
    }

    protected abstract AbstractFilterChecker<T, W, A, B, C> createFilterChecker(ObjectFilter<T, AttributeValueFilterModel> var1);

    public ModelFilterPatternSetup<S, U, V, T, Z> getModelFilterPatternSetup() {
        return this.modelFilterPatternSetup;
    }

    public void setShowFilterDefault(Boolean selection) {
        this.showFilterDefault = selection;
    }

    public void setShowFilter(Set<ObjectFilter<T, AttributeValueFilterModel>> invisibleFilters) {
        this.invisibleFilters = invisibleFilters;
    }

    public void turnFilter(ObjectFilter<T, AttributeValueFilterModel> filter, boolean selected) {
        if (this.invisibleFilters == null) {
            this.invisibleFilters = new HashSet<ObjectFilter<T, AttributeValueFilterModel>>();
        }
        if (selected) {
            this.invisibleFilters.remove(filter);
        } else {
            this.invisibleFilters.add(filter);
        }
    }
}

