/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.attribute;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.type.attribute.AttributeValue;
import de.datomino.peppergis.type.attribute.AttributeValueDescriptor;
import de.datomino.peppergis.type.attribute.StaticChoiceValue;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.common.PrimitiveUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class AttributeHelper {
    public static List<Tupel<String, String>> getTupelsForPrint(Collection<? extends AttributeValueDescriptor<?, ?>> descriptors, Collection<? extends AttributeValue<?, ?, ?>> attributeValueModelAttributeWrappers) {
        ArrayList<Tupel<String, String>> list = new ArrayList<Tupel<String, String>>(descriptors.size());
        for (AttributeValueDescriptor<?, ?> descriptor : descriptors) {
            String key = descriptor.getKey();
            String value = "";
            for (AttributeValue<?, ?, ?> attributeValue : attributeValueModelAttributeWrappers) {
                if (!key.equals(attributeValue.getAttributeValueDescriptor().getKey())) continue;
                value = AttributeHelper.getTextRepresentationValue(attributeValue);
                break;
            }
            list.add(new Tupel<String, String>(StringEscapeUtils.escapeXml(descriptor.getName()), StringEscapeUtils.escapeXml(value)));
        }
        return list;
    }

    public static List<Tupel<String, String>> getTupelsForPrintFromMap(Map<Long, ? extends AttributeValue<?, ?, ?>> map, List<? extends AttributeValueDescriptor<?, ?>> descriptors) {
        ArrayList<Tupel<String, String>> list = new ArrayList<Tupel<String, String>>(descriptors.size());
        for (AttributeValueDescriptor<?, ?> descriptor : descriptors) {
            AttributeValue<?, ?, ?> attributeValue = map.get(descriptor.getId());
            String value = "";
            if (attributeValue != null) {
                value = StringUtil.nullToEmpty(AttributeHelper.getTextRepresentationValue(attributeValue));
            }
            list.add(new Tupel<String, String>(descriptor.getName(), value));
        }
        return list;
    }

    public static String getTextRepresentationValue(AttributeValue<?, ?, ?> attributeValue) {
        return AttributeHelper.getTextRepresentationValue(attributeValue, FormUtil.TIMEFORMAT);
    }

    public static String getTextRepresentationValue(AttributeValue<?, ?, ?> attributeValue, String dateFormat) {
        String value = null;
        switch (attributeValue.getAttributeValueDescriptor().getAttributeValueType()) {
            case BOOLEAN: {
                boolean bool = PrimitiveUtil.nullToFalse(attributeValue.getBooleanValue());
                value = ModelEnviroment.getMessageResolver().resolveMessage("messages.default." + (bool ? "yes" : "no"), new Serializable[0]);
                break;
            }
            case DATE: {
                Long timestamp = attributeValue.getLongValue();
                if (timestamp == null) {
                    value = "";
                    break;
                }
                Date date = new Date(timestamp);
                SimpleDateFormat f = dateFormat == null ? new SimpleDateFormat() : new SimpleDateFormat(dateFormat);
                value = f.format(date);
                break;
            }
            case INTEGER: {
                value = StringUtil.nullToEmpty(attributeValue.getIntegerValue());
                break;
            }
            case STATIC_CHOICE: {
                StaticChoiceValue<?, ?> staticChoiceValue = attributeValue.getStaticChoiceValue();
                if (staticChoiceValue == null) {
                    value = "";
                    break;
                }
                value = staticChoiceValue.getName() + " (" + staticChoiceValue.getValue() + ")";
                break;
            }
            case STRING: {
                value = StringUtil.nullToEmpty(attributeValue.getStringValue());
                break;
            }
            case TEXT: {
                value = StringUtil.nullToEmpty(attributeValue.getTextValue());
                break;
            }
            case FLOAT: {
                value = StringUtil.nullToEmpty(attributeValue.getFloatValue());
                break;
            }
        }
        return value;
    }
}

