/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.logistic.type.CalculateType;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.AbstractLineRenderer;
import de.datomino.peppergis.client.manager.util.ManagerMapUtil;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.base.ServiceTicketModel;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererRewardModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceValueHistoryModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.StopModelImpl;
import de.datomino.peppergis.client.model.tour.TimeWindowModel;
import de.datomino.peppergis.client.model.tour.TourDifficultyLevelModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.model.tour.TourPartModelImpl;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.client.util.PoiModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.StopWithImportOrderComparator;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.DelivererStatus;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.type.ServiceStatusType;
import de.datomino.peppergis.type.StopStatus;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.peppergis.util.StringComparator;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import de.datomino.util.time.TimeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.ktde.math.projection.Coordinate;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class TourModelUtil {
    public static final int ACTUAL = 1;
    public static final int PLANNED = 2;
    private static final String NOLIMIT = ModelEnviroment.getMessageResolver().resolveMessage("gui.route.noLimit", new Serializable[0]);
    private static final String FIRSTFIX = ModelEnviroment.getMessageResolver().resolveMessage("gui.route.firstFix", new Serializable[0]);
    private static final String LASTFIX = ModelEnviroment.getMessageResolver().resolveMessage("gui.route.lastFix", new Serializable[0]);
    private static final String DEPOTASFIRST = ModelEnviroment.getMessageResolver().resolveMessage("gui.route.depotAsFirst", new Serializable[0]);
    private static final String DEPOTASLAST = ModelEnviroment.getMessageResolver().resolveMessage("gui.route.depotAsLast", new Serializable[0]);
    public static final String[] OPTIMISESTARTITEMS = new String[]{NOLIMIT, FIRSTFIX, DEPOTASFIRST};
    public static final String[] OPTIMISEENDITEMS = new String[]{NOLIMIT, LASTFIX, DEPOTASLAST};
    public static final String[] CALCULATESTARTITEMS = new String[]{NOLIMIT, DEPOTASFIRST};
    public static final String[] CALCULATEENDITEMS = new String[]{NOLIMIT, DEPOTASLAST};
    public static boolean tour_weight_active = false;
    public static String tour_weight_unity = "KG";
    public static boolean tour_cost_active = false;
    public static String tour_cost_unity = "\u20ac";
    public static String tour_tablecell_pattern = "";
    public static ImageIcon icon_bad_window;
    public static String stop_amount_service_descriptor;
    public static boolean tourWeightPeakActive;
    public static Icon RED_EURO_ICON;

    public static void updatePlannedArrivalTime(Date date, TourModel tour) {
        long deviation = 0L;
        if (tour.getPlannedStartTime() != null) {
            deviation = date.getTime() - tour.getPlannedStartTime().getTime();
        }
        tour.setPlannedStartTime(date);
        TourModelUtil.updateArrivalTimeOfStops(deviation, tour, 2);
    }

    public static void updateActualArrivalTime(Date date, TourModel tour) {
        tour.setActualStartTime(date);
        long deviation = 0L;
        Date arrivalTimeOfFirstStop = tour.getTourPartAt(0).getStopAt(0).getActualTimeOfArrival();
        if (arrivalTimeOfFirstStop != null) {
            deviation = date.getTime() - arrivalTimeOfFirstStop.getTime();
            TourModelUtil.updateArrivalTimeOfStops(deviation, tour, 1);
        }
    }

    private static void updateArrivalTimeOfStops(long deviation, TourModel tour, int typ) {
        Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
        while (tourPartIter.hasNext()) {
            Iterator<StopModel> stopIter = tourPartIter.next().iterateStops();
            while (stopIter.hasNext()) {
                if (typ == 2) {
                    StopModelUtil.updateEstimatedTimeOfStop(stopIter.next(), deviation);
                    continue;
                }
                StopModelUtil.updateActualTimeOfStop(stopIter.next(), deviation);
            }
        }
    }

    public static int countStopsOfTour(TourModel tour, boolean withNullGeom, boolean ignoreStatus) {
        int sum = 0;
        for (TourPartModel tp : tour.iterableTourParts()) {
            for (StopModel s : tp.iterableStops()) {
                if (!TourModelUtil.isStopOkForCounting(s, withNullGeom, ignoreStatus)) continue;
                ++sum;
            }
        }
        return sum;
    }

    private static boolean isStopOkForCounting(StopModel s, boolean withNullGeom, boolean ignoreStatus) {
        return !(!withNullGeom && GeoUtil.isNullPoint(StopModelUtil.getGeom(s)) || !ignoreStatus && s.getStopStatus() != null && s.getStopStatus() != StopStatus.NORMAL);
    }

    public static String getStreetMileageMetersString(TourModel tour) {
        Integer streetMileage = TourModelUtil.getStreetMileageMeters(tour);
        return streetMileage == null ? "0" : ModelEnviroment.getMessageResolver().getNumberFormat().format(streetMileage.intValue());
    }

    public static Integer getStreetMileageMeters(TourModel tour) {
        StopModel lastStop = TourModelUtil.getLastStop(tour, false);
        if (lastStop == null) {
            return null;
        }
        return lastStop.getStreetMileageMetersFromTourStart();
    }

    public static String getDurationOfTourString(TourModel tour) {
        Long duration = TourModelUtil.getDurationOfTour(tour);
        return duration == null ? "00:00:00" : ClientFormUtil.getSecondTimeString(duration.doubleValue() / 1000.0);
    }

    public static Long getDurationOfTour(TourModel tour) {
        Date estimatedTimeOfArrival;
        StopModel firstStop = TourModelUtil.getFirstStop(tour, null, false);
        StopModel lastStop = TourModelUtil.getLastStop(tour, false);
        if (lastStop == null || firstStop == null || lastStop.getEstimatedTimeOfArrival() == null || firstStop.getEstimatedTimeOfArrival() == null) {
            return null;
        }
        Integer duration = lastStop.getEstimatedDurationSeconds();
        if (duration == null) {
            duration = 0;
        }
        Long lasTimeOfTour = ((estimatedTimeOfArrival = lastStop.getEstimatedTimeOfArrival()) == null ? 0L : estimatedTimeOfArrival.getTime()) + (long)duration.intValue() * 1000L;
        estimatedTimeOfArrival = firstStop.getEstimatedTimeOfArrival();
        Long firstTimeOfTour = estimatedTimeOfArrival == null ? 0L : estimatedTimeOfArrival.getTime();
        return lasTimeOfTour - firstTimeOfTour;
    }

    public static int countServicesOfTour(TourModel tour, boolean withNullGeom) {
        int sum = 0;
        Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
        while (tourPartIter.hasNext()) {
            Iterator<StopModel> stopIter = tourPartIter.next().iterateStops();
            while (stopIter.hasNext()) {
                StopModel stop = stopIter.next();
                if (!TourModelUtil.isStopOkForCounting(stop, withNullGeom, false)) continue;
                sum += stop.countServiceStopRelations();
            }
        }
        return sum;
    }

    public static void loadInfoBox(Box box, TourModel tour) {
        box.add(ClientSwingUtil.createLabelWithTextFieldFont(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfTourparts", Integer.valueOf(tour.countTourParts())), 5));
        box.add(ClientSwingUtil.createLabelWithTextFieldFont(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfStops", Integer.valueOf(TourModelUtil.countStopsOfTour(tour, false, false))), 5));
        box.add(ClientSwingUtil.createLabelWithTextFieldFont(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.length", new Serializable[]{TourModelUtil.getStreetMileageMetersString(tour)}), 5));
        box.add(ClientSwingUtil.createLabelWithTextFieldFont(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.duration", new Serializable[]{TourModelUtil.getDurationOfTourString(tour)}), 5));
        box.add(ClientSwingUtil.createLabelWithTextFieldFont(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfServices", Integer.valueOf(TourModelUtil.countServicesOfTour(tour, false))), 5));
        box.add(ClientSwingUtil.createLabelWithTextFieldFont(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.duration", new Serializable[0]) + ": " + TourModelUtil.getDurationCostString(tour), 5));
        box.add(ClientSwingUtil.createLabelWithTextFieldFont(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.distance", new Serializable[0]) + ": " + TourModelUtil.getDistanceCostString(tour), 5));
        box.add(ClientSwingUtil.createLabelWithTextFieldFont(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.sum", new Serializable[0]) + ": " + TourModelUtil.getSumCostString(tour), 5));
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public static StopModel getLastStop(TourModel tour, boolean wihtBad) {
        StopModel lastStop = null;
        if (tour != null) {
            Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
            while (tourPartIter.hasNext()) {
                Iterator<StopModel> stopIter = tourPartIter.next().iterateStops();
                while (stopIter.hasNext()) {
                    StopModel next = stopIter.next();
                    if (!wihtBad && next.getStreetMileageMetersFromTourStart() == null) continue;
                    lastStop = next;
                }
            }
        }
        return lastStop;
    }

    public static StopModel getFirstStop(TourModel tour, Set<PoiType> noTypes, boolean wihtBad) {
        StopModel firstStop = null;
        if (tour != null && tour.countTourParts() > 0) {
            Iterator<StopModel> iter = tour.getTourPartAt(0).iterateStops();
            while (iter.hasNext()) {
                firstStop = iter.next();
                if (!wihtBad && firstStop.getStreetMileageMetersFromTourStart() == null || firstStop != null && firstStop.getPoi() != null && noTypes != null && (noTypes.isEmpty() || noTypes.contains(firstStop.getPoi()))) continue;
                break;
            }
        }
        return firstStop;
    }

    public static String getDisplayForPlanTable(TourModel tour) {
        String displayContent = StringUtil.nullToEmpty(tour_tablecell_pattern).replaceAll(",", "\n");
        displayContent = displayContent.replace("%%%tourName%%%", tour.getName());
        Integer length = TourModelUtil.getStreetMileageMeters(tour);
        String lengthString = length == null ? "" : FormUtil.numberToString(length.doubleValue() / 1000.0, 1) + " KM";
        displayContent = displayContent.replace("%%%length%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.table.length", new Serializable[]{lengthString}));
        Long duration = TourModelUtil.getDurationOfTour(tour);
        String durationString = duration == null ? "" : FormUtil.getSecondTimeString(duration.doubleValue() / 1000.0);
        if ((displayContent = displayContent.replace("%%%duration%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.table.duration", new Serializable[]{durationString}))).contains("%%%weight%%%")) {
            displayContent = displayContent.replace("%%%weight%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.weight", new Serializable[0]) + ": " + TourModelUtil.getSumAttributeString(tour, "WEIGHT"));
        }
        int countServicesOfTour = Integer.MAX_VALUE;
        if (displayContent.contains("%%%countService%%%") || displayContent.contains("%%%costService%%%")) {
            countServicesOfTour = TourModelUtil.countServicesOfTour(tour, false);
        }
        Double sumCost = 0.0;
        if (displayContent.contains("%%%cost%%%") || displayContent.contains("%%%costStop%%%") || displayContent.contains("%%%costAmount%%%") || displayContent.contains("%%%costService%%%")) {
            sumCost = TourModelUtil.sumCost(tour);
        }
        String costPerService = countServicesOfTour == 0 ? "" : FormUtil.numberToString(sumCost / (double)countServicesOfTour, 2) + " " + tour_cost_unity;
        int countStopsOfTour = displayContent.contains("%%%costStop%%%") ? TourModelUtil.countStopsOfTour(tour, false, false) : 0;
        String costPerStop = countStopsOfTour == 0 ? "" : FormUtil.numberToString(sumCost / (double)countStopsOfTour, 2) + " " + tour_cost_unity;
        int countAmountOfTour = displayContent.contains("%%%costAmount%%%") ? TourModelUtil.countAmountOfTour(tour, false) : 0;
        String costPerAmount = countAmountOfTour == 0 ? "" : FormUtil.numberToString(sumCost / (double)countAmountOfTour, 2) + " " + tour_cost_unity;
        displayContent = displayContent.replace("%%%cost%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.sum", new Serializable[0]) + ": " + FormUtil.numberToString(sumCost, 2) + " " + tour_cost_unity);
        displayContent = displayContent.replace("%%%costStop%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.stop", new Serializable[0]) + ": " + costPerStop);
        displayContent = displayContent.replace("%%%costAmount%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.amount", new Serializable[0]) + ": " + costPerAmount);
        displayContent = displayContent.replace("%%%costService%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.service", new Serializable[0]) + ": " + costPerService);
        if ((displayContent = displayContent.replace("%%%countService%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfServices", Integer.valueOf(countServicesOfTour)))).contains("%%%stopDuration%%%")) {
            displayContent = displayContent.replace("%%%stopDuration%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.stopDuration", new Serializable[0]) + ": " + FormUtil.getSecondTimeString(TourModelUtil.sumStopDuration(tour)));
        }
        if (displayContent.contains("%%%timewindowConflict%%%")) {
            String conflictString = TourModelUtil.isBreakTimeWindows(tour) ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.yes", new Serializable[0]) : ModelEnviroment.getMessageResolver().resolveMessage("messages.default.no", new Serializable[0]);
            displayContent = displayContent.replace("%%%timewindowConflict%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.timewindow.conflict", new Serializable[0]) + ": " + conflictString);
        }
        if (displayContent.contains("%%%difficultyLevel%%%") || displayContent.contains("%%%delivererStatus%%%")) {
            String difficultyLevelString = "";
            String delivererStatusString = "";
            DelivererModel deliverer = tour.getDeliverer();
            if (deliverer != null) {
                Double currentFactor = DelivererModelUtil.getCurrentFactor(deliverer);
                difficultyLevelString = currentFactor == null ? "100" : FormUtil.numberToString(currentFactor, 1);
                Date date = tour.getPlannedStartTime();
                DelivererStatus status = date == null ? DelivererModelUtil.getStatus(deliverer, new Date()) : DelivererModelUtil.getStatus(deliverer, date);
                delivererStatusString = ModelEnviroment.getMessageResolver().resolveMessageForEnum(status);
            }
            displayContent = displayContent.replace("%%%difficultyLevel%%%", ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.difficultyLevel", new Serializable[0]) + ": " + difficultyLevelString);
            displayContent = displayContent.replace("%%%delivererStatus%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.status", new Serializable[0]) + ": " + delivererStatusString);
        }
        if (displayContent.contains("weightPeak")) {
            displayContent = displayContent.replace("%%%weightPeak%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.weightPeak", new Serializable[0]) + ": " + TourModelUtil.getWeightPeak(tour));
        }
        if (displayContent.contains("tourDifficultyLevel")) {
            String tourDlString = "";
            for (TourPartModel part : tour.iterableTourParts()) {
                double dl;
                TourDifficultyLevelModel dlModel = part.getDifficultyLevel();
                double d = dl = dlModel == null || dlModel.getValue() == null ? 100.0 : dlModel.getValue();
                if (tourDlString.length() != 0) {
                    tourDlString = tourDlString + "/";
                }
                tourDlString = tourDlString + ClientFormUtil.getNumberString(dl);
            }
            displayContent = displayContent.replace("%%%tourDifficultyLevel%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.difficultyLevel", new Serializable[0]) + ": " + tourDlString);
        }
        return displayContent;
    }

    private static int countAmountOfTour(TourModel tour, boolean withNullGeom) {
        int sum = 0;
        for (TourPartModel tp : tour.iterableTourParts()) {
            for (StopModel s : tp.iterableStops()) {
                if (!TourModelUtil.isStopOkForCounting(s, withNullGeom, false)) continue;
                Object value = StopModelUtil.getServiceValue(s, stop_amount_service_descriptor, AttributeValueType.INTEGER);
                sum += value == null ? 0 : (Integer)value;
            }
        }
        return sum;
    }

    private static int sumStopDuration(TourModel tour) {
        int sum = 0;
        for (StopModel stop : TourModelUtil.getAllStops(tour, false)) {
            if (stop.getStopStatus() != null && stop.getStopStatus() != StopStatus.NORMAL) continue;
            Integer estimatedDurationSeconds = stop.getEstimatedDurationSeconds();
            sum += estimatedDurationSeconds == null ? 0 : estimatedDurationSeconds;
        }
        return sum;
    }

    private static boolean isBreakTimeWindows(TourModel tour) {
        for (StopModel stop : TourModelUtil.getAllStops(tour, false)) {
            if (!StopModelUtil.hasBadTimeWindow(stop)) continue;
            return true;
        }
        return false;
    }

    public static String getSumAttributeString(TourModel tour, String key) {
        if (tour_weight_active) {
            return FormUtil.numberToString(TourModelUtil.sumAttribute(tour, key), 1) + " " + tour_weight_unity;
        }
        return "";
    }

    private static Double sumAttribute(TourModel tour, String key) {
        Double sum = 0.0;
        for (TourPartModel tourPart : tour.iterableTourParts()) {
            for (StopModel stop : tourPart.iterableStops()) {
                if (stop.getStopStatus() != null && stop.getStopStatus() != StopStatus.NORMAL) continue;
                Double weight = StopModelUtil.getAttributeSum(stop, key);
                sum = sum + (weight == null ? 0.0 : weight);
            }
        }
        return sum;
    }

    private static String getDurationCostString(TourModel tour) {
        if (tour_cost_active) {
            return FormUtil.numberToString(TourModelUtil.durationCost(tour), 2) + " " + tour_cost_unity;
        }
        return "";
    }

    private static double durationCost(TourModel tour) {
        DelivererRewardModel reward;
        double durationCost = 0.0;
        DelivererModel deliverer = tour == null ? null : tour.getDeliverer();
        DelivererRewardModel delivererRewardModel = reward = deliverer == null ? null : deliverer.getReward();
        if (reward != null) {
            double hourReward = reward.getHourReward() == null ? 0.0 : reward.getHourReward();
            Long duration = TourModelUtil.getDurationOfTour(tour);
            durationCost = hourReward * ((duration == null ? 0.0 : duration.doubleValue()) / 1000.0 / 3600.0);
        }
        return durationCost;
    }

    private static String getDistanceCostString(TourModel tour) {
        if (tour_cost_active) {
            return FormUtil.numberToString(TourModelUtil.distanceCost(tour), 2) + " " + tour_cost_unity;
        }
        return "";
    }

    private static double distanceCost(TourModel tour) {
        DelivererRewardModel reward;
        double distanceCost = 0.0;
        DelivererModel deliverer = tour == null ? null : tour.getDeliverer();
        DelivererRewardModel delivererRewardModel = reward = deliverer == null ? null : deliverer.getReward();
        if (reward != null) {
            double kmReward = reward.getKilometerReward() == null ? 0.0 : reward.getKilometerReward();
            Integer streetMileage = TourModelUtil.getStreetMileageMeters(tour);
            distanceCost += kmReward * (streetMileage == null ? 0.0 : streetMileage.doubleValue() / 1000.0);
        }
        return distanceCost;
    }

    public static String getSumCostString(TourModel tour) {
        if (tour_cost_active) {
            return FormUtil.numberToString(TourModelUtil.sumCost(tour), 2) + " " + tour_cost_unity;
        }
        return "";
    }

    private static Double sumCost(TourModel tour) {
        return TourModelUtil.distanceCost(tour) + TourModelUtil.durationCost(tour);
    }

    public static String getDisplayForLegend(TourModel tour) {
        String pattern = ModelEnviroment.getProperties().getProperty("tourmanager.legende.tourInfo.pattern");
        String timeFormat = ModelEnviroment.getProperties().getProperty("tourmanager.legende.tourInfo.dateFormat");
        timeFormat = StringUtil.isBlank(timeFormat) ? FormUtil.TIMEFORMAT : (timeFormat.equals("DATEFORMAT") ? FormUtil.DATEFORMAT : (timeFormat.equals("CLOCKFORMAT") ? FormUtil.CLOCKFORMAT : FormUtil.TIMEFORMAT));
        String timeString = tour.getPlannedStartTime() == null ? "" : new SimpleDateFormat(timeFormat).format(tour.getPlannedStartTime());
        String plannedStartTime = ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.plannedStartTime", new Serializable[0]) + ": " + timeString;
        String duration = ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.duration", new Serializable[]{TourModelUtil.getDurationOfTourString(tour)});
        String length = ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.length", new Serializable[]{TourModelUtil.getStreetMileageMetersString(tour)});
        String weight = "";
        if (tour_weight_active) {
            weight = ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.weight", new Serializable[0]) + ": " + TourModelUtil.getSumAttributeString(tour, "WEIGHT");
        }
        String cost = "";
        if (tour_cost_active) {
            cost = ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.sum", new Serializable[0]) + ": " + TourModelUtil.getSumCostString(tour);
        }
        String weightPeak = "";
        if (tourWeightPeakActive) {
            weightPeak = ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.weightPeak", new Serializable[0]) + ": " + TourModelUtil.getWeightPeak(tour);
        }
        return pattern.replaceAll("%%%name%%%", tour.getName()).replaceAll("%%%plannedStartTime%%%", plannedStartTime).replaceAll("%%%duration%%%", duration).replaceAll("%%%length%%%", length).replaceAll("%%%weight%%%", weight).replaceAll("%%%cost%%%", cost).replaceAll("%%%weightPeak%%%", weightPeak);
    }

    public static String getWeightPeak(TourModel tour) {
        if (tourWeightPeakActive) {
            double max;
            Double startWeight = tour.getStartWeight();
            if (startWeight == null) {
                startWeight = TourModelUtil.sumAttribute(tour, StopModelUtil.UNLOADING_WEIGHT_KEY);
            }
            double current = max = startWeight == null ? 0.0 : startWeight;
            for (TourPartModel tp : tour.iterableTourParts()) {
                for (StopModel stop : tp.iterableStops()) {
                    Double unload;
                    Double load = StopModelUtil.getAttributeSum(stop, StopModelUtil.LOADING_WEIGHT_KEY);
                    if (load == null) {
                        load = 0.0;
                    }
                    if ((unload = StopModelUtil.getAttributeSum(stop, StopModelUtil.UNLOADING_WEIGHT_KEY)) == null) {
                        unload = 0.0;
                    }
                    if (!(max < (current += (load = Double.valueOf(load - unload)).doubleValue()))) continue;
                    max = current;
                }
            }
            return FormUtil.numberToString(max, 2) + " " + tour_weight_unity;
        }
        return "";
    }

    public static String getTourInformation(TourModel tour, String pattern) {
        String info = pattern == null ? "" : pattern;
        info = info.replaceAll("%%%name%%%", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]) + ": " + tour.getName());
        info = info.replaceAll("%%%deliverer%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.deliOrTech", new Serializable[0]) + ": " + DelivererModelUtil.getDisplayString(tour.getDeliverer()));
        info = info.replaceAll("%%%plannedStartTime%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.plannedStartTime", new Serializable[0]) + ": " + ClientFormUtil.dateToString(tour.getPlannedStartTime()));
        info = info.replaceAll("%%%duration%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.duration", new Serializable[]{TourModelUtil.getDurationOfTourString(tour)}));
        info = info.replaceAll("%%%distance%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.length", new Serializable[]{TourModelUtil.getStreetMileageMetersString(tour)}));
        info = info.replaceAll("%%%numberOfTourparts%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfTourparts", Integer.valueOf(tour.countTourParts())));
        info = info.contains("%%%numberOfServices%%%") ? info.replaceAll("%%%numberOfServices%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfServices", Integer.valueOf(TourModelUtil.countServicesOfTour(tour, false)))) : info;
        info = info.replaceAll("%%%numberOfStops%%%", ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfStops", Integer.valueOf(TourModelUtil.countStopsOfTour(tour, false, false))));
        String[] ss = info.split("\n");
        info = ss[0];
        for (int i = 1; i < ss.length; ++i) {
            if (StringUtil.isBlank(ss[i]) || ss[i].contains("%%%")) continue;
            info = info + "\n" + ss[i];
        }
        return info;
    }

    public static void sortWithImportOrder(TourPartModel tourPart) {
        List<StopModel> stops = TourModelUtil.getAllStopsInTourPart(tourPart, true);
        StopModel pickPoint = null;
        if (tourPart.countStops() != 0 && tourPart.getStopAt(0).getPoi() != null && tourPart.getStopAt(0).getPoi().getPoiType() == PoiType.PICK_POINT) {
            pickPoint = tourPart.getStopAt(0);
            stops.remove(pickPoint);
        }
        StopWithImportOrderComparator comparator = new StopWithImportOrderComparator();
        Collections.sort(stops, comparator);
        int sortOrder = 0;
        if (pickPoint != null) {
            TourModelUtil.insertStopWithSortOrder(tourPart, sortOrder, pickPoint);
            ++sortOrder;
        }
        for (StopModel stop : stops) {
            TourModelUtil.insertStopWithSortOrder(tourPart, sortOrder, stop);
            ++sortOrder;
        }
    }

    private static void insertStopWithSortOrder(TourPartModel tourPart, int sortOrder, StopModel stop) {
        tourPart.removeStop(stop);
        stop.setSortOrder(sortOrder);
        stop.setStreetMileageMetersFromTourStart(null);
        stop.setEstimatedTimeOfArrival(null);
        stop.setStopStatus(null);
        tourPart.insertStop(stop, sortOrder);
    }

    public static StopModel getStopWithIndex(TourModel tour, int index) {
        if (tour == null) {
            return null;
        }
        int sum = 0;
        Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
        while (tourPartIter.hasNext()) {
            Iterator<StopModel> stopIter = tourPartIter.next().iterateStops();
            while (stopIter.hasNext()) {
                if (++sum == index) {
                    return stopIter.next();
                }
                stopIter.next();
            }
        }
        return null;
    }

    public static List<StopModel> getAllStops(TourModel tour, boolean withNullGeom) {
        ArrayList<StopModel> allStops = new ArrayList<StopModel>();
        Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
        while (tourPartIter.hasNext()) {
            allStops.addAll(TourModelUtil.getAllStopsInTourPart(tourPartIter.next(), withNullGeom));
        }
        return allStops;
    }

    public static List<StopModel> getAllStopsInTourPart(TourPartModel tourPart, boolean withNullGeom) {
        ArrayList<StopModel> stops = new ArrayList<StopModel>(tourPart.countStops());
        Iterator<StopModel> stopIter = tourPart.iterateStops();
        while (stopIter.hasNext()) {
            StopModel stop = stopIter.next();
            if (!withNullGeom && GeoUtil.isNullPoint(StopModelUtil.getGeom(stop))) continue;
            stops.add(stop);
        }
        return stops;
    }

    public static void removeEndPois(TourModel tour, Set<PoiType> removedPoiTypes) {
        boolean removed = true;
        while (removed) {
            StopModel lastStop = TourModelUtil.getLastStop(tour, true);
            if (lastStop != null && lastStop.getPoi() != null && removedPoiTypes.contains((Object)lastStop.getPoi().getPoiType())) {
                tour.getTourPartAt(tour.countTourParts() - 1).removeStop(lastStop);
                for (TimeWindowModel timeWindow : lastStop.iterableTimeWindows()) {
                    if (timeWindow == null) continue;
                    timeWindow.delete();
                }
                lastStop.delete();
                continue;
            }
            removed = false;
        }
    }

    public static void removeStartPois(TourModel tour, Set<PoiType> removedPoiTypes) {
        boolean removed = true;
        while (removed) {
            StopModel firstStop = TourModelUtil.getFirstStop(tour, null, true);
            if (firstStop != null && firstStop.getPoi() != null && firstStop.getPoi().getPoiType() == PoiType.DELIVERER_LOCATION) {
                tour.getTourPartAt(0).removeStopAt(0);
                for (TimeWindowModel timeWindow : firstStop.iterableTimeWindows()) {
                    timeWindow.delete();
                }
                firstStop.delete();
                continue;
            }
            removed = false;
        }
    }

    private static void removeUnloadingPoint(TourModel tour) {
        Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
        while (tourPartIter.hasNext()) {
            TourPartModel tourPart = tourPartIter.next();
            Iterator<StopModel> stopIter = tourPart.iterateStops();
            while (stopIter.hasNext()) {
                StopModel stop = stopIter.next();
                if (stop == null || stop.getPoi() == null || stop.getPoi().getPoiType() != PoiType.PICK_POINT) continue;
                PoiModel poi = stop.getPoi();
                tourPart.removeStop(stop);
                stop.delete();
                poi.delete();
                stopIter = tourPart.iterateStops();
            }
        }
    }

    private static void addEndPois(TourModel tour, PoiModel delivererPoi) {
        if (delivererPoi != null) {
            StopModel stop = TourModelUtil.createNewStopFromPoi(tour, delivererPoi, false);
            int countOfTourParts = tour.countTourParts();
            TourPartModel lastTourPart = tour.getTourPartAt(countOfTourParts - 1);
            lastTourPart.addStop(stop);
        }
    }

    private static void addStartPois(TourModel tour, PoiModel devlivererPoi, PoiModel unloadingPoi) {
        StopModel firstStop = TourModelUtil.getFirstStop(tour, null, true);
        if (unloadingPoi != null && unloadingPoi.getPoiType() == PoiType.PICK_POINT) {
            TourPartModel firstTourPart = tour.getTourPartAt(0);
            if (firstStop != null && firstStop.getPoi() != null && firstStop.getPoi().getPoiType() == PoiType.PICK_POINT) {
                if (!firstStop.getPoi().getLocation().equals(unloadingPoi.getLocation()) && !firstStop.getPoi().getPoiNumber().equals(unloadingPoi.getPoiNumber())) {
                    firstTourPart.insertStop(TourModelUtil.createNewStopFromPoi(tour, unloadingPoi, true), 1);
                }
            } else {
                firstTourPart.insertStop(TourModelUtil.createNewStopFromPoi(tour, unloadingPoi, true), 0);
            }
        }
        if (devlivererPoi != null) {
            StopModel stop = TourModelUtil.createNewStopFromPoi(tour, devlivererPoi, true);
            TourPartModel firstTourPart = tour.getTourPartAt(0);
            firstTourPart.insertStop(stop, 0);
        }
    }

    public static StopModel createNewStopFromPoi(TourModel tour, PoiModel poi, boolean isStart) {
        StopModelImpl stop = new StopModelImpl();
        stop.setName(poi.getName());
        stop.setDelivererInformation(poi.getPoiNumber());
        stop.setLocation(poi.getLocation());
        if (poi.getPoiType() != PoiType.DELIVERER_LOCATION) {
            stop.setPoi(PoiModelUtil.createUnloadingPoi(poi));
        } else {
            stop.setPoi(poi);
        }
        stop.setEstimatedDurationSeconds(0);
        return stop;
    }

    @Deprecated
    public static Double getExpense(TourModel tour, double priceOfMeter, double priceOfMinute) {
        Double expense = null;
        Integer distance = TourModelUtil.getStreetMileageMeters(tour);
        Long duration = TourModelUtil.getDurationOfTour(tour);
        if (distance != null && duration != null) {
            expense = (double)distance.intValue() * priceOfMeter + (double)duration.longValue() * priceOfMinute / 60000.0;
        }
        return expense;
    }

    public static Set<Coordinate> getAreaRectangle(Set<TourModel> tours, boolean withPoi, ModelEnviroment modelEnviroment) {
        HashSet<ImmutablePoint> points = new HashSet<ImmutablePoint>();
        for (TourModel tour : tours) {
            Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
            while (tourPartIter.hasNext()) {
                Iterator<StopModel> stopIter = tourPartIter.next().iterateStops();
                while (stopIter.hasNext()) {
                    ImmutablePoint geom;
                    StopModel stop = stopIter.next();
                    if (!withPoi && stop.getPoi() != null || GeoUtil.isNullPoint(geom = StopModelUtil.getGeom(stop))) continue;
                    points.add(geom);
                }
            }
        }
        for (TourModel tour : tours) {
            List<Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>> lineStringOfTour = ManagerMapUtil.getLineStringOfTour(tour, withPoi, modelEnviroment);
            for (Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType> geoObject : lineStringOfTour) {
                if (geoObject == null || geoObject.getElement1() == null) continue;
                List<ImmutablePoint> coordinates = geoObject.getElement1().getCoordinates();
                for (ImmutablePoint ip : coordinates) {
                    if (GeoUtil.isNullPoint(ip)) continue;
                    points.add(ip);
                }
            }
        }
        return GeoUtils.getAreaRectangle(points);
    }

    public static void adaptCurrentCalculateType(TourModel tour, PoiModel delivererPoi, PoiModel unloadingPoi, CalculateType type) {
        TourModelUtil.removeStartPois(tour, CollectionUtil.buildHashSet(PoiType.DELIVERER_LOCATION));
        TourModelUtil.removeEndPois(tour, CollectionUtil.buildHashSet(PoiType.DELIVERER_LOCATION));
        TourModelUtil.removeUnloadingPoint(tour);
        TourModelUtil.checkPickPoint(tour);
        if (type.equals(CalculateType.NONFIX)) {
            TourModelUtil.addStartPois(tour, null, unloadingPoi);
        } else if (type.equals(CalculateType.STARTWITHPOI)) {
            TourModelUtil.addStartPois(tour, delivererPoi, unloadingPoi);
        } else if (type.equals(CalculateType.ENDWITHPOI)) {
            TourModelUtil.addStartPois(tour, null, unloadingPoi);
            TourModelUtil.addEndPois(tour, delivererPoi);
        } else {
            TourModelUtil.addStartPois(tour, delivererPoi, unloadingPoi);
            TourModelUtil.addEndPois(tour, delivererPoi);
        }
    }

    private static void checkPickPoint(TourModel tour) {
        Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
        while (tourPartIter.hasNext()) {
            TourPartModel tourPart = tourPartIter.next();
            StopModel pickPoint = null;
            Iterator<StopModel> stopIter = tourPart.iterateStops();
            while (stopIter.hasNext()) {
                StopModel stop = stopIter.next();
                if (stop == null || stop.getPoi() == null || stop.getPoi().getPoiType() != PoiType.PICK_POINT) continue;
                if (pickPoint == null) {
                    pickPoint = stop;
                }
                tourPart.removeStop(pickPoint);
                stopIter = tourPart.iterateStops();
            }
            if (pickPoint == null) continue;
            TourModelUtil.insertStopWithSortOrder(tourPart, 0, pickPoint);
        }
    }

    public static OptimizationType adaptTourForOptimization(TourModel tour, PoiModel delivererPoi, PoiModel unloadingPoi, OptimizationType type) {
        TourModelUtil.removeStartPois(tour, CollectionUtil.buildHashSet(PoiType.DELIVERER_LOCATION));
        TourModelUtil.removeEndPois(tour, CollectionUtil.buildHashSet(PoiType.DELIVERER_LOCATION));
        TourModelUtil.removeUnloadingPoint(tour);
        TourModelUtil.checkPickPoint(tour);
        switch (type) {
            case NONFIX: {
                TourModelUtil.addStartPois(tour, null, unloadingPoi);
                break;
            }
            case STARTPOINTFIX: {
                TourModelUtil.addStartPois(tour, null, unloadingPoi);
                break;
            }
            case ENDPOINTFIX: {
                TourModelUtil.addStartPois(tour, null, unloadingPoi);
                break;
            }
            case BOTHPOINTFIX: {
                TourModelUtil.addStartPois(tour, null, unloadingPoi);
                break;
            }
            case STARTWITHPOI: {
                TourModelUtil.addStartPois(tour, delivererPoi, unloadingPoi);
                break;
            }
            case STARTWITHPOIENDFIX: {
                TourModelUtil.addStartPois(tour, delivererPoi, unloadingPoi);
                break;
            }
            case ENDWITHPOI: {
                TourModelUtil.addStartPois(tour, null, unloadingPoi);
                TourModelUtil.addEndPois(tour, delivererPoi);
                break;
            }
            case STARTFIXENDWITHPOI: {
                TourModelUtil.addStartPois(tour, null, unloadingPoi);
                TourModelUtil.addEndPois(tour, delivererPoi);
                break;
            }
            case BOTHWITHPOI: {
                TourModelUtil.addStartPois(tour, delivererPoi, unloadingPoi);
                TourModelUtil.addEndPois(tour, delivererPoi);
                break;
            }
        }
        return type;
    }

    public static PoiModel getDelivererPoi(TourModel tour, TourCaller tourCaller) {
        List<PoiModel> pois;
        PoiModel delivererPoi = null;
        DelivererModel deliverer = tour.getDeliverer();
        PoiModel poiModel = delivererPoi = deliverer == null ? null : deliverer.getPoi();
        if (delivererPoi == null) {
            BranchModel branch = deliverer == null ? null : deliverer.getBranch();
            PoiModel poiModel2 = delivererPoi = branch == null ? null : branch.getPoi();
        }
        if (delivererPoi == null && (pois = tourCaller.fetchPoisWithTypes(CollectionUtil.buildHashSet(PoiType.DELIVERER_LOCATION))) != null && !pois.isEmpty()) {
            for (PoiModel poi : pois) {
                if (poi == null || delivererPoi != null && (poi.getId() == null || poi.getId() >= delivererPoi.getId())) continue;
                delivererPoi = poi;
            }
        }
        return delivererPoi;
    }

    public static void deleteTourComplete(TourModel tour, boolean complete) {
        for (TourPartModel tourPart : tour.iterableTourParts()) {
            if (complete) {
                for (StopModel stop : tourPart.iterableStops()) {
                    for (ServiceTicketStopRelationModel serviceTicketStopRelation : stop.iterableServiceStopRelations()) {
                        ServiceTicketModel serviceTicket = serviceTicketStopRelation.getServiceTicket();
                        serviceTicket.delete();
                        for (ServiceValueModel serviceValue : serviceTicketStopRelation.iterableServiceValues()) {
                            serviceValue.delete();
                        }
                        for (ServiceValueHistoryModel serviceValueHistoryModel : serviceTicketStopRelation.iterableServiceValueHistoryEntries()) {
                            serviceValueHistoryModel.delete();
                        }
                        serviceTicketStopRelation.delete();
                    }
                    for (TimeWindowModel timeWindow : stop.iterableTimeWindows()) {
                        timeWindow.delete();
                    }
                    stop.delete();
                }
            } else {
                for (int i = tourPart.countStops() - 1; i >= 0; --i) {
                    tourPart.removeStopAt(i);
                }
            }
            tourPart.delete();
        }
        tour.delete();
    }

    public static Map<TourPartModel, Collection<StopModel>> getStopsWithServiceStatus(TourModel tour, Set<ServiceStatusType> types) {
        HashMap<TourPartModel, Collection<StopModel>> map = new HashMap<TourPartModel, Collection<StopModel>>();
        Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
        while (tourPartIter.hasNext()) {
            TourPartModel tourPartModel = tourPartIter.next();
            HashSet<StopModel> stops = new HashSet<StopModel>();
            map.put(tourPartModel, stops);
            Iterator<StopModel> stopIter = tourPartModel.iterateStops();
            while (stopIter.hasNext()) {
                StopModel stop = stopIter.next();
                ServiceStatusType result = StopModelUtil.getSummarizedServiceStatusType(stop);
                if (!types.contains((Object)result)) continue;
                stops.add(stop);
            }
        }
        return map;
    }

    public static Date getPlannedEndTime(TourModel tour) {
        StopModel lastStop = TourModelUtil.getLastStop(tour, false);
        if (lastStop == null || lastStop.getEstimatedTimeOfArrival() == null) {
            return null;
        }
        int estimatedDurationSeconds = lastStop.getEstimatedDurationSeconds() == null ? 0 : lastStop.getEstimatedDurationSeconds();
        return TimeUtil.add(lastStop.getEstimatedTimeOfArrival(), 13, estimatedDurationSeconds);
    }

    public static Date getActualEndTime(TourModel tour) {
        StopModel lastStop = TourModelUtil.getLastStop(tour, false);
        if (lastStop.getActualTimeOfArrival() == null) {
            return null;
        }
        int actualDurationSeconds = lastStop.getActualDurationSeconds() == null ? 0 : lastStop.getActualDurationSeconds();
        return TimeUtil.add(lastStop.getActualTimeOfArrival(), 13, actualDurationSeconds);
    }

    public static boolean hasBadTimeWindow(TourModel tour) {
        boolean b = false;
        for (StopModel stop : TourModelUtil.getAllStops(tour, false)) {
            if (!StopModelUtil.hasBadTimeWindow(stop)) continue;
            b = true;
            break;
        }
        return b;
    }

    public static TourModel cutTourWithBadTw(TourModel tour, ModelEnviroment modelEnviroment) {
        ArrayList<StopModel> badTwStops = new ArrayList<StopModel>();
        for (TourPartModel tourPart : tour.iterableTourParts()) {
            for (StopModel stop : tourPart.iterableStops()) {
                if (!GeoUtil.isNullPoint(StopModelUtil.getGeom(stop)) && (stop.getStopStatus() == null || stop.getStopStatus() != StopStatus.BAD_TIME_WINDOW)) continue;
                badTwStops.add(stop);
            }
        }
        int i = 0;
        String prefix = tour.getName() + "_";
        for (TourModel dirtyModel : modelEnviroment.getModelCache().getCachedModels(TourModel.class)) {
            String n = dirtyModel.getName();
            if (!n.startsWith(prefix)) continue;
            try {
                i = Math.max(i, Integer.parseInt(n.replace(prefix, "")));
            }
            catch (Exception exception) {}
        }
        TourCaller tourCaller = modelEnviroment.getAllCaller().getTourCaller();
        String newTourName = tourCaller.generateTourName(prefix.length() + 3, prefix, i);
        TourModelImpl newTour = new TourModelImpl();
        newTour.setName(newTourName);
        TourPartModelImpl newTourPart = new TourPartModelImpl();
        newTour.addTourPart(newTourPart);
        for (StopModel stop : badTwStops) {
            newTourPart.addStop(stop);
        }
        return newTour;
    }

    public static List<ServiceModel> getServices(TourModel tour) {
        HashSet<ServiceModel> services = new HashSet<ServiceModel>();
        for (TourPartModel part : tour.iterableTourParts()) {
            for (StopModel stop : part.iterableStops()) {
                for (ServiceTicketStopRelationModel rel : stop.iterableServiceStopRelations()) {
                    services.add(rel.getServiceTicket().getService());
                }
            }
        }
        ArrayList<ServiceModel> list = new ArrayList<ServiceModel>(services);
        Collections.sort(list, new StringComparator<ServiceModel>(false){

            @Override
            protected String getString(ServiceModel o) {
                return o.getServiceNumber();
            }
        });
        return list;
    }

    public static List<OfferModel> getOffers(TourModel tour) {
        HashSet<OfferModel> offers = new HashSet<OfferModel>();
        for (TourPartModel part : tour.iterableTourParts()) {
            for (StopModel stop : part.iterableStops()) {
                for (ServiceTicketStopRelationModel rel : stop.iterableServiceStopRelations()) {
                    CustomerModel customer;
                    CustomerModel customerModel = customer = rel.getServiceTicket() == null ? null : rel.getServiceTicket().getCustomer();
                    if (customer == null) continue;
                    for (OfferModel offer : customer.iterableOffers()) {
                        offers.add(offer);
                    }
                }
            }
        }
        ArrayList<OfferModel> list = new ArrayList<OfferModel>(offers);
        Collections.sort(list, new StringComparator<OfferModel>(false){

            @Override
            protected String getString(OfferModel o) {
                return o.getOfferNumber();
            }
        });
        return list;
    }

    public static Double getDifficultyLevelValue(TourModel tour, TourPartModel tourPartModel, Double defaultValue) {
        Double difficultyLevelValue = null;
        TourDifficultyLevelModel difficultyLevel = tourPartModel.getDifficultyLevel();
        if (difficultyLevel == null) {
            DelivererModel deliverer = tour.getDeliverer();
            if (deliverer != null) {
                difficultyLevelValue = DelivererModelUtil.getCurrentFactor(deliverer);
            }
        } else {
            difficultyLevelValue = difficultyLevel.getValue();
        }
        return difficultyLevelValue == null ? defaultValue : difficultyLevelValue;
    }

    static {
        stop_amount_service_descriptor = "STOP_AMOUNT";
        tourWeightPeakActive = false;
        try {
            tour_tablecell_pattern = ModelEnviroment.getProperties().getProperty("tour.tablecell.pattern");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String s;
            tour_weight_active = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("tour.rendering.weight.sum.active"));
            if ((tour_weight_active |= tour_tablecell_pattern.contains("%%%weight%%%")) && tour_tablecell_pattern.indexOf("%%%weight%%%") == -1) {
                tour_tablecell_pattern = tour_tablecell_pattern + ",%%%weight%%%";
            }
            if (!StringUtil.isBlank(s = ModelEnviroment.getProperties().getProperty("tour.rendering.weight.unity"))) {
                tour_weight_unity = s;
            }
            if (tour_tablecell_pattern.contains("%%%countService%%%")) {
                tour_weight_active = true;
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        try {
            tourWeightPeakActive = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("tour.rendering.weightPeak.active"));
            if ((tourWeightPeakActive |= tour_tablecell_pattern.contains("%%%weightPeak%%%")) && tour_tablecell_pattern.indexOf("%%%weightPeak%%%") == -1) {
                tour_tablecell_pattern = tour_tablecell_pattern + ",%%%weightPeak%%%";
            }
            if (!StringUtil.isBlank(s = ModelEnviroment.getProperties().getProperty("tour.rendering.weight.unity"))) {
                tour_weight_unity = s;
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        try {
            tour_cost_active = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("tour.rendering.cost.sum.active"));
            tour_cost_active = tour_tablecell_pattern.contains("%%%cost%%%");
            if (tour_cost_active && tour_tablecell_pattern.indexOf("%%%cost%%%") == -1) {
                tour_tablecell_pattern = tour_tablecell_pattern + ",%%%cost%%%";
            }
            if (!StringUtil.isBlank(s = ModelEnviroment.getProperties().getProperty("tour.rendering.cost.unity"))) {
                tour_cost_unity = s;
            }
            if (tour_tablecell_pattern.contains("%%%costService%%%")) {
                tour_cost_active = true;
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        try {
            BufferedImage orig = ImageIO.read(TourModelUtil.class.getResourceAsStream("/images/clock-black.png"));
            Image scaled = orig.getScaledInstance(15, 15, 1);
            icon_bad_window = new ImageIcon(scaled);
        }
        catch (Exception orig) {
            // empty catch block
        }
        try {
            String value = ModelEnviroment.getProperties().getProperty("stop.amount.service.descriptor");
            if (value != null) {
                stop_amount_service_descriptor = value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        RED_EURO_ICON = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setPaint(Color.RED);
                g2d.drawString(tour_cost_unity, 4, 12);
            }

            @Override
            public int getIconWidth() {
                return 20;
            }

            @Override
            public int getIconHeight() {
                return 20;
            }
        };
    }
}

