/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.util.FormUtil;
import org.ktde.util.StringUtil;

public class StreetModelUtil {
    public static String getStreetString(StreetModel street) {
        PostcodeDistrictRelationModel postcodeDistrictRelation;
        CityModel city = null;
        DistrictModel district = null;
        PostcodeModel postcode = null;
        if (street != null && (postcodeDistrictRelation = street.getPostcodeDistrictRelation()) != null) {
            district = postcodeDistrictRelation.getDistrict();
            postcode = postcodeDistrictRelation.getPostcode();
            if (district != null) {
                city = district.getCity();
            }
        }
        String streetName = street == null ? null : street.getName();
        String postcodeName = postcode == null ? null : postcode.getName();
        String districtName = district == null ? null : district.getName();
        String cityName = city == null ? null : city.getName();
        String countryName = postcode == null || postcode.getCountry() == null ? null : postcode.getCountry().getVehicleSign();
        return StreetModelUtil.getStreetString(countryName, cityName, postcodeName, districtName, streetName);
    }

    public static String getStreetString(String countryName, String cityName, String postcodeName, String districtName, String streetName) {
        String string = FormUtil.getStringDisplay(countryName, ", ");
        string = string + FormUtil.getStringDisplay(postcodeName, " ");
        string = string + FormUtil.getStringDisplay(cityName, " ");
        string = string + (!StringUtil.isBlank(cityName) && !StringUtil.isBlank(districtName) ? "- " : "");
        string = string + FormUtil.getStringDisplay(districtName, ", ");
        string = string + FormUtil.getStringDisplay(streetName);
        return string;
    }
}

