/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.peppergis.client.gui.customer.CustomerNameRenderingType;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.base.ServiceStatusConfigurationModel;
import de.datomino.peppergis.client.model.base.ServiceStatusValueConfigurationModel;
import de.datomino.peppergis.client.model.base.ServiceTicketModel;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModel;
import de.datomino.peppergis.client.model.base.StaticChoiceValueModel;
import de.datomino.peppergis.client.model.mobile.AccountModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceValueHistoryModel;
import de.datomino.peppergis.client.model.tour.ServiceValueHistoryModelImpl;
import de.datomino.peppergis.client.model.tour.ServiceValueModel;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.MobileChangeSource;
import de.datomino.peppergis.type.Relation;
import de.datomino.peppergis.type.ServiceStatusType;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.StringUtil;

public class ServiceModelUtil {
    public static String getServiceValue(ServiceValueModel serviceValueModel) {
        String serviceValue = "";
        if (serviceValueModel == null) {
            return serviceValue;
        }
        AttributeValueType serviceValueType = serviceValueModel.getServiceValueDescriptor().getServiceValueType();
        if (serviceValueType == AttributeValueType.BOOLEAN) {
            serviceValue = serviceValueModel.getBooleanValue().booleanValue() ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.yes", new Serializable[0]) : ModelEnviroment.getMessageResolver().resolveMessage("messages.default.no", new Serializable[0]);
        } else if (serviceValueType == AttributeValueType.INTEGER) {
            serviceValue = String.valueOf(serviceValueModel.getIntegerValue());
        } else if (serviceValueType == AttributeValueType.STRING) {
            serviceValue = serviceValueModel.getStringValue();
        } else if (serviceValueType == AttributeValueType.TEXT) {
            serviceValue = serviceValueModel.getTextValue();
        } else if (serviceValueType == AttributeValueType.STATIC_CHOICE) {
            serviceValue = serviceValueModel.getStaticChoiceValue().getName();
        } else if (serviceValueType == AttributeValueType.FLOAT) {
            serviceValue = String.valueOf(serviceValueModel.getFloatValue());
        }
        return serviceValue;
    }

    public static String adapteWidthOfField(String string, int width) {
        int lengthOfField = width / 7;
        if (string.length() > lengthOfField) {
            string = string.substring(0, lengthOfField - 1) + ".";
        }
        return string;
    }

    public static ServiceValueModel getServiceValueModel(ServiceTicketStopRelationModel relationModel, ServiceValueDescriptorModel serviceValueDescriptorModel) {
        Iterator<ServiceValueModel> serviceValueModelIterator = relationModel.iterateServiceValues();
        while (serviceValueModelIterator.hasNext()) {
            ServiceValueModel serviceValueModel = serviceValueModelIterator.next();
            if (!serviceValueModel.getServiceValueDescriptor().getKey().equals(serviceValueDescriptorModel.getKey())) continue;
            return serviceValueModel;
        }
        return null;
    }

    public static String getCustomerDisplay(ServiceTicketStopRelationModel relationModel) {
        CustomerNameRenderingType areaNamePrintType = CustomerNameRenderingType.NUMBER_NAME;
        try {
            areaNamePrintType = CustomerNameRenderingType.valueOf(ModelEnviroment.getProperties().getProperty("customer.name.rendering"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServiceTicketModel serviceTicket = relationModel.getServiceTicket();
        CustomerModel customer = serviceTicket == null ? null : serviceTicket.getCustomer();
        String display = "";
        switch (areaNamePrintType) {
            case NUMBER_NAME: {
                display = customer == null ? "" : customer.getName() + " (" + customer.getCustomerNumber() + ")";
                break;
            }
            case NUMBER: {
                display = customer == null ? "" : customer.getCustomerNumber();
                break;
            }
            case NAME: {
                display = customer == null ? "" : customer.getName();
                break;
            }
        }
        return StringUtil.getNotNull(display);
    }

    public static String getCompanyName(ServiceTicketStopRelationModel relationModel) {
        ServiceTicketModel serviceTicket = relationModel.getServiceTicket();
        CustomerModel customer = serviceTicket == null ? null : serviceTicket.getCustomer();
        String companyName = "";
        if (customer != null) {
            companyName = customer.getCompany() != null || customer.getCompany() != false ? StringUtil.getNotNull(customer.getCompanyName()) : StringUtil.getNotNull(customer.getFirstName()) + " " + StringUtil.getNotNull(customer.getLastName());
        }
        return companyName;
    }

    public static String toString(ServiceModel service) {
        return service == null ? "" : service.getServiceNumber();
    }

    public static String toString(ServiceValueDescriptorModel serviceValueDescriptor) {
        return serviceValueDescriptor == null ? "" : serviceValueDescriptor.getName();
    }

    public static ServiceValueHistoryModel createServiceValueHistory(ServiceValueModel value, Date changeTime, MobileChangeSource changeSource, AccountModel account, UserModel user) {
        ServiceValueHistoryModelImpl serviceValueHistory = new ServiceValueHistoryModelImpl();
        serviceValueHistory.setAccount(account);
        serviceValueHistory.setBooleanValue(value.getBooleanValue());
        serviceValueHistory.setChangeSource(changeSource);
        serviceValueHistory.setChangeTime(changeTime);
        serviceValueHistory.setFloatValue(value.getFloatValue());
        serviceValueHistory.setImageValue(value.getImageValue());
        serviceValueHistory.setIntegerValue(value.getIntegerValue());
        serviceValueHistory.setLongValue(value.getLongValue());
        serviceValueHistory.setMultipleListChoiceValues(value.getMultipleListChoiceValues());
        serviceValueHistory.setSelectedMultipleListChoiceValues(value.getSelectedMultipleListChoiceValues());
        serviceValueHistory.setServiceStopRelation(value.getServiceStopRelation());
        serviceValueHistory.setServiceValueDescriptor(value.getServiceValueDescriptor());
        serviceValueHistory.setStaticChoiceValue(value.getStaticChoiceValue());
        serviceValueHistory.setStringValue(value.getStringValue());
        serviceValueHistory.setTextValue(value.getTextValue());
        serviceValueHistory.setUser(user);
        return serviceValueHistory;
    }

    public static ServiceStatusType calculateServiceStatus(ServiceTicketStopRelationModel rel) {
        HashMap<String, ServiceValueModel> serviceValueMap = new HashMap<String, ServiceValueModel>();
        for (ServiceValueModel serviceValue : rel.iterableServiceValues()) {
            ServiceValueDescriptorModel serviceValueDescriptorDo = serviceValue.getServiceValueDescriptor();
            String key = serviceValueDescriptorDo.getKey();
            serviceValueMap.put(key, serviceValue);
        }
        return ServiceModelUtil.getServiceStatusType(rel.getServiceTicket().getService(), serviceValueMap);
    }

    public static ServiceStatusType getServiceStatusType(ServiceModel service, Map<String, ServiceValueModel> serviceValueMap) {
        for (ServiceStatusConfigurationModel conf : service.iterableServiceStatusConfigurations()) {
            boolean matches = true;
            for (ServiceStatusValueConfigurationModel valueConf : conf.iterableServiceStatusValueConfigurations()) {
                ServiceValueDescriptorModel serviceValueDescriptorDo = valueConf.getServiceValueDescriptor();
                ServiceValueModel serviceValueDo = serviceValueMap.get(serviceValueDescriptorDo.getKey());
                if (serviceValueDo != null) {
                    AttributeValueType serviceValueType = serviceValueDescriptorDo.getServiceValueType();
                    Relation relation = valueConf.getRelation();
                    switch (serviceValueType) {
                        case BOOLEAN: {
                            matches = ServiceModelUtil.matches(serviceValueDo.getBooleanValue(), valueConf.getBooleanValue(), relation);
                            break;
                        }
                        case DATE: {
                            matches = ServiceModelUtil.matchesDate(serviceValueDo.getLongValue(), valueConf.getLongValue(), relation);
                            break;
                        }
                        case INTEGER: {
                            matches = ServiceModelUtil.matches(serviceValueDo.getIntegerValue(), valueConf.getIntegerValue(), relation);
                            break;
                        }
                        case STATIC_CHOICE: {
                            StaticChoiceValueModel vStaticChoiceValue = serviceValueDo.getStaticChoiceValue();
                            StaticChoiceValueModel tStaticChoiceValue = valueConf.getStaticChoiceValue();
                            matches = ServiceModelUtil.matchesId(vStaticChoiceValue == null ? null : vStaticChoiceValue.getId(), tStaticChoiceValue == null ? null : tStaticChoiceValue.getId(), relation);
                            break;
                        }
                        case STRING: {
                            matches = ServiceModelUtil.matches(serviceValueDo.getStringValue(), valueConf.getStringValue(), relation);
                            break;
                        }
                        case TEXT: {
                            matches = ServiceModelUtil.matches(serviceValueDo.getTextValue(), valueConf.getTextValue(), relation);
                            break;
                        }
                        case FLOAT: {
                            matches = ServiceModelUtil.matches(serviceValueDo.getFloatValue(), valueConf.getFloatValue(), relation);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Implement all types!");
                        }
                    }
                } else {
                    matches = false;
                }
                if (matches) continue;
                break;
            }
            if (!matches) continue;
            return conf.getType();
        }
        return ServiceStatusType.NOT_DONE;
    }

    private static boolean matches(String stringValue, String stringValue2, Relation relation) {
        switch (relation) {
            case EQUALS: {
                return new EqualsBuilder().append(stringValue, stringValue2).isEquals();
            }
        }
        return false;
    }

    private static boolean matchesId(Long id1, Long id2, Relation relation) {
        switch (relation) {
            case EQUALS: {
                return new EqualsBuilder().append(id1, id2).isEquals();
            }
        }
        return false;
    }

    private static boolean matches(Integer integerValue, Integer integerValue2, Relation relation) {
        switch (relation) {
            case EQUALS: {
                return new EqualsBuilder().append(integerValue, integerValue2).isEquals();
            }
        }
        return false;
    }

    private static boolean matchesDate(Long longValue, Long longValue2, Relation relation) {
        switch (relation) {
            case EQUALS: {
                return new EqualsBuilder().append(longValue, longValue2).isEquals();
            }
        }
        return false;
    }

    private static boolean matches(Boolean b1, Boolean b2, Relation relation) {
        switch (relation) {
            case EQUALS: {
                return new EqualsBuilder().append(b1, b2).isEquals();
            }
        }
        return false;
    }

    private static boolean matches(Double doubleValue, Double doubleValue2, Relation relation) {
        switch (relation) {
            case EQUALS: {
                return new EqualsBuilder().append(doubleValue, doubleValue2).isEquals();
            }
        }
        return false;
    }
}

