/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.model.map.SegmentAttributeModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.type.SegmentStatus;
import java.awt.Color;
import org.ktde.util.datatypes.Tupel;

public class SegmentModelUtil {
    public static SegmentStatus getBadestStatus(SegmentModel motor, SegmentModel foot, SegmentModel bike) {
        boolean badForMotor = motor == null || motor.getSegmentStatus() == null ? false : motor.getSegmentStatus().isBadForMotor();
        boolean badForFoot = foot == null || foot.getSegmentStatus() == null ? false : foot.getSegmentStatus().isBadForFoot();
        boolean badForBike = bike == null || bike.getSegmentStatus() == null ? false : bike.getSegmentStatus().isBadForBike();
        int factor = !badForMotor ? 100 : 0;
        factor += !badForFoot ? 10 : 0;
        return SegmentStatus.getSegmentStatus(factor += !badForBike ? 1 : 0);
    }

    public static Tupel<Color, Color> getSegmentColor(SegmentModel segment) {
        Color color1 = Color.BLACK;
        Color color2 = Color.BLACK;
        if (segment.getSegmentType() != null) {
            SegmentStatus segmentStatus = segment.getSegmentStatus() == null ? SegmentStatus.NORMAL : segment.getSegmentStatus();
            switch (segment.getSegmentType()) {
                case MOTORWAY: {
                    color2 = color1 = segmentStatus.isBadForMotor() ? Color.RED : PeppergisConstants.MOTOR_SEGMENT_COLOR;
                    break;
                }
                case FOOTWAY: {
                    color2 = color1 = segmentStatus.isBadForFoot() ? Color.RED : PeppergisConstants.FOOT_SEGMENT_COLOR;
                    break;
                }
                case STREET: {
                    color1 = segmentStatus == SegmentStatus.BAD_FOR_ALL ? Color.RED : PeppergisConstants.STREET_COLOR;
                    color2 = segmentStatus == SegmentStatus.NORMAL ? PeppergisConstants.STREET_COLOR : Color.RED;
                    break;
                }
                case BIKEWAY: {
                    color2 = color1 = segmentStatus.isBadForBike() ? Color.RED : PeppergisConstants.BIKE_SEGMENT_COLOR;
                    break;
                }
                case FOOT_BIKE: {
                    color1 = segmentStatus.isBadForFoot() ? Color.RED : PeppergisConstants.FOOT_SEGMENT_COLOR;
                    color2 = segmentStatus.isBadForBike() ? Color.RED : PeppergisConstants.BIKE_SEGMENT_COLOR;
                    break;
                }
                case MOTOR_BIKE: {
                    color1 = segmentStatus.isBadForMotor() ? Color.RED : PeppergisConstants.MOTOR_SEGMENT_COLOR;
                    color2 = segmentStatus.isBadForBike() ? Color.RED : PeppergisConstants.BIKE_SEGMENT_COLOR;
                    break;
                }
                case MOTOR_FOOT: {
                    color1 = segmentStatus.isBadForMotor() ? Color.RED : PeppergisConstants.MOTOR_SEGMENT_COLOR;
                    color2 = segmentStatus.isBadForFoot() ? Color.RED : PeppergisConstants.FOOT_SEGMENT_COLOR;
                    break;
                }
                case DUMMY: {
                    color2 = color1 = Color.RED;
                }
            }
        }
        return new Tupel<Color, Color>(color1, color2);
    }

    public static Color getSegmentStatusColor(SegmentStatus segmentStatus) {
        Color color = Color.BLACK;
        switch (segmentStatus) {
            case BAD_FOR_ALL: 
            case BAD_FOR_FOOT_BIKE: 
            case BAD_FOR_MOTOR_BIKE: 
            case BAD_FOR_MOTOR_FOOT: {
                color = PeppergisConstants.BAD_SEGMENT_ALL_COLOR;
                break;
            }
            case BAD_FOR_FOOT: {
                color = PeppergisConstants.BAD_SEGMENT_FOOT_COLOR;
                break;
            }
            case BAD_FOR_MOTOR: {
                color = PeppergisConstants.BAD_SEGMENT_MOTOR_COLOR;
                break;
            }
            case BAD_FOR_BIKE: {
                color = PeppergisConstants.BAD_SEGMENT_BIKE_COLOR;
                break;
            }
        }
        return color;
    }

    public static String getSegmentName(SegmentModel segment) {
        String segmentName = null;
        String ref = null;
        if (segment != null) {
            for (SegmentAttributeModel attribute : segment.iterableAttributes()) {
                String key = attribute.getKey();
                if (key == null) continue;
                if (key.equals("name")) {
                    segmentName = attribute.getValue();
                    continue;
                }
                if (!key.equals("ref")) continue;
                ref = attribute.getValue();
            }
        }
        return segmentName == null ? ref : segmentName;
    }
}

