/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import java.awt.Desktop;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.SimpleDoc;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.util.PDFMergerUtility;

public final class PdfUtil {
    private static final String PRINT = "DIRECT";

    private PdfUtil() {
    }

    public static void showPdf(String jobname, InputStream in, Properties properties) throws Exception {
        PdfUtil.showPdf(jobname, in, properties, "peppergis", true, false);
    }

    public static void showPdf(String jobname, InputStream in, Properties properties, String fileNamePrefix, boolean withRandomNumber, boolean addCountIfFileExists) throws Exception {
        try {
            String printProp = ModelEnviroment.getProperties().getProperty("print.mode");
            if (PRINT.equals(printProp)) {
                PrinterJob pj = PrinterJob.getPrinterJob();
                pj.setJobName(jobname);
                boolean b = pj.printDialog();
                if (b) {
                    DocPrintJob docPrintJob = pj.getPrintService().createPrintJob();
                    SimpleDoc document = new SimpleDoc(in, DocFlavor.INPUT_STREAM.PDF, null);
                    docPrintJob.print(document, null);
                }
            } else {
                PdfUtil.showPdf(in, fileNamePrefix, withRandomNumber, addCountIfFileExists);
            }
        }
        catch (IOException e) {
            throw new Exception("Could not open pdf: " + e.getMessage());
        }
    }

    public static void showPdf(InputStream in) throws Exception {
        PdfUtil.showPdf(in, "peppergis", true, false);
    }

    public static void showPdf(InputStream in, String prefix, boolean withRandomNumber, boolean addCountIfFileExists) throws Exception {
        try {
            prefix = prefix == null ? "peppergis" : prefix;
            File file = PdfUtil.createTemporaryFile(prefix, ".pdf", withRandomNumber, addCountIfFileExists);
            FileOutputStream fos = new FileOutputStream(file);
            IOUtils.copy(in, (OutputStream)fos);
            fos.flush();
            fos.close();
            file.deleteOnExit();
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                desktop.open(file);
            } else {
                Runtime.getRuntime().exec(new String[]{ModelEnviroment.getProperties().getProperty("pdf.opencommand"), file.getCanonicalPath()});
            }
        }
        catch (IOException e) {
            throw new Exception("Could not open pdf: " + e.getMessage());
        }
    }

    private static File createTemporaryFile(String prefix, String suffix, boolean withRandomNumber, boolean addCountIfFileExists) throws IOException {
        File file;
        if (withRandomNumber) {
            if (prefix.length() < 3) {
                prefix = "peppergis" + (prefix.length() == 0 ? "" : "_" + prefix);
            }
            return File.createTempFile(prefix + (prefix.endsWith("_") ? "" : "_"), (suffix.startsWith(".") ? "" : "_") + suffix);
        }
        String tmpDirString = System.getProperty("java.io.tmpdir");
        File tmpdir = new File(tmpDirString);
        String name = (prefix = new File(prefix).getName()) + suffix;
        if (!name.equals((file = new File(tmpdir, name)).getName())) {
            throw new IOException("Unable to create temporary file");
        }
        int count = 0;
        while (addCountIfFileExists && file.exists()) {
            name = prefix + "_" + StringUtils.leftPad(Integer.toString(count), 3, '0') + suffix;
            if (!name.equals((file = new File(tmpdir, name)).getName())) {
                throw new IOException("Unable to create temporary file");
            }
            ++count;
        }
        return file;
    }

    public static InputStream mergePdfs(Collection<byte[]> pdfs) throws COSVisitorException, IOException {
        ArrayList<InputStream> ins = new ArrayList<InputStream>(pdfs.size());
        for (byte[] b : pdfs) {
            ins.add(new ByteArrayInputStream(b));
        }
        return PdfUtil.mergePdfs(ins);
    }

    public static InputStream mergePdfs(List<InputStream> ins) throws COSVisitorException, IOException {
        PDFMergerUtility mergePdf = new PDFMergerUtility();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        mergePdf.setDestinationStream(baos);
        for (InputStream in : ins) {
            mergePdf.addSource(in);
        }
        mergePdf.mergeDocuments();
        baos.flush();
        baos.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

