/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTimeWindowDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.logistic.dto.LogisticTourPartDto;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.logistic.type.RoutingType;
import de.datomino.logistic.type.StopType;
import de.datomino.logistic.util.LogisticServicesUtil;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.AreaTourPartModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TimeWindowModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.AreaStopModelUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.helper.PointEntity;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.util.DefaultLogisticTourUtil;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.geo.util.GeoUtils;
import de.datomino.util.international.country.Country;
import de.datomino.util.time.TimeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class LogisticTourDtoUtil
extends DefaultLogisticTourUtil {
    public static LogisticLocationDto<PointEntityId> createLogisticLocationDto(LocationWrapper locationWrapper, PointEntityId id, RouteVehicleType routeVehicleType) {
        LogisticLocationDto<PointEntityId> logisticLocationDto = new LogisticLocationDto<PointEntityId>(id);
        LogisticTourDtoUtil.fillValues(locationWrapper, id, routeVehicleType, logisticLocationDto);
        return logisticLocationDto;
    }

    public static LogisticLocationDto<Long> createLogisticLocationDtoLong(LocationWrapper locationWrapper, Long id, RouteVehicleType routeVehicleType) {
        LogisticLocationDto<Long> logisticLocationDto = new LogisticLocationDto<Long>(id);
        LogisticTourDtoUtil.fillValues(locationWrapper, id, routeVehicleType, logisticLocationDto);
        return logisticLocationDto;
    }

    private static void fillValues(LocationWrapper locationWrapper, Object id, RouteVehicleType routeVehicleType, LogisticLocationDto<?> logisticLocationDto) {
        logisticLocationDto.setTempId(String.valueOf(id));
        Country country = locationWrapper.getCountry();
        logisticLocationDto.setCountry(country == null ? null : country.getVehicleSign());
        logisticLocationDto.setCity(locationWrapper.getCity());
        logisticLocationDto.setDistrict(locationWrapper.getDistrict());
        if (locationWrapper.getGeoLocation() != null) {
            logisticLocationDto.setGeom(ImmutablePointDto.create((ImmutablePoint)locationWrapper.getGeoLocation().getTransformed(factory)));
            if (routeVehicleType != null) {
                logisticLocationDto.setAccesGeom(ImmutablePointDto.create((ImmutablePoint)locationWrapper.getAccessLocation(routeVehicleType).getTransformed(factory)));
            }
        }
        logisticLocationDto.setHousenumber(String.valueOf(locationWrapper.getHousenumber()));
        logisticLocationDto.setExtension(locationWrapper.getHousenumberExtension());
        logisticLocationDto.setPostcode(locationWrapper.getPostcode());
        logisticLocationDto.setStreet(locationWrapper.getStreet());
        logisticLocationDto.setParcelLocation(locationWrapper.getParcelLocation());
    }

    public static LogisticTourDto<PointEntityId> createLogisticTourDto(TourPartModel currentTourPart, Collection<StopModel> stopsWithNullGeom, StopModel startStop, StopModel endStop, ModelEnviroment modelEnviroment) {
        LogisticStopDto<PointEntityId> stopDto;
        LogisticTourDto<PointEntityId> logisticTourDto = new LogisticTourDto<PointEntityId>(currentTourPart.getTempUUID());
        LogisticTourPartDto logisticTourPartDto = new LogisticTourPartDto(currentTourPart.getTempUUID());
        logisticTourPartDto.setRouteType(currentTourPart.getRouteType());
        logisticTourPartDto.setRouteVehicleType(currentTourPart.getRouteVehicleType());
        LocationWrapper locationWrapper = null;
        Iterator<StopModel> stopModelIter = currentTourPart.iterateStops();
        while (stopModelIter.hasNext()) {
            StopModel stop = stopModelIter.next();
            if (stopsWithNullGeom.contains(stop)) continue;
            locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(stop.getLocation());
            logisticTourPartDto.getStopDtos().add(LogisticTourDtoUtil.createLogisticStopDto(locationWrapper, stop, currentTourPart.getRouteVehicleType(), modelEnviroment));
        }
        if (startStop != null && !stopsWithNullGeom.contains(startStop)) {
            locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(startStop.getLocation());
            stopDto = LogisticTourDtoUtil.createLogisticStopDto(locationWrapper, startStop, currentTourPart.getRouteVehicleType(), modelEnviroment);
            logisticTourPartDto.getStopDtos().add(0, stopDto);
        }
        if (endStop != null && !stopsWithNullGeom.contains(endStop)) {
            locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(endStop.getLocation());
            stopDto = LogisticTourDtoUtil.createLogisticStopDto(locationWrapper, endStop, currentTourPart.getRouteVehicleType(), modelEnviroment);
            logisticTourPartDto.getStopDtos().add(stopDto);
        }
        Double difficultyLevelValue = TourModelUtil.getDifficultyLevelValue(currentTourPart.getTour(), currentTourPart, null);
        logisticTourPartDto.setDifficultLevel(difficultyLevelValue);
        logisticTourDto.getTourParts().add(logisticTourPartDto);
        return logisticTourDto;
    }

    public static LogisticTourDto<PointEntityId> createLogisticTourDto(TourModel tour, Map<TourPartModel, Collection<StopModel>> stopsWithNullGeomMap, OptimizationType optimizationType, RouteVehicleType routeVehicleType, RouteType routeType, ModelEnviroment modelEnviroment, int startBlock, int endBlock) {
        int i;
        LogisticTourDto<PointEntityId> logisticTourDto = new LogisticTourDto<PointEntityId>(tour.getTempUUID());
        logisticTourDto.setStartTime(tour.getPlannedStartTime());
        ArrayList<StopModel> allStops = new ArrayList<StopModel>();
        Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
        TourPartModel next = null;
        while (tourPartIter.hasNext()) {
            next = tourPartIter.next();
            Iterator<StopModel> stopIter = next.iterateStops();
            while (stopIter.hasNext()) {
                allStops.add(stopIter.next());
            }
        }
        int startPois = -1;
        int endPois = -1;
        for (i = 0; i < allStops.size() && ((StopModel)allStops.get(i)).getPoi() != null; ++i) {
            ++startPois;
        }
        for (i = allStops.size() - 1; i > 0 && ((StopModel)allStops.get(i)).getPoi() != null; --i) {
            ++endPois;
        }
        HashMap<TourPartModel, Tripel<OptimizationType, Integer, Integer>> typeMap = new HashMap<TourPartModel, Tripel<OptimizationType, Integer, Integer>>();
        if (tour.countTourParts() == 1) {
            typeMap.put(next, new Tripel<OptimizationType, Integer, Integer>(optimizationType, startPois == -1 ? 0 : startPois, endPois == -1 ? 0 : endPois));
        } else {
            TourPartModel pred = null;
            tourPartIter = tour.iterateTourParts();
            while (tourPartIter.hasNext()) {
                TourPartModel succ = tourPartIter.next();
                if (pred == null) {
                    typeMap.put(succ, new Tripel<OptimizationType, Integer, Integer>(optimizationType, startPois == -1 ? 0 : startPois, 0));
                } else {
                    typeMap.put(succ, new Tripel<OptimizationType, Integer, Integer>(OptimizationType.NONFIX, 0, 0));
                }
                pred = succ;
            }
            if (pred != null) {
                typeMap.put(pred, new Tripel<OptimizationType, Integer, Integer>(optimizationType, 0, endPois == -1 ? 0 : endPois));
            }
        }
        tourPartIter = tour.iterateTourParts();
        while (tourPartIter.hasNext()) {
            TourPartModel tourPartModel = tourPartIter.next();
            LogisticTourPartDto logisticTourPartDto = new LogisticTourPartDto(tourPartModel.getTempUUID());
            Tripel tripel = (Tripel)typeMap.get(tourPartModel);
            logisticTourPartDto.setRouteVehicleType(routeVehicleType);
            logisticTourPartDto.setRouteType(routeType);
            logisticTourPartDto.setStartTime(tour.getPlannedStartTime());
            logisticTourPartDto.setRoutingType((RoutingType)tripel.getElement1());
            logisticTourPartDto.setSizeOfStartBlock((Integer)tripel.getElement2() + startBlock);
            logisticTourPartDto.setSizeOfEndBlock((Integer)tripel.getElement3() + endBlock);
            logisticTourPartDto.setTourPartType(tourPartModel.getTourPartType());
            Double difficultyLevelValue = TourModelUtil.getDifficultyLevelValue(tour, tourPartModel, null);
            logisticTourPartDto.setDifficultLevel(difficultyLevelValue);
            Collection<StopModel> stopsWithNullGeom = stopsWithNullGeomMap.get(tourPartModel);
            LocationWrapper locationWrapper = null;
            Iterator<StopModel> stopModelIter = tourPartModel.iterateStops();
            while (stopModelIter.hasNext()) {
                StopModel stopModel = stopModelIter.next();
                if (stopsWithNullGeom.contains(stopModel)) continue;
                locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(stopModel.getLocation());
                LogisticStopDto<PointEntityId> logisticStopDto = LogisticTourDtoUtil.createLogisticStopDto(locationWrapper, stopModel, routeVehicleType, modelEnviroment);
                if (stopModel.getPoi() != null && stopModel.getPoi().getPoiType() == PoiType.DELIVERER_LOCATION) {
                    if (logisticTourPartDto.getStopDtos().isEmpty()) {
                        logisticStopDto.setStopType(StopType.POI_START);
                    } else {
                        logisticStopDto.setStopType(StopType.POI_END);
                    }
                }
                logisticTourPartDto.getStopDtos().add(logisticStopDto);
            }
            logisticTourDto.getTourParts().add(logisticTourPartDto);
        }
        return logisticTourDto;
    }

    private static LogisticStopDto<PointEntityId> createLogisticStopDto(LocationWrapper locationWrapper, StopModel stop, RouteVehicleType routeVehicleType, ModelEnviroment modelEnviroment) {
        SegmentModel segment;
        Long id = stop.getTempUUID();
        LogisticLocationDto<PointEntityId> logisticLocationDto = LogisticTourDtoUtil.createLogisticLocationDto(locationWrapper, new PointEntityId(id, PointEntityId.PointEnityType.STOP), routeVehicleType);
        LogisticStopDto<PointEntityId> logisticStopDto = new LogisticStopDto<PointEntityId>(new PointEntityId(stop.getTempUUID(), PointEntityId.PointEnityType.STOP), logisticLocationDto);
        logisticStopDto.setDurationInSecond(stop.getEstimatedDurationSeconds());
        if (stop != null) {
            logisticStopDto.setTimeWindows(LogisticTourDtoUtil.getLogisticTimeWindowDtos(stop));
        }
        logisticLocationDto.setRouteSegmentId((segment = LocationModelUtil.getRouteSegment(stop.getLocation(), routeVehicleType, modelEnviroment)) == null ? null : segment.getId());
        return logisticStopDto;
    }

    public static List<LogisticTimeWindowDto> getLogisticTimeWindowDtos(StopModel stopModel) {
        ArrayList<LogisticTimeWindowDto> timeWindowsDtos = new ArrayList<LogisticTimeWindowDto>(stopModel.countTimeWindows());
        Iterator<TimeWindowModel> timeWindowsIter = stopModel.iterateTimeWindows();
        while (timeWindowsIter.hasNext()) {
            timeWindowsDtos.add(LogisticTourDtoUtil.createLogisticTimeWindowDto(timeWindowsIter.next()));
        }
        return timeWindowsDtos;
    }

    private static LogisticTimeWindowDto createLogisticTimeWindowDto(TimeWindowModel selectedTimeWindow) {
        return new LogisticTimeWindowDto(selectedTimeWindow.getStartTime(), selectedTimeWindow.getEndTime());
    }

    public static List<Tupel<ImmutablePoint, ImmutablePoint>> getPoints(LogisticTourDto<?> logisticTourDto) {
        ImmutablePoint nullPoint = ImmutableGeoObjectFactory.createImmutablePoint(Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0));
        ArrayList<Tupel<ImmutablePoint, ImmutablePoint>> points = new ArrayList<Tupel<ImmutablePoint, ImmutablePoint>>();
        for (LogisticStopDto<?> logisticStopDto : LogisticTourDtoUtil.getAllStops(logisticTourDto)) {
            LogisticLocationDto<?> location = logisticStopDto.getLocation();
            ImmutablePoint geom = location.getGeom() == null ? nullPoint : (ImmutablePoint)location.getGeom().getGeoObject();
            ImmutablePoint accessGeom = location.getAccessGeom() == null ? nullPoint : (ImmutablePoint)location.getAccessGeom().getGeoObject();
            points.add(new Tupel<ImmutablePoint, ImmutablePoint>(geom, accessGeom));
        }
        return points;
    }

    public static List<ImmutableLineString> getLineStrings(LogisticTourDto<?> logisticTourDto) {
        ArrayList<ImmutableLineString> linstrings = new ArrayList<ImmutableLineString>();
        for (LogisticTourPartDto<?> logisticTourPartDto : logisticTourDto.getTourParts()) {
            linstrings.addAll(LogisticTourDtoUtil.getLineStrings(logisticTourPartDto));
        }
        return linstrings;
    }

    public static List<ImmutableLineString> getLineStrings(LogisticTourPartDto<?> logisticTourPartDto) {
        ArrayList<ImmutableLineString> linstrings = new ArrayList<ImmutableLineString>();
        for (LogisticStopDto<?> logisticStopDto : logisticTourPartDto.getStopDtos()) {
            LogisticLocationDto<?> location = logisticStopDto.getLocation();
            ImmutableLineString geoObject = location == null || location.getLineString() == null ? null : (ImmutableLineString)location.getLineString().getGeoObject();
            if (geoObject == null) continue;
            linstrings.add(geoObject);
        }
        if (linstrings.isEmpty() && logisticTourPartDto.getLineString() != null) {
            linstrings.add((ImmutableLineString)logisticTourPartDto.getLineString().getGeoObject());
        }
        return linstrings;
    }

    public static <T extends Serializable> List<ImmutableLineString> getAccessLinestrings(LogisticTourDto<T> logisticTourDto, List<Tupel<ImmutablePoint, ImmutablePoint>> points) {
        LogisticStopDto<T> pred;
        ArrayList<ImmutableLineString> accessLinestrings = new ArrayList<ImmutableLineString>();
        List<LogisticStopDto<T>> allStops = LogisticTourDtoUtil.getAllStops(logisticTourDto);
        Iterator<LogisticStopDto<T>> iter = allStops.iterator();
        LogisticStopDto<T> logisticStopDto = pred = iter.hasNext() ? iter.next() : null;
        while (iter.hasNext()) {
            LogisticStopDto<T> next = iter.next();
            LogisticTourDtoUtil.addAccessLineString(pred, next, accessLinestrings);
            pred = next;
        }
        if (allStops.size() > 1) {
            LogisticStopDto<T> last2 = allStops.get(allStops.size() - 2);
            LogisticTourDtoUtil.addAccessLineString(last2, pred, accessLinestrings);
        }
        return accessLinestrings;
    }

    private static <T extends Serializable> void addAccessLineString(LogisticStopDto<T> pred, LogisticStopDto<T> next, List<ImmutableLineString> accessLinestrings) {
        AbstractImmutableGeoObject lineStringOrPoint;
        LogisticLocationDto<T> predLocation = pred.getLocation();
        LogisticLocationDto<T> nextLocation = next.getLocation();
        boolean areSameAccess = LogisticTourDtoUtil.areSameAccess(predLocation, nextLocation, null);
        ImmutablePoint predGeom = (ImmutablePoint)predLocation.getGeom().getGeoObject();
        ImmutablePoint nextGeom = (ImmutablePoint)nextLocation.getGeom().getGeoObject();
        if (!areSameAccess) {
            lineStringOrPoint = GeoUtils.getLineString((ImmutablePoint)nextLocation.getAccessGeom().getGeoObject(), (ImmutablePoint)nextLocation.getGeom().getGeoObject());
            if (lineStringOrPoint != null && lineStringOrPoint instanceof ImmutableLineString) {
                accessLinestrings.add((ImmutableLineString)lineStringOrPoint);
            }
            nextGeom = (ImmutablePoint)predLocation.getAccessGeom().getGeoObject();
        }
        if ((lineStringOrPoint = GeoUtils.getLineString(predGeom, nextGeom)) != null && lineStringOrPoint instanceof ImmutableLineString) {
            accessLinestrings.add((ImmutableLineString)lineStringOrPoint);
        }
    }

    public static List<ParcelModel> updateSortOrderOfParcel(List<ParcelModel> parcels, LogisticTourDto<PointEntityId> logisticTourDto) {
        ArrayList<ParcelModel> updatedParcels = new ArrayList<ParcelModel>(parcels.size());
        for (LogisticStopDto<PointEntityId> logisticStopDto : LogisticServicesUtil.getAllStops(logisticTourDto)) {
            for (ParcelModel parcel : parcels) {
                if (((PointEntityId)logisticStopDto.getId()).getPointEnityType() != PointEntityId.PointEnityType.PARCEL || !parcel.getTempUUID().equals(((PointEntityId)logisticStopDto.getId()).getId())) continue;
                updatedParcels.add(parcel);
            }
        }
        return updatedParcels;
    }

    public static List<Tupel<SubscriptionModel, Integer>> updateSortOrderOfSubscription(Collection<SubscriptionModel> subscriptions, LogisticTourDto<PointEntityId> logisticTourDto) {
        ArrayList<Tupel<SubscriptionModel, Integer>> updatedSubscriptions = new ArrayList<Tupel<SubscriptionModel, Integer>>(subscriptions.size());
        for (LogisticStopDto<PointEntityId> logisticStopDto : LogisticServicesUtil.getAllStops(logisticTourDto)) {
            for (SubscriptionModel subscription : subscriptions) {
                if (((PointEntityId)logisticStopDto.getId()).getPointEnityType() != PointEntityId.PointEnityType.SUBSCRIPTION || !subscription.getTempUUID().equals(((PointEntityId)logisticStopDto.getId()).getId())) continue;
                updatedSubscriptions.add(new Tupel<SubscriptionModel, Integer>(subscription, logisticStopDto.getSortOrder()));
            }
        }
        return updatedSubscriptions;
    }

    public static List<Tupel<LetterModel, Integer>> updateSortOrderOfLetter(Collection<LetterModel> letters, LogisticTourDto<PointEntityId> logisticTourDto) {
        ArrayList<Tupel<LetterModel, Integer>> updatedLetters = new ArrayList<Tupel<LetterModel, Integer>>(letters.size());
        for (LogisticStopDto<PointEntityId> logisticStopDto : LogisticServicesUtil.getAllStops(logisticTourDto)) {
            for (LetterModel letter : letters) {
                if (((PointEntityId)logisticStopDto.getId()).getPointEnityType() != PointEntityId.PointEnityType.LETTER || !letter.getTempUUID().equals(((PointEntityId)logisticStopDto.getId()).getId())) continue;
                updatedLetters.add(new Tupel<LetterModel, Integer>(letter, logisticStopDto.getSortOrder()));
            }
        }
        return updatedLetters;
    }

    public static List<Model> updateSortOrderOfModel(List<Model> models, LogisticTourDto<PointEntityId> logisticTourDto) {
        ArrayList<Model> updatedModels = new ArrayList<Model>(models.size());
        block7: for (LogisticStopDto<PointEntityId> logisticStopDto : LogisticServicesUtil.getAllStops(logisticTourDto)) {
            for (Model model : models) {
                PointEntityId.PointEnityType pointEnityType = ((PointEntityId)logisticStopDto.getId()).getPointEnityType();
                boolean typeCondition = false;
                switch (pointEnityType) {
                    case LETTER: {
                        typeCondition = model instanceof LetterModel;
                        break;
                    }
                    case PARCEL: {
                        typeCondition = model instanceof ParcelModel;
                        break;
                    }
                    case POI: {
                        typeCondition = model instanceof PoiModel;
                        break;
                    }
                    case STOP: {
                        typeCondition = model instanceof StopModel;
                        break;
                    }
                    case SUBSCRIPTION: {
                        typeCondition = model instanceof SubscriptionModel;
                    }
                }
                if (!typeCondition || !model.getTempUUID().equals(((PointEntityId)logisticStopDto.getId()).getId())) continue;
                updatedModels.add(model);
                continue block7;
            }
        }
        return updatedModels;
    }

    public static LogisticTourDto<PointEntityId> createLogisticTourDto(AreaTourModel areaTour) {
        LogisticTourDto<PointEntityId> logisticTourDto = new LogisticTourDto<PointEntityId>(areaTour.getTempUUID());
        logisticTourDto.setDistanceSum(areaTour.getDistanceSum());
        logisticTourDto.setAccessSum(areaTour.getAccessSum());
        logisticTourDto.setDurationSum(areaTour.getDurationSum());
        Date startTime = new Date();
        logisticTourDto.setStartTime(startTime);
        for (AreaTourPartModel areaTourPart : areaTour.iterableAreaTourParts()) {
            LogisticTourPartDto logisticTourPartDto = new LogisticTourPartDto(areaTourPart.getTempUUID());
            logisticTourPartDto.setRouteType(areaTourPart.getRouteType());
            logisticTourPartDto.setRouteVehicleType(areaTourPart.getRouteVehicleType());
            logisticTourPartDto.setLineString(ImmutableLineStringDto.create(areaTourPart.getLineString()));
            logisticTourPartDto.setTourPartType(areaTourPart.getTourPartType());
            for (AreaStopModel areaStop : areaTourPart.iterableAreaStops()) {
                PointEntity pointTupel = AreaStopModelUtil.getPointTupel(areaStop);
                LogisticLocationDto<PointEntityId> logisticLocationDto = new LogisticLocationDto<PointEntityId>(pointTupel.getId());
                logisticLocationDto.setTempId(String.valueOf(pointTupel.getId()));
                if (pointTupel.getGeom() != null) {
                    logisticLocationDto.setGeom(ImmutablePointDto.create((ImmutablePoint)pointTupel.getGeom().getTransformed(factory)));
                }
                if (pointTupel.getAccessGeom() != null) {
                    logisticLocationDto.setAccesGeom(ImmutablePointDto.create((ImmutablePoint)pointTupel.getAccessGeom().getTransformed(factory)));
                }
                logisticLocationDto.setParcelLocation(ParcelModelUtil.getParcelLocation(areaStop.getParcel()));
                LogisticStopDto<PointEntityId> logisticStopDto = new LogisticStopDto<PointEntityId>(pointTupel.getId(), logisticLocationDto);
                logisticStopDto.setStreetMileageMetersFromStart(areaStop.getMetersFromStart());
                Integer secondsFromStart = areaStop.getSecondsFromStart() == null ? 0 : areaStop.getSecondsFromStart();
                logisticStopDto.setTimeOfArrival(TimeUtil.add(startTime, 13, secondsFromStart));
                logisticStopDto.setDurationInSecond(areaStop.getEstimatedDurationSeconds());
                if (areaStop.getPoi() != null && areaStop.getPoi().getPoiType() == PoiType.AREAOBJECT_LOCATION) {
                    if (logisticTourPartDto.getStopDtos().isEmpty()) {
                        logisticStopDto.setStopType(StopType.POI_START);
                    } else {
                        logisticStopDto.setStopType(StopType.POI_END);
                    }
                }
                logisticTourPartDto.getStopDtos().add(logisticStopDto);
            }
            logisticTourDto.getTourParts().add(logisticTourPartDto);
        }
        return logisticTourDto;
    }
}

