/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.util.swing.ImagePosition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FileUtils;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Holder;

public class ClientSwingUtil {
    public static JScrollPane scrollTextArea(JTextArea textArea, Rectangle rectangle, boolean editable) {
        if (!editable) {
            textArea.setBackground(UIManager.getDefaults().getColor("TextField.color"));
        }
        textArea.setLineWrap(true);
        JScrollPane scroller = new JScrollPane(textArea);
        if (rectangle != null) {
            scroller.setBounds(rectangle);
        }
        return scroller;
    }

    public static JPanel createPanelForComponent(Component comp, String title, String borderLayout) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(comp, borderLayout);
        if (title != null) {
            panel.setBorder(BorderFactory.createTitledBorder(title));
        } else {
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        return panel;
    }

    public static JPanel createPanelForComponent(Component comp, String title) {
        return ClientSwingUtil.createPanelForComponent(comp, title, "Center");
    }

    public static JLabel createLabelWithTextFieldFont(String text, int border) {
        JLabel label = new JLabel(text);
        label.setFont(UIManager.getDefaults().getFont("TextField.font"));
        label.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
        return label;
    }

    public static boolean validatePassword(char[] firstPasswd, char[] secondPasswd) {
        if (firstPasswd.length != secondPasswd.length) {
            return false;
        }
        for (int i = 0; i < firstPasswd.length; ++i) {
            if (firstPasswd[i] == secondPasswd[i]) continue;
            return false;
        }
        return true;
    }

    public static Color getColorFromRgb(int rgb) {
        int blue = rgb >> 0 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int red = rgb >> 16 & 0xFF;
        return new Color(red, green, blue);
    }

    public static void expandAll(JTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        ClientSwingUtil.expandAll(tree, new TreePath(root));
    }

    public static void expandAll(JTree tree, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                ClientSwingUtil.expandAll(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    public static void setSpinnerEnable(JSpinner spinner, boolean enable) {
        JFormattedTextField textField = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
        textField.setEditable(enable);
        for (Component child : spinner.getComponents()) {
            if ("Spinner.nextButton".equals(child.getName())) {
                ((JButton)child).setEnabled(enable);
            }
            if (!"Spinner.previousButton".equals(child.getName())) continue;
            ((JButton)child).setEnabled(enable);
        }
    }

    public static Image rotateImage(Image image, int degree) {
        BufferedImage bufferedimage = ClientSwingUtil.toBufferedImage(image);
        int w = bufferedimage.getWidth();
        int h = bufferedimage.getHeight();
        int type = bufferedimage.getColorModel().getTransparency();
        BufferedImage img = new BufferedImage(w, h, type);
        Graphics2D graphics2d = img.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2d.rotate(Math.toRadians(degree), w / 2, h / 2);
        graphics2d.drawImage((Image)bufferedimage, 0, 0, null);
        graphics2d.dispose();
        return img;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ClientSwingUtil.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static Image addLogoOnImage(Image image, Image logo, int logoWidth, int logoHeight, ImagePosition position) {
        if (image != null && logo != null) {
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            BufferedImage imageWithLogo = new BufferedImage(width, height, 1);
            Graphics2D g = imageWithLogo.createGraphics();
            g.drawImage(image, 0, 0, width, height, null);
            int x = 0;
            int y = 0;
            switch (position) {
                case TOP_LEFT: {
                    break;
                }
                case TOP_RIGHT: {
                    x = width - logoWidth;
                    break;
                }
                case BOTTOM_LEFT: {
                    y = height - logoHeight;
                    break;
                }
                case BOTTOM_RIGHT: {
                    x = width - logoWidth;
                    y = height - logoHeight;
                }
            }
            g.drawImage(logo, x, y, logoWidth, logoHeight, null);
            g.dispose();
            image.flush();
            return imageWithLogo;
        }
        return image;
    }

    public static JTextField createTextField(String text, boolean editable) {
        return ClientSwingUtil.createTextField(-1, text, editable);
    }

    public static JTextField createTextField(int size, String text, boolean editable) {
        JTextField textField = size > 0 ? new JTextField(size) : new JTextField();
        textField.setEditable(editable);
        if (text != null) {
            textField.setText(text);
        }
        return textField;
    }

    public static JTextField createParameterTextField(int size, String text, boolean editable, String fieldName, Holder<?> holder, Component parent) {
        return ClientSwingUtil.createParameterTextField(size, text, editable, fieldName, holder, parent, null);
    }

    public static JTextField createParameterTextField(int size, String text, boolean editable, String fieldName, Holder<?> holder, Component parent, String dateFormat) {
        return ClientSwingUtil.createParameterTextField(size, text, editable, fieldName, holder, parent, dateFormat, null);
    }

    public static JTextField createParameterTextField(int size, String text, boolean editable, final String fieldName, final Holder<?> holder, Component parent, final String dateFormat, final Class<?> clazz) {
        JTextField textField = new JTextField(size){
            private static final long serialVersionUID = -920325259896558890L;

            @Override
            public void repaint(long tm) {
                try {
                    Method getMethod = holder.getElement().getClass().getMethod("get" + fieldName, new Class[0]);
                    Class type = clazz == null ? getMethod.getReturnType() : clazz;
                    Object result = getMethod.invoke(holder.getElement(), null);
                    if (type.equals(String.class)) {
                        super.setText((String)result);
                    } else if (type.equals(Double.class)) {
                        super.setText(ClientFormUtil.getNumberString((Double)result));
                    } else if (type.equals(Integer.class)) {
                        super.setText(ClientFormUtil.getNumberString((Integer)result));
                    } else if (type.equals(Date.class) && dateFormat != null) {
                        super.setText(ClientFormUtil.getDateString((Date)result, dateFormat));
                    } else {
                        super.repaint(tm);
                    }
                }
                catch (Exception e) {
                    super.repaint(tm);
                }
            }
        };
        textField.setText(text == null ? "" : text);
        if (editable) {
            ClientSwingUtil.addListener(fieldName, holder, parent, textField, dateFormat, clazz);
        } else {
            textField.setEditable(false);
        }
        return textField;
    }

    public static JTextArea createParameterTextArea(int rows, int columns, String text, boolean editable, final String fieldName, final Holder<?> holder, Component parent) {
        JTextArea textArea = new JTextArea(rows, columns){
            private static final long serialVersionUID = -8763558147393001894L;

            @Override
            public void repaint() {
                this.repaint(0L);
            }

            @Override
            public void repaint(long tm) {
                try {
                    Method getMethod = holder.getElement().getClass().getMethod("get" + fieldName, new Class[0]);
                    Class<?> type = getMethod.getReturnType();
                    Object result = getMethod.invoke(holder.getElement(), null);
                    if (type.equals(String.class) && StringUtil.isBlank(super.getText())) {
                        super.setText((String)result);
                    } else {
                        super.repaint(tm);
                    }
                }
                catch (Exception e) {
                    super.repaint(tm);
                }
            }
        };
        textArea.setText(text == null ? "" : text);
        if (editable) {
            ClientSwingUtil.addListener(fieldName, holder, parent, textArea, null, null);
        }
        return textArea;
    }

    private static void addListener(final String fieldName, final Holder<?> holder, final Component parent, final JTextComponent textComponent, final String dateFormat, final Class<?> clazz) {
        textComponent.addFocusListener(new FocusListener(){
            private String oldText = null;

            @Override
            public void focusGained(FocusEvent e) {
                this.oldText = textComponent.getText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                String errorMessage = null;
                Object o = holder.getElement();
                if (o != null) {
                    try {
                        Method getMethod = o.getClass().getMethod("get" + fieldName, new Class[0]);
                        Class type = getMethod.getReturnType();
                        Method setMethod = o.getClass().getMethod("set" + fieldName, type);
                        type = clazz == null ? type : clazz;
                        String text = textComponent.getText();
                        if (!StringUtil.isBlank(text)) {
                            if (type.equals(String.class)) {
                                setMethod.invoke(o, text);
                            } else if (type.equals(Double.class)) {
                                try {
                                    Number number = ClientFormUtil.getNumber(text);
                                    setMethod.invoke(o, number.doubleValue());
                                }
                                catch (ParseException ex) {
                                    errorMessage = "Bitte eine Gleitkommazahl geben.";
                                }
                            } else if (type.equals(Integer.class)) {
                                try {
                                    Number number = ClientFormUtil.getNumber(text);
                                    setMethod.invoke(o, number.intValue());
                                }
                                catch (ParseException ex) {
                                    errorMessage = "Bitte eine Ganzzahl geben.";
                                }
                            } else if (type.equals(Date.class)) {
                                Date date = ClientFormUtil.stringToDate(text, dateFormat);
                                if (date == null) {
                                    text = text + " 00:00";
                                    date = ClientFormUtil.stringToDate(text, dateFormat);
                                }
                                if (date == null) {
                                    errorMessage = "Bitte ein Datum eingeben. Format: " + dateFormat;
                                } else {
                                    setMethod.invoke(o, date);
                                }
                            }
                        } else {
                            setMethod.invoke(o, new Object[]{null});
                        }
                    }
                    catch (Exception ex) {
                        errorMessage = ex.getMessage();
                    }
                }
                if (errorMessage != null) {
                    JOptionPane.showConfirmDialog(parent, errorMessage, "", -1, 2);
                    textComponent.setText(this.oldText);
                }
            }
        });
    }

    public static void saveContentToFile(byte[] content, Component parent) {
        if (content != null && content.length > 0) {
            int d;
            JFileChooser fileChooser = new JFileChooser(System.getProperty("user.home"));
            while ((d = fileChooser.showSaveDialog(parent)) == 0) {
                File file = fileChooser.getSelectedFile();
                d = 0;
                if (file.exists()) {
                    d = JOptionPane.showConfirmDialog(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question.overwriteFile", new Serializable[]{file.getAbsolutePath()}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
                }
                if (d != 0) continue;
                try {
                    FileUtils.writeByteArrayToFile(fileChooser.getSelectedFile(), content);
                    break;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(parent, e.getMessage());
                }
            }
        }
    }

    public static JScrollPane createScrollPane(final JPanel pane) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)pane, "North");
        JScrollPane scrollPane = new JScrollPane(p){
            private static final long serialVersionUID = -5041469075642398039L;

            @Override
            public void repaint(long tm) {
                for (Component c : pane.getComponents()) {
                    c.repaint(10L);
                }
                super.repaint(tm);
            }
        };
        return scrollPane;
    }
}

