/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.AreaTourPartModel;
import de.datomino.peppergis.client.util.AreaStopModelUtil;
import de.datomino.peppergis.helper.PointEntity;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.peppergis.util.NightSurchargeTimeWindow;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaTourModelUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AreaTourModelUtil.class);
    public static NightSurchargeTimeWindow NIGHT;

    public static int countStops(AreaTourModel areaTour) {
        int count = 0;
        Iterator<AreaTourPartModel> areaTourPartIter = areaTour.iterateAreaTourParts();
        while (areaTourPartIter.hasNext()) {
            AreaTourPartModel areaTourPart = areaTourPartIter.next();
            count += areaTourPart.countAreaStops();
        }
        return count;
    }

    public static List<PointEntity> getAllPointTupels(AreaTourModel areaTour, boolean onlyModels) {
        ArrayList<PointEntity> points = new ArrayList<PointEntity>();
        Iterator<AreaTourPartModel> areaTourPartIter = areaTour.iterateAreaTourParts();
        while (areaTourPartIter.hasNext()) {
            AreaTourPartModel areaTourPart = areaTourPartIter.next();
            List<PointEntity> areaTourPartPoints = AreaTourModelUtil.getAreaTourPartPoints(areaTourPart, onlyModels);
            if (areaTourPartPoints == null) {
                points.clear();
                break;
            }
            points.addAll(areaTourPartPoints);
        }
        return points;
    }

    public static List<PointEntity> getAreaTourPartPoints(AreaTourPartModel areaTourPart, boolean onlyModels) {
        ArrayList<PointEntity> points = new ArrayList<PointEntity>();
        Iterator<AreaStopModel> areaStopIter = areaTourPart.iterateAreaStops();
        while (areaStopIter.hasNext()) {
            AreaStopModel areaStop = areaStopIter.next();
            if (onlyModels && areaStop.getPoi() != null) continue;
            if (areaStop.getAccessLocation() == null) {
                points = null;
                break;
            }
            PointEntity pointEntity = AreaStopModelUtil.getPointTupel(areaStop);
            if (pointEntity == null) {
                points = null;
                break;
            }
            points.add(pointEntity);
        }
        return points;
    }

    public static void deleteAreaTour(AreaTourModel areaTour, ModelEnviroment modelEnviroment) {
        for (AreaTourPartModel areaTourPart : areaTour.iterableAreaTourParts()) {
            AreaTourModelUtil.deleteAreaTourPart(areaTourPart, modelEnviroment);
        }
        if (areaTour.getId() != null) {
            areaTour.delete();
        } else {
            Collection<AreaTourModel> unsavedAreaTours = modelEnviroment.getUndoManager().getChangedObjects(AreaTourModel.class);
            unsavedAreaTours.remove(areaTour);
            modelEnviroment.getModelCache().evictModel(areaTour);
        }
    }

    public static void deleteAreaTourPart(AreaTourPartModel areaTourPart, ModelEnviroment modelEnviroment) {
        for (AreaStopModel areaStop : areaTourPart.iterableAreaStops()) {
            AreaStopModelUtil.deleteAreaStop(areaStop, modelEnviroment);
        }
        if (areaTourPart.getId() != null) {
            areaTourPart.delete();
        } else {
            Collection<AreaTourPartModel> unsavedAreaTourParts = modelEnviroment.getUndoManager().getChangedObjects(AreaTourPartModel.class);
            unsavedAreaTourParts.remove(areaTourPart);
            modelEnviroment.getModelCache().evictModel(areaTourPart);
        }
    }

    public static void deleteAreaTours(Collection<AreaTourModel> toDeletes, ModelEnviroment modelEnviroment) {
        for (AreaTourModel toDelete : toDeletes) {
            AreaTourModelUtil.deleteAreaTour(toDelete, modelEnviroment);
        }
    }

    public static LinkedHashMap<AreaTourModel, Color> getToursWithColor(Collection<AreaTourModel> tours) {
        Color color = null;
        LinkedHashMap<AreaTourModel, Color> toursWithColor = new LinkedHashMap<AreaTourModel, Color>(tours.size(), 0.75f, true);
        for (AreaTourModel tour : tours) {
            color = GeoUtil.getNextColor(color);
            toursWithColor.put(tour, color);
        }
        return toursWithColor;
    }

    public static Integer getMeterDistanceOfTour(AreaTourModel areaTour) {
        Integer distance = 0;
        for (AreaTourPartModel tourPart : areaTour.iterableAreaTourParts()) {
            if (tourPart.countAreaStops() <= 1) continue;
            AreaStopModel last = tourPart.getAreaStopAt(tourPart.countAreaStops() - 1);
            Integer distanceOfLast = last.getMetersFromStart() == null ? 0 : last.getMetersFromStart();
            distance = distance + distanceOfLast;
        }
        return distance;
    }

    public static int hasRightType(AreaTourModel areaTour, RouteVehicleType vehicleType, RouteType routeType) {
        int i = -1;
        for (AreaTourPartModel part : areaTour.iterableAreaTourParts()) {
            if (part.getRouteVehicleType() == null || part.getRouteType() == null) break;
            i = 0;
            if (part.getRouteVehicleType() == vehicleType && part.getRouteType() == routeType) {
                i = 1;
            }
            if (i != 0) continue;
            break;
        }
        return i;
    }

    public static AreaTourModel findBetter(AreaTourModel areaTour1, AreaTourModel areaTour2, RouteVehicleType vehicleType, ModelEnviroment modelEnviroment) throws LogisticException {
        Integer sum1 = null;
        Integer sum2 = null;
        if (areaTour1.getDistanceSum() == null || areaTour1.getDistanceSum() == null) {
            modelEnviroment.getAllCaller().getTourCaller().calculateAreaTour(areaTour1, modelEnviroment, true);
        }
        if (areaTour2.getDistanceSum() == null || areaTour2.getDistanceSum() == null) {
            modelEnviroment.getAllCaller().getTourCaller().calculateAreaTour(areaTour2, modelEnviroment, true);
        }
        switch (vehicleType) {
            case BIKE: 
            case FOOT: {
                sum1 = areaTour1.getDistanceSum();
                sum2 = areaTour2.getDistanceSum();
                break;
            }
            case MOTORCAR: {
                sum1 = areaTour1.getDistanceSum();
                sum2 = areaTour2.getDistanceSum();
            }
        }
        if (sum2 != null && sum1 != null && sum2 < sum1) {
            return areaTour2;
        }
        return areaTour1;
    }

    static {
        int startHour = 0;
        int startMinute = 0;
        int endHour = 0;
        int endMinute = 0;
        boolean initNight = false;
        String nightString = ModelEnviroment.getProperties().getProperty("areatour.nightSurcharge.timeWindow");
        try {
            String[] nightSplit = nightString.split("-");
            String[] start = nightSplit[0].split(":");
            String[] end = nightSplit[1].split(":");
            startHour = Integer.valueOf(start[0]);
            startMinute = Integer.valueOf(start[1]);
            endHour = Integer.valueOf(end[0]);
            endMinute = Integer.valueOf(end[1]);
        }
        catch (Exception e) {
            initNight = true;
        }
        if (startHour < 0 || startHour > 23 || startMinute < 0 || startMinute > 59) {
            initNight = true;
        } else if (endHour < 0 || endHour > 23 || endMinute < 0 || endMinute > 59) {
            initNight = true;
        } else if (startHour < endHour) {
            initNight = true;
        }
        if (initNight) {
            startHour = 23;
            startMinute = 0;
            endHour = 6;
            endMinute = 0;
        }
        NIGHT = new NightSurchargeTimeWindow(startHour, startMinute, endHour, endMinute);
        LOGGER.info("time window for night surcharge: " + NIGHT.toString());
    }
}

