/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelDialog;
import de.datomino.peppergis.client.gui.poi.PoiDialog;
import de.datomino.peppergis.client.gui.subscription.SubscriptionDialog;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.PoiModelUtil;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.helper.PointEntity;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.type.PoiType;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Collection;

public class AreaStopModelUtil {
    public static PointEntity getPointTupel(AreaStopModel areaStop) {
        Long id = null;
        ImmutablePoint geom = null;
        Double parcelLocation = null;
        if (areaStop.getPoi() != null) {
            id = areaStop.getPoi().getTempUUID();
            geom = LocationModelUtil.getGeom(areaStop.getPoi().getLocation());
            parcelLocation = ParcelModelUtil.getParcelLocation(areaStop.getPoi().getLocation().getParcel());
        } else if (areaStop.getSubscription() != null) {
            id = areaStop.getSubscription().getTempUUID();
            geom = SubscriptionModelUtil.getGeom(areaStop.getSubscription());
            parcelLocation = ParcelModelUtil.getParcelLocation(areaStop.getSubscription().getLocation().getParcel());
        } else if (areaStop.getParcel() != null) {
            id = areaStop.getParcel().getTempUUID();
            geom = areaStop.getParcel().getGeom();
            parcelLocation = ParcelModelUtil.getParcelLocation(areaStop.getParcel());
        } else if (areaStop.getLetter() != null) {
            id = areaStop.getLetter().getTempUUID();
            geom = LetterModelUtil.getGeom(areaStop.getLetter());
            parcelLocation = ParcelModelUtil.getParcelLocation(areaStop.getLetter().getLocation().getParcel());
        }
        if (id == null || geom == null) {
            return null;
        }
        PointEntity pointEntity = new PointEntity(new PointEntityId(id, AreaStopModelUtil.getPointEntityType(areaStop)), geom, areaStop.getAccessLocation());
        pointEntity.setParcelLocation(parcelLocation);
        return pointEntity;
    }

    public static PointEntityId.PointEnityType getPointEntityType(AreaStopModel areaStop) {
        PointEntityId.PointEnityType pointEnityType = null;
        if (areaStop.getPoi() != null) {
            pointEnityType = PointEntityId.PointEnityType.POI;
        } else if (areaStop.getParcel() != null) {
            pointEnityType = PointEntityId.PointEnityType.PARCEL;
        } else if (areaStop.getSubscription() != null) {
            pointEnityType = PointEntityId.PointEnityType.SUBSCRIPTION;
        } else if (areaStop.getLetter() != null) {
            pointEnityType = PointEntityId.PointEnityType.LETTER;
        }
        return pointEnityType;
    }

    public static void deleteAreaStop(AreaStopModel areaStop, ModelEnviroment modelEnviroment) {
        PoiModel poi = areaStop.getPoi();
        if (poi != null && poi.getPoiType() == PoiType.END_POINT) {
            PoiModelUtil.deletePoi(poi, modelEnviroment, false);
        }
        if (areaStop.getId() != null) {
            areaStop.delete();
        } else {
            Collection<AreaStopModel> unsavedAreaStops = modelEnviroment.getUndoManager().getChangedObjects(AreaStopModel.class);
            unsavedAreaStops.remove(areaStop);
            modelEnviroment.getModelCache().evictModel(areaStop);
        }
    }

    public static String getAddressString(AreaStopModel areaStop) {
        String s = "";
        if (areaStop.getPoi() != null) {
            s = LocationModelUtil.getAddressString(areaStop.getPoi().getLocation());
        } else if (areaStop.getParcel() != null) {
            s = ParcelModelUtil.getAddress(areaStop.getParcel());
        } else if (areaStop.getSubscription() != null) {
            s = LocationModelUtil.getAddressString(areaStop.getSubscription().getLocation());
        }
        return s;
    }

    public static LegendObject<Model> getModel(AreaStopModel areaStop) {
        Model m = null;
        if (areaStop.getPoi() != null) {
            m = areaStop.getPoi();
        } else if (areaStop.getSubscription() != null) {
            m = areaStop.getSubscription();
        } else if (areaStop.getParcel() != null) {
            m = areaStop.getParcel();
        }
        return new LegendObject<Model>(m, 0);
    }

    public static void createAndShowDialog(AreaStopModel selectedStop, ModelEnviroment modelEnviroment, Window parent) {
        if (selectedStop != null) {
            if (selectedStop.getPoi() != null) {
                PoiDialog poiDialog = new PoiDialog(parent, CollectionUtil.buildArrayList(selectedStop.getPoi()), modelEnviroment);
                poiDialog.setVisible(true);
            } else if (selectedStop.getSubscription() != null) {
                SubscriptionDialog subscriptionDialog = new SubscriptionDialog(parent, CollectionUtil.buildArrayList(selectedStop.getSubscription()), modelEnviroment);
                subscriptionDialog.setVisible(true);
            } else if (selectedStop.getParcel() != null) {
                ParcelDialog parcelDialog = new ParcelDialog(parent, selectedStop.getParcel(), Dialog.ModalityType.MODELESS, modelEnviroment, false);
                parcelDialog.setVisible(true);
            }
        }
    }
}

