/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.logistic.dto.LogisticTourPartDto;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModelImpl;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundModel;
import de.datomino.peppergis.client.model.area.AreaFilterPatternRelationAreaLayerRelationModel;
import de.datomino.peppergis.client.model.area.AreaFilterPatternRelationAreaLayerRelationModelImpl;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaLayerModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectRelModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectGenSegmentModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenSegmentModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectGenSegmentRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenSegmentRelModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModelImpl;
import de.datomino.peppergis.client.model.area.AreaStaticChoiceAttributeValueModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModel;
import de.datomino.peppergis.client.model.base.PoiFilterPatternRelationAreaLayerRelationModel;
import de.datomino.peppergis.client.model.base.PoiFilterPatternRelationAreaLayerRelationModelImpl;
import de.datomino.peppergis.client.model.base.SubscriptionFilterPatternRelationAreaLayerRelationModel;
import de.datomino.peppergis.client.model.base.SubscriptionFilterPatternRelationAreaLayerRelationModelImpl;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternRelationAreaLayerRelationModel;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternRelationAreaLayerRelationModelImpl;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.StringComparator;
import de.datomino.util.comparator.ComparatorBuilder;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.time.TimeUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class AreaObjectModelUtil {
    public static Collection<Coordinate> getAreaRectangle(AreaObjectModel areaObjectModel) {
        ImmutablePolygonKind geom = areaObjectModel.getGeom();
        if (geom != null) {
            CoordinateFactory coordinateFactory = geom.getCoordinateFactory();
            double maxX = geom.getMaxX();
            double maxY = geom.getMaxY();
            double minX = geom.getMinX();
            double minY = geom.getMinY();
            HashSet<Coordinate> areaRectangle = new HashSet<Coordinate>(2);
            areaRectangle.add(coordinateFactory.createCoordinate(minX, minY));
            areaRectangle.add(coordinateFactory.createCoordinate(maxX, maxY));
            return areaRectangle;
        }
        return Collections.emptySet();
    }

    public static void removeOldRelationsOfAreaObject(AreaObjectModel area, Collection<ParcelModel> parcels) {
        Iterator<AreaObjectParcelRelModel> rels = area.iterateAreaObjectParcelRel();
        while (rels.hasNext()) {
            AreaObjectParcelRelModel rel = rels.next();
            ParcelModel parcel = rel.getParcel();
            if (parcels.contains(parcel)) continue;
            parcel.removeAAreaObjectParcelRel(rel);
            area.removeAAreaObjectParcelRel(rel);
            rel.delete();
            rels = area.iterateAreaObjectParcelRel();
        }
    }

    public static boolean isContains(AreaObjectModel area, ParcelModel parcel) {
        Iterator<AreaObjectParcelRelModel> rels = area.iterateAreaObjectParcelRel();
        while (rels.hasNext()) {
            AreaObjectParcelRelModel rel = rels.next();
            if (!rel.getParcel().equals(parcel)) continue;
            return true;
        }
        return false;
    }

    public static Integer getIntValue(AreaObjectModel areaObject, AreaAttributeValueDescriptorModel descriptor) {
        Integer values = null;
        Iterator<AreaAttributeValueModel> valueIter = areaObject.iterateAreaAttributeValues();
        try {
            while (valueIter.hasNext()) {
                AreaAttributeValueModel value = valueIter.next();
                if (!value.getAreaAttributeValueDescriptor().equals(descriptor)) continue;
                Integer integerValue = value.getIntegerValue();
                if (integerValue == null) {
                    integerValue = 0;
                }
                values = values == null ? integerValue : values + integerValue;
            }
        }
        catch (ConcurrentModificationException ex) {
            return AreaObjectModelUtil.getIntValue(areaObject, descriptor);
        }
        return values;
    }

    public static String getStringRepresantation(AreaAttributeValueModel valueModel) {
        switch (valueModel.getAreaAttributeValueDescriptor().getAttributeValueType()) {
            case BOOLEAN: {
                Boolean booleanValue = valueModel.getBooleanValue();
                return booleanValue == null ? "" : (booleanValue != false ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.yes", new Serializable[0]) : ModelEnviroment.getMessageResolver().resolveMessage("messages.default.no", new Serializable[0]));
            }
            case DATE: {
                Long longValue = valueModel.getLongValue();
                return longValue == null ? "" : new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date(longValue));
            }
            case FLOAT: {
                Double floatValue = valueModel.getFloatValue();
                return floatValue == null ? "" : floatValue.toString();
            }
            case INTEGER: {
                Integer integerValue = valueModel.getIntegerValue();
                return integerValue == null ? "" : integerValue.toString();
            }
            case MULTIPLE_LIST_CHOICE: {
                String selectedMultipleListChoiceValues = valueModel.getSelectedMultipleListChoiceValues();
                return selectedMultipleListChoiceValues == null ? "" : selectedMultipleListChoiceValues;
            }
            case STATIC_CHOICE: {
                AreaStaticChoiceAttributeValueModel staticChoiceValue = valueModel.getStaticChoiceValue();
                String name = staticChoiceValue == null ? "" : staticChoiceValue.getName();
                return name == null ? "" : name;
            }
            case STRING: {
                String stringValue = valueModel.getStringValue();
                return stringValue == null ? "" : stringValue;
            }
            case TEXT: {
                String textValue = valueModel.getTextValue();
                return textValue == null ? "" : textValue;
            }
            case IMAGE: 
            case PDF_DOWN: {
                return "";
            }
        }
        return "???";
    }

    public static Integer getSourceIntValue(AreaObjectModel areaObject, AreaAttributeValueDescriptorModel descriptor) {
        AreaObjectGenAreaObjectModel areaObjectGenAreaObject;
        Integer values = 0;
        AreaObjectGenInfoModel genInfo = areaObject.getGenInfo();
        if (genInfo != null && (areaObjectGenAreaObject = genInfo.getAreaObjectGenAreaObject()) != null) {
            for (AreaObjectGenAreaObjectRelModel rel : areaObjectGenAreaObject.iterableAreaObjects()) {
                Integer value;
                AreaObjectModel sub = rel.getAreaObject();
                if (sub == null || (value = AreaObjectModelUtil.getIntValue(sub, descriptor)) == null) continue;
                values = values + value;
            }
        }
        return values;
    }

    public static Double getSourceDoubleValue(AreaObjectModel areaObject, AreaAttributeValueDescriptorModel descriptor) {
        AreaObjectGenAreaObjectModel areaObjectGenAreaObject;
        Double values = 0.0;
        AreaObjectGenInfoModel genInfo = areaObject.getGenInfo();
        if (genInfo != null && (areaObjectGenAreaObject = genInfo.getAreaObjectGenAreaObject()) != null) {
            for (AreaObjectGenAreaObjectRelModel rel : areaObjectGenAreaObject.iterableAreaObjects()) {
                Double value;
                AreaObjectModel sub = rel.getAreaObject();
                if (sub == null || (value = AreaObjectModelUtil.getDoubleValue(sub, descriptor)) == null) continue;
                values = values + value;
            }
        }
        return values;
    }

    public static Double getDoubleValue(AreaObjectModel areaObject, AreaAttributeValueDescriptorModel descriptor) {
        Iterator<AreaAttributeValueModel> valueIter = areaObject.iterateAreaAttributeValues();
        while (valueIter.hasNext()) {
            AreaAttributeValueModel value = valueIter.next();
            if (!value.getAreaAttributeValueDescriptor().equals(descriptor)) continue;
            Double floatValue = value.getFloatValue();
            return floatValue;
        }
        return null;
    }

    public static String getShortcutAndDisplayname(AreaObjectModel areaObject) {
        if (areaObject == null) {
            return "";
        }
        String delim = ModelEnviroment.getProperties().getProperty("area.name.rendering.delim");
        if (delim == null) {
            delim = "-";
        }
        delim = " " + delim + " ";
        return FormUtil.getStringDisplay(areaObject.getShortcut()) + delim + FormUtil.getStringDisplay(areaObject.getDisplayname());
    }

    public static AreaLayerModel cloneAreaLayer(AreaLayerModel areaLayer, String newName) {
        AbstractModel newModel;
        AreaLayerModelImpl newAreaLayer = new AreaLayerModelImpl();
        newAreaLayer.setDisplayname(newName);
        newAreaLayer.setDiscriminator(areaLayer.getDiscriminator());
        for (AreaFilterPatternRelationAreaLayerRelationModel areaFilterPatternRelationAreaLayerRelationModel : areaLayer.iterableAreaFilterPatternRelationAreaLayerRelations()) {
            newModel = new AreaFilterPatternRelationAreaLayerRelationModelImpl();
            newModel.setAreaFilterPatternSetup(areaFilterPatternRelationAreaLayerRelationModel.getAreaFilterPatternSetup());
            newAreaLayer.addAreaFilterPatternRelationAreaLayerRelation((AreaFilterPatternRelationAreaLayerRelationModel)((Object)newModel));
        }
        for (AreaObjectModel areaObjectModel : areaLayer.iterableAreaObjects()) {
            newAreaLayer.addAreaObject(AreaObjectModelUtil.cloneAreaObject(areaObjectModel));
        }
        for (ParcelFilterPatternRelationAreaLayerRelationModel parcelFilterPatternRelationAreaLayerRelationModel : areaLayer.iterableParcelFilterPatternRelationAreaLayerRelations()) {
            newModel = new ParcelFilterPatternRelationAreaLayerRelationModelImpl();
            newModel.setParcelFilterPatternSetup(parcelFilterPatternRelationAreaLayerRelationModel.getParcelFilterPatternSetup());
            newAreaLayer.addParcelFilterPatternRelationAreaLayerRelation((ParcelFilterPatternRelationAreaLayerRelationModel)((Object)newModel));
        }
        for (PoiFilterPatternRelationAreaLayerRelationModel poiFilterPatternRelationAreaLayerRelationModel : areaLayer.iterablePoiFilterPatternRelationAreaLayerRelations()) {
            newModel = new PoiFilterPatternRelationAreaLayerRelationModelImpl();
            newModel.setPoiFilterPatternSetup(poiFilterPatternRelationAreaLayerRelationModel.getPoiFilterPatternSetup());
            newAreaLayer.addPoiFilterPatternRelationAreaLayerRelation((PoiFilterPatternRelationAreaLayerRelationModel)((Object)newModel));
        }
        for (SubscriptionFilterPatternRelationAreaLayerRelationModel subscriptionFilterPatternRelationAreaLayerRelationModel : areaLayer.iterableSubscriptionFilterPatternRelationAreaLayerRelations()) {
            newModel = new SubscriptionFilterPatternRelationAreaLayerRelationModelImpl();
            newModel.setSubscriptionFilterPatternSetup(subscriptionFilterPatternRelationAreaLayerRelationModel.getSubscriptionFilterPatternSetup());
            newAreaLayer.addSubscriptionFilterPatternRelationAreaLayerRelation((SubscriptionFilterPatternRelationAreaLayerRelationModel)((Object)newModel));
        }
        return newAreaLayer;
    }

    public static AreaObjectModel cloneAreaObject(AreaObjectModel areaObject) {
        AreaObjectModelImpl newAreaObject = new AreaObjectModelImpl();
        newAreaObject.setDisplayname(areaObject.getDisplayname());
        newAreaObject.setGeom(areaObject.getGeom());
        newAreaObject.setPoi(areaObject.getPoi());
        newAreaObject.setShortcut(areaObject.getShortcut());
        AreaObjectGenInfoModel genInfo = areaObject.getGenInfo();
        if (genInfo != null) {
            AreaObjectGenSegmentModel genSegment;
            AreaObjectGenInfoModelImpl newGenInfo = new AreaObjectGenInfoModelImpl();
            AreaObjectGenAreaObjectModel genAreaObject = genInfo.getAreaObjectGenAreaObject();
            if (genAreaObject != null) {
                AreaObjectGenAreaObjectModelImpl newGenAreaObject = new AreaObjectGenAreaObjectModelImpl();
                for (AreaObjectGenAreaObjectRelModel genAreaObjectRel : genAreaObject.iterableAreaObjects()) {
                    AreaObjectGenAreaObjectRelModelImpl newGenAreaObjectRel = new AreaObjectGenAreaObjectRelModelImpl();
                    newGenAreaObjectRel.setAreaObject(genAreaObjectRel.getAreaObject());
                    newGenAreaObject.addAreaObject(newGenAreaObjectRel);
                }
                newGenInfo.setAreaObjectGenAreaObject(newGenAreaObject);
            }
            if ((genSegment = genInfo.getAreaObjectGenSegment()) != null) {
                AreaObjectGenSegmentModelImpl newGenSegment = new AreaObjectGenSegmentModelImpl();
                for (AreaObjectGenSegmentRelModel genSideRel : genSegment.iterableSegments()) {
                    AreaObjectGenSegmentRelModelImpl newGenSegmentRel = new AreaObjectGenSegmentRelModelImpl();
                    newGenSegmentRel.setSegment(genSideRel.getSegment());
                    newGenSegment.addSegment(newGenSegmentRel);
                }
                newGenInfo.setAreaObjectGenSegment(newGenSegment);
            }
            newAreaObject.setGenInfo(newGenInfo);
        }
        for (AreaAttributeValueModel attributeValue : areaObject.iterableAreaAttributeValues()) {
            AreaAttributeValueModelImpl newAttributeValue = new AreaAttributeValueModelImpl();
            newAttributeValue.setAreaAttributeValueDescriptor(attributeValue.getAreaAttributeValueDescriptor());
            newAttributeValue.setAreaObject(newAreaObject);
            newAttributeValue.setBooleanValue(attributeValue.getBooleanValue());
            newAttributeValue.setFloatValue(attributeValue.getFloatValue());
            newAttributeValue.setIntegerValue(attributeValue.getIntegerValue());
            newAttributeValue.setLongValue(attributeValue.getLongValue());
            newAttributeValue.setMultipleListChoiceValues(attributeValue.getMultipleListChoiceValues());
            newAttributeValue.setSelectedMultipleListChoiceValues(attributeValue.getSelectedMultipleListChoiceValues());
            newAttributeValue.setStaticChoiceValue(attributeValue.getStaticChoiceValue());
            newAttributeValue.setStringValue(attributeValue.getStringValue());
            newAttributeValue.setTextValue(attributeValue.getTextValue());
            newAreaObject.addAreaAttributeValue(newAttributeValue);
        }
        for (AreaObjectParcelRelModel parcelRel : areaObject.iterableAreaObjectParcelRel()) {
            AreaObjectParcelRelModelImpl newParcelRel = new AreaObjectParcelRelModelImpl();
            newParcelRel.setParcel(parcelRel.getParcel());
            newAreaObject.addAAreaObjectParcelRel(newParcelRel);
        }
        return newAreaObject;
    }

    public static int mappingParcelsToArea(AreaObjectModel area, ModelEnviroment modelEnviroment) {
        int sum = 0;
        ImmutablePolygonKind polygon = area.getGeom();
        if (polygon != null) {
            CoordinateFactory factory = polygon.getCoordinateFactory();
            Coordinate topLeft = factory.createCoordinate(polygon.getMinX(), polygon.getMaxY());
            Coordinate bottomRight = factory.createCoordinate(polygon.getMaxX(), polygon.getMinY());
            Collection<ParcelModel> parcels = modelEnviroment.getAllCaller().getStreetNetCaller().fetchParcels(topLeft, bottomRight, true);
            AreaObjectModelUtil.removeOldRelationsOfAreaObject(area, parcels);
            for (ParcelModel parcel : parcels) {
                if (!polygon.contains(parcel.getGeom()) || AreaObjectModelUtil.isContains(area, parcel)) continue;
                AreaObjectParcelRelModelImpl rel = new AreaObjectParcelRelModelImpl();
                rel.setAreaObject(area);
                rel.setParcel(parcel);
                parcel.addAAreaObjectParcelRel(rel);
                ++sum;
            }
        }
        return sum;
    }

    public static Set<AreaObjectModel> getKnownAreaObjects(AreaObjectGenAreaObjectModel areaObjectinfo) {
        HashSet<AreaObjectModel> result = new HashSet<AreaObjectModel>();
        for (AreaObjectGenAreaObjectRelModel rel : areaObjectinfo.iterableAreaObjects()) {
            result.add(rel.getAreaObject());
        }
        return result;
    }

    public static Set<SegmentModel> getKnownSegments(AreaObjectGenSegmentModel segmentInfo) {
        HashSet<SegmentModel> result = new HashSet<SegmentModel>();
        if (segmentInfo != null) {
            for (AreaObjectGenSegmentRelModel rel : segmentInfo.iterableSegments()) {
                result.add(rel.getSegment());
            }
        }
        return result;
    }

    public static void updateNumberAttributeValues(AreaObjectModel area, Collection<AreaObjectModel> changedSet, AreaObjectChangeType changeType) {
        AreaObjectGenAreaObjectModel genAreaObject = AreaObjectModelUtil.getGeninfo(area);
        HashSet<AreaObjectModel> toAdd = new HashSet<AreaObjectModel>();
        HashSet<AreaObjectModel> toRemove = new HashSet<AreaObjectModel>();
        Set<AreaObjectModel> known = AreaObjectModelUtil.getKnownAreaObjects(genAreaObject);
        for (AreaObjectModel areaObjectDo : changedSet) {
            if (known.contains(areaObjectDo)) continue;
            toAdd.add(areaObjectDo);
        }
        for (AreaObjectModel areaObject : known) {
            if (changedSet.contains(areaObject)) continue;
            toRemove.add(areaObject);
        }
        switch (changeType) {
            case NEW: {
                area.clearAreaAttributeValues();
                toAdd.clear();
                toAdd.addAll(changedSet);
                break;
            }
            case ADD: {
                toRemove.clear();
                break;
            }
            case REMOVE: {
                toAdd.clear();
                break;
            }
        }
        HashMap<AreaAttributeValueDescriptorModel, Integer> intDescriptorMap = new HashMap<AreaAttributeValueDescriptorModel, Integer>();
        HashMap<AreaAttributeValueDescriptorModel, Double> doubleDescriptorMap = new HashMap<AreaAttributeValueDescriptorModel, Double>();
        for (AreaObjectModel add : toAdd) {
            AreaObjectModelUtil.loadDescriptorMap(intDescriptorMap, doubleDescriptorMap, add, 1);
        }
        for (AreaObjectModel remove : toRemove) {
            AreaObjectModelUtil.loadDescriptorMap(intDescriptorMap, doubleDescriptorMap, remove, -1);
        }
        for (AreaAttributeValueDescriptorModel intDescriptor : intDescriptorMap.keySet()) {
            AreaObjectModelUtil.updateIntValue(area, intDescriptor, (Integer)intDescriptorMap.get(intDescriptor));
        }
        for (AreaAttributeValueDescriptorModel doubleDescriptor : doubleDescriptorMap.keySet()) {
            AreaObjectModelUtil.updateDoubleValue(area, doubleDescriptor, (Double)doubleDescriptorMap.get(doubleDescriptor));
        }
    }

    private static void loadDescriptorMap(Map<AreaAttributeValueDescriptorModel, Integer> intDescriptorMap, Map<AreaAttributeValueDescriptorModel, Double> doubleDescriptorMap, AreaObjectModel area, int factor) {
        for (AreaAttributeValueModel value : area.iterableAreaAttributeValues()) {
            AreaAttributeValueDescriptorModel descriptor = value.getAreaAttributeValueDescriptor();
            AttributeValueType attributeValueType = descriptor.getAttributeValueType();
            switch (attributeValueType) {
                case INTEGER: {
                    Integer oldIntValue;
                    Integer intValue = AreaObjectModelUtil.getIntValue(area, descriptor);
                    if (intValue == null) {
                        intValue = 0;
                    }
                    if ((oldIntValue = intDescriptorMap.get(descriptor)) == null) {
                        oldIntValue = 0;
                    }
                    intDescriptorMap.put(descriptor, oldIntValue + intValue * factor);
                    break;
                }
                case FLOAT: {
                    Double oldDoubleValue;
                    Double doubleValue = AreaObjectModelUtil.getDoubleValue(area, descriptor);
                    if (doubleValue == null) {
                        doubleValue = 0.0;
                    }
                    if ((oldDoubleValue = doubleDescriptorMap.get(descriptor)) == null) {
                        oldDoubleValue = 0.0;
                    }
                    double dFactor = factor;
                    doubleDescriptorMap.put(descriptor, oldDoubleValue + doubleValue * dFactor);
                    break;
                }
            }
        }
    }

    public static void updateDoubleValue(AreaObjectModel area, AreaAttributeValueDescriptorModel doubleDescriptor, Double doubleValue) {
        boolean create = true;
        for (AreaAttributeValueModel value : area.iterableAreaAttributeValues()) {
            if (!value.getAreaAttributeValueDescriptor().equals(doubleDescriptor)) continue;
            Double oldDoubleValue = value.getFloatValue() == null ? 0.0 : value.getFloatValue();
            value.setFloatValue(oldDoubleValue + doubleValue);
            create = false;
            break;
        }
        if (create) {
            AreaAttributeValueModelImpl valueModel = new AreaAttributeValueModelImpl();
            valueModel.setAreaAttributeValueDescriptor(doubleDescriptor);
            valueModel.setAreaObject(area);
            valueModel.setFloatValue(doubleValue);
        }
    }

    public static void updateIntValue(AreaObjectModel area, AreaAttributeValueDescriptorModel intDescriptor, Integer intValue) {
        boolean create = true;
        for (AreaAttributeValueModel value : area.iterableAreaAttributeValues()) {
            if (!value.getAreaAttributeValueDescriptor().equals(intDescriptor)) continue;
            Integer oldIntValue = value.getIntegerValue() == null ? 0 : value.getIntegerValue();
            value.setIntegerValue(oldIntValue + intValue);
            create = false;
            break;
        }
        if (create) {
            AreaAttributeValueModelImpl valueModel = new AreaAttributeValueModelImpl();
            valueModel.setAreaAttributeValueDescriptor(intDescriptor);
            valueModel.setAreaObject(area);
            valueModel.setIntegerValue(intValue);
        }
    }

    private static AreaObjectGenAreaObjectModel getGeninfo(AreaObjectModel currentAreaObject) {
        AreaObjectGenInfoModel geninfo = currentAreaObject.getGenInfo();
        if (geninfo == null) {
            geninfo = new AreaObjectGenInfoModelImpl();
            geninfo.setAreaObject(currentAreaObject);
            AreaObjectGenAreaObjectModelImpl genareaobject = new AreaObjectGenAreaObjectModelImpl();
            geninfo.setAreaObjectGenAreaObject(genareaobject);
        }
        AreaObjectGenAreaObjectModel data = currentAreaObject.getGenInfo().getAreaObjectGenAreaObject();
        return data;
    }

    public static void setAreaAttributeValue(AreaObjectModel areaObject, AreaAttributeValueDescriptorModel descriptor, Object o) {
        AreaAttributeValueModel foundValue = null;
        for (AreaAttributeValueModel value : areaObject.iterableAreaAttributeValues()) {
            if (!value.getAreaAttributeValueDescriptor().equals(descriptor)) continue;
            if (foundValue == null) {
                foundValue = value;
                continue;
            }
            value.delete();
        }
        if (foundValue == null) {
            foundValue = new AreaAttributeValueModelImpl();
            foundValue.setAreaObject(areaObject);
            foundValue.setAreaAttributeValueDescriptor(descriptor);
            areaObject.addAreaAttributeValue(foundValue);
        }
        AreaObjectModelUtil.adaptValuesToModel(foundValue, o);
    }

    public static void adaptValuesToModel(AreaAttributeValueModel value, Object o) {
        AreaAttributeValueDescriptorModel descriptor = value.getAreaAttributeValueDescriptor();
        if (descriptor.getEditable().booleanValue()) {
            switch (descriptor.getAttributeValueType()) {
                case BOOLEAN: {
                    value.setBooleanValue((Boolean)o);
                    break;
                }
                case DATE: {
                    Date date = (Date)o;
                    value.setLongValue(date == null ? null : Long.valueOf(date.getTime()));
                    break;
                }
                case INTEGER: {
                    Number number = (Number)o;
                    value.setIntegerValue(number == null ? null : Integer.valueOf(number.intValue()));
                    break;
                }
                case STATIC_CHOICE: {
                    value.setStaticChoiceValue((AreaStaticChoiceAttributeValueModel)o);
                    break;
                }
                case STRING: {
                    value.setStringValue((String)o);
                    break;
                }
                case TEXT: {
                    value.setTextValue((String)o);
                    break;
                }
                case FLOAT: {
                    Number doubleValue = (Number)o;
                    value.setFloatValue(doubleValue == null ? null : Double.valueOf(doubleValue.doubleValue()));
                    break;
                }
            }
        }
    }

    public static void setAreaParameter(AreaObjectModel areaObject, LogisticTourPartDto<?> logisticTourPart, ModelEnviroment modelEnviroment) {
        Double difficultyLevel = null;
        Double parcelLocation = null;
        switch (logisticTourPart.getRouteVehicleType()) {
            case BIKE: {
                difficultyLevel = AreaObjectModelUtil.getRoutingDoubleValue(areaObject, modelEnviroment.getModelFromMap("AREA-DIFFICULTYLEVEL-BIKE"), 100.0);
                parcelLocation = AreaObjectModelUtil.getRoutingDoubleValue(areaObject, modelEnviroment.getModelFromMap("AREA-PARCELLOCATION-BIKE"), 100.0);
                break;
            }
            case FOOT: {
                difficultyLevel = AreaObjectModelUtil.getRoutingDoubleValue(areaObject, modelEnviroment.getModelFromMap("AREA-DIFFICULTYLEVEL-FOOT"), 100.0);
                parcelLocation = AreaObjectModelUtil.getRoutingDoubleValue(areaObject, modelEnviroment.getModelFromMap("AREA-PARCELLOCATION-FOOT"), 100.0);
                break;
            }
            case MOTORCAR: {
                difficultyLevel = AreaObjectModelUtil.getRoutingDoubleValue(areaObject, modelEnviroment.getModelFromMap("AREA-DIFFICULTYLEVEL-MOTOR"), 100.0);
                parcelLocation = AreaObjectModelUtil.getRoutingDoubleValue(areaObject, modelEnviroment.getModelFromMap("AREA-PARCELLOCATION-MOTOR"), 100.0);
            }
        }
        logisticTourPart.setDifficultLevel(difficultyLevel);
        logisticTourPart.setParcelLocation(parcelLocation);
    }

    public static void setAreaParameter(AreaObjectModel areaObject, LogisticTourPartDto<PointEntityId> logisticTourPart, AreaTourParameter areaTourParameter, ModelEnviroment modelEnviroment) {
        Boolean setParcelLocationDescriptor;
        Boolean setLevelDescriptor = areaTourParameter.getDifficultyLevelDescriptor();
        if (setLevelDescriptor == null) {
            setLevelDescriptor = false;
        }
        String difficultLevelDescriptor = null;
        if (setLevelDescriptor.booleanValue()) {
            switch (logisticTourPart.getRouteVehicleType()) {
                case BIKE: {
                    difficultLevelDescriptor = "AREA-DIFFICULTYLEVEL-BIKE";
                    break;
                }
                case FOOT: {
                    difficultLevelDescriptor = "AREA-DIFFICULTYLEVEL-FOOT";
                    break;
                }
                case MOTORCAR: {
                    difficultLevelDescriptor = "AREA-DIFFICULTYLEVEL-MOTOR";
                }
            }
        }
        if ((setParcelLocationDescriptor = areaTourParameter.getParcelLocationDescriptor()) == null) {
            setParcelLocationDescriptor = false;
        }
        String parcelLocationDescriptor = null;
        if (setParcelLocationDescriptor.booleanValue()) {
            switch (logisticTourPart.getRouteVehicleType()) {
                case BIKE: {
                    parcelLocationDescriptor = "AREA-PARCELLOCATION-BIKE";
                    break;
                }
                case FOOT: {
                    parcelLocationDescriptor = "AREA-PARCELLOCATION-FOOT";
                    break;
                }
                case MOTORCAR: {
                    parcelLocationDescriptor = "AREA-PARCELLOCATION-MOTOR";
                }
            }
        }
        Double difficultyLevel = AreaObjectModelUtil.getRoutingDoubleValue(areaObject, difficultLevelDescriptor == null ? null : modelEnviroment.getModelFromMap(difficultLevelDescriptor), null);
        Double parcelLocation = AreaObjectModelUtil.getRoutingDoubleValue(areaObject, parcelLocationDescriptor == null ? null : modelEnviroment.getModelFromMap(parcelLocationDescriptor), null);
        if (areaTourParameter.getDifficultyLevel() != null) {
            difficultyLevel = areaTourParameter.getDifficultyLevel();
        }
        if (areaTourParameter.getParcelLocation() != null) {
            parcelLocation = areaTourParameter.getParcelLocation();
        }
        logisticTourPart.setDifficultLevel(difficultyLevel);
        logisticTourPart.setParcelLocation(parcelLocation);
    }

    private static Double getRoutingDoubleValue(AreaObjectModel areaObject, Model descriptor, Double defaultValue) {
        if (descriptor != null) {
            Iterator<AreaAttributeValueModel> valueIter = areaObject.iterateAreaAttributeValues();
            while (valueIter.hasNext()) {
                AreaAttributeValueModel value = valueIter.next();
                if (!value.getAreaAttributeValueDescriptor().equals(descriptor)) continue;
                Double floatValue = value.getFloatValue();
                return floatValue == null ? defaultValue : floatValue;
            }
        }
        return defaultValue;
    }

    public static Collection<ImmutablePolygonKind> getImmutablePolygonKindsFromAreas(Collection<AreaObjectModel> areas) {
        if (areas == null || areas.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ImmutablePolygonKind> polygons = new ArrayList<ImmutablePolygonKind>(areas.size());
        for (AreaObjectModel area : areas) {
            ImmutablePolygonKind polygon = area.getGeom();
            if (polygon == null) continue;
            polygons.add(polygon);
        }
        return polygons;
    }

    public static Tupel<String, String> getContractTextAttribute(AreaObjectModel area) {
        Tupel<Object, Object> tupel = new Tupel<Object, Object>(null, null);
        AreaLayerModel areaLayer = area.getAreaLayer();
        if (areaLayer.getDiscriminator() != AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT) {
            return tupel;
        }
        String text = null;
        Date creationDate = null;
        for (AreaAttributeValueModel value : area.iterableAreaAttributeValues()) {
            AreaAttributeValueDescriptorModel descriptor = value.getAreaAttributeValueDescriptor();
            Boolean canPrint = descriptor.getCanPrint() == null ? true : descriptor.getCanPrint();
            if (!canPrint.booleanValue()) continue;
            String key = descriptor.getKey();
            if (key.equals("AREA-PRINTING-TITEL")) {
                tupel.setElement1(value.getStringValue());
                continue;
            }
            if (key.equals("AREA-PRINTING-TEXT")) {
                text = value.getTextValue();
                continue;
            }
            if (!key.equals("AREA-PRINTING-CREATION-DATE") || value.getLongValue() == null) continue;
            creationDate = new Date(value.getLongValue());
        }
        text = !StringUtil.isBlank(text) ? text + (creationDate == null ? "" : "/n") : "";
        String creationDateString = creationDate == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("messages.default.creationDate", new Serializable[0]) + ": " + ClientFormUtil.dateToString(creationDate);
        tupel.setElement2((text + creationDateString));
        return tupel;
    }

    public static Collection<Tupel<AreaObjectModel, List<Model>>> checkDeliveryRound(Collection<Tupel<AreaObjectModel, List<Model>>> areas, Date date) {
        TreeSet<Tupel<AreaObjectModel, List<Model>>> noRounds = new TreeSet<Tupel<AreaObjectModel, List<Model>>>(new Comparator<Tupel<AreaObjectModel, List<Model>>>(){

            @Override
            public int compare(Tupel<AreaObjectModel, List<Model>> o1, Tupel<AreaObjectModel, List<Model>> o2) {
                AreaObjectModel area1 = o1.getElement1();
                AreaObjectModel area2 = o2.getElement1();
                String shortcut1 = area1.getShortcut();
                String shortcut2 = area2.getShortcut();
                return new ComparatorBuilder().append(shortcut1, shortcut2).append(area1.getId(), area2.getId()).compare();
            }
        });
        for (Tupel<AreaObjectModel, List<Model>> area : areas) {
            if (AreaObjectModelUtil.hasDeliveryRound(area.getElement1(), date)) continue;
            noRounds.add(area);
        }
        return noRounds;
    }

    private static boolean hasDeliveryRound(AreaObjectModel area, Date date) {
        int weekDay = TimeUtil.getDayOfWeek(date);
        for (AreaDeliveryRoundModel areaRound : area.iterableAreaDeliveryRounds()) {
            switch (weekDay) {
                case 2: {
                    if (areaRound.getMonday() == null) break;
                    return true;
                }
                case 3: {
                    if (areaRound.getTuesday() == null) break;
                    return true;
                }
                case 4: {
                    if (areaRound.getWednesday() == null) break;
                    return true;
                }
                case 5: {
                    if (areaRound.getThursday() == null) break;
                    return true;
                }
                case 6: {
                    if (areaRound.getFriday() == null) break;
                    return true;
                }
                case 7: {
                    if (areaRound.getSaturday() == null) break;
                    return true;
                }
                case 1: {
                    if (areaRound.getSunday() == null) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<DeliveryRoundRelationModel> getRounds(AreaObjectModel area, Date date) {
        ArrayList<DeliveryRoundRelationModel> list = new ArrayList<DeliveryRoundRelationModel>();
        int weekDay = TimeUtil.getDayOfWeek(date);
        for (AreaDeliveryRoundModel areaRound : area.iterableAreaDeliveryRounds()) {
            if (areaRound == null) continue;
            switch (weekDay) {
                case 2: {
                    if (areaRound.getMonday() == null) break;
                    list.add(areaRound.getMonday());
                    break;
                }
                case 3: {
                    if (areaRound.getTuesday() == null) break;
                    list.add(areaRound.getTuesday());
                    break;
                }
                case 4: {
                    if (areaRound.getWednesday() == null) break;
                    list.add(areaRound.getWednesday());
                    break;
                }
                case 5: {
                    if (areaRound.getThursday() == null) break;
                    list.add(areaRound.getThursday());
                    break;
                }
                case 6: {
                    if (areaRound.getFriday() == null) break;
                    list.add(areaRound.getFriday());
                    break;
                }
                case 7: {
                    if (areaRound.getSaturday() == null) break;
                    list.add(areaRound.getSaturday());
                    break;
                }
                case 1: {
                    if (areaRound.getSunday() == null) break;
                    list.add(areaRound.getSunday());
                    break;
                }
            }
        }
        Collections.sort(list, new StringComparator<DeliveryRoundRelationModel>(true){

            @Override
            protected String getString(DeliveryRoundRelationModel o) {
                return o.getDeliveryRound().getName();
            }
        });
        return list;
    }

    public static enum AreaObjectChangeType {
        NEW,
        ADD,
        REMOVE,
        REPLACE;

    }
}

