/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.swing.tourmanager;

import de.datomino.peppergis.client.event.ApplicationMessage;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.swing.AbstractPepperGisInternalFrame;
import de.datomino.peppergis.client.swing.PepperGisDesktopApplication;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.license.LicenseType;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.swing.JOptionPane;
import org.ktde.swing.navigator.NavigatorPanel;

public class TourManagerInternalFrame
extends AbstractPepperGisInternalFrame {
    private static final long serialVersionUID = -1951377310022805944L;
    private ModelEnviroment modelEnviroment;
    private TourManagerCalendarGui gui;

    public TourManagerInternalFrame(PepperGisDesktopApplication application) throws IOException, PropertyVetoException {
        super(application, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.tourPlanning", new Serializable[0]), true, true, true);
        this.modelEnviroment = new ModelEnviroment(application, false);
        this.modelEnviroment.updateSharedValues();
        this.gui = new TourManagerCalendarGui(this.modelEnviroment);
        this.add(this.gui);
        this.pack();
    }

    @Override
    public boolean close() {
        if (this.modelEnviroment.getUndoManager().canUndo()) {
            int d = JOptionPane.showConfirmDialog(this, "Wollen Sie die \u00c4nderungen speichern?", "\u00c4nderungen speichern", 1, 3);
            switch (d) {
                case 0: {
                    try {
                        this.modelEnviroment.getUndoManager().storeTransactions();
                        break;
                    }
                    catch (ValidateException e) {
                        this.modelEnviroment.getUndoManager().handleValidateException(e);
                    }
                }
                case 1: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        this.gui.actionBeforeClose();
        this.modelEnviroment.close();
        return true;
    }

    @Override
    public NavigatorPanel getCurrentNavigatorPanel() {
        return this.gui.getCurrentNavigatorPanel();
    }

    @Override
    public LicenseType getLicenseType() {
        return LicenseType.TOUR;
    }

    @Override
    public void consumeApplicationMessage(ApplicationMessage<?> message) {
        super.consumeApplicationMessage(message);
        if (message.getMessage().equals((Object)ApplicationMessage.Message.REFRESH_MODELS)) {
            Map idMap = (Map)message.getPayload();
            for (Class key : idMap.keySet()) {
                Collection ids = (Collection)idMap.get(key);
                if (ids == null) continue;
                for (Long id : ids) {
                    this.modelEnviroment.getModelCache().refreshRek(key, id);
                }
            }
            this.repaint(1L);
        }
    }
}

