/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.swing.license;

import de.datomino.peppergis.client.communication.UserCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.swing.AbstractPepperGisInternalFrame;
import de.datomino.peppergis.client.swing.PepperGisDesktopApplication;
import de.datomino.peppergis.exception.InsufficiantLicenseException;
import de.datomino.peppergis.exception.UserAlreadyLogedInException;
import de.datomino.peppergis.license.LicenseType;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.ktde.ee.rmi.KickedAuthenticationException;

public class LicenseManager
extends InternalFrameAdapter
implements Runnable {
    private static final long INTERVAL = 60000L;
    private PepperGisDesktopApplication pepperGisDesktopApplication;
    private ModelEnviroment modelEnviroment;
    private boolean refreshFlag = true;

    public LicenseManager(PepperGisDesktopApplication pepperGisDesktopApplication) {
        this.pepperGisDesktopApplication = pepperGisDesktopApplication;
        this.modelEnviroment = new ModelEnviroment(pepperGisDesktopApplication);
    }

    @Override
    public void run() {
        block11: while (true) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            UserCaller userCaller = this.modelEnviroment.getAllCaller().getUserCaller();
            while (this.refreshFlag) {
                try {
                    userCaller.refresh();
                    this.refreshFlag = false;
                }
                catch (UserAlreadyLogedInException e) {
                    e.printStackTrace();
                    this.refreshFlag = false;
                    this.terminate(1);
                }
                catch (KickedAuthenticationException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, ModelEnviroment.getMessageResolver().resolveMessage("messages.admin.kickUserAlreadyLoggedIn.kicked", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 0);
                    System.exit(0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    int d = JOptionPane.showConfirmDialog(this.pepperGisDesktopApplication, ModelEnviroment.getMessageResolver().resolveMessage("messages.error.connectionTimeout", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.error", new Serializable[0]), 0);
                    switch (d) {
                        case 1: {
                            this.refreshFlag = false;
                            ModelEnviroment.setUserInformation(null);
                            System.exit(0);
                            break;
                        }
                    }
                }
            }
            Collection allWindows = this.pepperGisDesktopApplication.getAllWindows().values();
            HashSet<LicenseType> foundLicenses = new HashSet<LicenseType>();
            for (AbstractPepperGisInternalFrame peppergisFrame : allWindows) {
                LicenseType licenseType = peppergisFrame.getLicenseType();
                if (licenseType == null) continue;
                foundLicenses.add(licenseType);
            }
            Iterator<Object> iterator = foundLicenses.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block11;
                LicenseType licenseType = (LicenseType)((Object)iterator.next());
                try {
                    userCaller.refreshModule(licenseType);
                    continue;
                }
                catch (InsufficiantLicenseException e) {
                    e.printStackTrace();
                    this.terminate(2);
                    continue;
                }
                break;
            }
            break;
        }
    }

    private void terminate(int code) {
        System.out.println("Exit with code " + code);
        JOptionPane.showMessageDialog(this.pepperGisDesktopApplication, ModelEnviroment.getMessageResolver().resolveMessage("messages.license.terminate", Integer.valueOf(code)), ModelEnviroment.getMessageResolver().resolveMessage("messages.error", new Serializable[0]), 0);
        System.exit(0);
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        AbstractPepperGisInternalFrame oldWindow;
        LicenseType licenseType;
        if (!ModelEnviroment.getUserInformation().isSuperUser() && (licenseType = (oldWindow = (AbstractPepperGisInternalFrame)e.getInternalFrame()).getLicenseType()) != null) {
            Collection windows = this.pepperGisDesktopApplication.getAllWindows().values();
            boolean found = false;
            for (AbstractPepperGisInternalFrame window : windows) {
                if (window == oldWindow || licenseType != window.getLicenseType()) continue;
                found = true;
                break;
            }
            if (!found) {
                this.modelEnviroment.getAllCaller().getUserCaller().logoutModule(licenseType);
            }
        }
    }
}

