/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.swing.data;

import de.datomino.peppergis.client.data.DataManagerModelInterface;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.swing.AbstractPepperGisInternalFrame;
import de.datomino.peppergis.datamanager.gui.DataManagerGui;
import de.datomino.peppergis.license.LicenseType;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import org.ktde.swing.DesktopClientApplication;

public class DataManagerInternalFrame
extends AbstractPepperGisInternalFrame
implements DataManagerModelInterface {
    private static final long serialVersionUID = 672814586638605218L;
    private ModelEnviroment modelEnvironment;
    private DataManagerGui gui;

    public DataManagerInternalFrame(DesktopClientApplication<AbstractPepperGisInternalFrame> application, JMenu importMenu, JMenu exportMenu) {
        super(application, ModelEnviroment.getMessageResolver().resolveMessage("messages.data", new Serializable[0]), true, true, true);
        this.modelEnvironment = new ModelEnviroment(application);
        JRootPane rootPane = this.getRootPane();
        this.gui = new DataManagerGui(this.modelEnvironment, rootPane, importMenu, exportMenu);
        this.add(this.gui);
        this.setJMenuBar(this.gui.getDataManagerControlGui());
        this.pack();
    }

    @Override
    public boolean close() {
        if (this.gui.checkCloseConditions(null)) {
            if (this.modelEnvironment.getUndoManager().canUndo()) {
                int d = JOptionPane.showConfirmDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.confirm.save", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.confirm.save.title", new Serializable[0]), 1, 3);
                switch (d) {
                    case 0: {
                        this.gui.save();
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            this.gui.actionBeforeClose();
            this.modelEnvironment.close();
            return true;
        }
        return false;
    }

    @Override
    public LicenseType getLicenseType() {
        return null;
    }

    @Override
    public boolean setModel(Model model) {
        Long id = model.getId();
        if (id != null) {
            if (model instanceof ParcelModel) {
                ParcelModel parcelModel = this.modelEnvironment.getAllCaller().getStreetNetCaller().fetchParcelById(id);
                return this.gui.setModel(parcelModel);
            }
            if (model instanceof SubscriptionModel) {
                List<SubscriptionModel> subscriptionsList = this.modelEnvironment.getAllCaller().getSubscriptionCaller().fetchSubscriptionsByIds(Collections.singletonList(id));
                if (subscriptionsList.size() == 1) {
                    SubscriptionModel subscriptionModel = subscriptionsList.get(0);
                    return this.gui.setModel(subscriptionModel);
                }
            } else if (model instanceof LetterModel) {
                LinkedList<LetterModel> letterList = new LinkedList<LetterModel>(this.modelEnvironment.getAllCaller().getLetterCaller().fetchLettersByIds(Collections.singletonList(id)));
                if (letterList.size() == 1) {
                    LetterModel letterModel = (LetterModel)letterList.get(0);
                    return this.gui.setModel(letterModel);
                }
            } else if (model instanceof StopModel) {
                StopModel stopModel = this.modelEnvironment.getAllCaller().getTourCaller().getStopById(id);
                return this.gui.setModel(stopModel);
            }
        }
        return false;
    }
}

