/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.swing.areamanager;

import de.datomino.peppergis.areamanager.gui.AreaManagerCalendarGui;
import de.datomino.peppergis.client.event.ApplicationMessage;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.swing.AbstractPepperGisInternalFrame;
import de.datomino.peppergis.client.swing.PepperGisDesktopApplication;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.license.LicenseType;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JOptionPane;
import org.ktde.swing.navigator.NavigatorPanel;

public class AreaManagerInternalFrame
extends AbstractPepperGisInternalFrame {
    private static final long serialVersionUID = -1951377310022805944L;
    private ModelEnviroment modelEnviroment;
    private AreaManagerCalendarGui gui;

    public AreaManagerInternalFrame(PepperGisDesktopApplication application, Long areaLayerId) throws IOException, PropertyVetoException {
        super(application, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areaPlanning", new Serializable[0]), true, true, true);
        this.modelEnviroment = new ModelEnviroment(application);
        this.modelEnviroment.updateSharedValues();
        AreaLayerModel areaLayer = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayer(areaLayerId);
        if (areaLayer != null) {
            this.setTitle(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areaPlanning", new Serializable[0]) + " - " + areaLayer.getDisplayname());
        }
        this.gui = new AreaManagerCalendarGui(this.modelEnviroment, areaLayerId);
        this.add(this.gui);
        this.pack();
    }

    @Override
    public boolean close() {
        if (this.modelEnviroment.getUndoManager().canUndo()) {
            int d = JOptionPane.showConfirmDialog(this, "Wollen Sie die \u00c4nderungen speichern?", "\u00c4nderungen speichern", 1, 3);
            switch (d) {
                case 0: {
                    try {
                        this.modelEnviroment.getUndoManager().storeTransactions();
                        break;
                    }
                    catch (ValidateException e) {
                        this.modelEnviroment.getUndoManager().handleValidateException(e);
                    }
                }
                case 1: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        this.gui.actionBeforeClose();
        this.modelEnviroment.close();
        return true;
    }

    @Override
    public NavigatorPanel getCurrentNavigatorPanel() {
        return this.gui.getCurrentNavigatorPanel();
    }

    @Override
    public LicenseType getLicenseType() {
        return LicenseType.AREA;
    }

    @Override
    public void consumeApplicationMessage(ApplicationMessage<?> message) {
        super.consumeApplicationMessage(message);
        this.gui.consumeApplicationMessage(message);
    }
}

