/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.swing.areamanager;

import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.swing.AbstractPepperGisInternalFrame;
import de.datomino.peppergis.client.swing.PepperGisDesktopApplication;
import de.datomino.peppergis.client.swing.action.AbstractWindowOpenerAction;
import de.datomino.peppergis.client.swing.areamanager.AreaManagerInternalFrame;
import de.datomino.peppergis.license.LicenseType;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class AreaManagerAction
extends AbstractWindowOpenerAction {
    private static final long serialVersionUID = 7538672081592334250L;

    public AreaManagerAction(PepperGisDesktopApplication application) {
        super(application, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areaPlanning", new Serializable[0]), null);
    }

    @Override
    protected String getWindowId(ModelEnviroment modelEnviroment) {
        AreaLayerModel choosen;
        int selectedIndex;
        AreaCaller areaCaller = modelEnviroment.getAllCaller().getAreaCaller();
        AreaObjectGenInfoDiscriminator[] discriminators = new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT, AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND, AreaObjectGenInfoDiscriminator.AREA_OBJECT_MICRO_CELL, AreaObjectGenInfoDiscriminator.AREA_OBJECT_MACRO_CELL};
        ArrayList<AreaLayerModel> layers = new ArrayList<AreaLayerModel>(areaCaller.getAreaLayersForType(discriminators));
        ListIterator layerIter = layers.listIterator();
        Vector<String> layernames = new Vector<String>();
        while (layerIter.hasNext()) {
            AreaLayerModel curLayer = (AreaLayerModel)layerIter.next();
            layernames.add(curLayer.getDisplayname());
        }
        JComboBox chooseEditLayerCombo = new JComboBox(layernames);
        if (JOptionPane.showConfirmDialog(this.getApplication(), chooseEditLayerCombo, "Bearbeitungslayer w\u00e4hlen", 2) == 0 && (selectedIndex = chooseEditLayerCombo.getSelectedIndex()) >= 0 && (choosen = (AreaLayerModel)layers.get(selectedIndex)) != null) {
            int counter = 0;
            String id = "baselayer_" + choosen.getId() + "_" + counter;
            while (this.getApplication().getWindow(id) != null) {
                id = "baselayer_" + choosen.getId() + "_" + ++counter;
            }
            return id;
        }
        return null;
    }

    @Override
    protected AbstractPepperGisInternalFrame createWindow(String windowId, ModelEnviroment modelEnviroment) throws Exception {
        Long id = Long.parseLong(windowId.substring(10, windowId.lastIndexOf(95)));
        return new AreaManagerInternalFrame(this.getApplication(), id);
    }

    @Override
    protected LicenseType getLicenseType() {
        return LicenseType.TOUR2;
    }
}

